/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.cha;

import oracle.cha.config.CHAConstants;
import oracle.cluster.crs.ActionListener;
import oracle.cluster.crs.ActionMessage;
import oracle.cluster.crs.ActionResult;
import oracle.cluster.impl.cha.CHAStatusImpl;
import oracle.cluster.impl.cha.CompositeCHAStatusImpl;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.trace.Trace;

public class CHAStatusListener
implements ActionListener {
    private static final String CHA_STAT_MONITORING = "MONITORING";
    CompositeCHAStatusImpl m_compStat;

    CHAStatusListener(CompositeCHAStatusImpl compStat) {
        this.m_compStat = compStat;
    }

    @Override
    public void notifyActionResult(ActionResult ar) {
    }

    @Override
    public void notifyActionMessage(Node node, ActionMessage am) {
        Object hostName = null;
        Object instNames = null;
        String modelName = null;
        boolean isError = false;
        ActionMessage.Type msgtype = am.getType();
        String msg = am.getMessage();
        Trace.out("msg = " + msg);
        CHAStatusImpl csi = (CHAStatusImpl)this.m_compStat.getCHAStatus(node);
        if (csi == null) {
            Trace.out("add CHA status for node " + node);
            csi = new CHAStatusImpl();
            this.m_compStat.addCHAStatusImpl(node, csi);
        }
        if (msgtype == ActionMessage.Type.ACTION_MESSAGE_INFO) {
            String[] targets;
            for (String target : targets = msg.split(CHAConstants.PROG_MSG_SEP1)) {
                String[] contents = target.split(CHAConstants.PROG_MSG_SEP2);
                if (contents.length < 3 || contents.length > 4) {
                    Trace.out("Contents format of CHA Progress msg is wrong.  Discarding it.");
                    continue;
                }
                String type = contents[0];
                String name = contents[1];
                String stat = contents[2];
                if (!stat.equals(CHA_STAT_MONITORING)) continue;
                if (type.equals("host")) {
                    Trace.out((Object)"Host name is %s", name);
                    if (4 == contents.length) {
                        modelName = contents[3];
                        Trace.out((Object)"Model name is %s", modelName);
                        csi.addHostModelName(name, modelName);
                    }
                }
                if (!type.equals("instance")) continue;
                Trace.out((Object)"Instance name is %s", name);
                if (4 != contents.length) continue;
                modelName = contents[3];
                Trace.out((Object)"Model name is %s", modelName);
                csi.addInstModelName(name, modelName);
            }
        } else if (msgtype == ActionMessage.Type.ACTION_MESSAGE_ERROR) {
            csi.setError(msg);
        }
    }
}

