/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.cha;

import java.util.HashMap;
import java.util.Map;
import oracle.cluster.cha.CHAStatus;
import oracle.cluster.impl.crs.ActionStatusImpl;
import oracle.ops.mgmt.trace.Trace;

public class CHAStatusImpl
extends ActionStatusImpl
implements CHAStatus {
    Map<String, String> m_monHostModelName = new HashMap<String, String>();
    Map<String, String> m_monInstModelName = new HashMap<String, String>();
    String m_errorMsg = "";
    boolean m_isError = false;
    boolean m_isWarning = false;
    boolean m_isNOOP = false;

    CHAStatusImpl() {
    }

    void addHostModelName(String hostName, String modelName) {
        this.m_monHostModelName.put(hostName, modelName);
    }

    void addInstModelName(String instName, String modelName) {
        this.m_monInstModelName.put(instName, modelName);
    }

    void setError(String msg) {
        Trace.out("CHA Message:" + msg);
        if (msg.contains("CLSCH-2402")) {
            Trace.out("Setting NOOP to true");
            this.m_isNOOP = true;
        } else if (msg.contains("CLSCH-2403") || msg.contains("CLSCH-2404")) {
            Trace.out("Setting Warning to true");
            this.m_isWarning = true;
        } else {
            Trace.out("Setting Error to true");
            this.m_isError = true;
        }
        this.m_errorMsg = msg;
    }

    @Override
    public Map<String, String> getMonitoringHostModelName() {
        return this.m_monHostModelName;
    }

    @Override
    public Map<String, String> getMonitoringInstanceModelName() {
        return this.m_monInstModelName;
    }
}

