/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.cha;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.cha.CHA;
import oracle.cluster.cha.CHAException;
import oracle.cluster.cha.CompositeCHAStatus;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.impl.cha.CHAStatusListener;
import oracle.cluster.impl.cha.CompositeCHAStatusImpl;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceDependency;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.database.DatabaseFactoryImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrClMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyMonitoredException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyUnmonitoredException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;

public class CHAImpl
extends SoftwareModuleImpl
implements CHA {
    private static final String CHA_ACTIONS_PRIV_SEPARATOR = ",";
    private static final String CHA_ACTIONS_USER_SEPARATOR = ":";
    private static final String CHA_ACTIONS_TARGET_SEPARATOR = ":";
    CompositeCHAStatusImpl m_ccs = new CompositeCHAStatusImpl();
    private ResourceAttribute m_nameAttr;

    CHAImpl(ResourceAttribute nameAttr) throws CHAException {
        try {
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.CHAD.NAME.name())) {
                throw new CHAException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.CHAD.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            if (numValues != 2 || !"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.CHAD.toString().equalsIgnoreCase(values[numValues - 1])) {
                throw new CHAException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.CHAD.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            this.m_displayName = values[numValues - 1];
            this.m_crsResource = (CRSResourceImpl)CRSFactoryImpl.getInstance().get(this.m_nameAttr);
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new CHAException(e);
        }
    }

    void create(Version version, boolean force) throws AlreadyExistsException, CHAException {
        boolean mgmtDBExists = false;
        MgmtDatabase mgmtDB = null;
        try {
            DatabaseFactoryImpl dbFactImpl = DatabaseFactoryImpl.getInstance();
            mgmtDB = dbFactImpl.getMgmtDatabase();
            mgmtDBExists = true;
        }
        catch (NotExistsException e) {
            Trace.out("We are on a GIMR client cluster, there is no mgmtdb resource");
            mgmtDBExists = false;
        }
        catch (SoftwareModuleException e) {
            if (!force) {
                throw new CHAException((MessageKey)PrClMsgID.CHA_GET_DATABASE_FAILED, (Throwable)e, new Object[0]);
            }
            Trace.out("Failed to check if Mgmtdb exists, but force option was specified, so ignoring this failure");
        }
        try {
            Util utl = new Util();
            String crsUser = utl.getCRSUser();
            crsUser = crsUser.trim();
            if (crsUser.indexOf(" ") >= 0 && !crsUser.startsWith("\"") && !crsUser.endsWith("\"")) {
                crsUser = "\"" + crsUser + "\"";
            }
            String mgmtDBName = ResourceLiterals.MGMTDB_RES_NAME.toString();
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute chadTypeAttr = crsFactory.create(ResourceType.CHAD.NAME.name(), ResourceType.CHAD.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(chadTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.CHAD.NAME.name())) {
                    attr.setValue(CHAImpl.getResourceName());
                    continue;
                }
                if (attr.getName().equalsIgnoreCase(ResourceType.CHAD.DESCRIPTION.name())) {
                    attr.setValue(ResourceLiterals.CHAD_RES_DESC.toString());
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.CHAD.ACTIONS.name())) continue;
                attr.setValue(ResourceLiterals.CHAD_ACTIONS.toString() + CHA_ACTIONS_PRIV_SEPARATOR + (Object)((Object)ResourceType.ACL.USER) + ":" + crsUser);
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            if (mgmtDBExists) {
                ResourceDependency hardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.MgmtDatabase.NAME.name(), mgmtDBName), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
                ResourceDependency pullupDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.Database.NAME.name(), mgmtDBName), ResourceDependency.DepType.PULLUP_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP);
                ResourceDependency stophardDep = crsFactory.createResourceDependency(crsFactory.create(ResourceType.MgmtDatabase.NAME.name(), mgmtDBName), ResourceDependency.DepType.HARD_DEP, ResourceDependency.DepModifier.GLOBAL_MODIFIER_DEP, ResourceDependency.DepModifier.INTERMEDIATE_MODIFIER_DEP);
                ResourceAttribute startDep = crsFactory.create(ResourceType.LocalResource.START_DEPENDENCIES.name(), ResourceDependency.toString(hardDep, pullupDep));
                attrList.add(startDep);
                ResourceAttribute stopDep = crsFactory.create(ResourceType.LocalResource.STOP_DEPENDENCIES.name(), ResourceDependency.toString(stophardDep));
                attrList.add(stopDep);
            }
            ResourceAttribute aclPerm = this.createCHAACLAttr();
            attrList.add(aclPerm);
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, force);
        }
        catch (CRSException e) {
            throw new CHAException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
        catch (UtilException e) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_GET_CRSUSER_FAILED, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public boolean registerDB4Monitor(String dbname) throws CHAException {
        DatabaseFactory dbFactory = null;
        ResourceAttribute monitoredDatabaseAttr = null;
        Database monitoredDatabase = null;
        try {
            monitoredDatabaseAttr = this.m_crsResource.getAttribute(ResourceType.CHAD.MONITORED_DATABASES.name());
        }
        catch (CRSException ce) {
            Trace.out(ce.getMessage());
            throw new CHAException(ce);
        }
        StringBuffer dbListNames = new StringBuffer(monitoredDatabaseAttr.getValue());
        if (dbListNames.indexOf(dbname) >= 0) {
            return false;
        }
        try {
            dbFactory = DatabaseFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            Trace.out(sme.getMessage());
            throw new CHAException(sme);
        }
        try {
            monitoredDatabase = dbFactory.getDatabase(dbname, dbFactory.getDatabaseVersion(dbname));
        }
        catch (DatabaseException dbe) {
            Trace.out(dbe.getMessage());
            throw new CHAException(dbe);
        }
        catch (NotExistsException nee) {
            Trace.out(nee.getMessage());
            throw new CHAException(nee);
        }
        if (dbListNames.length() != 0) {
            dbListNames.append(" ");
        }
        dbListNames.append(dbname);
        monitoredDatabaseAttr.setValue(dbListNames.toString());
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        attrList.add(monitoredDatabaseAttr);
        try {
            this.m_crsResource.update(attrList);
        }
        catch (AlreadyExistsException aee) {
            Trace.out(aee.getMessage());
            throw new CHAException(aee);
        }
        catch (CRSException ce) {
            Trace.out(ce.getMessage());
            throw new CHAException(ce);
        }
        try {
            if (monitoredDatabase.isRunning()) {
                monitoredDatabase.startMonitor();
            }
        }
        catch (DatabaseException dbe) {
            Trace.out(dbe.getMessage());
            throw new CHAException(dbe);
        }
        catch (SoftwareModuleException sme) {
            Trace.out(sme.getMessage());
            throw new CHAException(sme);
        }
        catch (CompositeActionException cae) {
            Trace.out(cae.getMessage());
            throw new CHAException(cae);
        }
        return true;
    }

    @Override
    public boolean unregisterDB4Monitor(String dbname) throws CHAException {
        ResourceAttribute monitoredDatabaseAttr = null;
        DatabaseFactory dbFactory = null;
        Database monitoredDatabase = null;
        try {
            monitoredDatabaseAttr = this.m_crsResource.getAttribute(ResourceType.CHAD.MONITORED_DATABASES.name());
        }
        catch (CRSException ce) {
            Trace.out(ce.getMessage());
            throw new CHAException(ce);
        }
        String dbListNames = monitoredDatabaseAttr.getValue();
        if (dbListNames.indexOf(dbname) < 0) {
            return false;
        }
        try {
            dbFactory = DatabaseFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            Trace.out(sme.getMessage());
            throw new CHAException(sme);
        }
        try {
            monitoredDatabase = dbFactory.getDatabase(dbname, dbFactory.getDatabaseVersion(dbname));
        }
        catch (DatabaseException dbe) {
            Trace.out(dbe.getMessage());
            throw new CHAException(dbe);
        }
        catch (NotExistsException nee) {
            Trace.out(nee.getMessage());
            throw new CHAException(nee);
        }
        dbListNames = dbListNames.replace(dbname, "");
        dbListNames = dbListNames.trim();
        dbListNames = dbListNames.replace("  ", " ");
        monitoredDatabaseAttr.setValue(dbListNames.toString());
        ArrayList<ResourceAttribute> attrList = new ArrayList<ResourceAttribute>();
        attrList.add(monitoredDatabaseAttr);
        try {
            this.m_crsResource.update(attrList);
        }
        catch (AlreadyExistsException aee) {
            Trace.out(aee.getMessage());
            throw new CHAException(aee);
        }
        catch (CRSException ce) {
            Trace.out(ce.getMessage());
            throw new CHAException(ce);
        }
        try {
            if (monitoredDatabase.isRunning()) {
                monitoredDatabase.stopMonitor();
            }
        }
        catch (DatabaseException dbe) {
            Trace.out(dbe.getMessage());
            throw new CHAException(dbe);
        }
        catch (SoftwareModuleException sme) {
            Trace.out(sme.getMessage());
            throw new CHAException(sme);
        }
        catch (CompositeActionException cae) {
            Trace.out(cae.getMessage());
            throw new CHAException(cae);
        }
        return true;
    }

    @Override
    public List<String> getListDB4Monitor() throws CHAException {
        ArrayList<String> dbNames = new ArrayList<String>();
        try {
            String[] tokensNames = null;
            ResourceAttribute monitoredDatabaseAttr = this.m_crsResource.getAttribute(ResourceType.CHAD.MONITORED_DATABASES.name());
            String dbListNames = monitoredDatabaseAttr.getValue();
            for (String dbName : tokensNames = dbListNames.split(" ")) {
                dbNames.add(dbName);
            }
            return dbNames;
        }
        catch (CRSException ce) {
            Trace.out(ce.getMessage());
            throw new CHAException(ce);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, CHAException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new CHAException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    public static String getResourceName() {
        return "ora." + ResourceLiterals.CHAD.toString();
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, CHAException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new CHAException(e);
        }
    }

    @Override
    public void monitor(String modelName) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor cluster with model " + modelName);
        if (null == modelName) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "modelName");
        }
        if (modelName.trim().equals("")) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_EMPTY_MODEL_NAME, new Object[0]);
        }
        try {
            ClusterUtil cu = new ClusterUtil();
            String clName = cu.getClusterName();
            this.requestAction("start_target", "cluster", clName + ":", modelName, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_1, modelName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_ON_CLUSTER_MODEL, (Throwable)e, e.getCompositeCHAStatus(), modelName);
        }
        catch (ClusterUtilException e) {
            Trace.out("ClusterUtilException");
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_ON_CLUSTER_MODEL, (Throwable)e, modelName);
        }
    }

    @Override
    public void monitor() throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor cluster");
        try {
            ClusterUtil cu = new ClusterUtil();
            String clName = cu.getClusterName();
            this.requestAction("start_target", "cluster", clName + ":", null, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_2, new Object[0]);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_ON_CLUSTER, (Throwable)e, e.getCompositeCHAStatus(), new Object[0]);
        }
        catch (ClusterUtilException e) {
            Trace.out("ClusterUtilException");
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_ON_CLUSTER, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void monitor(ServerPool sp, String modelName) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor serverpool with model " + modelName);
        if (null == sp) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        if (null == modelName) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "modelName");
        }
        if (modelName.trim().equals("")) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_EMPTY_MODEL_NAME, new Object[0]);
        }
        String spName = sp.getName();
        if (sp.isBuiltinPool()) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_BUILTIN_SERVERPOOL, spName);
        }
        try {
            ClusterUtil cu = new ClusterUtil();
            String clName = cu.getClusterName();
            this.requestAction("start_target", "cluster", clName + ":" + spName, modelName, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_3, spName, modelName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_ON_SRVPOOL_MODEL, (Throwable)e, e.getCompositeCHAStatus(), spName, modelName);
        }
        catch (ClusterUtilException e) {
            Trace.out("ClusterUtilException");
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_ON_SRVPOOL_MODEL, (Throwable)e, spName, modelName);
        }
    }

    @Override
    public void monitor(ServerPool sp) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor serverpool");
        if (null == sp) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        String spName = sp.getName();
        if (sp.isBuiltinPool()) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_BUILTIN_SERVERPOOL, spName);
        }
        try {
            ClusterUtil cu = new ClusterUtil();
            String clName = cu.getClusterName();
            this.requestAction("start_target", "cluster", clName + ":" + spName, null, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_4, spName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_ON_SRVPOOL, (Throwable)e, e.getCompositeCHAStatus(), spName);
        }
        catch (ClusterUtilException e) {
            Trace.out("ClusterUtilException");
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_ON_SRVPOOL, (Throwable)e, spName);
        }
    }

    @Override
    public void monitor(Node node, String modelName) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor host with model " + modelName);
        if (null == node) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
        }
        if (null == modelName) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "modelName");
        }
        if (modelName.trim().equals("")) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_EMPTY_MODEL_NAME, new Object[0]);
        }
        String nodeName = null;
        try {
            nodeName = node.getName();
        }
        catch (NodeException e) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_NODENAME, (Throwable)e, new Object[0]);
        }
        try {
            Node[] nodes = new Node[]{node};
            this.requestAction("start_target", "host", nodeName, modelName, new Node[]{node});
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_5, nodeName, modelName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_MODEL, (Throwable)e, e.getCompositeCHAStatus(), nodeName, modelName);
        }
    }

    @Override
    public void monitor(Node node) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor host");
        if (null == node) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
        }
        String nodeName = null;
        try {
            nodeName = node.getName();
        }
        catch (NodeException e) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED_NODENAME, (Throwable)e, new Object[0]);
        }
        try {
            Node[] nodes = new Node[]{node};
            this.requestAction("start_target", "host", nodeName, null, new Node[]{node});
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_6, nodeName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_HOST_FAILED, (Throwable)e, e.getCompositeCHAStatus(), nodeName);
        }
    }

    @Override
    public void monitor(Database db, String modelName) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor database on all nodes with model " + modelName);
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (null == modelName) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "modelName");
        }
        if (modelName.trim().equals("")) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_EMPTY_MODEL_NAME, new Object[0]);
        }
        String dbName = db.getUserAssignedName();
        try {
            this.requestAction("start_target", "database", dbName, modelName, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_7, dbName, modelName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_DB_FAILED_MODEL, (Throwable)e, e.getCompositeCHAStatus(), dbName, modelName);
        }
    }

    @Override
    public void monitor(Database db) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor database on all nodes");
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        String dbName = db.getUserAssignedName();
        try {
            this.requestAction("start_target", "database", dbName, null, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_8, dbName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_DB_FAILED, (Throwable)e, e.getCompositeCHAStatus(), dbName);
        }
    }

    @Override
    public void monitor(Database db, ServerPool sp, String modelName) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor database on a given serverpool with model " + modelName);
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (null == sp) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        if (null == modelName) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "modelName");
        }
        if (modelName.trim().equals("")) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_EMPTY_MODEL_NAME, new Object[0]);
        }
        String dbName = db.getUserAssignedName();
        String spName = sp.getName();
        if (sp.isBuiltinPool()) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_BUILTIN_SERVERPOOL, spName);
        }
        try {
            this.requestAction("start_target", "database", dbName + ":" + spName, modelName, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_9, dbName, spName, modelName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_DB_FAILED_ON_SRVPOOL_MODEL, (Throwable)e, e.getCompositeCHAStatus(), dbName, spName, modelName);
        }
    }

    @Override
    public void monitor(Database db, ServerPool sp) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor database on a given serverpool");
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (null == sp) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        String dbName = db.getUserAssignedName();
        String spName = sp.getName();
        if (sp.isBuiltinPool()) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_BUILTIN_SERVERPOOL, spName);
        }
        try {
            this.requestAction("start_target", "database", dbName + ":" + spName, null, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_10, dbName, spName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_DB_FAILED_ON_SRVPOOL, (Throwable)e, e.getCompositeCHAStatus(), dbName, spName);
        }
    }

    @Override
    public void monitor(Database db, Node node, String modelName) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor database on a given node with model " + modelName);
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (null == node) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
        }
        if (null == modelName) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "modelName");
        }
        if (modelName.trim().equals("")) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_EMPTY_MODEL_NAME, new Object[0]);
        }
        String dbName = db.getUserAssignedName();
        try {
            Node[] nodes = new Node[]{node};
            this.requestAction("start_target", "instance", dbName + ":", modelName, nodes);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_11, dbName, node.toString(), modelName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_DB_FAILED_ON_NODE_MODEL, (Throwable)e, e.getCompositeCHAStatus(), dbName, node, modelName);
        }
    }

    @Override
    public void monitor(Database db, Node node) throws AlreadyMonitoredException, CHAException {
        Trace.out("monitor database on a given node");
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (null == node) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
        }
        String dbName = db.getUserAssignedName();
        try {
            Node[] nodes = new Node[]{node};
            this.requestAction("start_target", "instance", dbName + ":", null, nodes);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyMonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_MONITORED_12, dbName, node.toString());
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_DB_FAILED_ON_NODE, (Throwable)e, e.getCompositeCHAStatus(), dbName, node);
        }
    }

    @Override
    public void unmonitor() throws AlreadyUnmonitoredException, CHAException {
        Trace.out("unmonitor cluster");
        try {
            ClusterUtil cu = new ClusterUtil();
            String clName = cu.getClusterName();
            this.requestAction("stop_target", "cluster", clName + ":", null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyUnmonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_UNMONITORED_1, new Object[0]);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_HOST_FAILED_ON_CLUSTER, (Throwable)e, e.getCompositeCHAStatus(), new Object[0]);
        }
        catch (ClusterUtilException e) {
            Trace.out("ClusterUtilException");
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_HOST_FAILED_ON_CLUSTER, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void unmonitor(ServerPool sp) throws AlreadyUnmonitoredException, CHAException {
        Trace.out("unmonitor serverpool");
        if (null == sp) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        String spName = sp.getName();
        if (sp.isBuiltinPool()) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_MONITOR_FAILED_BUILTIN_SERVERPOOL, spName);
        }
        try {
            ClusterUtil cu = new ClusterUtil();
            String clName = cu.getClusterName();
            this.requestAction("stop_target", "cluster", clName + ":" + spName, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyUnmonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_UNMONITORED_2, spName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_HOST_FAILED_ON_SRVPOOL, (Throwable)e, e.getCompositeCHAStatus(), spName);
        }
        catch (ClusterUtilException e) {
            Trace.out("ClusterUtilException");
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_HOST_FAILED_ON_SRVPOOL, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void unmonitor(Node node) throws AlreadyUnmonitoredException, CHAException {
        Trace.out("unmonitor host");
        if (null == node) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
        }
        String nodeName = null;
        try {
            nodeName = node.getName();
        }
        catch (NodeException e) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_HOST_FAILED_NODENAME, (Throwable)e, new Object[0]);
        }
        try {
            Node[] nodes = new Node[]{node};
            this.requestAction("stop_target", "host", nodeName, new Node[]{node});
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyUnmonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_UNMONITORED_3, nodeName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_HOST_FAILED, (Throwable)e, e.getCompositeCHAStatus(), nodeName);
        }
    }

    @Override
    public void unmonitor(Database db) throws AlreadyUnmonitoredException, CHAException {
        Trace.out("unmonitor database on all nodes");
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        String dbName = db.getUserAssignedName();
        try {
            this.requestAction("stop_target", "database", dbName, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyUnmonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_UNMONITORED_4, dbName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_DB_FAILED, (Throwable)e, e.getCompositeCHAStatus(), dbName);
        }
    }

    @Override
    public void unmonitor(Database db, ServerPool sp) throws AlreadyUnmonitoredException, CHAException {
        Trace.out("unmonitor database on a given serverpool");
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (null == sp) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        String dbName = db.getUserAssignedName();
        String spName = sp.getName();
        if (sp.isBuiltinPool()) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_FAILED_BUILTIN_SERVERPOOL, spName);
        }
        try {
            this.requestAction("stop_target", "database", dbName + ":" + spName, null);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyUnmonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_UNMONITORED_5, dbName, spName);
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_DB_FAILED_ON_SRVPOOL, (Throwable)e, e.getCompositeCHAStatus(), dbName, spName);
        }
    }

    @Override
    public void unmonitor(Database db, Node node) throws AlreadyUnmonitoredException, CHAException {
        Trace.out("unmonitor database on a given node");
        if (null == db) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "db");
        }
        if (null == node) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node");
        }
        String dbName = db.getUserAssignedName();
        try {
            Node[] nodes = new Node[]{node};
            this.requestAction("stop_target", "instance", dbName + ":", nodes);
        }
        catch (CHAException e) {
            if (this.m_ccs.isWarning()) {
                throw new AlreadyUnmonitoredException((MessageKey)PrClMsgID.CHA_ALREADY_UNMONITORED_6, dbName, node.toString());
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_UNMONITOR_DB_FAILED_ON_NODE, (Throwable)e, e.getCompositeCHAStatus(), dbName, node);
        }
    }

    @Override
    public CompositeCHAStatus getStatus() throws CHAException {
        Trace.out("Get the status");
        try {
            this.requestAction("status_target", "all", "", null);
        }
        catch (CHAException e) {
            Trace.out("there:" + e.getCompositeCHAStatus());
            throw new CHAException((MessageKey)PrClMsgID.CHA_GET_STATUS_FAILED, (Throwable)e, e.getCompositeCHAStatus(), new Object[0]);
        }
        return this.m_ccs;
    }

    @Override
    public CompositeCHAStatus getStatus(ServerPool sp) throws CHAException {
        Trace.out("Get the status for the given serverpool");
        if (null == sp) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "sp");
        }
        String spName = sp.getName();
        if (sp.isBuiltinPool()) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_STATUS_FAILED_BUILTIN_SERVERPOOL, spName);
        }
        try {
            this.requestAction("status_target", "all", spName, null);
        }
        catch (CHAException e) {
            throw new CHAException((MessageKey)PrClMsgID.CHA_GET_STATUS_FAILED_ON_SRVPOOL, (Throwable)e, e.getCompositeCHAStatus(), spName);
        }
        return this.m_ccs;
    }

    @Override
    public CompositeCHAStatus getStatus(List<Node> nodeList) throws CHAException {
        Trace.out("Get the status for the given nodes");
        if (null == nodeList) {
            throw new CHAException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "node", new Object[0]);
        }
        Node[] nodes = null;
        if (!nodeList.isEmpty()) {
            nodes = nodeList.toArray(new Node[nodeList.size()]);
        }
        try {
            this.requestAction("status_target", "all", "", nodes);
        }
        catch (CHAException e) {
            StringBuilder nNames = new StringBuilder();
            for (Node n : nodes) {
                if (nNames.length() > 0) {
                    nNames.append(", ");
                }
                nNames.append(n.toString());
            }
            throw new CHAException((MessageKey)PrClMsgID.CHA_GET_STATUS_FAILED_ON_NODE, (Throwable)e, e.getCompositeCHAStatus(), nNames.toString());
        }
        return this.m_ccs;
    }

    private void requestAction(String actionType, String targetType, String targetName, Node[] nodes) throws CHAException {
        this.requestAction(actionType, targetType, targetName, null, nodes);
    }

    private void requestAction(String actionType, String targetType, String targetName, String modelName, Node[] nodes) throws CHAException {
        block3: {
            if (null == modelName) {
                modelName = "";
            }
            ActionAttribute attrAction = new ActionAttribute("ACTION_TYPE", actionType);
            ActionAttribute attrTarget = new ActionAttribute("TARGET_TYPE", targetType);
            ActionAttribute attrName = new ActionAttribute("TARGET_NAME", targetName);
            ActionAttribute attrModel = new ActionAttribute("MODEL_NAME", modelName);
            ActionAttribute[] attrs = new ActionAttribute[]{attrAction, attrTarget, attrName, attrModel};
            CHAStatusListener csLsnr = new CHAStatusListener(this.m_ccs);
            try {
                this.m_crsResource.requestAction("action_target", attrs, nodes, csLsnr);
            }
            catch (CompositeActionException e) {
                if (this.m_ccs.isSuccess()) break block3;
                throw new CHAException((MessageKey)PrClMsgID.CHA_ACTION_REQUEST_FAILED, (Throwable)e, this.m_ccs.getErrorMessage(), this.m_ccs, new Object[0]);
            }
        }
    }

    private ResourceAttribute createCHAACLAttr() throws CRSException {
        NativeSystem m_nativeSystem = new SystemFactory().CreateSystem();
        ResourcePermissionsImpl per = null;
        try {
            Util utl = new Util();
            if (m_nativeSystem.isUnixSystem()) {
                per = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.CRS_USER);
                String owner = per.getOwner();
                String pGroup = utl.getPrimaryGroup(owner);
                per.setPerm(ResourceType.ACL.PGROUP, pGroup, ResourceType.ACL_PERM.READ);
            } else {
                Trace.out("Create windows resource using NT AUTHORITY\\SYSTEM as owner");
                per = CRSFactoryImpl.getInstance().createPerm(ResourceType.ACL_CREATOR.DB_USER);
            }
            String crsHome = utl.getCRSHome();
            String group = utl.getOracleGroup(crsHome);
            per.setPerm(ResourceType.ACL.GROUP, group, ResourceType.ACL_PERM.READ);
            String acl = ResourceLiterals.ACL_ATTR.toString();
            per.setPerm(ResourceType.ACL.OTHER, "", ResourceType.ACL_PERM.READ);
            Trace.out(" CHA ACL permissions:" + per.getAclString());
            ResourceAttribute aclAttr = new ResourceAttribute(acl, per.getAclString());
            return aclAttr;
        }
        catch (UtilException e) {
            Trace.out((Exception)((Object)e));
            throw new CRSException(e);
        }
    }
}

