/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.cha;

import oracle.cluster.cha.CHADBConnection;
import oracle.cluster.cha.CHAException;
import oracle.cluster.database.DBConnectionException;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.impl.database.MgmtDBConnectionImpl;
import oracle.cluster.wallet.CLSW;
import oracle.cluster.wallet.CLSWException;
import oracle.ops.mgmt.trace.Trace;

public class CHADBConnectionImpl
extends MgmtDBConnectionImpl
implements CHADBConnection {
    public static final String MGMTDB_WALLET_TYPE = "MGMTDB";

    CHADBConnectionImpl() throws DBConnectionException, DatabaseException, CHAException {
        this.m_user = this.getDBSchema();
        this.m_passwd = this.getDBSchemaPassword();
    }

    private String getDBSchema() {
        return "CHA";
    }

    private String getDBSchemaPassword() throws CHAException {
        CLSW clsw = null;
        Trace.out("Getting password from wallet...");
        try {
            String wname = new String("");
            clsw = CLSW.getInstance();
            clsw.initializeCLSW();
            String passwd = clsw.getSecret(MGMTDB_WALLET_TYPE, wname, this.m_user);
            Trace.out(this.m_user + " passwd obtained.");
            clsw.terminateCLSW();
            return passwd;
        }
        catch (CLSWException e) {
            Trace.out("Failed to te initialize CLSW context: " + e.toString());
            throw new CHAException(e);
        }
    }
}

