/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.adminhelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.cluster.adminhelper.AdminHelper;
import oracle.cluster.adminhelper.AdminHelperException;
import oracle.cluster.adminhelper.AdminHelperWarningException;
import oracle.cluster.adminhelper.AdminResult;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.impl.common.SoftwareModuleImpl;
import oracle.cluster.impl.crs.CRSEntity;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.CRSResourceImpl;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.impl.crs.cops.CRSNative;
import oracle.cluster.impl.crs.cops.CRSNativeException;
import oracle.cluster.impl.crs.cops.CRSNativeResult;
import oracle.cluster.impl.nodeapps.NodeAppsFactoryImpl;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class AdminHelperImpl
extends SoftwareModuleImpl
implements AdminHelper {
    private ResourceAttribute m_nameAttr;
    private static final String SUCCESS_SIGNATURE = "SUCCESS";
    private static final String FAILURE_SIGNATURE = "FAILURE";
    private static final String LSEP = System.getProperty("line.separator");
    private boolean isFailure = false;
    public static String m_clusterName = null;

    AdminHelperImpl(ResourceAttribute nameAttr) throws AdminHelperException {
        try {
            Trace.out("nameAttr.getValue(): " + nameAttr.getValue());
            if (!nameAttr.getName().equalsIgnoreCase(ResourceType.ADMINHELPER.NAME.name())) {
                throw new AdminHelperException((MessageKey)PrCrMsgID.RES_ATTR_NAME_INVALID, nameAttr.getName(), ResourceType.ADMINHELPER.NAME.name());
            }
            String[] values = nameAttr.getValue().split(Pattern.quote(String.valueOf('.')));
            int numValues = values.length;
            boolean attrValueInvalid = false;
            if (numValues == 2) {
                if (!"ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) || !ResourceLiterals.ADMINHELPER.toString().equalsIgnoreCase(values[numValues - 1])) {
                    attrValueInvalid = true;
                }
            } else if (numValues == 3) {
                if (!("ora.".equalsIgnoreCase(values[0] + String.valueOf('.')) && values[1].startsWith(ResourceLiterals.ADMINHELPER.toString()) && ResourceLiterals.ADMINHELPERSUFFIX.toString().equalsIgnoreCase(values[2]))) {
                    attrValueInvalid = true;
                }
            } else {
                attrValueInvalid = true;
            }
            if (attrValueInvalid) {
                throw new AdminHelperException((MessageKey)PrCrMsgID.RES_ATTR_VALUE_INVALID, ResourceType.ADMINHELPER.NAME.name(), nameAttr.getValue());
            }
            this.m_nameAttr = nameAttr;
            this.m_name = this.m_nameAttr.getValue();
            Trace.out("m_name: " + this.m_name);
            this.m_displayName = values[1];
            this.m_crsResource = (CRSResourceImpl)((Object)CRSFactoryImpl.getInstance().getClusterResource(this.m_nameAttr));
        }
        catch (NotExistsException values) {
        }
        catch (CRSException e) {
            throw new AdminHelperException(e);
        }
    }

    void create(Version version) throws AlreadyExistsException, AdminHelperException {
        try {
            NodeAppsFactoryImpl.getInstance().assertRoot();
        }
        catch (SoftwareModuleException e) {
            throw new AdminHelperException(e);
        }
        try {
            CRSFactoryImpl crsFactory = CRSFactoryImpl.getInstance();
            ResourceAttribute admhTypeAttr = crsFactory.create(ResourceType.ADMINHELPER.NAME.name(), ResourceType.ADMINHELPER.NAME.toString());
            List<ResourceAttribute> attrList = crsFactory.getResourceTypeEntity(admhTypeAttr).getAttributes(new String[0]);
            attrList = ResourceType.getProfile(attrList);
            for (ResourceAttribute attr : attrList) {
                if (attr.getName().equalsIgnoreCase(ResourceType.ADMINHELPER.NAME.name())) {
                    attr.setValue(this.getAdminHelperResourceName());
                    continue;
                }
                if (!attr.getName().equalsIgnoreCase(ResourceType.ADMINHELPER.DESCRIPTION.name())) continue;
                attr.setValue(ResourceLiterals.ADMINHELPER_RES_DESC.toString());
            }
            attrList.add(crsFactory.create(ResourceType.LocalResource.VERSION.name(), version.toString()));
            this.m_crsResource = (CRSResourceImpl)crsFactory.create(CRSEntity.Type.Resource, attrList, ResourceType.ACL_CREATOR.ROOT);
        }
        catch (CRSException e) {
            throw new AdminHelperException((MessageKey)PrCrMsgID.RES_ADD_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void remove(boolean force) throws AlreadyRunningException, AdminHelperException {
        try {
            super.remove(force);
        }
        catch (SoftwareModuleException e) {
            throw new AdminHelperException(e);
        }
    }

    @Override
    public CRSResource crsResource() throws NotExistsException, AdminHelperException {
        try {
            return super.crsResource();
        }
        catch (SoftwareModuleException e) {
            throw new AdminHelperException((MessageKey)PrCrMsgID.RES_LOOKUP_FAILED, (Throwable)e, this.m_nameAttr.getValue(), this.getUserAssignedName());
        }
    }

    @Override
    public void start(List<Node> nodes) throws AlreadyRunningException, AdminHelperException, CompositeOperationException {
        try {
            super.start(nodes);
        }
        catch (SoftwareModuleException e) {
            throw new AdminHelperException(e);
        }
    }

    public static String getDefaultResourceName() {
        return "ora." + ResourceLiterals.ADMINHELPER.toString();
    }

    public static String getNonDefaultResourceName(int number) {
        return "ora." + ResourceLiterals.ADMINHELPER.toString() + number + '.' + ResourceLiterals.ADMINHELPERSUFFIX.toString();
    }

    @Override
    public String getAdminHelperResourceName() {
        return this.m_nameAttr.getValue();
    }

    private boolean buildFailureMap(CRSNativeResult nr, List<String> nodeList, boolean warningIsExit2, String keyword, Map<String, AdminResult> out_Map) {
        Map<Object, CRSNativeException> msgCRSMap = nr.getCompDescr();
        ArrayList<String> nodesNoResponse = new ArrayList<String>();
        boolean isWarningOnly = true;
        boolean isDBCAorDBUA = "GH_DBCA".equals(keyword) || "GH_DBUA".equals(keyword) || "GH_Addnode".equals(keyword);
        nodesNoResponse.addAll(nodeList);
        Trace.out("No of nodes initially = " + nodesNoResponse.size());
        for (Object str : msgCRSMap.keySet()) {
            nodesNoResponse.remove((String)str);
            CRSNativeException exec = msgCRSMap.get(str);
            Trace.out("NODENAME-->" + str + " MSG STRING is..." + exec.toString());
            String detMsg = exec.toString();
            String[] detArr = detMsg.split("::");
            if (detArr[0].equals(SUCCESS_SIGNATURE)) continue;
            String retStatus = detArr[0].trim().substring(6);
            int status = Integer.parseInt(retStatus);
            Trace.out("exit code : %d", status);
            if (isWarningOnly && warningIsExit2 && !isDBCAorDBUA && status == 2 || isDBCAorDBUA && status > 0 && status < 128) {
                Trace.out("Warning received on node " + str);
            } else {
                Trace.out("Error received on node " + str);
                isWarningOnly = false;
            }
            if (out_Map.get(str) == null) {
                out_Map.put((String)str, new AdminResult(Integer.parseInt(retStatus), detArr[1]));
                continue;
            }
            if (detArr.length <= 1) continue;
            String appendMsg = out_Map.get(str) + LSEP + detArr[1];
            out_Map.put((String)str, new AdminResult(Integer.parseInt(retStatus), appendMsg));
        }
        Trace.out("No of nodes without response = " + nodesNoResponse.size());
        if (nodesNoResponse.size() > 0) {
            isWarningOnly = false;
            for (String node : nodesNoResponse) {
                out_Map.put(node, new AdminResult(1, MessageBundle.getMessage(PrCrMsgID.NO_RESPONSE, false, null)));
            }
        }
        return isWarningOnly;
    }

    private Map<String, AdminResult> buildOutputMap(CRSNativeResult nr) {
        Map<String, List<String>> outputCRSMap = nr.getCompOutput();
        LinkedHashMap<String, AdminResult> outputMap = new LinkedHashMap<String, AdminResult>();
        for (String node : outputCRSMap.keySet()) {
            List<String> output = outputCRSMap.get(node);
            if (output == null || output.size() <= 0) continue;
            Trace.out("NODENAME-->" + node + " Output is..." + output.toString());
            outputMap.put(node, new AdminResult(0, output));
        }
        return outputMap;
    }

    @Override
    public Map<String, AdminResult> executeAction(String userName, List<String> nodeList, int magicno, String keyword, int nargs, String[] args, ProgressListener plsnr) throws AdminHelperException, AdminHelperWarningException {
        return this.executeAction(userName, nodeList, magicno, keyword, nargs, args, plsnr, false, false);
    }

    @Override
    public Map<String, AdminResult> executeAction(String userName, List<String> nodeList, int magicno, String keyword, int nargs, String[] args, ProgressListener plsnr, boolean warningIsExit2, boolean isOutputOff) throws AdminHelperException, AdminHelperWarningException {
        CRSNativeResult nr = new CRSNativeResult(plsnr, nodeList.size() == 1);
        if (isOutputOff) {
            nr.setOutputOff();
        }
        try {
            ServerFactory sf = ServerFactory.getInstance();
            ArrayList<Node> nl = new ArrayList<Node>();
            for (String nodename : nodeList) {
                nl.add(sf.getNode(nodename));
            }
            if (nl.size() > 0) {
                this.start(nl);
            } else {
                Trace.out("Helper Resource is Running on all the nodes :" + Arrays.toString(nodeList.toArray()));
            }
        }
        catch (AlreadyRunningException sf) {
        }
        catch (CompositeOperationException e) {
            throw new AdminHelperException(e);
        }
        catch (ServerException e) {
            throw new AdminHelperException(e);
        }
        catch (NodeException e) {
            throw new AdminHelperException(e);
        }
        catch (SoftwareModuleException e) {
            throw new AdminHelperException(e);
        }
        String nodelist = Utils.getString(nodeList, ",");
        try {
            if (m_clusterName == null) {
                m_clusterName = new ClusterUtil().getClusterName();
            }
            String resourceName = this.getAdminHelperResourceName();
            Trace.out("Executing Admin Action ");
            CRSNative.executeAdminAction(nr, userName, m_clusterName, nodelist, resourceName, magicno, keyword, nargs, args);
            Trace.out(" Success Executing Admin Action");
            return this.buildOutputMap(nr);
        }
        catch (CRSException e) {
            if (nr.isPartialStatus()) {
                Trace.out("Partial result was set..");
                LinkedHashMap<String, AdminResult> out_Map = new LinkedHashMap<String, AdminResult>();
                boolean isWarningOnly = this.buildFailureMap(nr, nodeList, warningIsExit2, keyword, out_Map);
                if (!isWarningOnly) {
                    Trace.out("Failure case.....");
                    throw new AdminHelperException((MessageKey)PrCrMsgID.EXEC_ROOTCMD_FAILED, out_Map);
                }
                Trace.out("WARNING case.....");
                throw new AdminHelperWarningException((MessageKey)PrCrMsgID.EXEC_ROOTCMD_FAILED, out_Map);
            }
            Trace.out("Error Executing Admin Action" + e.getMessage());
            throw new AdminHelperException((MessageKey)PrCrMsgID.EXEC_ROOTCMD_FAILED, (Throwable)e, new Object[0]);
        }
        catch (ClusterUtilException e) {
            throw new AdminHelperException(e);
        }
    }
}

