/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.home;

import java.util.List;
import oracle.cluster.home.Home;
import oracle.cluster.home.HomeArgs;
import oracle.cluster.home.HomeException;
import oracle.cluster.home.HomeType;
import oracle.cluster.home.OracleHome;
import oracle.cluster.impl.home.HomeFactoryImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.nls.MessageKey;

public class HomeFactory {
    private static HomeFactory s_instance;
    private HomeFactoryImpl s_homeFactoryImpl = HomeFactoryImpl.getInstance();

    private HomeFactory() throws HomeException {
    }

    public static synchronized HomeFactory getInstance() throws HomeException {
        if (s_instance == null) {
            s_instance = new HomeFactory();
        }
        return s_instance;
    }

    public Home getHome(String oraHome) throws HomeException {
        if (null == oraHome) {
            throw new HomeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oraHome", oraHome);
        }
        return this.s_homeFactoryImpl.getHome(oraHome);
    }

    public Home getHome(String oraHome, Node clusterNode) throws HomeException {
        if (null == oraHome) {
            throw new HomeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "oraHome", oraHome);
        }
        if (null == clusterNode) {
            throw new HomeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "clusterNode", clusterNode);
        }
        return this.s_homeFactoryImpl.getHome(oraHome, clusterNode);
    }

    public OracleHome createOracleHome(HomeArgs values) throws AlreadyExistsException, HomeException {
        return this.s_homeFactoryImpl.createOracleHome(values);
    }

    public OracleHome createPOLICYOracleHome(String name, String path) throws AlreadyExistsException, HomeException {
        return this.s_homeFactoryImpl.createOracleHome(name, path);
    }

    public OracleHome createADMINOracleHome(String name, String path, String[] nodeList) throws AlreadyExistsException, HomeException {
        return this.s_homeFactoryImpl.createOracleHome(name, path, nodeList);
    }

    public OracleHome createSIOracleHome(String name, String path) throws AlreadyExistsException, HomeException {
        return this.s_homeFactoryImpl.createSIOracleHome(name, path);
    }

    public OracleHome createOracleHome(String name, String path, HomeType type, String[] nodeList) throws AlreadyExistsException, HomeException {
        return this.s_homeFactoryImpl.createOracleHome(name, path, type, nodeList);
    }

    public List<OracleHome> getOracleHomes() throws NotExistsException, HomeException {
        return this.s_homeFactoryImpl.getOracleHomes();
    }

    public OracleHome getOracleHome(String name) throws NotExistsException, HomeException {
        return this.s_homeFactoryImpl.getOracleHome(name);
    }

    public OracleHome getOracleHomeByPath(String path) throws NotExistsException, HomeException {
        return this.s_homeFactoryImpl.getOracleHomeByPath(path);
    }
}

