/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.helper;

import java.util.ArrayList;
import oracle.cluster.helper.Helper;
import oracle.cluster.logger.FileOutput;
import oracle.cluster.logger.SRVLevel;
import oracle.cluster.logger.TraceLogger;
import oracle.cluster.logger.TraceLoggerFactory;
import oracle.cluster.resources.PrCgMsgID;
import oracle.ops.mgmt.nls.MessageBundle;

public class SRVMHelper
extends Helper {
    private static String SRVM = "srvm";
    private static String LOG = "log";
    private static String[] m_args;
    private static String UPDATE_DEP_ASM;
    private ArrayList<Helper.CommandLineOption> m_cmdLineOptList = null;
    private static TraceLoggerFactory tf;
    private static TraceLogger s_tlogger;
    private static boolean s_bAppend;
    private static boolean s_bSavePreviousLog;
    private static int s_maxLogOutputSize;
    private static int s_maxLogOutputFiles;
    private static MessageBundle m_msgBndl;

    public SRVMHelper() {
        this.addCommandLineOption("-getCSSMode", 1, "getCSSMode", "return CSS mode");
        this.addCommandLineOption("-getASMStatusInfo", 1, "getASMStatusInfo", "return ASM status info");
        this.addCommandLineOption("copydir", 8, "copyDir", "copy directory contents from source to destination path. Usage: srvmhelper copydir <source_path> <destination_path> <include_list_file> <exclude_list_file> <node_names> <host_and_port> <database_unique_name>");
        this.addCommandLineOption("copydbs", 4, "copyDBS", "copy database directory contents from source to destination path. Usage: srvmhelper copydbs <source_path> <destination_path> <host_and_port> [<database_unique_name>]");
        this.addCommandLineOption("-getTargetHubSize", 1, "getTargetHubSize", "return target hub size");
        this.addCommandLineOption("-updateDepASM", 1, "updateDepASM", "update start and stop dependencies of ASM related resources.");
        this.addCommandLineOption("addnfs", 8, "addnfs", "Adds nfs resource: srvmhelper addnfs <mount-path> <name> <hostname-ipaddress> <export-path> [-fsoptions <mount-options>] <username>");
        this.addCommandLineOption("addexportfs", 7, "addexportfs", "Adds exportfs resource: srvmhelper addexportfs <havip-id> <export-name> <export-path> <export-clients> <export-options>");
        this.addCommandLineOption("runmgmtca", 1, "runmgmtca", "Runs mgmtca on the node having mgmtdb");
        this.addCommandLineOption("makedir", 3, "makeDir", "Creates directory on a given node list: srvmhelper makedir <node_list> <full_directory_path>");
        this.addCommandLineOption("deleteDir", 3, "deleteDir", "Deletes directory on a given node list: srvmhelper -deleteDir <node_list> <full_directory_path>");
        this.addCommandLineOption("ghcreds", 3, "createGHCreds", "Create rhp credentials: srvmhelper ghcreds <updFlag> <isUpg> [<cluster_name>]");
        this.addCommandLineOption("-isOCROnASM", 1, "isOCROnASM", "returns whether OCR is on ASM");
        this.addCommandLineOption("-isMgmtDBConfigured", 1, "isMgmtDBConfigured", "return true if Management database is configured, false otherwise");
        this.addCommandLineOption("addUserToACFS", 3, "addUserToACFS", "Add user to ACL of the acfs filesystem resource");
        this.addCommandLineOption("removeUserFromACFS", 3, "removeUserFromACFS", "Remove user from ACL of the acfs filesystem resource");
        this.addCommandLineOption("isDirWritable", 3, "isDirWritable", "Is Directory (absolute path) Writable: srvmhelper isDirWritable <nodelist> <dir>");
        this.addCommandLineOption("getDeltaPatchesLspatches", 3, "getDeltaPatchesLspatches", "Get the difference between the patches applied to two Oracle Homes using opatch lspatches command: srvmhelper getDeltaPatchesLspatches <oracle_home_1> <oracle_home_2>");
        this.addCommandLineOption("-getMgmtDBNodeName", 1, "getMgmtDBNodeName", "return the name of the node where mgmt db is running");
        this.addCommandLineOption("-getACFSAcl", 2, "getACFSPermission", "gets the ACL of the provided ACFS: srvmhelper -getACFSAcl <acfs_path>");
        this.addCommandLineOption("-isDatabaseAdminManaged", 2, "isDatabaseAdminManaged", "Checks if database is admin-managed. Usage: srvmhelper -isDatabaseAdminManaged <db_name>");
        this.addCommandLineOption("-isLeafnodeAllowed", 1, "isLeafnodeAllowed", "Checks if the cluster is configured to support leaf nodes. Usage: srvmhelper -isLeafnodeAllowed");
        this.addCommandLineOption("-getAdminDBConfiguredNodes", 2, "getAdminDBConfiguredNodes", "Get list of nodes on which an admin-managed database is configures. Usage: srvmhelper -getAdminDBConfiguredNodes <db_name>");
        this.addCommandLineOption("checkdbinst", 6, "checkdbinst", "do cluvfy pre dbinst check: srvmhelper checkdbinst <dbver> <nodelist> {<dbhome>|null} {<oraclebase>|null} {<adminGroups>|HelperConstants.GROUP_PLACEHOLDER}");
        this.addCommandLineOption("checkdbfile", 3, "checkdbfile", "verify database storage (writable and shared): srvmhelper checkdbfile <nodelist> <dbfile>");
        this.addCommandLineOption("getDirSize", 2, "getDirSize", "Get directory size of a home path: srvmhelper getDirSize <path>");
        this.addCommandLineOption("checkEnoughSpace", 5, "checkEnoughSpace", "check if enough space is available on the given path : srvmhelper checkEnoughSpace <Home_path> <nodelist> <path> <size>");
        this.addCommandLineOption("isSharedPath", 3, "isSharedPath", "Is Directory (absolute path) shared: srvmhelper isSharedPath <nodelist> <dir>");
        this.addCommandLineOption("getDeltaPatchesLsinventory", 3, "getDeltaPatchesLsinventory", "Get the difference between the patches applied to two Oracle Homes using opatch lsinventory command: srvmhelper getDeltaPatchesLsinventory <oracle_home_1> <oracle_home_2>");
        this.addCommandLineOption("getIdPatches", 4, "getIdPatches", "Get the IDs of the patches applied to the specified Oracle Home: srvmhelper getIdPatches <oracle_home> <oracle_home_version> [create_inventory]");
        this.addCommandLineOption("isRollingPatch", 3, "isRollingPatch", "Identify if the specified patch is a rolling patch: srvmhelper isRollingPatch <oracle_home> <patch_number>");
        this.addCommandLineOption("getBugNumbers", 4, "getBugNumbers", "Get the bug numbers of the patches installed in the specified Oracle Home: srvmhelper getBugNumbers <oracle_home> <oracle_home_version> [create_inventory]");
        this.addCommandLineOption("getPlatformID", 2, "getPlatformID", "Get platform ID of a home path: srvmhelper getPlatformID <path>");
        this.addCommandLineOption("-moveDatabases", 4, "moveDatabases", "Moves all databases from the specified source Oracle Home to the specified destination Oracle Home in a rolling or non-rolling fashion (specify true or false accordingly for the rolling_flag option). Usage: srvmhelper -moveDatabases <oldOraHome> <newOraHome> <rolling_flag>");
        this.addCommandLineOption("-move1Database", 4, "move1Database", "Moves the specified database to the specified Oracle Home in a rolling or non-rolling fashion (specify true or false accordingly for the rolling_flag option). Usage: srvmhelper -move1Database <db_name> <OraHome> <rolling_flag>");
        this.addCommandLineOption("-batchMoveDatabases", 9, "batchMoveDatabases", "Moves the specified databases to the specified Oracle Home by modifying ORACLE_HOME attribute, if needed, and restarting database instances on specified nodes. Usage: srvmhelper -batchMoveDatabases <db_names> <destOraHome> <node_names> <stop_option> <disconnect_flag> <noreplay_flag> <drain_timeout> <plsnr_host_port>. Use HelperConstants.NOT_SPECIFIED as a placeholder to skip arguments.");
        this.addCommandLineOption("-moveDatabases2", 9, "moveDatabases2", "Moves the specified databases to the specified destination Oracle Home in a rolling or non-rolling fashion (specify true or false accordingly for the rolling_flag option). Usage: srvmhelper -moveDatabases2 <db_name_list> <newOraHome> <rolling_flag> <stop_option> <disconnect_flag> <noreplay_flag> <drain_timeout> <plsnr_host_port>. Use HelperConstants.NOT_SPECIFIED as a placeholder to skip arguments.");
        this.addCommandLineOption("mergeListenerOra", 3, "mergeListenerOra", "Merge two listener.ora files: srvmhelper mergelistenerora <source_path> <target_path>");
        this.addCommandLineOption("mergeTnsnames", 3, "mergeTnsnames", "Merge two tnsnames.ora files: srvmhelper mergetnsnames <source_path> <target_path>");
        this.addCommandLineOption("mergeSqlNetOra", 5, "mergeSqlNetOra", "Merge two sqlnet.ora files: srvmhelper mergesqlnetora <source_oracle_home> <target_oracle_home> <source_path> <target_path>");
        this.addCommandLineOption("execpatchaction", 16, "execPatchAction", "Executes a pre or post gi patch action : srvmhelper execpatchaction <oracle_home> <postpatch/prepatch> <rhplsnrhostport> <mayExit> <auPath/null> <agPath/null> <clusterNodes/null> <giUser/null> <oracleBase/null> <oracleHomeName/null> <isRolling> <isRollback> <perlHome> <cleanPIDFlag> <iplsnrhostport> ");
        this.addCommandLineOption("getdbswVer", 2, "getdbswVer", "Get DBSOFTWARE version from an image home path: srvmhelper getdbswVer <source_path>");
        this.addCommandLineOption("getRHPClusterType", 1, "getRHPClusterType", "Prints GHC or GHS  if the RHP client/server is configured, NONE otherwise, srvmhelper getRHPClusterType");
        this.addCommandLineOption("exportClientData", 5, "exportClientData", "Export the RHP client credentials: srvmhelper exportClientData <sysID> <client> <vipAddr> <subdomain>");
        this.addCommandLineOption("createAdminHelper", 2, "createAdminHelper", "Creates an Admin Helper resource with the specified name. Usage: srvmhelper createAdminHelper <resourceName>");
        this.addCommandLineOption("deleteAdminHelper", 2, "deleteAdminHelper", "Deletes a list of Admin Helper resources given a comma seperated rescource name list. Usage: srvmhelper deleteAdminHelper <resourceName1,resourceName2,...,resourceNameN>");
        this.addCommandLineOption("-copyFrom", 5, "copyFrom", "Performs client side actions to copy a file from the client to a node running CopyListener with a configured host and port. Usage: srvmhelper -copyFrom <host> <port> <source_path> <destination_path>");
        this.addCommandLineOption("-copyTo", 5, "copyTo", "Performs client side actions to copy a file to the client from a node running CopyListener with a configured host and port. Usage: srvmhelper -copyTo <host> <port> <source_path> <destination_path>");
        this.addCommandLineOption("-getOracleUser", 2, "getOracleUser", "Gets the oracle user of the specified oracle home path. Usage: srvmhelper -getOracleUser <path>");
        this.addCommandLineOption("-getServerPools", 2, "getServerPools", "Gets Serverpools configured in cluster by category type, either hub or leaf. Usage: srvmhelper -getServerPools <category_type>");
        this.addCommandLineOption("-executeUserActions", 2, "executeUserActions", "Executes the useractions provided in the useraction list. Usage: srvmhelper -executeUserActions <baseDir> <uaInfo> <args> <nodelist>");
        this.addCommandLineOption("resetRepos", 1, "resetRepos", "Resets the Rapid Home Provisioning repository. Usage: srvmhelper resetRepos");
        this.addCommandLineOption("-getAdminDBRunOnNode", 2, "getAdminDatabaseNames", "Gets the unique names of admin-managed databases whose instances are running on the specified node. Usage: srvmhelper -getAdminDBRunOnNode <node_name>");
        this.addCommandLineOption("-getActiveServers", 2, "getActiveServers", "Gets the list of active servers configured in server pool. Usage: srvmhelper -getActiveServers <server_poolName>");
        this.addCommandLineOption("getACFSMountNodes", 4, "getACFSMountNodes", "Gets all the nodes where an ACFS resource is running (mounted). Usage: srvmhelper getACFSMountNodes <vol_device> <dg_name> <vol_name>");
        this.addCommandLineOption("isACFSNodeLocal", 2, "isACFSNodeLocal", "Check if ACFS resource using the specified volume device is node local Usage: srvmhelper isACFSNodeLocal <volume_device>");
        this.addCommandLineOption("copyAndChown", 5, "copyAndChown", "Copies the provided files to the given directory and changes it's ownership. Usage: srvmhelper copyAndChown <userid> <groupid> <file_list> <destination_path>");
        this.addCommandLineOption("removeFiles", 3, "removeFiles", "Removes the specified files from all of the specified nodes. Usage: srvmhelper removeFiles <file_list> <destination_nodes>");
        this.addCommandLineOption("-execRHPHelper", 4, "executeRHPHelper", "Executes 'rhphelper' on the local node. Usage: srvmhelper -execRHPHelper <parent_dir_path> {home_path|HelperConstants.NOT_SPECIFIED} <keyword> [args]");
        this.addCommandLineOption("getScanName", 2, "getScanName", "Gets the Cluster Scan Name. Usage: srvmhelper getScanName <netnum>");
        this.addCommandLineOption("-dynamicOps", 3, "dynamicOps", "Loads RHPHelper*class from rhphelper*jar located in the specified parent directory and invokes dynamicOps method with the specified keyword and arguments.Usage: srvmhelper -dynamicOps <parent_dir_path> <keyword> [args]");
        this.addCommandLineOption("checkPatchedBugs", 5, "checkPatchedBugs", "Checks if the specified Oracle bug numbers or patch numbers are installed in the specified Oracle HomeUsage: srvmhelper -checkPatchedBugs <Oracle_Home> <bugs> <node_list> <isRacHome>");
    }

    public static void main(String[] args) {
        int retVal = 1;
        SRVMHelper.setupTracing();
        SRVMHelper helper = new SRVMHelper();
        String methodName = helper.parseArguments(args);
        if (methodName != null) {
            if (methodName.equals("NOT_SPECIFIED")) {
                System.exit(retVal);
            }
            if (methodName.equalsIgnoreCase(UPDATE_DEP_ASM)) {
                helper.setUseTags(false);
            }
            if ((retVal = helper.processCommandLine("oracle.cluster.helper.Helper", methodName, args)) != 1) {
                helper.displayExecutionSuccess();
            } else {
                helper.displayExecutionError(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "srvmhelper-main-error_1"));
            }
        } else {
            helper.displayExecutionError(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "srvmhelper-main-error_2"));
        }
        System.exit(retVal);
    }

    public static void setupTracing() {
        boolean tracingOn = Boolean.parseBoolean(System.getProperty("TRACING.ENABLED"));
        tf = TraceLoggerFactory.getInstance();
        s_tlogger = tf.getTraceLogger();
        int defaultValue = s_tlogger.convertToTraceLevel(SRVLevel.CRITICAL_LEVEL);
        int tracingLvl = Integer.parseInt(System.getProperty("TRACING.LEVEL", "" + defaultValue), 10);
        String traceFileName = System.getProperty("srvm.srvmhelper.tracefile");
        s_tlogger.traceEnabled(tracingOn);
        s_tlogger.setLevel(tracingLvl);
        if (tracingOn && traceFileName != null) {
            FileOutput fout = new FileOutput(traceFileName, s_maxLogOutputSize, s_maxLogOutputFiles, s_bAppend, s_bSavePreviousLog);
            s_tlogger.addOutput(fout);
        }
    }

    static {
        UPDATE_DEP_ASM = "updateDepASM";
        s_tlogger = null;
        s_bAppend = true;
        s_bSavePreviousLog = false;
        s_maxLogOutputSize = 0xA00000;
        s_maxLogOutputFiles = 2;
    }
}

