/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import oracle.cluster.common.CSSMode;
import oracle.cluster.deployment.ASMStatusInfo;
import oracle.cluster.helper.HelperConstants;
import oracle.cluster.helper.HelperException;
import oracle.cluster.helper.SRVMHelperExec;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class HelperUtil
implements HelperConstants {
    private static String GET_CSSMODE_HELPER_ARG = "-getCSSMode";
    private static String GET_ASMSTATUS_HELPER_ARG = "-getASMStatusInfo";
    private static String GET_TGTHUBSIZE_HELPER_ARG = "-getTargetHubSize";
    private static String COPY_DIR_HELPER_ARG = "-copyDir";
    private static String SOURCE_PATH_HELPER_ARG = "-sourcepath";
    private static String DEST_PATH_HELPER_ARG = "-destpath";
    private static String EXCL_FILE_HELPER_ARG = "-exclfile";
    private static String IS_OCR_ON_ASM_HELPER_ARG = "-isOCROnASM";
    private static String IS_MGMTDB_CONFIGURED_ARG = "-isMgmtDBConfigured";
    private static String NODELIST_HELPER_ARG = "-nodelist";
    private static String GET_MGMTDBNODENAME_HELPER_ARG = "-getmgmtdbnodename";
    private static String GET_ACFS_ACL_HELPER_ARG = "-getACFSAcl";
    private static String ACTIVE = "ACTIVE";
    private static String CONFIGURED = "CONFIGURED";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final char[] cmdSepArrNT = new char[]{',', ';'};

    public static SRVMHelperExec runSRVMHelper(String[] args, String[] env) throws HelperException {
        try {
            NativeSystem system = new SystemFactory().CreateSystem();
            String crsHome = system.getCRSHome(new Version());
            Trace.out("crshome obtained is" + crsHome);
            return HelperUtil.runSRVMHelper(args, env, crsHome);
        }
        catch (NativeException e) {
            Trace.out("Crshome couldn't be obtained");
            throw new HelperException(e);
        }
    }

    public static SRVMHelperExec runSRVMHelper(String[] args, String[] env, String crsHome) throws HelperException {
        int i;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean isUnix = nativeSystem.isUnixSystem();
        String helper = nativeSystem.getScriptFileName("srvmhelper");
        String helperCmd = crsHome + FSEP + "srvm" + FSEP + "admin" + FSEP + helper;
        File helperBinary = new File(helperCmd);
        if (!helperBinary.exists()) {
            throw new HelperException((MessageKey)PrCtMsgID.SRVMHELPER_SCRIPT_NOT_FOUND, helperCmd);
        }
        Trace.out("About to run" + helperCmd);
        if (args.length < 1) {
            throw new HelperException((MessageKey)PrCrMsgID.HELPER_INSUFFICIENT_ARGUMENTS, helper);
        }
        String[] execArgs = new String[args.length + 2];
        execArgs[0] = helperCmd;
        if (isUnix) {
            for (i = 0; i < args.length; ++i) {
                execArgs[i + 1] = args[i];
            }
        } else {
            for (i = 0; i < args.length; ++i) {
                boolean addQuote = false;
                for (int j = 0; j < cmdSepArrNT.length; ++j) {
                    if (args[i].indexOf(cmdSepArrNT[j]) == -1) continue;
                    addQuote = true;
                    break;
                }
                execArgs[i + 1] = addQuote ? "\"" + args[i] + "\"" : args[i];
            }
        }
        execArgs[args.length + 1] = "\"SRVM_TRACING_ID=" + Integer.toString(Trace.getUID()) + "\"";
        ArrayList<Object> envList = env != null ? new ArrayList<String>(Arrays.asList(env)) : new ArrayList();
        String strLang = MessageBundle.getStrLang();
        String strNlsLang = MessageBundle.getStrNlsLang();
        if (strLang != null) {
            envList.add("LANG=" + strLang);
        }
        if (strNlsLang != null) {
            envList.add("NLS_LANG=" + strNlsLang);
        }
        if (!envList.isEmpty()) {
            Trace.out("env variables are not empty.");
            env = new String[envList.size()];
            envList.toArray(env);
        }
        SRVMHelperExec helperExec = new SRVMHelperExec(execArgs, env);
        helperExec.runCommand();
        Trace.out("after execution of helper for " + args[0]);
        return helperExec;
    }

    public static int fetchVerificationStatus(String sfmtd) {
        String tagValue = HelperUtil.fetchTextByTags(sfmtd, null, "<HLP_VRES>", "</HLP_VRES>");
        return Integer.parseInt(tagValue);
    }

    public static String[] fetchError(String[] sfmtd) {
        return HelperUtil.fetchArrayByTags(sfmtd, "<HLP_EMSG>", "</HLP_EMSG>");
    }

    public static String[] fetchWarning(String[] sfmtd) {
        return HelperUtil.fetchArrayByTags(sfmtd, "<HLP_WMSG>", "</HLP_WMSG>");
    }

    public static String[] fetchOutput(String[] sfmtd) {
        return HelperUtil.fetchArrayByTags(sfmtd, "<HLP_OUT>", "</HLP_OUT>");
    }

    public static String[] fetchArrayByTags(String[] sfmtd, String tagStart, String tagEnd) {
        int i = 0;
        ArrayList<String> resultList = new ArrayList<String>();
        boolean tagFound = false;
        block0: while (i < sfmtd.length) {
            while (i < sfmtd.length) {
                Trace.out("###" + sfmtd[i] + "###");
                if (!sfmtd[i].equalsIgnoreCase(tagStart)) {
                    Trace.out("starting tag not found : " + i);
                    ++i;
                    continue;
                }
                Trace.out("Starting tag found : " + ++i);
                tagFound = true;
                break;
            }
            if (i == sfmtd.length && sfmtd.length > 0 && !tagFound) {
                i = 0;
            }
            while (i < sfmtd.length) {
                if (sfmtd[i].equalsIgnoreCase(tagEnd)) {
                    Trace.out("found end tag at : " + ++i);
                    continue block0;
                }
                Trace.out("adding " + sfmtd[i]);
                resultList.add(sfmtd[i]);
                ++i;
            }
        }
        return resultList.toArray(new String[0]);
    }

    public static String fetchTextByTags(String sfmtd, String start_tag, String end_tag) {
        return HelperUtil.fetchTextByTags(sfmtd, null, start_tag, end_tag);
    }

    public static String[] fetchTextByTagsRepeat(String sfmtd, String start_tag, String end_tag) {
        Vector<String> data = new Vector<String>();
        String tmpStr = null;
        sfmtd = sfmtd.trim();
        while (sfmtd.length() > 0 && (tmpStr = HelperUtil.fetchTextByTags(sfmtd, start_tag, end_tag)) != null) {
            data.add(tmpStr);
            if (sfmtd.indexOf(end_tag) + end_tag.length() >= sfmtd.length()) break;
            sfmtd = sfmtd.substring(sfmtd.indexOf(end_tag) + end_tag.length());
            sfmtd = sfmtd.trim();
        }
        return data.toArray(new String[0]);
    }

    public static String fetchTextByTags(String sfmtd, String entity, String start_tag, String end_tag) {
        if (null == sfmtd || sfmtd.length() == 0) {
            return null;
        }
        String fmtdstr = null == entity || entity.trim().length() == 0 ? sfmtd : sfmtd;
        int begin = fmtdstr.indexOf(start_tag);
        if (begin == -1) {
            return null;
        }
        begin += start_tag.length();
        int end = fmtdstr.indexOf(end_tag);
        if (end == -1) {
            return null;
        }
        String data = fmtdstr.substring(begin, end);
        if (Trace.isLevelEnabled(5)) {
            Trace.out("\nTags " + start_tag + " and " + end_tag + " contains:" + data + "\n");
        }
        return data;
    }

    public static boolean fetchExecResult(String sfmtd) {
        int res;
        String eres = HelperUtil.fetchTextByTags(sfmtd, null, "<HLP_ERES>", "</HLP_ERES>");
        try {
            res = Integer.parseInt(eres);
        }
        catch (NumberFormatException e) {
            Trace.out("Invalid exec result in the output. " + e.getMessage());
            return false;
        }
        return res == 0;
    }

    public static String fetchVerificationResult(String sfmtd) {
        return HelperUtil.fetchTextByTags(sfmtd, null, "<HLP_VRES>", "</HLP_VRES>");
    }

    public static String fetchError(String sfmtd) {
        return HelperUtil.fetchTextByTags(sfmtd, null, "<HLP_ERES>", "</HLP_ERES>");
    }

    public static String formatExceptionMessage(String sfmtd) {
        Trace.out("Received encoded string: " + sfmtd);
        if (!sfmtd.contains("<HLP_EMSG>") || !sfmtd.contains("</HLP_EMSG>")) {
            Trace.out("Encoded string did not contain any tags");
            return sfmtd;
        }
        String[] error = HelperUtil.fetchTextByTagsRepeat(sfmtd, "<HLP_EMSG>,", ",</HLP_EMSG>");
        if (error.length == 0) {
            error = HelperUtil.fetchTextByTagsRepeat(sfmtd, "<HLP_EMSG>,", ", </HLP_EMSG>");
        }
        if (error.length == 0) {
            error = HelperUtil.fetchTextByTagsRepeat(sfmtd, "<HLP_EMSG>", "</HLP_EMSG>");
        }
        Trace.out("Error length = " + error.length);
        for (int i = 0; i < error.length; ++i) {
            Trace.out("Error part: " + error[i]);
            error[i] = Utils.getString(error[i].split(","), NEWLINE);
        }
        return Utils.getString(error, NEWLINE);
    }

    public static CSSMode getCSSMode() throws HelperException {
        String[] args = new String[]{GET_CSSMODE_HELPER_ARG};
        String[] env = null;
        SRVMHelperExec helperExec = null;
        helperExec = HelperUtil.runSRVMHelper(args, env);
        if (helperExec.getExitValue() == 1) {
            Trace.out("srvmhelper failed to execute");
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_CSSMODE_HELPER_ARG);
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out(outputStr);
            int status = HelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out("failed to get CSS mode " + helperExec.getErrorString());
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_CSSMODE_HELPER_ARG);
            }
            String[] outArr = HelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                if (CSSMode.cssBCCLUSTERED.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssBCCLUSTERED;
                }
                if (CSSMode.cssCLUSTERED.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssCLUSTERED;
                }
                if (CSSMode.cssEXCLUSIVE.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssEXCLUSIVE;
                }
                if (CSSMode.cssLOCALONLY.name().equalsIgnoreCase(outArr[0])) {
                    return CSSMode.cssLOCALONLY;
                }
                return CSSMode.cssNULL;
            }
            Trace.out("no output from srvmhelper");
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_CSSMODE_HELPER_ARG);
        }
        Trace.out("helper produced no output");
        return null;
    }

    public String getMgmtDBNodeName() throws HelperException {
        String[] args = new String[]{GET_MGMTDBNODENAME_HELPER_ARG};
        Trace.out(2, "Entry");
        String[] env = null;
        SRVMHelperExec helperExec = null;
        helperExec = HelperUtil.runSRVMHelper(args, env);
        if (helperExec.getExitValue() == 1) {
            Trace.out("srvmhelper failed to execute" + helperExec.getErrorString());
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_MGMTDBNODENAME_HELPER_ARG, helperExec.getErrorString());
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out(outputStr);
            int status = HelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out("failed to get mgmt db node name " + helperExec.getErrorString());
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_MGMTDBNODENAME_HELPER_ARG);
            }
            String[] outArr = HelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return outArr[0];
            }
        } else {
            Trace.out("No output from SRVM Helper");
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_MGMTDBNODENAME_HELPER_ARG);
        }
        Trace.out("helper produced no output");
        return null;
    }

    public static int getTargetHubSize() throws HelperException {
        String[] args = new String[]{GET_TGTHUBSIZE_HELPER_ARG};
        String[] env = null;
        SRVMHelperExec helperExec = null;
        helperExec = HelperUtil.runSRVMHelper(args, env);
        if (helperExec.getExitValue() == 1) {
            Trace.out("srvmhelper failed to execute" + helperExec.getErrorString());
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_TGTHUBSIZE_HELPER_ARG, helperExec.getErrorString());
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out(outputStr);
            int status = HelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out("failed to get target gub size" + helperExec.getErrorString());
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_TGTHUBSIZE_HELPER_ARG);
            }
            String[] outArr = HelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return Integer.parseInt(outArr[0]);
            }
        } else {
            Trace.out("no output from srvmhelper");
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_TGTHUBSIZE_HELPER_ARG);
        }
        Trace.out("helper produced no output");
        return 0;
    }

    public static boolean isOCROnASM() throws HelperException {
        String[] args = new String[]{IS_OCR_ON_ASM_HELPER_ARG};
        String[] env = null;
        SRVMHelperExec helperExec = null;
        helperExec = HelperUtil.runSRVMHelper(args, env);
        if (helperExec.getExitValue() == 1) {
            Trace.out("srvmhelper failed to execute" + helperExec.getErrorString());
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, IS_OCR_ON_ASM_HELPER_ARG, helperExec.getErrorString());
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out(outputStr);
            int status = HelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out("failed to get whether OCR is on ASM" + helperExec.getErrorString());
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, IS_OCR_ON_ASM_HELPER_ARG);
            }
            String[] outArr = HelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                return Boolean.parseBoolean(outArr[0]);
            }
        } else {
            Trace.out("no output from srvmhelper");
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, IS_OCR_ON_ASM_HELPER_ARG);
        }
        Trace.out("helper produced no output");
        return false;
    }

    public static ASMStatusInfo getASMStatusInfo() throws HelperException {
        String[] args = new String[]{GET_ASMSTATUS_HELPER_ARG};
        String[] env = null;
        SRVMHelperExec helperExec = null;
        helperExec = HelperUtil.runSRVMHelper(args, env);
        if (helperExec.getExitValue() == 1) {
            Trace.out("srvmhelper failed to execute");
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_ASMSTATUS_HELPER_ARG);
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out(outputStr);
            int status = HelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out("failed to get asm status " + helperExec.getErrorString());
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_ASMSTATUS_HELPER_ARG);
            }
            String[] outArr = HelperUtil.fetchOutput(output);
            if (outArr.length == 2) {
                String asmModeStr = HelperUtil.fetchTextByTags(outArr[0], "<ASM_MODE>", "</ASM_MODE>");
                String asmPresenceStr = HelperUtil.fetchTextByTags(outArr[1], "<ASM_PRESENCE>", "</ASM_PRESENCE>");
                Trace.out("asm mode is " + asmModeStr + ", asm presence is " + asmPresenceStr);
                ASMStatusInfo statusInfo = new ASMStatusInfo(asmModeStr, asmPresenceStr);
                return statusInfo;
            }
            Trace.out("Got no output or multiple output from srvmhelper. Should never happen:" + outArr.length);
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_ASMSTATUS_HELPER_ARG);
        }
        Trace.out("helper produced no output");
        return null;
    }

    public static void copyDir() throws HelperException {
        String[] args = new String[]{COPY_DIR_HELPER_ARG, SOURCE_PATH_HELPER_ARG, DEST_PATH_HELPER_ARG, EXCL_FILE_HELPER_ARG, NODELIST_HELPER_ARG};
        String[] env = null;
        SRVMHelperExec helperExec = null;
        helperExec = HelperUtil.runSRVMHelper(args, env);
        if (helperExec.getExitValue() == 1) {
            Trace.out("srvmhelper failed to execute");
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, COPY_DIR_HELPER_ARG);
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out(outputStr);
            int status = HelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out("failed to copy Dir " + helperExec.getErrorString());
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, COPY_DIR_HELPER_ARG);
            }
            String[] outArr = HelperUtil.fetchOutput(output);
            if (outArr.length <= 0) {
                Trace.out("no output from srvmhelper");
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, COPY_DIR_HELPER_ARG);
            }
        }
        Trace.out("helper produced no output");
    }

    public static boolean isMgmtDBConfigured() throws HelperException {
        String[] args = new String[]{IS_MGMTDB_CONFIGURED_ARG};
        String[] env = null;
        SRVMHelperExec helperExec = null;
        helperExec = HelperUtil.runSRVMHelper(args, env);
        String[] output = helperExec.getOutput();
        if (helperExec.getExitValue() == 1) {
            String outputStr;
            String errorStr;
            Trace.out("srvmhelper failed to execute");
            if (output.length != 0 && null != (errorStr = HelperUtil.fetchTextByTags(outputStr = helperExec.getOutputString(), "<HLP_EMSG>", "</HLP_EMSG>"))) {
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED_EXCEPTION, IS_MGMTDB_CONFIGURED_ARG, errorStr);
            }
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, IS_MGMTDB_CONFIGURED_ARG);
        }
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out(outputStr);
            int status = HelperUtil.fetchVerificationStatus(outputStr);
            if (status == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean hasACFSPermission(String acfsPath, String userName) throws HelperException {
        String[] args = new String[]{GET_ACFS_ACL_HELPER_ARG, acfsPath};
        Trace.out(2, "Entry");
        String[] env = null;
        SRVMHelperExec helperExec = null;
        helperExec = HelperUtil.runSRVMHelper(args, env);
        if (helperExec.getExitValue() == 1) {
            Trace.out("srvmhelper failed to execute" + helperExec.getErrorString());
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_ACFS_ACL_HELPER_ARG, helperExec.getErrorString());
        }
        String[] output = helperExec.getOutput();
        if (output.length != 0) {
            String outputStr = helperExec.getOutputString();
            Trace.out(outputStr);
            int status = HelperUtil.fetchVerificationStatus(outputStr);
            if (status == 2) {
                Trace.out("failed to get ACL of ACFS" + helperExec.getErrorString());
                throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_ACFS_ACL_HELPER_ARG);
            }
            String[] outArr = HelperUtil.fetchOutput(output);
            if (outArr.length > 0) {
                String[] tokens;
                for (String s : tokens = outArr[0].trim().split(String.valueOf(","))) {
                    if (!s.contains(userName) || !s.contains(ResourceType.ACL_PERM.EXECUTE.toString()) || !s.contains(ResourceType.ACL_PERM.READ.toString())) continue;
                    return true;
                }
            }
        } else {
            Trace.out("No output from SRVM Helper");
            throw new HelperException((MessageKey)PrCrMsgID.SRVMHELPER_EXECUTION_FAILED, GET_ACFS_ACL_HELPER_ARG);
        }
        throw new HelperException((MessageKey)PrCrMsgID.INSUFFICIENT_USER_PRIVILEGE_ERROR_ON_ACFS, GET_ACFS_ACL_HELPER_ARG);
    }
}

