/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.adminhelper.AdminHelper;
import oracle.cluster.adminhelper.AdminHelperException;
import oracle.cluster.asm.ASMException;
import oracle.cluster.asm.ASMFactory;
import oracle.cluster.asm.AsmBaseFileSystem;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.asm.AsmClusterFileSystemException;
import oracle.cluster.asm.FileSystemOptionalArgs;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.MGMTCAUtil;
import oracle.cluster.cmdtools.OPATCHUtil;
import oracle.cluster.common.ClusterClassification;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.common.ProgressListenerException;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.CredDomain;
import oracle.cluster.credentials.CredentialsACLPerm;
import oracle.cluster.credentials.CredentialsSet;
import oracle.cluster.credentials.CredentialsType;
import oracle.cluster.credentials.UserPassCredentials;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.VersionMismatchException;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseFactory;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.MgmtDBInstance;
import oracle.cluster.database.MgmtDatabase;
import oracle.cluster.database.MoveDatabaseException;
import oracle.cluster.database.MoveDatabaseOptionalArgs;
import oracle.cluster.database.NoDatabasesToMoveException;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSFactory;
import oracle.cluster.gridhome.GridHomeClient;
import oracle.cluster.gridhome.GridHomeClientException;
import oracle.cluster.gridhome.GridHomeFactory;
import oracle.cluster.gridhome.GridHomeServer;
import oracle.cluster.gridhome.GridHomeServerException;
import oracle.cluster.gridhome.RHPContainerType;
import oracle.cluster.gridhome.credentials.Credentials;
import oracle.cluster.gridhome.credentials.CredentialsException;
import oracle.cluster.gridhome.credentials.CredentialsFactory;
import oracle.cluster.hanfs.HANFSFactory;
import oracle.cluster.helper.HelperConstants;
import oracle.cluster.helper.HelperException;
import oracle.cluster.helper.UserActionHelper;
import oracle.cluster.home.HomeException;
import oracle.cluster.impl.adminhelper.AdminHelperFactoryImpl;
import oracle.cluster.impl.asm.ASMFactoryImpl;
import oracle.cluster.impl.asm.AsmBaseFileSystemImpl;
import oracle.cluster.impl.common.ProgressListenerImpl;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.impl.crs.ResourcePermissionsImpl;
import oracle.cluster.install.InstallException;
import oracle.cluster.nfs.NFSException;
import oracle.cluster.nfs.NFSFactory;
import oracle.cluster.nodeapps.InvalidFileException;
import oracle.cluster.nodeapps.ListenerException;
import oracle.cluster.nodeapps.NodeAppsFactory;
import oracle.cluster.remote.CopyClient;
import oracle.cluster.remote.CopyClientException;
import oracle.cluster.remote.ExecCommand;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.ExecRunTime;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.scan.ScanFactory;
import oracle.cluster.scan.ScanVIPException;
import oracle.cluster.server.Node;
import oracle.cluster.server.Server;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerException;
import oracle.cluster.server.ServerFactory;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.ParamPreReqDBProv;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.wallet.CLSW;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.GHAdminWallet;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterBatch;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.OCRInfo;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.file.CopyCommand;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.database.ParallelServerConfig;
import oracle.ops.mgmt.has.ClusterUtil;
import oracle.ops.mgmt.has.ClusterUtilException;
import oracle.ops.mgmt.has.Util;
import oracle.ops.mgmt.has.UtilException;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nativesystem.StreamReader;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nativesystem.UnixSystem;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.NodeException;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Helper
implements HelperConstants {
    private static String SRVM = "srvm";
    private static String LOG = "log";
    private MessageBundle m_msgBndl;
    private static String[] m_args;
    private static String TRACE_SRVMHELPER_FNAME;
    private static final String LSEP;
    private static final String FILE_SEP;
    private static final String TMP_LOC;
    private static final String INVENTORY_FILE = "inventory.xml";
    private static final String ORAINVENTORY_DIR = "oraInventory";
    private static final String CONTENTSXML_DIR = "ContentsXML";
    private static final String ORAINST_PREFIX = "oraInst";
    private static final String ORAINST_SUFFIX = ".loc";
    private static final String FILELIST_PREFIX = "fileList";
    private static final String FILELIST_SUFFIX = ".data";
    private static final String SUCCESS_SUFFIX = " successful";
    private static final String GH_DOMAIN = "GHADMIN";
    private static final String OC4J_ADMIN = "oc4jadmin";
    private static final String JWC_DOMAIN = "JWC";
    private static final String RHP_DOMAIN = "rhp";
    private static final String ROLES = "roles";
    private static final String LAST_MODIFIED = "last_modified";
    private static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss.SSS z yyyy";
    private static final String CONTAINER_ADMIN = "jwcadmin";
    private static final String EMPTY = "";
    private static final String UMOUNT = "umount";
    private ArrayList<CommandLineOption> m_cmdLineOptList = null;
    private final String HUB = ResourceLiterals.HUB.toString();
    private final String ORAHUB = ServerCategory.ServerCategoryType.HUB_CATEGORY.toString();
    private final String LEAF = ResourceLiterals.RIM.toString();
    private final String ORALEAF = ServerCategory.ServerCategoryType.LEAF_CATEGORY.toString();
    private boolean m_useTags = true;

    public Helper() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new NullSecurityManager());
            Trace.out("Security manager is set");
        }
        this.m_msgBndl = MessageBundle.getMessageBundle(PrCgMsgID.facility);
        this.m_msgBndl.setPackage("oracle.cluster.resources");
        this.m_cmdLineOptList = new ArrayList();
    }

    public int processCommandLine(String helperClassName, String methodName, String[] args) {
        try {
            Class<?> helperClass = Class.forName(helperClassName);
            Class[] clsArr = new Class[]{args.getClass()};
            Method cmdMethod = helperClass.getMethod(methodName, clsArr);
            Object[] arglist = new Object[]{args};
            Integer retVal = (Integer)cmdMethod.invoke(helperClass.newInstance(), arglist);
            return retVal;
        }
        catch (NoSuchMethodException e) {
            Trace.out("NoSuchMethodException while processing srvm herlper command line: " + e.getMessage());
            this.displayExecutionError(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-processCmd-error_1"));
            return 1;
        }
        catch (InstantiationException e) {
            Trace.out("InstantiationException while processing srvm herlper command line: " + e.getMessage());
            this.displayExecutionError(e.getMessage());
            return 1;
        }
        catch (ClassNotFoundException e) {
            Trace.out("ClassNotFoundException while processing srvm herlper command line: " + e.getMessage());
            this.displayExecutionError(e.getMessage());
            return 1;
        }
        catch (IllegalAccessException e) {
            Trace.out("IllegalAccessException while processing srvm herlper command line: " + e.getMessage());
            this.displayExecutionError(e.getMessage());
            return 1;
        }
        catch (InvocationTargetException e) {
            Trace.out("InvocationTargetException while processing srvm herlper command line: " + e.getMessage());
            this.displayExecutionError(e.getMessage());
            return 1;
        }
    }

    public void addCommandLineOption(String key, int numberOfArgs, String methodName, String usageInfo) {
        CommandLineOption cmdOpt = new CommandLineOption(key, numberOfArgs, methodName, usageInfo);
        this.m_cmdLineOptList.add(cmdOpt);
    }

    private void displayUsage() {
        String usageString = "USAGE:" + LSEP;
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            String curOpt = cmdOpt.getKey();
            String usageInfo = cmdOpt.getUsageInfo();
            usageString = usageString + "    " + curOpt + "  : " + usageInfo + LSEP;
        }
        this.displayExecutionError(usageString);
    }

    private void displayUsage(String curOpt) {
        String usageInfo = null;
        String usageString = "Incorrect arguments to option " + curOpt + LSEP + "USAGE:" + LSEP;
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            if (!curOpt.equalsIgnoreCase(cmdOpt.getKey())) continue;
            usageInfo = cmdOpt.getUsageInfo();
            break;
        }
        if (usageInfo == null) {
            this.displayExecutionError("Incorrect commandline option : " + curOpt);
            return;
        }
        usageString = usageString + "    " + curOpt + "  : " + usageInfo;
        this.displayErrorResult(usageString);
    }

    public String parseArguments(String[] args) {
        boolean argsOK = false;
        boolean found = false;
        String methodName = null;
        int numberOfArgs = -1;
        String curOpt = null;
        for (int i = args.length - 1; i >= 0; --i) {
            int j;
            if (!args[i].startsWith("SRVM_TRACING_ID")) continue;
            int tracingUID = Integer.parseInt(args[i].substring("SRVM_TRACING_ID".length() + 1));
            Trace.setHelperUID(tracingUID);
            Trace.out("SRVM_TRACING_ID=" + tracingUID);
            String[] newargs = new String[args.length - 1];
            for (j = 0; j < i; ++j) {
                newargs[j] = args[j];
            }
            for (j = i + 1; j < args.length; ++j) {
                newargs[j - 1] = args[j];
            }
            args = newargs;
            break;
        }
        Trace.out("Found args: " + args.length);
        Helper helper = this;
        Trace.out("JVM locale: " + helper.m_msgBndl.getDefLocale().getISO3Language());
        if (args.length < 1) {
            this.displayUsage();
            Trace.out("Return value: NOT_SPECIFIED");
            return "NOT_SPECIFIED";
        }
        Trace.out("more than one arg found");
        for (CommandLineOption cmdOpt : this.m_cmdLineOptList) {
            curOpt = cmdOpt.getKey();
            if (!curOpt.equalsIgnoreCase(args[0])) continue;
            found = true;
            methodName = cmdOpt.getMethodName();
            numberOfArgs = cmdOpt.getNumberOfArgs();
            String usageInfo = cmdOpt.getUsageInfo();
            break;
        }
        if (found) {
            if (numberOfArgs != 1 && args.length < numberOfArgs) {
                Trace.out("incorrect number of arguments");
                this.displayUsage(args[0]);
                return null;
            }
        } else {
            Trace.out("option not supported");
            this.displayUsage();
            return null;
        }
        return methodName;
    }

    public void setUseTags(boolean useTags) {
        this.m_useTags = useTags;
    }

    public void displaySuccessResult(List<String> rsltArr) {
        if (this.m_useTags) {
            System.out.println("<HLP_OUT>");
        }
        for (String rslt : rsltArr) {
            System.out.println(rslt);
        }
        if (this.m_useTags) {
            System.out.println("</HLP_OUT>");
        }
    }

    public void displaySuccessResult(String rslt) {
        if (this.m_useTags) {
            System.out.println("<HLP_OUT>");
        }
        System.out.println(rslt);
        if (this.m_useTags) {
            System.out.println("</HLP_OUT>");
        }
    }

    public void displaySuccessResult(List<String> rslt, int status) {
        this.displaySuccessResult(rslt);
        this.displayVRESStatus(status);
    }

    public void displaySuccessResult(String rslt, int status) {
        this.displaySuccessResult(rslt);
        this.displayVRESStatus(status);
    }

    public void displayWarningResult(String warning) {
        if (this.m_useTags) {
            System.out.println("<HLP_WMSG>");
        }
        System.out.println(warning);
        if (this.m_useTags) {
            System.out.println("</HLP_WMSG>");
        }
    }

    public void displayWarningResult(String warning, int status) {
        this.displayWarningResult(warning);
        this.displayVRESStatus(status);
    }

    public void displayErrorResult(String errMsg) {
        if (this.m_useTags) {
            System.out.println("<HLP_EMSG>");
        }
        System.out.println(errMsg);
        if (this.m_useTags) {
            System.out.println("</HLP_EMSG>");
        }
    }

    public void displayErrorResult(String errMsg, int status) {
        this.displayErrorResult(errMsg);
        this.displayVRESStatus(status);
    }

    public void displayVRESStatus(int status) {
        if (this.m_useTags) {
            System.out.println("<HLP_VRES>" + status + "</HLP_VRES>");
        }
    }

    public void displayExecutionError(String errMsg) {
        Trace.out("displayExecutionError: " + errMsg);
        if (this.m_useTags) {
            System.out.println("<HLP_IEEMSG>");
        }
        System.out.println(errMsg);
        if (this.m_useTags) {
            System.out.println("</HLP_IEEMSG>");
            System.out.println("<HLP_ERES>1</HLP_ERES>");
        }
    }

    public void displayExecutionSuccess() {
        if (this.m_useTags) {
            System.out.println("<HLP_ERES>0</HLP_ERES>");
        }
    }

    public String genTaggedOutput(String output, String tagStart, String tagEnd) {
        return tagStart + output + tagEnd;
    }

    public int getCSSMode(String[] args) {
        Trace.out(2, "Entry");
        try {
            ClusterUtil util = new ClusterUtil();
            this.displaySuccessResult(util.getCSSMode().toString() + EMPTY, 0);
            return 0;
        }
        catch (ClusterUtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
    }

    public int getTargetHubSize(String[] args) {
        Trace.out(2, "Entry");
        try {
            Util util = new Util();
            this.displaySuccessResult(new Integer(util.getTargetHubSize()).toString(), 0);
            return 0;
        }
        catch (UtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
    }

    public int getASMStatusInfo(String[] args) {
        Trace.out(2, "Entry");
        try {
            ASMFactory asmFactory = ASMFactory.getInstance();
            ArrayList<String> resultList = new ArrayList<String>();
            resultList.add(this.genTaggedOutput(asmFactory.getASMMode().toString(), "<ASM_MODE>", "</ASM_MODE>"));
            resultList.add(this.genTaggedOutput(asmFactory.getASMPresence().toString(), "<ASM_PRESENCE>", "</ASM_PRESENCE>"));
            this.displaySuccessResult(resultList, 0);
            return 0;
        }
        catch (ASMException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
    }

    public int isOCROnASM(String[] args) {
        String[] ocrLocationPaths;
        Trace.out(2, "Entry");
        try {
            OCRInfo ocrInfo = ClusterInfo.getOCRLocations(new Version());
            ocrLocationPaths = ocrInfo.getPaths();
        }
        catch (ClusterInfoException cie) {
            this.displayErrorResult(cie.getMessage(), 2);
            return 2;
        }
        NativeSystem system = new SystemFactory().CreateSystem();
        for (int i = 0; i < ocrLocationPaths.length; ++i) {
            Trace.out("ocrLocationPaths[" + i + "]=" + ocrLocationPaths[i]);
            if (!system.isPathOnASM(ocrLocationPaths[i])) continue;
            this.displaySuccessResult(Boolean.toString(true), 0);
            return 0;
        }
        this.displaySuccessResult(Boolean.toString(false), 0);
        return 0;
    }

    public int makeDir(String[] args) {
        Trace.out(2, "Entry");
        try {
            ClusterCmd cmd = new ClusterCmd();
            String nodes = args[1];
            if (nodes == null) {
                Trace.out("Node list can not be null for makeDir.");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-makeDir-error_1"), 2);
                return 1;
            }
            Trace.out("Node list is...." + nodes);
            String dirPath = args[2];
            if (dirPath == null) {
                Trace.out("Directory path can not be null for makeDir.");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-makeDir-error_2"), 2);
                return 1;
            }
            Trace.out("Dir path is...." + dirPath);
            String[] nodeList = nodes.split(",");
            if (nodeList.length == 0) {
                Trace.out("Node list can not be null for makeDir.");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-makeDir-error_3"), 2);
                return 1;
            }
            cmd.createDirWithPermissionsOnNodes(nodeList, dirPath, "755");
            return 0;
        }
        catch (ClusterException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int deleteDir(String[] args) {
        String nodes = args[1];
        String[] nodeNames = nodes.split(",");
        String dirName = args[2];
        Trace.out("oracleHome = " + dirName);
        Trace.out("nodeNames = " + nodes);
        try {
            ClusterCmd clusterCmd;
            if (nodes.equals("+null")) {
                String localHostName = new Util().getLocalHostName();
                Trace.out("Local hostname " + localHostName);
                nodeNames = new String[]{localHostName};
            }
            if ((clusterCmd = new ClusterCmd()).removeDirFromNodes(nodeNames, dirName, true)) {
                Trace.out("deleteDir succeeded");
                return 0;
            }
            Trace.out("deleteDir couldn't complete");
            return 2;
        }
        catch (ClusterException | UtilException e) {
            Trace.out("deleteDir failed");
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int runmgmtca(String[] args) {
        String crshome;
        Trace.out(2, "Entry");
        Trace.out("Going to create credentials for grid home");
        String dbnode = null;
        try {
            crshome = new Util().getCRSHome();
        }
        catch (UtilException ue) {
            Trace.out("Failed to get CRS Home " + ue.getMessage());
            this.displayErrorResult(ue.getMessage(), 2);
            return 1;
        }
        try {
            dbnode = new ClusterwareInfo().getMgmtDBNodeName();
        }
        catch (InstallException ie) {
            this.displayErrorResult(ie.getMessage(), 2);
            return 1;
        }
        try {
            MGMTCAUtil mgmtcaUtil = new MGMTCAUtil(crshome, dbnode);
            mgmtcaUtil.createGHCredentials();
        }
        catch (CmdToolUtilException ctue) {
            this.displayErrorResult(ctue.getMessage(), 2);
            return 1;
        }
        this.displaySuccessResult(args[0] + SUCCESS_SUFFIX, 0);
        return 0;
    }

    public int createGHCreds(String[] args) {
        block18: {
            Trace.out(2, "Entry");
            Trace.out("Going to create wallet for grid home");
            String updFlag = args[1];
            String isUpg = args[2];
            String clusterName = args.length > 3 ? args[3].toLowerCase() : null;
            String passwd = null;
            try {
                if (clusterName == null) {
                    if (isUpg.equals("true")) {
                        CLSW clsw = CLSW.getInstance();
                        clsw.initializeCLSW();
                        passwd = clsw.getSecret(GH_DOMAIN, EMPTY, OC4J_ADMIN);
                        clsw.terminateCLSW();
                    } else {
                        passwd = new String(oracle.cluster.credentials.CredentialsFactory.generateRandomPassword());
                    }
                } else {
                    Trace.out("getting passwd from cred");
                    CredentialsFactory ghCredfact = CredentialsFactory.getInstance();
                    String ghcpwd = ghCredfact.getClientSecret(clusterName);
                    String[] passwdList = ghcpwd.split(":");
                    passwd = passwdList[1];
                }
                if (Utils.useTomcat()) {
                    oracle.cluster.credentials.Credentials c;
                    Trace.out("Using Tomcat");
                    StringBuilder domainPath = new StringBuilder(JWC_DOMAIN);
                    domainPath.append("/");
                    domainPath.append(new ClusterUtil().getClusterGUID());
                    String domGUIDPath = domainPath.toString();
                    domainPath.append("/");
                    domainPath.append(RHP_DOMAIN);
                    String path = domainPath.toString();
                    Trace.out((Object)"Domain path: %s", path);
                    oracle.cluster.credentials.CredentialsFactory cFact = oracle.cluster.credentials.CredentialsFactory.getInstance();
                    CredDomain cDom = null;
                    CredDomain domGUID = null;
                    try {
                        Trace.out("Getting domain");
                        cDom = cFact.getDomainByPath(path);
                        domGUID = cFact.getDomainByPath(domGUIDPath);
                    }
                    catch (NotExistsException e) {
                        Trace.out("Creating domain");
                        cDom = cFact.createDomain(path, true);
                        domGUID = cFact.getDomainByPath(domGUIDPath);
                    }
                    CredentialsSet credSet = null;
                    try {
                        Trace.out("Getting credSet");
                        credSet = cDom.getCredentialsSet(CredentialsType.USERPASS);
                    }
                    catch (NotExistsException e) {
                        Trace.out("Creating credentials set");
                        credSet = cDom.createCredentialSet(CredentialsType.USERPASS);
                    }
                    UserPassCredentials upc = null;
                    Iterator<oracle.cluster.credentials.Credentials> iterator = credSet.getAllCredentials().iterator();
                    while (iterator.hasNext() && !CONTAINER_ADMIN.equals((upc = (UserPassCredentials)(c = iterator.next())).getUsername())) {
                        upc = null;
                    }
                    HashMap<String, String> userAttrs = new HashMap<String, String>();
                    userAttrs.put(LAST_MODIFIED, Helper.getTimestamp());
                    if (updFlag.equals("true") || upc != null) {
                        Trace.out("Updating credentials for Tomcat");
                        userAttrs.put(ROLES, upc.getAttributes(Arrays.asList(ROLES)).get(ROLES));
                        credSet.removeCredentials(upc.getMemberID());
                        credSet.createUserPassCredentials(CONTAINER_ADMIN, passwd, userAttrs);
                    } else {
                        Trace.out("Creating credentials for Tomcat");
                        userAttrs.put(ROLES, EMPTY);
                        credSet.createUserPassCredentials(CONTAINER_ADMIN, passwd, userAttrs);
                    }
                    Util utl = new Util();
                    String usr = utl.getCRSUser();
                    domGUID.setPGroup(utl.getPrimaryGroup(usr));
                    cDom.setPGroupPerms(CredentialsACLPerm.READ);
                    domGUID.setOwner(usr);
                    break block18;
                }
                GHAdminWallet ghwallet = GHAdminWallet.getInstance();
                ghwallet.open();
                if (updFlag.equals("true")) {
                    ghwallet.updateWallet(passwd);
                } else {
                    ghwallet.createWallet(passwd);
                }
                ghwallet.close();
            }
            catch (CLSWException clswe) {
                Trace.out("Failed to create gh wallet " + clswe.getMessage());
                this.displayErrorResult(clswe.getMessage(), 2);
                return 1;
            }
            catch (CredentialsException clswe) {
                Trace.out("Failed to create gh wallet " + clswe.getMessage());
                this.displayErrorResult(clswe.getMessage(), 2);
                return 1;
            }
            catch (Exception e) {
                Trace.out("Failed to create gh wallet " + e.getMessage());
                this.displayErrorResult(e.getMessage(), 2);
                return 1;
            }
        }
        this.displaySuccessResult(args[0] + SUCCESS_SUFFIX, 0);
        return 0;
    }

    public int copyDBS(String[] args) throws ProgressListenerException {
        Trace.out(2, "Entry");
        String srcPath = args[1];
        String dstPath = args[2];
        String hostAndPort = args[3];
        String dbfiles = "*";
        if (args.length > 4) {
            dbfiles = "*" + args[4] + "*";
        }
        CopyCommand cpCmd = new CopyCommand(srcPath, dstPath, dbfiles, false);
        cpCmd.execute();
        this.displaySuccessResult(args[0] + SUCCESS_SUFFIX, 0);
        return 0;
    }

    public int copyAndChown(String[] args) throws ProgressListenerException {
        Trace.out(2, "Beginning of copy and chown");
        String uid = args[1];
        String groupid = args[2];
        String files = args[3];
        String destination = args[4];
        List<String> fileList = Arrays.asList(args[3].split(","));
        Trace.out("Copying files " + files + " to path " + destination + " and chowning");
        String localHostName = null;
        try {
            localHostName = new Util().getLocalHostName();
        }
        catch (UtilException e) {
            Trace.out("UtilException " + (Object)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        String[] dstNodeList = new String[]{localHostName};
        ArrayList<String> cmdArgsList = new ArrayList<String>();
        if (!groupid.isEmpty() && !groupid.equals("NOT_SPECIFIED")) {
            cmdArgsList.add(uid + ':' + groupid);
        } else {
            cmdArgsList.add(uid);
        }
        try {
            ClusterBatch clusterBatch = new ClusterBatch();
            for (String file : fileList) {
                Path p = Paths.get(file, new String[0]);
                clusterBatch.copyFileToNodes(file, dstNodeList, destination);
                cmdArgsList.add(destination + File.separator + p.getFileName().toString());
            }
            clusterBatch.execute();
            Trace.out("Chown the files that were copied");
            ClusterCmd clusterCmd = new ClusterCmd();
            String cmd = "/usr/bin/chown";
            clusterCmd.runCmd(cmd, oracle.cluster.impl.util.Utils.convertListToStringArray(cmdArgsList), new String[0], dstNodeList);
        }
        catch (ClusterException e) {
            Trace.out("ClusterException:" + e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        return 0;
    }

    public int removeFiles(String[] args) throws ProgressListenerException {
        String[] nodeList;
        Trace.out(2, "Beginning of removeFiles");
        String files = args[1];
        List<String> fileList = Arrays.asList(args[1].split(","));
        Trace.out("Removing files " + files + " from nodes " + args[2]);
        if (!args[2].isEmpty() && !args[2].equals("NOT_SPECIFIED")) {
            nodeList = args[2].split(",");
        } else {
            String localHostName = null;
            try {
                localHostName = new Util().getLocalHostName();
            }
            catch (UtilException e) {
                Trace.out("UtilException " + (Object)((Object)e));
                this.displayErrorResult(e.getMessage(), 2);
                return 1;
            }
            nodeList = new String[]{localHostName};
        }
        try {
            ClusterBatch clusterBatch = new ClusterBatch();
            for (String file : fileList) {
                Path p = Paths.get(file, new String[0]);
                clusterBatch.removeFileFromNodes(nodeList, file);
            }
            clusterBatch.execute();
        }
        catch (ClusterException e) {
            Trace.out("ClusterException:" + e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyDir(String[] args) throws ProgressListenerException {
        InetAddress localhost;
        Trace.out(2, "Entry");
        ProgressListenerImpl plsnr = null;
        String oracleHome = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out("Got UnknownHostException while retrieving the local host");
            this.displayErrorResult(uhe.getMessage(), 2);
            return 1;
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        String sourceHome = args[1];
        String destDir = args[2];
        String includeListFile = null;
        includeListFile = args[3].equals("null") ? null : args[3];
        String excludeListFile = args[4].equals("null") ? null : args[4];
        String[] nodeNames = null;
        nodeNames = args[5].equals("null") ? new String[]{localhost.getHostAddress()} : args[5].split(",");
        String hostAndPort = args[6];
        if (!hostAndPort.equals("null")) {
            plsnr = new ProgressListenerImpl(hostAndPort);
        }
        String dbUniqueName = null;
        if (!args[7].equals("null")) {
            dbUniqueName = args[7];
            BufferedWriter writer = null;
            String list = null;
            try {
                File fileList = File.createTempFile(FILELIST_PREFIX, FILELIST_SUFFIX);
                includeListFile = fileList.getAbsolutePath();
                writer = new BufferedWriter(new FileWriter(includeListFile));
                list = ".*" + dbUniqueName + ".*";
                writer.write(list);
            }
            catch (IOException e) {
                Trace.out("IOException: " + e.getMessage());
                this.displayErrorResult(e.getMessage(), 2);
                int n = 1;
                return n;
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        Trace.out("IOException: " + e.getMessage());
                        this.displayErrorResult(e.getMessage(), 2);
                        return 1;
                    }
                }
            }
            Trace.out("The content of includeListFile" + includeListFile + "is: " + list);
        }
        Trace.out("Entering try block for getcrshome");
        try {
            oracleHome = new Util().getCRSHome();
        }
        catch (UtilException ue) {
            Trace.out("Got UtilException during copyDir - IGNORED");
            oracleHome = sourceHome;
        }
        try {
            Trace.out("oracleHome = " + oracleHome);
            Trace.out("nodeNames = " + Utils.getString(nodeNames, ","));
            Trace.out("sourceHome = " + sourceHome);
            Trace.out("includeListFile = " + includeListFile);
            Trace.out("excludeListFile = " + excludeListFile);
            Trace.out("tempDir = " + tempDir);
            Trace.out("destDir = " + destDir);
            String[] destDirs = new String[nodeNames.length];
            for (int i = 0; i < destDirs.length; ++i) {
                destDirs[i] = destDir;
            }
            ClusterCmd clusterCmd = new ClusterCmd();
            if (plsnr != null) {
                clusterCmd.transferDirStructureToNodes(oracleHome, nodeNames, sourceHome, includeListFile, true, excludeListFile, true, tempDir, destDirs, false, (ProgressListener)plsnr);
            } else {
                clusterCmd.transferDirStructureToNodes(oracleHome, nodeNames, sourceHome, includeListFile, true, excludeListFile, true, tempDir, destDirs, false);
            }
        }
        catch (ClusterException e) {
            Trace.out("Got ClusterExcpetion during copyDir");
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (RemoteFileOperationException re) {
            Trace.out("Got RemoteFileOpException during copyDir");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nodeNames.length; ++i) {
                try {
                    NativeResult result = re.getNativeResult(nodeNames[i]);
                    if (result.getStatus()) continue;
                    Trace.out("copy dir \n");
                    Trace.out("result #" + i + " -- Details:");
                    Trace.out("getStatus() --> " + result.getStatus());
                    Trace.out("getOSString() --> " + result.getOSString());
                    if (sb.length() == 0) {
                        sb.append(result.getOSString());
                        continue;
                    }
                    sb.append(LSEP + result.getOSString());
                    continue;
                }
                catch (NoSuchNodeException noSuchNodeException) {
                    // empty catch block
                }
            }
            this.displayErrorResult(sb.toString(), 2);
            return 1;
        }
        this.displaySuccessResult(args[0] + SUCCESS_SUFFIX, 0);
        return 0;
    }

    public int isDirWritable(String[] args) {
        Trace.out(2, "Entry");
        String[] nodeList = new String[]{};
        try {
            ClusterCmd cmd = new ClusterCmd();
            String nodes = args[1];
            if (nodes == null) {
                this.displayErrorResult("Node list can not be null", 2);
                return 1;
            }
            Trace.out("Node list is...." + nodes);
            String dirPath = args[2];
            if (dirPath == null) {
                this.displayErrorResult("Directory path can not be null", 2);
                return 1;
            }
            Trace.out("Dir path is...." + dirPath);
            nodeList = nodes.split(",");
            if (nodeList.length == 0) {
                this.displayErrorResult("Node list can not be empty", 2);
                return 1;
            }
            boolean isWritable = cmd.isDirWritable(nodeList, dirPath);
            if (isWritable) {
                return 0;
            }
            this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.NON_WRITABLE_PATH, true, dirPath), 2);
            return 1;
        }
        catch (ClusterException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (ClusterOperationException coe) {
            Trace.out("Got ClusterOperationException during isDirWritable");
            StringBuilder sb = new StringBuilder();
            for (String nodeName : nodeList) {
                try {
                    int status = coe.getStatus(nodeName);
                    Trace.out("exception check on node " + nodeName);
                    Trace.out("exception check status is " + status);
                    if (2 != status && 1 != status) continue;
                    Trace.out("getErrorMessage() --> " + coe.getErrorMessage(nodeName));
                    if (sb.length() == 0) {
                        sb.append(coe.getErrorMessage(nodeName));
                        continue;
                    }
                    sb.append(LSEP + coe.getErrorMessage(nodeName));
                }
                catch (NoSuchNodeException ns) {
                    Trace.out("\n UNEXPECTED::: \n" + ns.getMessage());
                }
            }
            this.displayErrorResult(sb.toString(), 2);
            return 1;
        }
    }

    public int isSharedPath(String[] args) {
        Trace.out(2, "Entry");
        try {
            boolean isShared = false;
            String nodes = null;
            if (!args[1].equals("null")) {
                nodes = args[1];
            }
            if (nodes == null) {
                Trace.out("Node list can not be null");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-isSharedPath-error_1"), 2);
                return 1;
            }
            Trace.out("Node list is...." + nodes);
            String dirPath = null;
            if (!args[2].equals("null")) {
                dirPath = args[2];
            }
            if (dirPath == null) {
                Trace.out("Directory path can not be null");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-isSharedPath-error_2"), 2);
                return 1;
            }
            Trace.out("Dir path is...." + dirPath);
            String[] nodeList = nodes.split(",");
            if (nodeList.length == 0) {
                Trace.out("Node list can not be empty");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-isSharedPath-error_3"), 2);
                return 1;
            }
            if (nodeList.length > 1) {
                isShared = Cluster.isSharedPath(dirPath, nodeList);
            }
            this.displaySuccessResult(new Boolean(isShared).toString(), 0);
            return 0;
        }
        catch (InvalidNodeListException e) {
            Trace.out("InvalidNodeListException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SharedDeviceException e) {
            Trace.out("SharedDeviceException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int updateDepASM(String[] args) {
        Trace.out(2, "Entry");
        this.m_useTags = false;
        try {
            ASMFactory af = ASMFactory.getInstance();
            af.updateDependenciesASMConversion();
            return 0;
        }
        catch (ASMException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int addnfs(String[] args) {
        try {
            FileSystemOptionalArgs fsOpt = new FileSystemOptionalArgs();
            fsOpt.setMountPointPath(args[1]);
            fsOpt.setNFSName(args[2]);
            fsOpt.setExportServerName(args[3]);
            fsOpt.setExportPath(args[4]);
            if (args[6] != null && args[6].length() > 0) {
                fsOpt.setFSOptions(args[6]);
            }
            if (args[7] != null && args[7].length() > 0) {
                fsOpt.setUser(args[7]);
            }
            NFSFactory nf = NFSFactory.getInstance();
            nf.createNFS(fsOpt);
            return 0;
        }
        catch (AsmClusterFileSystemException acfse) {
            this.displayErrorResult(acfse.getMessage(), 2);
            return 1;
        }
        catch (NFSException fse) {
            this.displayErrorResult(fse.getMessage(), 2);
            return 1;
        }
        catch (AlreadyExistsException aae) {
            this.displayErrorResult(aae.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException sme) {
            this.displayErrorResult(sme.getMessage(), 2);
            return 1;
        }
    }

    public int addexportfs(String[] args) {
        try {
            String id = args[1];
            String expname = args[2];
            String exppath = args[3];
            String clients = null;
            String expoptions = null;
            boolean ghExport = false;
            if (args[4] != null && args[4].length() > 0) {
                clients = args[4];
            }
            if (args[5] != null && args[5].length() > 0) {
                expoptions = args[5];
            }
            if (args[6] != null && args[6].length() > 0) {
                ghExport = true;
            }
            Version version = new Version();
            HANFSFactory hanfsFact = HANFSFactory.getInstance();
            hanfsFact.createExportFS(id, expname, exppath, clients, expoptions, version, ghExport);
            return 0;
        }
        catch (SoftwareModuleException sme) {
            this.displayErrorResult(sme.getMessage(), 2);
            return 1;
        }
        catch (AlreadyExistsException aee) {
            this.displayErrorResult(aee.getMessage(), 2);
            return 1;
        }
    }

    public int getDeltaPatchesLspatches(String[] args) {
        try {
            String destHome = args[1];
            String srcHome = args[2];
            if (destHome == null) {
                Trace.out("Oracle home 1 can not be null");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-getDeltaPatchesLspatches-error_1"), 2);
                return 1;
            }
            if (srcHome == null) {
                Trace.out("Oracle home 2 can not be null");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-getDeltaPatchesLspatches-error_2"), 2);
                return 1;
            }
            ArrayList idPatches = new ArrayList();
            List<String> destPatches = new OPATCHUtil(destHome).getIDPatchesLspatches(destHome);
            List<String> srcPatches = new OPATCHUtil(srcHome).getIDPatchesLspatches(srcHome);
            String deltaPatches = this.getDeltaPatches(destPatches, srcPatches);
            this.displaySuccessResult(deltaPatches);
            return 0;
        }
        catch (CmdToolUtilException ce) {
            this.displayErrorResult(ce.getMessage(), 2);
            return 1;
        }
    }

    public int getBugNumbers(String[] args) {
        return this.execOpatch(args, true);
    }

    public int getIdPatches(String[] args) {
        return this.execOpatch(args, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int execOpatch(String[] args, boolean getBugNum) {
        try {
            List<String> lstResult;
            String oracleHome = args[1];
            String dbVersion = args[2];
            String createInvLoc = args[3];
            if (oracleHome == null) {
                Trace.out("Oracle home can not be null");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-execOpatch-error_1"), 2);
                return 1;
            }
            if (dbVersion == null) {
                Trace.out("Oracle home version can not be null");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-execOpatch-error_2"), 2);
                return 1;
            }
            Version ver = null;
            try {
                ver = Version.getVersion(dbVersion);
            }
            catch (ConfigurationException ce) {
                this.displayErrorResult(ce.getMessage(), 2);
                return 1;
            }
            boolean isPre11204 = Version.isPre11204(ver);
            if (createInvLoc != null && createInvLoc.equals("true")) {
                Object invLoc = null;
                File oraInst = null;
                File inventory = null;
                BufferedWriter writer = null;
                String oraInstPath = null;
                String inventoryPath = null;
                try {
                    oraInst = File.createTempFile(ORAINST_PREFIX, ORAINST_SUFFIX);
                    oraInstPath = oraInst.getAbsolutePath();
                    int randomNum = (int)(Math.random() * 999999.0);
                    writer = new BufferedWriter(new FileWriter(oraInstPath));
                    writer.write(this.createOraInst(TMP_LOC + FILE_SEP + ORAINVENTORY_DIR + randomNum));
                    writer.close();
                    File contentsDir = new File(TMP_LOC + FILE_SEP + ORAINVENTORY_DIR + randomNum + FILE_SEP + CONTENTSXML_DIR);
                    contentsDir.mkdirs();
                    inventory = new File(contentsDir.getAbsolutePath() + FILE_SEP + INVENTORY_FILE);
                    inventory.createNewFile();
                    inventoryPath = inventory.getAbsolutePath();
                    writer = new BufferedWriter(new FileWriter(inventoryPath));
                    writer.write(this.createInventory(oracleHome));
                }
                catch (IOException e) {
                    this.displayErrorResult(e.getMessage(), 2);
                    int n = 1;
                    return n;
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            this.displayErrorResult(e.getMessage(), 2);
                            return 1;
                        }
                    }
                }
                lstResult = !isPre11204 ? (getBugNum ? new OPATCHUtil(oracleHome).getBugNumbersLspatches(oracleHome, oraInstPath) : new OPATCHUtil(oracleHome).getIDPatchesLspatches(oracleHome, oraInstPath)) : (getBugNum ? new OPATCHUtil(oracleHome).getBugNumbersLsinventory(oracleHome, oraInstPath) : new OPATCHUtil(oracleHome).getIDPatchesLsinventory(oracleHome, oraInstPath));
                try {
                    oraInst.delete();
                    inventory.delete();
                }
                catch (SecurityException e) {
                    this.displayErrorResult(e.getMessage(), 2);
                    return 1;
                }
            }
            lstResult = !isPre11204 ? (getBugNum ? new OPATCHUtil(oracleHome).getBugNumbersLspatches(oracleHome) : new OPATCHUtil(oracleHome).getIDPatchesLspatches(oracleHome)) : (getBugNum ? new OPATCHUtil(oracleHome).getBugNumbersLsinventory(oracleHome) : new OPATCHUtil(oracleHome).getIDPatchesLsinventory(oracleHome));
            String result = this.getLst2Str(lstResult);
            this.displaySuccessResult(result);
            return 0;
        }
        catch (CmdToolUtilException ce) {
            this.displayErrorResult(ce.getMessage(), 2);
            return 1;
        }
    }

    public int isRollingPatch(String[] args) {
        try {
            String oracleHome = args[1];
            String patchID = args[2];
            boolean isRollingPatch = new OPATCHUtil(oracleHome).isRollingPatch(oracleHome, patchID, null);
            this.displaySuccessResult(Boolean.toString(isRollingPatch));
            return 0;
        }
        catch (CmdToolUtilException | InvalidArgsException ce) {
            Trace.out("attempt to execute opatch is_rolling_patch failed with exception %s : %s", ce.getClass().getName(), ce.getMessage());
            this.displayErrorResult(ce.getMessage(), 2);
            return 1;
        }
    }

    public int checkdbinst(String[] args) {
        try {
            String oracleHome = null;
            String oracleBase = null;
            Object adminGroupsStr = null;
            String dbVer = args[1];
            String nodeList = args[2];
            if (!args[3].equals("null")) {
                oracleHome = args[3];
            }
            if (!args[4].equals("null")) {
                oracleBase = args[4];
            }
            String tmp = System.getProperty("java.io.tmpdir");
            String failedNodesString = null;
            StringBuffer result = new StringBuffer();
            ArrayList resultList = new ArrayList();
            String[] nodeListArr = nodeList.split(",");
            ArrayList<VerificationTask> ghTaskList = new ArrayList<VerificationTask>();
            String errMsg = EMPTY;
            String errMsg1 = EMPTY;
            int count = 0;
            int warnCount = 0;
            ParamPreReqDBProv cvuParam = new ParamPreReqDBProv();
            Trace.out("Setting cvu param values");
            cvuParam.setRelease(dbVer);
            if (oracleHome != null) {
                Trace.out("Setting oracle Home to" + oracleHome);
                cvuParam.setOrclHome(oracleHome);
            }
            if (oracleBase != null) {
                Trace.out("Setting oracle base to" + oracleBase);
                cvuParam.setOracleBase(oracleBase);
            }
            if (!args[5].equals("2d7428a6b58c406")) {
                String[] adminGroups = args[5].split(",", 7);
                if (!adminGroups[0].trim().isEmpty()) {
                    cvuParam.setOSDBAgroup(adminGroups[0]);
                    Trace.out("Setting OSDBA group to:" + adminGroups[0]);
                }
                if (!adminGroups[1].trim().isEmpty()) {
                    cvuParam.setOSOPERgroup(adminGroups[1]);
                    Trace.out("Setting OSOPER group to:" + adminGroups[1]);
                }
                if (!adminGroups[2].trim().isEmpty()) {
                    cvuParam.setOSASMGroup(adminGroups[2]);
                    Trace.out("Setting ASMAdmin group to:" + adminGroups[2]);
                }
                if (!adminGroups[3].trim().isEmpty()) {
                    cvuParam.setOSBACKUPgroup(adminGroups[3]);
                    Trace.out("Setting OSBACKUP group to:" + adminGroups[3]);
                }
                if (!adminGroups[4].trim().isEmpty()) {
                    cvuParam.setOSDGgroup(adminGroups[4]);
                    Trace.out("Setting OSDG group to:" + adminGroups[4]);
                }
                if (!adminGroups[5].trim().isEmpty()) {
                    cvuParam.setOSKMgroup(adminGroups[5]);
                    Trace.out("Setting OSKM group to:" + adminGroups[5]);
                }
                if (!adminGroups[6].trim().isEmpty()) {
                    cvuParam.setOSRACDBAgroup(adminGroups[6]);
                    Trace.out("Setting OSRAC group to:" + adminGroups[6]);
                }
            }
            ClusterVerification cvu = ClusterVerification.getInstance();
            VerificationResultSet resultSet = cvu.checkFrameworkSetup(nodeListArr);
            Trace.out("skipping stack size limit task");
            cvu.setVariableValue(VerificationAPIConstants.VAR_ORA_DISABLED_CVU_CHECKS, "CHECK_SHELL_LIMIT_SOFT_maximum stack size");
            if (resultSet != null && resultSet.getOverallStatus() != OverallStatus.SUCCESSFUL && resultSet.getFailedNodes() != null && resultSet.getFailedNodes().size() > 0) {
                Iterator failNodeIt = resultSet.getFailedNodes().iterator();
                while (failNodeIt.hasNext()) {
                    StringBuffer failedMsg = new StringBuffer();
                    String nodeName = (String)failNodeIt.next();
                    Trace.out("Failed Node ==> " + nodeName);
                    if (failedNodesString != null) {
                        failedNodesString = failedNodesString + "," + nodeName;
                        continue;
                    }
                    failedNodesString = nodeName;
                }
                for (VerificationError vfe : resultSet.getErrors()) {
                    errMsg = errMsg + LSEP + vfe.getErrorMessage();
                }
                this.displayErrorResult(errMsg, 2);
                return 1;
            }
            Trace.out("getting task list .. ");
            List taskList = cvu.getPreReqTasksForDBProv(nodeListArr, cvuParam);
            for (VerificationTask verTask : taskList) {
                ghTaskList.add(verTask);
                try {
                    if (!verTask.hasSubtasks()) continue;
                    List subTasks = verTask.getSubtasks();
                    Iterator subtaskIt = subTasks.iterator();
                    while (subtaskIt.hasNext()) {
                        ghTaskList.add((VerificationTask)subtaskIt.next());
                    }
                }
                catch (SubtasksUnavailableException ce) {
                    Trace.out(ce.getMessage());
                }
            }
            for (VerificationTask verTask : ghTaskList) {
                ArrayList resultLst = new ArrayList();
                this.CVUTaskCheck(verTask, resultLst);
                boolean isTaskCritical = SeverityType.CRITICAL.equals((Object)verTask.getSeverity());
                Trace.out("Task: " + verTask.getElementName() + " isTaskCritical:" + isTaskCritical);
                if (resultLst.isEmpty()) continue;
                Trace.out("Task: " + verTask.getElementName() + " with error");
                for (String rstr : resultLst) {
                    errMsg1 = errMsg1 + LSEP + rstr;
                }
                Trace.out("CVU task error message is " + errMsg1);
                if (isTaskCritical) {
                    ++count;
                    continue;
                }
                ++warnCount;
            }
            if (count > 0) {
                Trace.out("No of critical cvu tasks that failed are " + count);
                this.displayErrorResult(errMsg1, 2);
                return 1;
            }
            if (warnCount > 0) {
                Trace.out("Number of warnings from cvu tasks are " + warnCount);
                this.displayWarningResult(errMsg1, 1);
                return 2;
            }
        }
        catch (VerificationException ce) {
            Trace.out("Got Verification Exception " + ce.getMessage());
            this.displayErrorResult(ce.getMessage(), 2);
            return 1;
        }
        return 0;
    }

    public int getDirSize(String[] args) {
        Trace.out(2, "Entry");
        String[] nodeList = new String[]{};
        try {
            String path = args[1];
            Util utl = new Util();
            String crsHome = utl.getCRSHome();
            ClusterVerification cv = ClusterVerification.getInstance((String)System.getProperty("java.io.tmpdir"), (String)crsHome);
            VerificationResult result = cv.getDirSize(path);
            if (result.hasResultValues()) {
                String size = result.getActualValue().trim();
                Trace.out("directory size = " + size);
                this.displaySuccessResult(size, 0);
                return 0;
            }
            List errorList = result.getErrors();
            ArrayList<String> errorStrList = new ArrayList<String>();
            for (VerificationError error : errorList) {
                errorStrList.add(error.getErrorMessage());
            }
            String[] errorString = errorStrList.toArray(new String[errorStrList.size()]);
            this.displayErrorResult(Utils.getString(errorString, LSEP), 2);
            return 1;
        }
        catch (InvalidPathException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (ResultValuesUnavailableException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (UtilException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (VerificationException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int getPlatformID(String[] args) {
        String home = args[1];
        if (!home.trim().endsWith(File.separator)) {
            home = home + File.separator;
        }
        try {
            String homeProps = home + "inventory/ContentsXML/oraclehomeproperties.xml";
            File homePropsFile = new File(homeProps);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(homePropsFile);
            doc.getDocumentElement().normalize();
            String aruID = doc.getElementsByTagName("ARU_ID").item(0).getTextContent();
            Trace.out("ARU ID=" + aruID);
            this.displaySuccessResult(aruID);
            return 0;
        }
        catch (IOException e) {
            Trace.out("IOException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (ParserConfigurationException e) {
            Trace.out("ParserConfigurationException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SAXException e) {
            Trace.out("SAXException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int isMgmtDBConfigured(String[] args) {
        Trace.out(2, "Entry");
        try {
            DatabaseFactory dbFact = DatabaseFactory.getInstance();
            MgmtDatabase db = dbFact.getMgmtDatabase();
            if (db.isConfigured()) {
                this.displayVRESStatus(0);
            } else {
                this.displayVRESStatus(2);
            }
            return 0;
        }
        catch (SoftwareModuleException sme) {
            this.displayErrorResult(sme.getMessage());
            return 1;
        }
        catch (NotExistsException nee) {
            this.displayVRESStatus(2);
            return 0;
        }
    }

    public int getMgmtDBNodeName(String[] args) {
        Trace.out(2, "Entry");
        Object dbnode = null;
        try {
            DatabaseFactory df = DatabaseFactory.getInstance();
            MgmtDatabase db = df.getMgmtDatabase();
            MgmtDBInstance inst = db.getDBInstance();
            this.displaySuccessResult(inst.node().getName(), 0);
            return 0;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (DatabaseException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (InstanceException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (NodeException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
    }

    public int getACFSPermission(String[] args) {
        Trace.out(2, "Entry");
        try {
            String acfsPath = args[1];
            ClusterwareInfo clstInfo = new ClusterwareInfo();
            String volumeDevicePath = clstInfo.getVolumeDevice(acfsPath);
            ASMFactory asmfact = ASMFactory.getInstance();
            AsmBaseFileSystem abfs = asmfact.getFileSystem(volumeDevicePath);
            this.displaySuccessResult(((ResourcePermissionsImpl)abfs.crsResource().getPermissions()).getAclString(), 0);
            return 0;
        }
        catch (ASMException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (SoftwareModuleException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (NotExistsException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (CRSException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (InstallException e) {
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
    }

    public int addUserToACFS(String[] args) {
        Trace.out(2, "Entry");
        String user = args[1];
        String volDevice = args[2];
        try {
            ASMFactoryImpl asmFactoryImpl = ASMFactoryImpl.getInstance();
            AsmBaseFileSystemImpl baseFS = (AsmBaseFileSystemImpl)asmFactoryImpl.getFileSystem(volDevice);
            baseFS.addUser(user);
            return 0;
        }
        catch (AlreadyExistsException aee) {
            Trace.out("User already added: " + aee.getMessage());
            return 0;
        }
        catch (AsmClusterFileSystemException acfse) {
            Trace.out("Failed to add user: " + acfse.getMessage());
            this.displayErrorResult(acfse.getMessage(), 2);
            return 1;
        }
        catch (NotExistsException nee) {
            Trace.out("Failed to add user: " + nee.getMessage());
            this.displayErrorResult(nee.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Failed to add user: " + sme.getMessage());
            this.displayErrorResult(sme.getMessage(), 2);
            return 1;
        }
    }

    public int removeUserFromACFS(String[] args) {
        Trace.out(2, "Entry");
        String user = args[1];
        String volDevice = args[2];
        try {
            ASMFactoryImpl asmFactoryImpl = ASMFactoryImpl.getInstance();
            AsmBaseFileSystemImpl baseFS = (AsmBaseFileSystemImpl)asmFactoryImpl.getFileSystem(volDevice);
            baseFS.removeUser(user);
            return 0;
        }
        catch (AsmClusterFileSystemException acfse) {
            Trace.out("Failed to remove user " + acfse.getMessage());
            this.displayErrorResult(acfse.getMessage(), 2);
            return 1;
        }
        catch (NotExistsException nee) {
            Trace.out("Failed to remove user " + nee.getMessage());
            this.displayErrorResult(nee.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Failed to remove user " + sme.getMessage());
            this.displayErrorResult(sme.getMessage(), 2);
            return 1;
        }
    }

    public int isDatabaseAdminManaged(String[] args) {
        String dbUniqueName = args[1];
        try {
            Database db = DatabaseFactory.getInstance().getDatabase(null, dbUniqueName);
            boolean isAdminManaged = db.isAdminManaged();
            this.displaySuccessResult(String.valueOf(isAdminManaged), 0);
            return 0;
        }
        catch (NotExistsException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (DatabaseException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (VersionMismatchException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
    }

    public int isLeafnodeAllowed(String[] args) {
        try {
            GNSFactory gnsfact;
            boolean gnsConfigured;
            boolean leafAllowed = false;
            ClusterwareInfo clstInfo = new ClusterwareInfo();
            ClusterClassification ClusterClass = clstInfo.getClusterClassification();
            leafAllowed = ClusterClass == ClusterClassification.DOMAIN_CLUSTER || ClusterClass == ClusterClassification.MEMBER_CLUSTER ? false : (clstInfo.isExtendedCluster() ? false : (gnsConfigured = (gnsfact = GNSFactory.getInstance()).isGNSConfigured(true)));
            this.displaySuccessResult(String.valueOf(leafAllowed), 0);
            return 0;
        }
        catch (GNSException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (VIPNotFoundException e) {
            Trace.out((Exception)((Object)e));
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (InstallException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int getAdminDBConfiguredNodes(String[] args) {
        String dbUniqueName = args[1];
        try {
            Trace.out("Executing 'srvmhelper -getAdminDBConfiguredNodes'");
            Database db = DatabaseFactory.getInstance().getDatabase(null, dbUniqueName);
            List<String> nodes = db.getAdminDBConfiguredNodes();
            String nodeNames = EMPTY;
            for (int i = 0; i < nodes.size(); ++i) {
                nodeNames = nodeNames + nodes.get(i) + ",";
            }
            if (!nodeNames.isEmpty()) {
                nodeNames = nodeNames.substring(0, nodeNames.length() - 1);
            }
            Trace.out("Configured nodes for " + dbUniqueName + " are " + nodeNames);
            this.displaySuccessResult(nodeNames, 0);
            return 0;
        }
        catch (NotExistsException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (DatabaseException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (VersionMismatchException e) {
            Trace.out(e);
            try {
                if (Cluster.isParallelServerConfigured(dbUniqueName)) {
                    Trace.out(dbUniqueName + " is pre-TB database. Getting list of nodes...");
                    ParallelServerConfig psConfig = Cluster.getParallelServer(dbUniqueName).getConfiguration();
                    String[] nodes = psConfig.enumerateNodes();
                    String nodeNames = EMPTY;
                    for (String node : nodes) {
                        nodeNames = nodeNames + node + ",";
                    }
                    if (!nodeNames.isEmpty()) {
                        nodeNames = nodeNames.substring(0, nodeNames.length() - 1);
                    }
                    Trace.out("Configured nodes for " + dbUniqueName + " are " + nodeNames);
                    this.displaySuccessResult(nodeNames, 0);
                    return 0;
                }
            }
            catch (ConfigurationException ce) {
                Trace.out(e);
                this.displayErrorResult(e.getMessage(), 2);
                return 2;
            }
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 2;
        }
    }

    public int copyFrom(String[] args) {
        String host = args[1];
        String portStr = args[2];
        int port = Integer.valueOf(portStr);
        String srcPath = args[3];
        String destPath = args[4];
        try {
            RemoteFactory remoteFactory = RemoteFactory.getInstance();
            CopyClient copyClient = remoteFactory.getCopyClient();
            copyClient.copyFrom(host, port, srcPath, destPath);
            return 0;
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (CopyClientException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int copyTo(String[] args) {
        String host = args[1];
        String portStr = args[2];
        int port = Integer.valueOf(portStr);
        String srcPath = args[3];
        Trace.out("Source:" + srcPath);
        String destPath = args[4];
        Trace.out("Destination:" + srcPath);
        try {
            RemoteFactory remoteFactory = RemoteFactory.getInstance();
            CopyClient copyClient = remoteFactory.getCopyClient();
            copyClient.copyTo(host, port, srcPath, destPath);
            return 0;
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (CopyClientException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int executeUserActions(String[] args) throws ProgressListenerException {
        String baseDir = args[1];
        String uaInfo = args[2];
        String[] argsArr = oracle.cluster.impl.util.Utils.convertStringToArray(args[3]);
        String[] nodeList = oracle.cluster.impl.util.Utils.convertStringToArray(args[4]);
        String hostAndPort = args[5];
        ProgressListenerImpl plsnr = null;
        if (!hostAndPort.isEmpty() && !hostAndPort.equals("null")) {
            plsnr = new ProgressListenerImpl(hostAndPort);
        }
        try {
            Trace.out("Calling remote methods to execute useractions ...");
            new UserActionHelper().executeUserActions(baseDir, uaInfo, argsArr, nodeList, plsnr);
            return 0;
        }
        catch (HelperException e) {
            Trace.out("HelperException: " + e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int getOracleUser(String[] args) {
        String path = args[1];
        try {
            String owner = new Util().getOracleUser(path, null);
            this.displaySuccessResult(owner, 0);
            return 0;
        }
        catch (UtilException e) {
            Trace.out("UtilException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int move1Database(String[] args) {
        String dbUniqueName = args[1];
        String newOraHome = args[2];
        String rollingFlag = args[3];
        boolean rolling = Boolean.valueOf(rollingFlag);
        try {
            ArrayList<String> dbNames = new ArrayList<String>();
            dbNames.add(dbUniqueName);
            DatabaseFactory.getInstance().moveDatabases(dbNames, newOraHome, rolling);
            return 0;
        }
        catch (InvalidArgsException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (NoDatabasesToMoveException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (HomeException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (VersionMismatchException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (MoveDatabaseException e) {
            Trace.out(e);
            if (this.m_useTags) {
                System.out.println("<HLP_EMSG>");
                System.out.println(e.getReport());
                System.out.println("</HLP_EMSG>");
            } else {
                System.out.println(e.getReport());
            }
            return 1;
        }
        catch (DatabaseException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int moveDatabases(String[] args) {
        String oldOraHome = args[1];
        String newOraHome = args[2];
        String rollingFlag = args[3];
        boolean rolling = Boolean.valueOf(rollingFlag);
        try {
            DatabaseFactory.getInstance().moveDatabases(oldOraHome, newOraHome, rolling);
            return 0;
        }
        catch (HomeException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (VersionMismatchException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (MoveDatabaseException e) {
            Trace.out(e);
            if (this.m_useTags) {
                System.out.println("<HLP_EMSG>");
                System.out.println(e.getReport());
                System.out.println("</HLP_EMSG>");
            } else {
                System.out.println(e.getReport());
            }
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int moveDatabases2(String[] args) {
        try {
            List<String> dbNames = Arrays.asList(args[1].split(","));
            String destOraHome = args[2];
            MoveDatabaseOptionalArgs mvdbArgs = new MoveDatabaseOptionalArgs();
            if (!args[3].equals("NOT_SPECIFIED")) {
                mvdbArgs.setNonrollingOption(Boolean.valueOf(args[3]) == false);
            }
            if (!args[4].equals("NOT_SPECIFIED")) {
                try {
                    mvdbArgs.setStopOption(args[4]);
                }
                catch (DatabaseException e) {
                    Trace.out("Failed to retrieve enum representing stop option : " + e);
                    this.displayErrorResult(e.getMessage(), 2);
                    return 1;
                }
            }
            if (!args[5].equals("NOT_SPECIFIED")) {
                mvdbArgs.setDisconnectOption(Boolean.valueOf(args[5]));
            }
            if (!args[6].equals("NOT_SPECIFIED")) {
                mvdbArgs.setNoreplayOption(Boolean.valueOf(args[6]));
            }
            if (!args[7].equals("NOT_SPECIFIED")) {
                try {
                    mvdbArgs.setDrainTimeout(Integer.parseInt(args[7]));
                }
                catch (NumberFormatException e) {
                    Trace.out("Invalid number format for drain timeout : " + e);
                    this.displayErrorResult(e.getMessage(), 2);
                    return 1;
                }
            }
            if (!args[8].equals("NOT_SPECIFIED")) {
                mvdbArgs.setProgressListener(new ProgressListenerImpl(args[8]));
            }
            DatabaseFactory df = DatabaseFactory.getInstance();
            df.moveDatabases(dbNames, destOraHome, mvdbArgs);
            return 0;
        }
        catch (VersionMismatchException | HomeException e) {
            Trace.out(e.getClass().getName());
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (MoveDatabaseException e) {
            Trace.out(e);
            if (this.m_useTags) {
                System.out.println("<HLP_EMSG>");
                System.out.println(e.getReport());
                System.out.println("</HLP_EMSG>");
            } else {
                System.out.println(e.getReport());
            }
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int batchMoveDatabases(String[] args) {
        try {
            List<String> dbNames = Arrays.asList(args[1].split(","));
            String destOraHome = args[2];
            List<String> batch = Arrays.asList(args[3].split(","));
            MoveDatabaseOptionalArgs mvdbArgs = new MoveDatabaseOptionalArgs();
            if (!args[4].equals("NOT_SPECIFIED")) {
                try {
                    mvdbArgs.setStopOption(args[4]);
                }
                catch (DatabaseException e) {
                    Trace.out("Failed to retrieve enum representing stop option : " + e);
                    this.displayErrorResult(e.getMessage(), 2);
                    return 1;
                }
            }
            if (!args[5].equals("NOT_SPECIFIED")) {
                mvdbArgs.setDisconnectOption(Boolean.valueOf(args[5]));
            }
            if (!args[6].equals("NOT_SPECIFIED")) {
                mvdbArgs.setNoreplayOption(Boolean.valueOf(args[6]));
            }
            if (!args[7].equals("NOT_SPECIFIED")) {
                try {
                    mvdbArgs.setDrainTimeout(Integer.parseInt(args[7]));
                }
                catch (NumberFormatException e) {
                    Trace.out("Invalid number format for drain timeout : " + e);
                    this.displayErrorResult(e.getMessage(), 2);
                    return 1;
                }
            }
            if (!args[8].equals("NOT_SPECIFIED")) {
                mvdbArgs.setProgressListener(new ProgressListenerImpl(args[8]));
            }
            DatabaseFactory df = DatabaseFactory.getInstance();
            df.moveDatabases(dbNames, destOraHome, batch, mvdbArgs);
            return 0;
        }
        catch (NotExistsException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (VersionMismatchException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (MoveDatabaseException e) {
            Trace.out(e);
            if (this.m_useTags) {
                System.out.println("<HLP_EMSG>");
                System.out.println(e.getReport());
                System.out.println("</HLP_EMSG>");
            } else {
                System.out.println(e.getReport());
            }
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int getDeltaPatchesLsinventory(String[] args) {
        try {
            String destHome = args[1];
            String srcHome = args[2];
            if (destHome == null) {
                Trace.out("Oracle home 1 can not be null");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-getDeltaPatchesLsinventory-error_1"), 2);
                return 1;
            }
            if (srcHome == null) {
                Trace.out("Oracle home 2 can not be null");
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-getDeltaPatchesLsinventory-error_2"), 2);
                return 1;
            }
            ArrayList idPatches = new ArrayList();
            List<String> destPatches = new OPATCHUtil(destHome).getIDPatchesLsinventory(destHome);
            List<String> srcPatches = new OPATCHUtil(srcHome).getIDPatchesLsinventory(srcHome);
            String deltaPatches = this.getDeltaPatches(destPatches, srcPatches);
            this.displaySuccessResult(deltaPatches);
            return 0;
        }
        catch (CmdToolUtilException ce) {
            this.displayErrorResult(ce.getMessage(), 2);
            return 1;
        }
    }

    public int getdbswVer(String[] args) {
        try {
            this.displaySuccessResult(oracle.cluster.impl.util.Utils.getHomeVer(args[1], true).toString());
            return 0;
        }
        catch (InstallException e) {
            Trace.out((Object)"Failed to retrieve version from path %s", args[1]);
            Trace.out((Object)"Error: %s", e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int checkdbfile(String[] args) {
        Trace.out(2, "Entry");
        String[] nodeList = new String[]{};
        String dbfilePath = null;
        try {
            ClusterCmd cmd = new ClusterCmd();
            String nodes = args[1];
            Trace.out("Node list is...." + nodes);
            nodeList = nodes.split(",");
            dbfilePath = args[2];
            Trace.out("Dir path is...." + dbfilePath);
            StringBuffer sb = null;
            File f = new File(dbfilePath);
            if (!cmd.isDirWritable(nodeList, f.getCanonicalPath())) {
                Trace.out("The directory is not writable: " + dbfilePath);
                this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.NON_WRITABLE_PATH, true, dbfilePath), 2);
                return 1;
            }
            ClusterVerification cVer = ClusterVerification.getInstance();
            VerificationResultSet result = cVer.checkSharedStorageAccessibility(nodeList, dbfilePath, OracleFileType.RAC_DATA_FILES);
            if (result.getOverallStatus() == OverallStatus.OPERATION_FAILED || result.getOverallStatus() == OverallStatus.VERIFICATION_FAILED) {
                List vError = result.getErrors();
                for (VerificationError err : vError) {
                    Trace.out("Error is...." + err.getErrorMessage());
                    if (sb == null) {
                        sb = new StringBuffer(err.getErrorMessage());
                        continue;
                    }
                    sb.append(LSEP + err.getErrorMessage());
                }
            }
            if (sb != null) {
                this.displayErrorResult(sb.toString(), 2);
                return 1;
            }
            return 0;
        }
        catch (VerificationException e) {
            Trace.out("Failed to check if the databse storage is shared: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (InvalidPathException e) {
            Trace.out("InvalidPathException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (ClusterException e) {
            Trace.out("Failed to check if the databse storage is writable: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (IOException e) {
            Trace.out("IOException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (ClusterOperationException coe) {
            Trace.out("Got ClusterOperationException during isDirWritable");
            StringBuilder sb = new StringBuilder();
            for (String nodeName : nodeList) {
                try {
                    int status = coe.getStatus(nodeName);
                    Trace.out("exception check on node " + nodeName);
                    Trace.out("exception check status is " + status);
                    if (2 != status && 1 != status) continue;
                    Trace.out("getErrorMessage() --> " + coe.getErrorMessage(nodeName));
                    if (sb.length() == 0) {
                        sb.append(coe.getErrorMessage(nodeName));
                        continue;
                    }
                    sb.append(LSEP + coe.getErrorMessage(nodeName));
                }
                catch (NoSuchNodeException ns) {
                    Trace.out("\n UNEXPECTED::: \n" + ns.getMessage());
                }
            }
            this.displayErrorResult(sb.toString(), 2);
            return 1;
        }
    }

    public int mergeListenerOra(String[] args) {
        return this.intenalMergeNetCfgFiles(args[1], args[2], false);
    }

    public int mergeTnsnames(String[] args) {
        return this.intenalMergeNetCfgFiles(args[1], args[2], true);
    }

    private int intenalMergeNetCfgFiles(String srcPath, String tgtPath, boolean isTnsNames) {
        NodeAppsFactory naf = null;
        try {
            naf = NodeAppsFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Error while getting NodeAppsFactory instance: " + sme.getMessage());
            this.displayErrorResult(sme.getMessage(), 2);
            return 1;
        }
        if (naf != null) {
            try {
                if (isTnsNames) {
                    naf.mergeTnsNames(srcPath, tgtPath);
                }
                naf.mergeListenerOra(srcPath, tgtPath);
            }
            catch (ListenerException le) {
                String fileStr = isTnsNames ? "tnsnames.ora" : "listener.ora";
                Trace.out("Error while merging %s: %s", fileStr, le.getMessage());
                this.displayErrorResult(le.getMessage(), 2);
                return 1;
            }
            catch (InvalidFileException ife) {
                Trace.out("Got InvalidFileException: " + ife.getMessage());
                this.displayErrorResult(ife.getMessage(), 2);
                return 1;
            }
        } else {
            Trace.out("Error while getting NodeAppsFactory instance");
            return 1;
        }
        return 0;
    }

    public int mergeSqlNetOra(String[] args) {
        NodeAppsFactory naf = null;
        try {
            naf = NodeAppsFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Error while getting NodeAppsFactory instance: " + sme.getMessage());
            this.displayErrorResult(sme.getMessage(), 2);
            return 1;
        }
        if (naf != null) {
            try {
                naf.mergeSqlNet(args[1], args[2], args[3], args[4]);
            }
            catch (ListenerException le) {
                Trace.out((Object)"Error while merging sqlnet.ora: %s", le.getMessage());
                this.displayErrorResult(le.getMessage(), 2);
                return 1;
            }
            catch (InvalidFileException ife) {
                Trace.out("Got InvalidFileException: " + ife.getMessage());
                this.displayErrorResult(ife.getMessage(), 2);
                return 1;
            }
        } else {
            Trace.out("Error while getting NodeAppsFactory instance");
            return 1;
        }
        return 0;
    }

    public int getScanName(String[] args) {
        ScanFactory sf = null;
        String scanName = EMPTY;
        try {
            sf = ScanFactory.getInstance();
        }
        catch (SoftwareModuleException sme) {
            Trace.out("Error while getting ScanFactory instance: " + sme.getMessage());
            this.displayErrorResult(sme.getMessage(), 2);
            return 1;
        }
        if (sf != null) {
            try {
                int netnum = Integer.valueOf(args[1]);
                scanName = sf.getScanVIPs(netnum).get(0).getFQDNScanName();
            }
            catch (NotExistsException ne) {
                Trace.out((Object)"ScanVIP resources do not exist: %s", ne.getMessage());
                this.displayErrorResult(ne.getMessage(), 2);
                return 1;
            }
            catch (ScanVIPException sve) {
                Trace.out("Got ScanVIPException: " + sve.getMessage());
                this.displayErrorResult(sve.getMessage(), 2);
                return 1;
            }
            catch (NumberFormatException nfe) {
                Trace.out("Got NumberFormatException: " + nfe.getMessage());
                this.displayErrorResult(nfe.getMessage(), 2);
                return 1;
            }
        } else {
            Trace.out("Error while getting ScanFactory instance");
            return 1;
        }
        this.displaySuccessResult(scanName);
        return 0;
    }

    protected void CVUTaskCheck(VerificationTask verTask, List resultList) throws VerificationException {
        Object failedNodesString = null;
        Object successNodesString = null;
        String taskName = null;
        String taskDescr = null;
        taskName = verTask.getElementName();
        taskDescr = verTask.getDescription();
        Trace.out("CVU task name is " + taskName);
        Trace.out("CVU task description is " + taskDescr);
        VerificationResultSet set = null;
        try {
            if (!verTask.hasSubtasks() && (set = verTask.verify()) != null) {
                String errorMessage = this.getErrorMessage(set);
                Trace.out("Got The error set :" + errorMessage);
                if (errorMessage.length() > 0) {
                    resultList.add(errorMessage);
                }
            }
        }
        catch (SubtasksNotCompleteException ce) {
            Trace.out("Got SubtasksNotCompleteException " + ce.getMessage());
            throw new VerificationException(ce.getMessage());
        }
    }

    private String getErrorMessage(VerificationResultSet set) {
        String errMsg = EMPTY;
        if (null == set) {
            return errMsg;
        }
        if (set.getOverallStatus() != OverallStatus.SUCCESSFUL) {
            for (VerificationError vfe : set.getErrors()) {
                String errorMessage = vfe.getErrorMessage();
                errMsg = errMsg + LSEP + errorMessage;
            }
            List failedNodes = set.getFailedNodes();
            for (String nodeName : failedNodes) {
                Trace.out("Failed Node ==> " + nodeName);
                try {
                    VerificationResult vr = set.getNodeResult(nodeName);
                    List verErrList = vr.getErrors();
                    for (VerificationError verErr : verErrList) {
                        String errorMessage = verErr.getErrorMessage();
                        Trace.out("Failed Node msg ==> " + errorMessage);
                        errMsg = errMsg + LSEP + errorMessage;
                    }
                }
                catch (NodeResultsUnavailableException e) {
                    Trace.out("Got NodeResultsUnavailableException " + e.getMessage());
                    errMsg = errMsg + LSEP + e.getMessage();
                }
            }
        }
        return errMsg;
    }

    private String getDeltaPatches(List<String> destPatches, List<String> srcPatches) {
        ArrayList<String> deltaPatches = new ArrayList<String>();
        StringBuilder deltaPatchesSB = new StringBuilder();
        for (String destP : destPatches) {
            deltaPatches.add(destP);
        }
        for (String srcP : srcPatches) {
            deltaPatches.remove(srcP);
        }
        if (deltaPatches.size() == 0) {
            return deltaPatchesSB.toString();
        }
        for (String idP : deltaPatches) {
            deltaPatchesSB.append(idP);
            deltaPatchesSB.append(",");
        }
        deltaPatchesSB.deleteCharAt(deltaPatchesSB.length() - 1);
        return deltaPatchesSB.toString();
    }

    private String getLst2Str(List<String> lst) {
        StringBuilder elements = new StringBuilder();
        if (!lst.isEmpty()) {
            for (String e : lst) {
                elements.append(e);
                elements.append(",");
            }
            elements.deleteCharAt(elements.length() - 1);
        }
        return elements.toString();
    }

    private String createOraInst(String invLoc) {
        StringBuffer sb = new StringBuffer();
        sb.append("inventory_loc=" + invLoc);
        Trace.out("Content of oraInst.loc file:" + sb.toString());
        return sb.toString();
    }

    private String createInventory(String oracleHome) {
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        sb.append("<INVENTORY>");
        sb.append(lineSeparator);
        sb.append("<VERSION_INFO>");
        sb.append(lineSeparator);
        sb.append("<SAVED_WITH>12.1.0.2.0</SAVED_WITH>");
        sb.append(lineSeparator);
        sb.append("<MINIMUM_VER>2.1.0.6.0</MINIMUM_VER>");
        sb.append(lineSeparator);
        sb.append("</VERSION_INFO>");
        sb.append(lineSeparator);
        sb.append("<HOME_LIST>");
        sb.append(lineSeparator);
        sb.append("<HOME NAME=\"dbtmp\" LOC=\"" + oracleHome + "\" TYPE=\"O\" IDX=\"1\">");
        sb.append(lineSeparator);
        sb.append("</HOME>");
        sb.append(lineSeparator);
        sb.append("</HOME_LIST>");
        sb.append(lineSeparator);
        sb.append("</INVENTORY>");
        Trace.out("Content of inventory.xml file:" + sb.toString());
        return sb.toString();
    }

    public int exportClientData(String[] args) throws CredentialsException {
        String sysID = args[1];
        String client = args[2];
        if (client != null) {
            client = client.toLowerCase();
        }
        String vipAddr = args[3];
        String subdomain = args[4];
        String credFile = args[5];
        String version = args[6];
        if (version == null) {
            version = Version.getCurrentVersion().toString();
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("GHS_SITE_NAME", sysID);
        props.put("GHC_SITE_NAME", client);
        props.put("GNS_DISCOVERY_STRING", vipAddr);
        props.put("GNS_SUBDOMAIN_STRING", subdomain);
        CredentialsFactory cfact = CredentialsFactory.getInstance();
        Credentials cred = new Credentials();
        cred.setProperties(props);
        String cldataBuf = credFile == null ? cfact.exportClientDataBuf(client, cred, version) : cfact.exportClientDataBuf(client, cred, credFile, version);
        this.displaySuccessResult(cldataBuf);
        return 0;
    }

    public int createAdminHelper(String[] args) {
        Trace.out(2, "Entry");
        String resourceName = args[1];
        if (resourceName == null) {
            Trace.out("Resource name can not be null");
            this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-createAdminHelper-error_1"), 2);
            return 1;
        }
        AdminHelperFactoryImpl ahFactory = null;
        AdminHelper helper = null;
        Version version = new Version();
        try {
            ahFactory = AdminHelperFactoryImpl.getInstance();
            helper = ahFactory.createAdminHelper(resourceName, version);
            helper.start();
        }
        catch (AlreadyExistsException e) {
            Trace.out("AlreadyExistsException while adding an admin helper resource: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (AlreadyRunningException e) {
            Trace.out("AlreadyRunningException while adding an admin helper resource: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (AdminHelperException e) {
            Trace.out("AdminHelperException while adding an admin helper resource: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException while adding an admin helper resource: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        this.displaySuccessResult(args[0] + SUCCESS_SUFFIX, 0);
        return 0;
    }

    public int deleteAdminHelper(String[] args) {
        Trace.out(2, "Entry");
        String resourceNameList = args[1];
        if (resourceNameList == null) {
            Trace.out("Resource name list can not be null");
            this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-deleteAdminHelper-error_1"), 2);
            return 1;
        }
        AdminHelperFactoryImpl ahFactory = null;
        AdminHelper helper = null;
        try {
            ahFactory = AdminHelperFactoryImpl.getInstance();
            String[] list = resourceNameList.split(",");
            if (list != null && list.length > 0) {
                for (String eachResourceName : list) {
                    helper = ahFactory.getAdminHelper(eachResourceName);
                    if (helper.isRunning()) {
                        helper.stop(true);
                    }
                    helper.remove(true);
                }
            }
        }
        catch (NotExistsException e) {
            Trace.out("NotExistsException while deleting admin helper resources: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (AlreadyRunningException e) {
            Trace.out("AlreadyRunningException while deleting admin helper resources: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (AlreadyStoppedException e) {
            Trace.out("AlreadyStoppedException while deleting admin helper resources: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (AdminHelperException e) {
            Trace.out("AdminHelperException while deleting admin helper resources: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out("SoftwareModuleException while deleting admin helper resources: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        this.displaySuccessResult(args[0] + SUCCESS_SUFFIX, 0);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public int execPatchAction(String[] args) throws ProgressListenerException {
        void var43_60;
        String oHome = args[1];
        String patchStep = args[2];
        String rhplsnrhostport = args[3];
        String mayExit = args[4];
        String auPath = args[5];
        String agPath = args[6];
        String clusterNodes = args[7];
        String giUser = args[8];
        String oracleBase = args[9];
        String oHomeName = args[10];
        String rollingFlag = args[11];
        String rollbackFlag = args[12];
        String perlHome = args[13];
        String cleanPIDFlag = args[14];
        String iplsnrhostport = args[15];
        String cmd = EMPTY;
        String[] env = null;
        ProgressListenerImpl iplsnr = null;
        ProgressListenerImpl rhplsnr = null;
        ExecRunTime crProc = null;
        InputStream crProcOutput = null;
        InputStream crProcError = null;
        int exitVal = -1;
        String exitMsg = null;
        Object perlcmd = null;
        String[] cmdArray = null;
        String[][] cmdArgsArray = null;
        String localHost = null;
        try {
            localHost = Utils.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        GridHomeFactory ghFact = null;
        boolean isGHS = false;
        GridHomeServer ghs = null;
        GridHomeClient ghc = null;
        String rhpHost = null;
        if (args[11].equals("null")) {
            rollingFlag = EMPTY;
        }
        if (args[12].equals("null")) {
            rollbackFlag = EMPTY;
        }
        Trace.out("Entering execPatchAction");
        Trace.out("oracleHome = " + oHome);
        Trace.out("patchStep = " + patchStep);
        Trace.out("AU Path = " + auPath);
        Trace.out("AG Path = " + agPath);
        Trace.out("clusterNodes =" + clusterNodes);
        Trace.out("giUser = " + giUser);
        Trace.out("OracleBase = " + oracleBase);
        Trace.out("Oracle Home Name =" + oHomeName);
        Trace.out((Object)"Local host is %s", localHost);
        Trace.out((Object)"ORACLE_BASE env var is %s", System.getenv("ORACLE_BASE"));
        cmd = "/bin/sh";
        String cmd1 = oHome + FILE_SEP + Constants.PERL;
        Trace.out("cmd is " + cmd);
        Trace.out("iplsnr details are " + iplsnrhostport);
        Trace.out("rhpplsnr details are " + rhplsnrhostport);
        Trace.out("Rolling Flag is set to " + rollingFlag);
        Trace.out("Rollback Flag is set to " + rollbackFlag);
        Trace.out("CleanPID flag is set to " + cleanPIDFlag);
        Trace.out("Home to execute rootcrs perl script" + perlHome);
        try {
            ghFact = GridHomeFactory.getInstance();
            try {
                ghs = ghFact.getGridHomeServer();
                List<Node> ghsNodes = ghs.crsResource().fetchRunningNodes();
                if (ghsNodes.size() == 0) {
                    Trace.out("GHS not running");
                    this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-execPatchAction-error_1"), 2);
                    return 1;
                }
                rhpHost = ghsNodes.get(0).getName();
                isGHS = true;
            }
            catch (NotExistsException e) {
                try {
                    ghc = ghFact.getGridHomeClient();
                    List<Node> ghcNodes = ghc.crsResource().fetchRunningNodes();
                    if (ghcNodes.size() == 0) {
                        Trace.out("GHC not running");
                        this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.UNEXPECTED_INTERNAL_ERROR, true, "Helper-execPatchAction-error_2"), 2);
                        return 1;
                    }
                    rhpHost = ghcNodes.get(0).getName();
                }
                catch (NotExistsException ex) {
                    Trace.out("Got NotexistsException");
                    this.displayErrorResult(ex.getMessage(), 2);
                    return 1;
                }
                catch (GridHomeClientException ce) {
                    Trace.out("Got GridHomeClientException");
                    this.displayErrorResult(ce.getMessage(), 2);
                    return 1;
                }
            }
            catch (GridHomeServerException se) {
                Trace.out("Got GridHomeServerException");
                this.displayErrorResult(se.getMessage(), 2);
                return 1;
            }
            Trace.out("rhp is running  on " + rhpHost);
            if (InetAddress.getByName(localHost).equals(InetAddress.getByName(rhpHost))) {
                Trace.out("Disabling rhp host");
                if (isGHS) {
                    ghs.disable();
                } else {
                    ghc.disable();
                }
            }
        }
        catch (CRSException e) {
            Trace.out("Got CRSException");
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (NodeException e) {
            Trace.out("Got NodeException");
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (GridHomeServerException e) {
            Trace.out("Got GridHomeServerException");
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (GridHomeClientException e) {
            Trace.out("Got GridHomeClientException");
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out("Got SoftwareModuleException");
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (AlreadyDisabledException e) {
            Trace.out("Got AlreadyDisabledException");
        }
        catch (UnknownHostException e) {
            Trace.out("Got UnknownHostException");
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        String incl1 = "-I " + perlHome + "/perl/lib";
        String incl2 = "-I " + perlHome + "/crs/install";
        String rootscrPath = perlHome + "/crs/install/rootcrs.pl";
        String patchstep = "-" + patchStep;
        String desthomeopt = "-dstcrshome";
        if (!auPath.equals("null")) {
            cmdArray = new String[9];
            cmdArgsArray = new String[9][];
            String prepatchCommand = "(" + cmd1 + " " + incl1 + " " + incl2 + " " + rootscrPath + " " + "-prepatch" + " " + rollingFlag + " " + rollbackFlag + ")";
            cmdArray[0] = cmd;
            cmdArgsArray[0] = new String[]{"-c", prepatchCommand};
            cmdArray[1] = "/bin/umount";
            cmdArgsArray[1] = new String[]{oHome};
            cmdArray[2] = auPath + "/bin/olfsroot";
            cmdArgsArray[2] = new String[]{"uninstall"};
            cmdArray[3] = auPath + "/bin/olfsroot";
            cmdArgsArray[3] = new String[]{"install", "-u", auPath, "-g", agPath, "-m", oHome};
            cmdArray[4] = "/bin/su";
            String string = "(" + auPath + "/bin/olfscmd" + " " + "repltree" + " " + auPath + " " + agPath + ")";
            cmdArgsArray[4] = new String[]{giUser, "-c", string};
            cmdArray[5] = "/bin/chown";
            cmdArgsArray[5] = new String[]{"-R", giUser, agPath};
            cmdArray[6] = "/bin/mount";
            cmdArgsArray[6] = new String[]{auPath, oHome, "-t", "olfs", "-o", agPath};
            cmdArray[7] = "/bin/su";
            String tmpCloneCmd = "(" + oHome + FILE_SEP + Constants.PERL + " " + oHome + "/clone/bin/clone.pl" + " " + "-silent" + " " + "-force" + " " + "ORACLE_HOME=" + oHome + " " + "ORACLE_HOME_NAME=" + oHomeName + " " + "ORACLE_BASE=" + oracleBase + " " + "\"CLUSTER_NODES={" + clusterNodes + "}\"" + " " + "CRS=TRUE" + ")";
            cmdArgsArray[7] = new String[]{giUser, "-c", tmpCloneCmd};
            String postpatchCommand = "(" + cmd1 + " " + incl1 + " " + incl2 + " " + rootscrPath + " " + "-postpatch" + " " + rollingFlag + " " + rollbackFlag + ")";
            cmdArray[8] = cmd;
            cmdArgsArray[8] = new String[]{"-c", postpatchCommand};
        } else {
            String tempCommand = "(" + cmd1 + " " + incl1 + " " + incl2 + " " + rootscrPath + " " + patchstep + " " + desthomeopt + " " + oHome + " " + rollingFlag + " " + rollbackFlag + ")";
            Trace.out("args are" + incl1, incl2, rootscrPath, patchstep, desthomeopt, oHome, rollingFlag, rollbackFlag);
            Trace.out("Command is " + tempCommand);
            cmdArray = new String[1];
            cmdArgsArray = new String[1][];
            cmdArray[0] = cmd;
            cmdArgsArray[0] = new String[]{"-c", tempCommand};
        }
        Trace.out("Launching the runcommandnowait");
        Trace.out("cmd args are");
        for (int i = 0; i < cmdArray.length; ++i) {
            Trace.out("Command :" + cmdArray[i] + " with options:");
            for (String opts : cmdArgsArray[i]) {
                Trace.out(opts);
            }
        }
        if (!rhplsnrhostport.equals("null")) {
            rhplsnr = new ProgressListenerImpl(rhplsnrhostport);
        }
        if (!iplsnrhostport.equals("null")) {
            iplsnr = new ProgressListenerImpl(iplsnrhostport);
        }
        ExecCommand execCommand = RemoteFactory.getInstance().getExecCommand();
        boolean bl = false;
        while (var43_60 < cmdArray.length) {
            try {
                if (cmdArray[var43_60].endsWith(UMOUNT) && cleanPIDFlag.equals("true")) {
                    this.killLPMHomeProcs(oHome);
                }
                if (cmdArray[var43_60].endsWith("olfsroot")) {
                    env = new String[]{"ORACLE_HOME=" + auPath};
                    Trace.out("Setting environment variable " + env[0]);
                } else {
                    env = new String[]{};
                }
                crProc = execCommand.runCommandNoWait(cmdArray[var43_60], cmdArgsArray[var43_60], env);
            }
            catch (ExecException e) {
                Trace.out("execgiPatch failed");
                this.displayErrorResult(e.getMessage(), 2);
                return 1;
            }
            catch (InvalidArgsException e) {
                Trace.out("execgiPatch failed");
                this.displayErrorResult(e.getMessage(), 2);
                return 1;
            }
            Trace.out("Process the output of spawned process");
            crProcOutput = crProc.getInputStream();
            crProcError = crProc.getErrorStream();
            InputStreamReader isr = new InputStreamReader(crProcOutput);
            BufferedReader br = new BufferedReader(isr);
            StreamReader errReader = new StreamReader(crProcError, "ERROR");
            errReader.start();
            String startMsg = localHost + ':' + "POSTPATCH STARTED";
            iplsnr.write(startMsg, false);
            Trace.out("waiting for execgiPatchScript to complete");
            while (crProc.isAlive()) {
                try {
                    String line = null;
                    Trace.out("In StreamReader.run ");
                    while ((line = br.readLine()) != null) {
                        Trace.out("read line is " + line);
                        if (rhplsnr == null) continue;
                        rhplsnr.write(line, false);
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Trace.out("Got interrupted exception " + ie.getMessage());
                }
                catch (IOException ioe) {
                    Trace.out("Got IO exception " + ioe.getMessage());
                }
            }
            for (String str : errReader.getBuffer()) {
                Trace.out("read line is " + str);
                if (rhplsnr == null) continue;
                rhplsnr.write(str, false);
            }
            Trace.out("execgiPatchScript completed");
            exitVal = crProc.exitValue();
            if (exitVal != 0) break;
            ++var43_60;
        }
        try {
            if (InetAddress.getByName(localHost).equals(InetAddress.getByName(rhpHost))) {
                ServerFactory serverFactory = ServerFactory.getInstance();
                Node rhpNode = serverFactory.getNode(rhpHost);
                if (isGHS) {
                    try {
                        ghs.enable();
                    }
                    catch (AlreadyEnabledException e) {
                        Trace.out("Got AlreadyEnabledException" + e.getMessage());
                    }
                    try {
                        ghs.start(rhpNode);
                    }
                    catch (AlreadyRunningException e) {
                        Trace.out("Got AlreadyRunningException" + e.getMessage());
                    }
                } else {
                    try {
                        ghc.enable();
                    }
                    catch (AlreadyEnabledException e) {
                        Trace.out("Got AlreadyEnabledException" + e.getMessage());
                    }
                    try {
                        ghc.start(rhpNode);
                    }
                    catch (AlreadyRunningException e) {
                        Trace.out("Got AlreadyRunningException" + e.getMessage());
                    }
                }
            }
            String string = Integer.toString(exitVal);
            Trace.out("Exit Value is " + string);
            exitMsg = localHost + ':' + "POSTPATCH EXITED" + ':' + string;
            iplsnr.write(exitMsg, false);
        }
        catch (GridHomeServerException gridHomeServerException) {
            Trace.out("Got GridHomeServerException" + gridHomeServerException.getMessage());
            this.displayErrorResult(gridHomeServerException.getMessage(), 2);
            return 1;
        }
        catch (GridHomeClientException gridHomeClientException) {
            Trace.out("Got GridHomeClientException" + gridHomeClientException.getMessage());
            this.displayErrorResult(gridHomeClientException.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException softwareModuleException) {
            Trace.out("Got SoftwareModuleException" + softwareModuleException.getMessage());
            this.displayErrorResult(softwareModuleException.getMessage(), 2);
            return 1;
        }
        catch (NodeException nodeException) {
            Trace.out("Got NodeException" + nodeException.getMessage());
            this.displayErrorResult(nodeException.getMessage(), 2);
            return 1;
        }
        catch (ServerException serverException) {
            Trace.out("Got ServerException" + serverException.getMessage());
            this.displayErrorResult(serverException.getMessage(), 2);
            return 1;
        }
        catch (UnknownHostException unknownHostException) {
            Trace.out("Got UnknownHostException");
            this.displayErrorResult(unknownHostException.getMessage(), 2);
            return 1;
        }
        if (exitVal == 0) {
            this.displaySuccessResult("execPatchAction successful", 0);
            return 0;
        }
        this.displayErrorResult("execPatchAction completed with non zero exit status", 2);
        return 1;
    }

    public int getServerPools(String[] args) {
        List<Object> spList = new ArrayList();
        String wantedCategory = args[1];
        ServerCategory sg = null;
        if (wantedCategory == null) {
            this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.VALUED_OPTION_VALUE_MISSING, true, "getServerPools"), 2);
            return 1;
        }
        if (!wantedCategory.equalsIgnoreCase(this.HUB) && !wantedCategory.equalsIgnoreCase(this.LEAF)) {
            this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.INVALID_OPTION_NAME, true, wantedCategory), 2);
            return 1;
        }
        Trace.out("Wanted  category.." + wantedCategory);
        StringBuffer sb = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        String obtainedCategory = null;
        try {
            ServerFactory sf = ServerFactory.getInstance();
            spList = wantedCategory.equalsIgnoreCase(this.HUB) ? sf.getServerPools(this.ORAHUB) : sf.getServerPools(this.ORALEAF);
            if (spList.size() == 0) {
                return 0;
            }
            sb.append("<SERVERPOOLS>" + lineSeparator);
            for (ServerPool serverPool : spList) {
                Trace.out("Get config info for srvpool: " + serverPool.getName());
                sg = serverPool.serverCategory();
                if (sg == null) continue;
                obtainedCategory = sg.getName();
                StringBuilder sb1 = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                String candServerStr = EMPTY;
                String activeServerStr = EMPTY;
                List<Server> servers = serverPool.candidateServers();
                for (Server s : servers) {
                    if (sb1.length() != 0) {
                        sb1.append("," + s.node().getName());
                        continue;
                    }
                    sb1.append(s.node().getName());
                }
                if (sb1.length() != 0) {
                    candServerStr = sb1.toString();
                }
                servers = serverPool.servers();
                for (Server s : servers) {
                    if (sb2.length() != 0) {
                        sb2.append("," + s.node().getName());
                        continue;
                    }
                    sb2.append(s.node().getName());
                }
                if (sb2.length() != 0) {
                    activeServerStr = sb2.toString();
                }
                sb.append("<SERVERPOOL>" + lineSeparator);
                sb.append("<SERVERPOOL_NAME>" + serverPool.getName() + "</SERVERPOOL_NAME>" + lineSeparator);
                sb.append("<SERVERPOOL_CATEGORY>" + (obtainedCategory != null ? obtainedCategory : EMPTY) + "</SERVERPOOL_CATEGORY>" + lineSeparator);
                sb.append("<MIN_SIZE>" + serverPool.getMinSize() + "</MIN_SIZE>" + lineSeparator);
                sb.append("<MAX_SIZE>" + serverPool.getMaxSize() + "</MAX_SIZE>" + lineSeparator);
                sb.append("<IMPORTANCE>" + serverPool.getImportance() + "</IMPORTANCE>" + lineSeparator);
                sb.append("<ACTIVE_SERVERS>" + activeServerStr + "</ACTIVE_SERVERS>" + lineSeparator);
                sb.append("<CANDIDATE_SERVERS>" + candServerStr + "</CANDIDATE_SERVERS>" + lineSeparator);
                sb.append("</SERVERPOOL>" + lineSeparator);
            }
            sb.append("</SERVERPOOLS>" + lineSeparator);
        }
        catch (ServerGroupException e) {
            Trace.out("getServerPools failed with exception" + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (ServerException e) {
            Trace.out("getServerPools failed with exception" + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (NotExistsException e) {
            Trace.out("getServerPools failed with exception" + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (NodeException e) {
            Trace.out("getServerPools failed with exception" + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        this.displaySuccessResult(sb.toString());
        return 0;
    }

    public int getActiveServers(String[] args) {
        String serverPoolName = args[1];
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        String hubServerStr = EMPTY;
        String leafServerStr = EMPTY;
        if (serverPoolName == null) {
            this.displayErrorResult(MessageBundle.getMessage(PrCgMsgID.VALUED_OPTION_VALUE_MISSING, true, "getActiveServers"), 2);
            return 1;
        }
        try {
            ServerPool serverPool = ServerFactory.getInstance().getServerPool(serverPoolName);
            if (serverPool != null) {
                List<Server> servers = serverPool.servers();
                for (Server s : servers) {
                    if (this.HUB.equalsIgnoreCase(s.role().toString())) {
                        if (sb1.length() != 0) {
                            sb1.append("," + s.getName());
                            continue;
                        }
                        sb1.append(s.getName());
                        continue;
                    }
                    if (!this.LEAF.equalsIgnoreCase(s.role().toString())) continue;
                    if (sb2.length() != 0) {
                        sb2.append("," + s.getName());
                        continue;
                    }
                    sb2.append(s.getName());
                }
                if (sb1.length() != 0) {
                    hubServerStr = sb1.toString();
                }
                if (sb2.length() != 0) {
                    leafServerStr = sb2.toString();
                }
            }
        }
        catch (ServerGroupException e) {
            Trace.out("getActiveServers failed with exception " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (ServerException e) {
            Trace.out("getActiveServers failed with exception " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (NotExistsException e) {
            Trace.out("getActiveServers failed with exception " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        StringBuilder result = new StringBuilder();
        result.append("<ACTIVE_HUB_SERVERS>" + hubServerStr + "</ACTIVE_HUB_SERVERS>" + System.getProperty("line.separator"));
        result.append("<ACTIVE_LEAF_SERVERS>" + leafServerStr + "</ACTIVE_LEAF_SERVERS>");
        this.displaySuccessResult(result.toString());
        return 0;
    }

    public int resetRepos(String[] args) {
        Trace.out(2, "Entry");
        try {
            String crsHome = new Util().getCRSHome();
            String dbnode = new ClusterwareInfo().getMgmtDBNodeName();
            MGMTCAUtil mgmtcaUtil = new MGMTCAUtil(crsHome, dbnode);
            mgmtcaUtil.resetRepos();
            mgmtcaUtil.setGHSUserPass();
        }
        catch (CmdToolUtilException | InstallException | UtilException e) {
            Trace.out("%s: %s", e.getClass().getSimpleName(), e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        this.displaySuccessResult(args[0] + SUCCESS_SUFFIX, 0);
        return 0;
    }

    private static String getTimestamp() {
        SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        sdf.applyPattern(DATE_FORMAT);
        return sdf.format(new Date());
    }

    public int getAdminDatabaseNames(String[] args) {
        String node = args[1];
        Trace.out((Object)"retrieving admin database instances on node %s", node);
        try {
            List<DatabaseInstance> insts = DatabaseFactory.getInstance().getAdminDatabaseInstances(node);
            ArrayList<String> dbnames = new ArrayList<String>();
            for (DatabaseInstance inst : insts) {
                dbnames.add(inst.getName());
            }
            this.displaySuccessResult(oracle.cluster.impl.util.Utils.strListToList2(dbnames), 0);
            return 0;
        }
        catch (InvalidArgsException | DatabaseException e) {
            Trace.out(e.getClass().getName());
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int getACFSMountNodes(String[] args) {
        String volDevice = args[1];
        String dgName = args[2];
        String volName = args[3];
        try {
            ASMFactory afact = ASMFactory.getInstance();
            AsmClusterFileSystem acfs = null;
            ArrayList<String> nodeStr = new ArrayList<String>();
            if (!volDevice.isEmpty()) {
                acfs = afact.getAsmClusterFileSystem(volDevice);
            } else if (!dgName.isEmpty() && !volName.isEmpty()) {
                acfs = afact.getAsmClusterFileSystem(volName, dgName);
            }
            if (acfs != null) {
                List<Node> nodes = acfs.crsResource().fetchRunningNodes();
                for (Node n : nodes) {
                    nodeStr.add(n.getHostName());
                }
            }
            this.displaySuccessResult(oracle.cluster.impl.util.Utils.strListToList2(nodeStr), 0);
            return 0;
        }
        catch (CRSException | NotExistsException | NodeException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int isACFSNodeLocal(String[] args) {
        String volDevice = args[1];
        try {
            ASMFactory afact = ASMFactory.getInstance();
            AsmClusterFileSystem acfs = null;
            String isNodeLocal = "0";
            if (!volDevice.isEmpty()) {
                acfs = afact.getAsmClusterFileSystem(volDevice);
            }
            if (acfs != null) {
                isNodeLocal = acfs.isLocalResource() ? "0" : "1";
            }
            this.displaySuccessResult(isNodeLocal, 0);
            return 0;
        }
        catch (NotExistsException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int executeRHPHelper(String[] args) {
        try {
            String[] cmdOutput;
            Trace.out("Executing 'srvmhelper -execRHPHelper' ...");
            String currUser = null;
            String localNode = null;
            String crshome = null;
            try {
                Util util = new Util();
                currUser = util.getCurrentUser();
                Trace.out((Object)"command is being executed as user %s", currUser);
                localNode = util.getLocalHostName();
                Trace.out((Object)"command is being executed on node %s", localNode);
                crshome = util.getCRSHome();
                Trace.out((Object)"CRS home is %s", crshome);
            }
            catch (UtilException ue) {
                Trace.out("attempt to retrieve information using methods in ops.mgmt.has.Util failed with : %s", new Object[]{ue});
                this.displayErrorResult(ue.getMessage(), 2);
                return 1;
            }
            String parentDir = args[1];
            String home = !"NOT_SPECIFIED".equals(args[2]) ? args[2] : parentDir;
            String keyword = args[3];
            args[1] = home;
            args[2] = parentDir;
            ArrayList<String> cmdArgs = new ArrayList<String>(Arrays.asList(args));
            cmdArgs.remove(0);
            Trace.out("rhphelper's parent dir is %s and home %s will be used for CLASSPATH", parentDir, home);
            String rhphelperCmd = parentDir + "/crs/install/rhpdata/helper/rhphelper";
            cmdArgs.add(0, rhphelperCmd);
            ClusterwareInfo crsInfo = new ClusterwareInfo();
            Version homeVersion = crsInfo.getSRVCTLVersion(home);
            Trace.out("version of home %s is %s", home, homeVersion.toString());
            cmdArgs.add(3, homeVersion.toString());
            cmdArgs.remove(cmdArgs.size() - 1);
            Trace.out((Object)"command array : %s ...", ((Object)cmdArgs).toString());
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
            String rhpTraceFileName = "rhphelper_" + sdf.format(new Date()) + ".log";
            String rhpTraceFileLoc = "/tmp/" + rhpTraceFileName;
            Trace.out((Object)"rhphelper tracefile's location : %s", rhpTraceFileLoc);
            HashMap<String, String> envMap = new HashMap<String, String>(System.getenv());
            envMap.put("SRVM_TRACE", Boolean.TRUE.toString());
            envMap.put("RHPHELPER_TRACEFILE", rhpTraceFileLoc);
            ArrayList<String> env = new ArrayList<String>();
            for (String key : envMap.keySet()) {
                env.add(key + "=" + (String)envMap.get(key));
            }
            Trace.out((Object)"env variables : %s", ((Object)env).toString());
            Trace.out("executing rhphelper ...");
            RuntimeExec runtime = new RuntimeExec(cmdArgs.toArray(new String[0]), null, env.toArray(new String[0]));
            int retval = runtime.runCommand();
            Trace.out("rhphelper's retval = %d", retval);
            int exitVal = runtime.getExitValue();
            Trace.out("rhphelper's exitval = %d", exitVal);
            String[] cmdError = runtime.getError();
            String output = EMPTY;
            if (cmdError != null && cmdError.length > 0) {
                Trace.out((Object)"rhphelper's error stream : %s", Arrays.asList(cmdError).toString());
                output = oracle.cluster.impl.util.Utils.strArrToString(cmdError, System.lineSeparator());
            }
            if ((cmdOutput = runtime.getOutput()) != null && cmdOutput.length > 0) {
                Trace.out((Object)"rhphelper's output stream : %s", Arrays.asList(cmdOutput).toString());
                output = output + (!output.trim().isEmpty() ? System.lineSeparator() : EMPTY) + oracle.cluster.impl.util.Utils.strArrToString(cmdOutput, System.lineSeparator());
            }
            StringBuilder result = new StringBuilder();
            if (retval != 0 || exitVal != 0 || cmdError.length > 0) {
                Trace.out((Object)"rhphelper failed with : %s", output);
                Exception exp = runtime.getException();
                result.append((exp != null ? exp.getMessage() + System.lineSeparator() : EMPTY) + output);
            } else {
                Trace.out((Object)"rhphelper succeeded with : %s", output);
                result.append(output);
            }
            Trace.out((Object)"rhphelper's result is : %s", result.toString());
            this.displaySuccessResult(result.toString(), exitVal);
            return 0;
        }
        catch (InstallException e) {
            Trace.out("'srvmhelper -execRHPHelper' failed with InstallException : %s", e);
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    public int dynamicOps(String[] args) {
        try {
            String parentDir = args[1];
            String keyword = args[2];
            ArrayList<String> methodArgs = new ArrayList<String>(Arrays.asList(args));
            methodArgs.remove(0);
            methodArgs.remove(0);
            methodArgs.remove(0);
            Trace.out("parent dir : %s ; keyword : %s ; args : %s", parentDir, keyword, ((Object)methodArgs).toString());
            Version currVer = Version.getCurrentVersion();
            String suffix = currVer.getMajorVersion() + currVer.getMinorVersion();
            Trace.out((Object)"suffix : %s", suffix);
            String rhphelperjarPath = parentDir + "/crs/install/rhpdata/helper/rhphelper" + suffix + ".jar";
            Trace.out((Object)"rhphelper jar is located at : %s", rhphelperjarPath);
            URL jarURL = new URL("jar:file:" + rhphelperjarPath + "!/");
            URLClassLoader clsLoader = URLClassLoader.newInstance(new URL[]{jarURL}, Helper.class.getClassLoader());
            String clsName = "oracle.gridhome.common.helper" + suffix + ".RHPHelper" + suffix;
            Trace.out((Object)"loading class : %s", clsName);
            Class<?> rhphelperCls = Class.forName(clsName, true, clsLoader);
            Trace.out((Object)"retrieved class : %s", rhphelperCls.getName());
            Method dynamicOps = rhphelperCls.getMethod("dynamicOps", String.class, List.class);
            Trace.out("invoking dynamicOps method ...");
            String result = (String)dynamicOps.invoke(rhphelperCls.newInstance(), keyword, methodArgs);
            Trace.out((Object)"result of dynamicOps : %s", result);
            this.displaySuccessResult(result, 0);
            return 0;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | MalformedURLException e) {
            Trace.out("attempt to invoke dynamicOps failed with exception : %s. Details : %s", e.getClass().getName(), e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (InvocationTargetException e) {
            Trace.out((Object)"attempt to invoke dynamicOps failed with InvocationTargetException : %s", e.getCause().getMessage());
            this.displayErrorResult(e.getCause().getMessage(), 2);
            return 1;
        }
    }

    public int checkEnoughSpace(String[] args) {
        Trace.out(2, "Entry");
        Trace.out("Framework home is " + args[1]);
        Trace.out("Nodes are " + args[2]);
        Trace.out("Path is" + args[3]);
        Trace.out("Size is " + args[4]);
        String frameworkHome = args[1];
        String[] nodeList = args[2].split(",");
        String[] nodeListArr = this.getNodeListArr(Arrays.asList(nodeList));
        String path = args[3];
        Long size = Long.parseLong(args[4]);
        try {
            Trace.out("Check if at least " + args[4] + " GB space is available for " + path);
            ClusterVerification cvu = ClusterVerification.getInstance((String)frameworkHome, (ClusterVerification.PathType)ClusterVerification.PathType.FRAMEWORK_HOME);
            VerificationResultSet resultSet = cvu.checkSpaceAvailability(nodeListArr, path, size.longValue(), StorageUnit.KBYTE);
            String errMsg = this.getErrorMessage(resultSet);
            if (!errMsg.isEmpty()) {
                Trace.out("Error Message is " + errMsg);
                this.displayErrorResult(errMsg, 2);
                return 1;
            }
            return 0;
        }
        catch (VerificationException e) {
            Trace.out("VerificationException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
        catch (InvalidPathException e) {
            Trace.out("InvalidPathException: " + e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    protected String[] getNodeListArr(List<String> nodeList) {
        String[] nodeListArr = new String[nodeList.size()];
        int index = 0;
        for (String node : nodeList) {
            Trace.out("Node is " + node);
            String[] nodeNameArr = node.split("\\.");
            nodeListArr[index] = nodeNameArr[0].toLowerCase();
            ++index;
        }
        return nodeListArr;
    }

    private void killLPMHomeProcs(String home) {
        UnixSystem system = (UnixSystem)new SystemFactory().CreateSystem();
        String lsofPath = system.getLSOFPath();
        String killPath = system.getKillPath();
        String[] cmdArray = new String[]{lsofPath, home};
        RuntimeExec runtime = new RuntimeExec(cmdArray, null, null);
        int retval = runtime.runCommand();
        int exitVal = runtime.getExitValue();
        Trace.out("Successfully executed with retval " + retval + " exitVal " + exitVal);
        cmdArray = new String[]{lsofPath, "-t", home};
        runtime = new RuntimeExec(cmdArray, null, null);
        retval = runtime.runCommand();
        exitVal = runtime.getExitValue();
        Trace.out("Successfully executed with retval " + retval + " exitVal " + exitVal);
        String[] cmdOutput = runtime.getOutput();
        if (null != cmdOutput && cmdOutput.length > 0) {
            cmdArray = new String[3];
            cmdArray[0] = killPath;
            cmdArray[1] = "-9";
            String[] stringArray = cmdOutput;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String procid;
                cmdArray[2] = procid = stringArray[i];
                runtime = new RuntimeExec(cmdArray, null, null);
                runtime.runCommand();
            }
        }
    }

    public int getRHPClusterType(String[] args) {
        int retValue = 0;
        try {
            GridHomeFactory gridFact = GridHomeFactory.getInstance();
            RHPContainerType ghType = gridFact.getRHPClusterType();
            this.displaySuccessResult(ghType.toString(), 0);
        }
        catch (SoftwareModuleException e) {
            Trace.out(e);
            this.displayErrorResult(e.getMessage(), 2);
            retValue = 1;
        }
        return retValue;
    }

    public int checkPatchedBugs(String[] args) {
        Trace.out(2, "Entry");
        Trace.out((Object)"Oracle Home is: %s", args[1]);
        Trace.out((Object)"Bug numbers are: %s", args[2]);
        Trace.out((Object)"Nodes are: %s", args[3]);
        Trace.out((Object)"isRacHome: %s", args[4]);
        String oracleHome = args[1];
        String[] bugNums = args[2].split(",");
        String[] nodes = args[3].split(",");
        Boolean isRacHome = Boolean.parseBoolean(args[4]);
        StringBuilder allErrMsg = new StringBuilder();
        try {
            ClusterVerification cvu = ClusterVerification.getInstance();
            Hashtable result = cvu.checkOraclePatches(oracleHome, nodes, bugNums, isRacHome.booleanValue());
            for (String bug : result.keySet()) {
                String errMsg = this.getErrorMessage((VerificationResultSet)result.get(bug));
                if (errMsg.isEmpty()) continue;
                allErrMsg.append(errMsg);
            }
            if (!allErrMsg.toString().isEmpty()) {
                Trace.out((Object)"Error Message is %s ", allErrMsg.toString());
                this.displayErrorResult(allErrMsg.toString(), 2);
                return 1;
            }
            return 0;
        }
        catch (InvalidPathException | VerificationException e) {
            Trace.out("%s: %s", e.getClass().getSimpleName(), e.getMessage());
            this.displayErrorResult(e.getMessage(), 2);
            return 1;
        }
    }

    static {
        TRACE_SRVMHELPER_FNAME = "srvmhelper.log";
        LSEP = System.getProperty("line.separator");
        FILE_SEP = System.getProperty("file.separator");
        TMP_LOC = System.getProperty("java.io.tmpdir");
    }

    class CommandLineOption {
        String m_key;
        String m_usageInfo;
        String m_methodName;
        int m_numberOfArgs;

        public CommandLineOption(String key, int numberOfArgs, String methodName, String usageInfo) {
            this.m_key = key;
            this.m_numberOfArgs = numberOfArgs;
            this.m_methodName = methodName;
            this.m_usageInfo = usageInfo;
        }

        public String getKey() {
            return this.m_key;
        }

        public String getUsageInfo() {
            return this.m_usageInfo;
        }

        public int getNumberOfArgs() {
            return this.m_numberOfArgs;
        }

        public String getMethodName() {
            return this.m_methodName;
        }
    }
}

