/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.hanfs;

import oracle.cluster.hanfs.HAVIPException;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.VIPAddress;

public class HAVIPArgs {
    private VIPAddress m_vipAddress = null;
    private Network m_network = null;
    private String m_description = null;
    private boolean m_skipVIPReachabilityCheck = false;
    private String m_homeNode = null;

    public VIPAddress getVipAddress() {
        return this.m_vipAddress;
    }

    public void setVipAddress(VIPAddress vipAddress) throws HAVIPException {
        this.validateAgainstNull(vipAddress, "havipargs-error-vipaddress");
        this.m_vipAddress = vipAddress;
    }

    public Network getNetwork() {
        return this.m_network;
    }

    public void setNetwork(Network network) throws HAVIPException {
        this.validateAgainstNull(network, "havipargs-error-network");
        this.m_network = network;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) throws HAVIPException {
        this.validateAgainstNull(description, "havipargs-error-description");
        this.m_description = description;
    }

    public boolean isSkipVIPReachabilityCheck() {
        return this.m_skipVIPReachabilityCheck;
    }

    public void setSkipVIPReachabilityCheck(boolean skipVIPReachabilityCheck) {
        this.m_skipVIPReachabilityCheck = skipVIPReachabilityCheck;
    }

    public String getHomeNode() {
        return this.m_homeNode;
    }

    public void setHomeNode(String homeNode) throws HAVIPException {
        this.validateAgainstNull(homeNode, "havipargs-error-homenode");
        this.m_homeNode = homeNode;
    }

    private void validateAgainstNull(Object objToValidate, String errorId) throws HAVIPException {
        if (objToValidate == null) {
            throw new HAVIPException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, errorId);
        }
    }
}

