/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.gridhome.client.GridHomeActionException;
import oracle.cluster.resources.PrCgMsgID;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class GridHomeActionResult {
    private ActionStatus m_status;
    private List<String> m_output = new ArrayList<String>();
    private String m_result;
    private String m_exMsg;
    private Map<String, String> m_returnMap = new HashMap<String, String>();
    public static final String STATUS_BEGTAG = "<STATUS>";
    public static final String STATUS_ENDTAG = "</STATUS>";
    public static final String OUTPUT_BEGTAG = "<OUTPUT>";
    public static final String OUTPUT_ENDTAG = "</OUTPUT>";
    public static final String OUTPUT_FACILITY_BEGTAG = "<FACILITY>";
    public static final String OUTPUT_FACILITY_ENDTAG = "</FACILITY>";
    public static final String OUTPUT_KEY_BEGTAG = "<KEY>";
    public static final String OUTPUT_KEY_ENDTAG = "</KEY>";
    public static final String OUTPUT_PRINTKEY_BEGTAG = "<PRINTKEY>";
    public static final String OUTPUT_PRINTKEY_ENDTAG = "</PRINTKEY>";
    public static final String OUTPUT_ARG_BEGTAG = "<ARG>";
    public static final String OUTPUT_ARG_ENDTAG = "</ARG>";
    public static final String EXCEPTION_BEGTAG = "<EXCEPTION>";
    public static final String EXCEPTION_ENDTAG = "</EXCEPTION>";
    public static final String RETURN_BEGTAG = "<RETURN>";
    public static final String RETURN_ENDTAG = "</RETURN>";
    public static final String CAPS_OUTPUT_BODY = " %s={%s}";
    public static final String CAPS_OUTPUT_HEADER = "#@=result[%d]:%s";
    private static final String LSEP = System.getProperty("line.separator");

    public GridHomeActionResult(String result) throws GridHomeActionException {
        this.m_result = result;
        Trace.out("result = " + result);
        int statusBegIndex = result.indexOf(STATUS_BEGTAG);
        int statusEndIndex = result.indexOf(STATUS_ENDTAG);
        try {
            this.m_status = ActionStatus.getEnumMember(result.substring(statusBegIndex + STATUS_BEGTAG.length(), statusEndIndex));
        }
        catch (EnumConstNotFoundException e) {
            throw new GridHomeActionException(e);
        }
        int outputBegIndex = result.indexOf(OUTPUT_BEGTAG);
        Trace.out("outputBegIndex = " + outputBegIndex);
        if (outputBegIndex != -1) {
            String outputStr = result.substring(outputBegIndex);
            Trace.out("outputStr = " + outputStr);
            while (outputBegIndex != -1) {
                int outputEndIndex = outputStr.indexOf(OUTPUT_ENDTAG);
                Trace.out("outputEndIndex = " + outputEndIndex);
                String output = outputStr.substring(OUTPUT_BEGTAG.length(), outputEndIndex);
                Trace.out("output = " + output);
                int facEndIndex = output.indexOf(OUTPUT_FACILITY_ENDTAG);
                int facBegIndex = output.indexOf(OUTPUT_FACILITY_BEGTAG);
                String facility = null;
                if (facEndIndex != -1) {
                    facility = output.substring(facBegIndex + OUTPUT_FACILITY_BEGTAG.length(), facEndIndex);
                    Trace.out("Facility = " + facility);
                    int keyBegIndex = output.indexOf(OUTPUT_KEY_BEGTAG);
                    int keyEndIndex = output.indexOf(OUTPUT_KEY_ENDTAG);
                    String key = output.substring(keyBegIndex + OUTPUT_KEY_BEGTAG.length(), keyEndIndex);
                    Trace.out("Message key = " + key);
                    int printkeyBegIndex = output.indexOf(OUTPUT_PRINTKEY_BEGTAG);
                    int printkeyEndIndex = output.indexOf(OUTPUT_PRINTKEY_ENDTAG);
                    String printkey = output.substring(printkeyBegIndex + OUTPUT_PRINTKEY_BEGTAG.length(), printkeyEndIndex);
                    Trace.out("Print key = " + printkey);
                    int argBegIndex = output.indexOf(OUTPUT_ARG_BEGTAG);
                    ArrayList<String> args = new ArrayList<String>();
                    if (argBegIndex != -1) {
                        String argStr = output.substring(argBegIndex);
                        while (argBegIndex != -1) {
                            int argEndIndex = argStr.indexOf(OUTPUT_ARG_ENDTAG);
                            String arg = argStr.substring(OUTPUT_ARG_BEGTAG.length(), argEndIndex);
                            Trace.out("arg = " + arg);
                            args.add(arg);
                            argStr = argStr.substring(argEndIndex + OUTPUT_ARG_ENDTAG.length());
                            argBegIndex = argStr.indexOf(OUTPUT_ARG_BEGTAG);
                            Trace.out("argBegIndex = " + argBegIndex + ", argStr = " + argStr);
                        }
                    }
                    MessageBundle msgBndl = MessageBundle.getMessageBundle(facility);
                    msgBndl.setPackage("oracle.gridhome.resources");
                    String msg = null;
                    msg = args.size() == 0 ? msgBndl.getMessage(key, (boolean)new Boolean(printkey)) : msgBndl.getMessage(key, new Boolean(printkey), args.toArray(new String[args.size()]));
                    Trace.out("msg = " + msg);
                    this.m_output.add(msg);
                } else {
                    this.m_output.add(output);
                }
                outputStr = outputStr.substring(outputEndIndex + OUTPUT_ENDTAG.length());
                outputBegIndex = outputStr.indexOf(OUTPUT_BEGTAG);
                Trace.out("outputBegIndex = " + outputBegIndex + ", outputStr = " + outputStr);
            }
        }
        int retBegIndex = result.indexOf(RETURN_BEGTAG);
        Trace.out("retBegIndex = " + retBegIndex);
        if (retBegIndex != -1) {
            String retStr = result.substring(retBegIndex);
            Trace.out("retStr = " + retStr);
            while (retBegIndex != -1) {
                int retEndIndex = retStr.indexOf(RETURN_ENDTAG);
                Trace.out("retEndIndex = " + retEndIndex);
                String nameValuePair = retStr.substring(RETURN_BEGTAG.length(), retEndIndex);
                Trace.out("nameValuePair = " + nameValuePair);
                String[] nameValue = nameValuePair.split("=");
                if (nameValue.length == 1) {
                    this.m_returnMap.put(nameValue[0], "");
                } else {
                    this.m_returnMap.put(nameValue[0], nameValue[1]);
                }
                retStr = retStr.substring(retEndIndex + RETURN_ENDTAG.length());
                retBegIndex = retStr.indexOf(RETURN_BEGTAG);
                Trace.out("retBegIndex = " + retBegIndex + ", retStr = " + retStr);
            }
        }
        int exBegIndex = result.indexOf(EXCEPTION_BEGTAG);
        Trace.out("exBegIndex = " + exBegIndex);
        if (exBegIndex != -1) {
            int exEndIndex = result.indexOf(EXCEPTION_ENDTAG);
            this.m_exMsg = result.substring(exBegIndex + EXCEPTION_BEGTAG.length(), exEndIndex);
        }
    }

    public ActionStatus getStatus() {
        return this.m_status;
    }

    public boolean isSuccess() {
        return this.m_status == ActionStatus.SUCCESS;
    }

    public boolean isWarning() {
        return this.m_status == ActionStatus.WARNING;
    }

    public String[] getOutput() {
        return this.m_output.toArray(new String[this.m_output.size()]);
    }

    public String getAllOutputs() {
        StringBuffer sb = null;
        for (String out : this.m_output) {
            if (sb == null) {
                sb = new StringBuffer(out);
                continue;
            }
            sb.append(LSEP + out);
        }
        return sb == null ? "" : sb.toString();
    }

    public String getExceptionMessage() {
        return this.m_exMsg;
    }

    public Map<String, String> getReturnValues() {
        return this.m_returnMap;
    }

    public static String generateStatus(ActionStatus status) {
        return STATUS_BEGTAG + status.toString() + STATUS_ENDTAG;
    }

    public static String generateOutput(String facility, String key, boolean printKey, String ... args) {
        StringBuilder retVal = new StringBuilder("<OUTPUT><FACILITY>" + facility + OUTPUT_FACILITY_ENDTAG);
        retVal.append(OUTPUT_KEY_BEGTAG + key + OUTPUT_KEY_ENDTAG);
        retVal.append(OUTPUT_PRINTKEY_BEGTAG + String.valueOf(printKey) + OUTPUT_PRINTKEY_ENDTAG);
        for (String arg : args) {
            retVal.append(OUTPUT_ARG_BEGTAG + (arg == null ? "" : arg) + OUTPUT_ARG_ENDTAG);
        }
        retVal.append(OUTPUT_ENDTAG);
        return retVal.toString();
    }

    public static String generateEMOutput(String fieldName, String fieldValue) {
        StringBuilder retVal = new StringBuilder();
        retVal.append(String.format(CAPS_OUTPUT_BODY, fieldName, fieldValue));
        return retVal.toString();
    }

    public static String generateEMOutput(int index, String outputBody) {
        StringBuilder retVal = new StringBuilder();
        retVal.append(OUTPUT_BEGTAG + String.format(CAPS_OUTPUT_HEADER, index, outputBody) + OUTPUT_ENDTAG);
        return retVal.toString();
    }

    private static String generateStatusOutput(ActionStatus status, String ... outMsgs) {
        StringBuilder retVal = new StringBuilder(GridHomeActionResult.generateStatus(status));
        for (String outMsg : outMsgs) {
            retVal.append(OUTPUT_BEGTAG + outMsg + OUTPUT_ENDTAG);
        }
        return retVal.toString();
    }

    public static String genExceptionOutput(String ... excptMsgs) {
        return GridHomeActionResult.generateStatusOutput(ActionStatus.EXCEPTION, excptMsgs);
    }

    public static String genSuccessOutput(String ... outMsgs) {
        return GridHomeActionResult.generateStatusOutput(ActionStatus.SUCCESS, outMsgs);
    }

    public static String genWarningOutput(String ... warningMsgs) {
        return GridHomeActionResult.generateStatusOutput(ActionStatus.WARNING, warningMsgs);
    }

    public static String genSuccessRetValue(String ... retValues) {
        StringBuilder retVal = new StringBuilder(GridHomeActionResult.generateStatus(ActionStatus.SUCCESS));
        for (String val : retValues) {
            if (val == null || val.trim().length() == 0) continue;
            retVal.append(RETURN_BEGTAG + val + RETURN_ENDTAG);
        }
        return retVal.toString();
    }

    public static String genStackTrace(String stackTrace) {
        return EXCEPTION_BEGTAG + stackTrace + EXCEPTION_ENDTAG;
    }

    public static enum ActionStatus {
        SUCCESS("0"),
        WARNING("1"),
        EXCEPTION("2"),
        INTERRUPTED("3");

        private String m_status;

        private ActionStatus(String status) {
            this.m_status = status;
        }

        public String toString() {
            return this.m_status;
        }

        public static ActionStatus getEnumMember(String status) throws EnumConstNotFoundException {
            for (ActionStatus s : ActionStatus.values()) {
                if (!s.m_status.equals(status)) continue;
                return s;
            }
            throw new EnumConstNotFoundException((MessageKey)PrCgMsgID.INVALID_ACTION_STATUS, status);
        }
    }
}

