/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gridhome;

import oracle.cluster.gridhome.GridHomeClientException;
import oracle.cluster.gridhome.GridHomeException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.resources.PrCgMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class GridHomeArgs {
    private String m_emailAddress = null;
    private String m_mailServerAddress = null;
    private String m_mailServerPort = null;
    private String m_passwd = null;
    public static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";

    public void setEmailAddress(String emailAddress) throws GridHomeException {
        Trace.out("Setting email address is..." + emailAddress);
        if (emailAddress == null) {
            throw new GridHomeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "emailAddress");
        }
        if (emailAddress.trim().length() != 0) {
            this.checkEmailAddressFormat(emailAddress);
        }
        this.m_emailAddress = emailAddress;
    }

    public String getEmailAddress() {
        return this.m_emailAddress;
    }

    public void setMailServerAddress(String mailServerAddress) throws GridHomeException {
        Trace.out("Setting mail server address..." + mailServerAddress);
        if (mailServerAddress == null) {
            throw new GridHomeException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "mailServerAddress");
        }
        this.m_mailServerAddress = mailServerAddress;
    }

    public String getMailServerAddress() {
        return this.m_mailServerAddress;
    }

    public void setMailServerPort(String mailServerport) throws GridHomeException {
        Trace.out("Mail server port is..." + mailServerport);
        this.sureNotNull(mailServerport, "mailServerport");
        try {
            if (mailServerport.trim().length() != 0) {
                int port = Integer.parseInt(mailServerport);
                this.assertPortNumber(port);
            }
            this.m_mailServerPort = mailServerport;
        }
        catch (NumberFormatException e) {
            throw new GridHomeException((MessageKey)PrCgMsgID.MAIL_SERVER_PORT_NOT_INTEGER, mailServerport);
        }
    }

    public String getMailServerPort() throws GridHomeException {
        return this.m_mailServerPort;
    }

    public void setPassword(String passwd) throws GridHomeException {
        this.sureNotNull(passwd, "password");
        this.m_passwd = passwd;
    }

    public String getPassword() throws GridHomeException {
        return this.m_passwd;
    }

    private void sureNotNull(Object o, String name) throws GridHomeException {
        if (o == null) {
            throw new GridHomeException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, name);
        }
    }

    private void assertPortNumber(int port) throws GridHomeException {
        if (port < 1 || port > 65535) {
            throw new GridHomeException((MessageKey)PrCfMsgID.PORT_NUMBER_OUT_OF_EXPECTED_RANGE, port);
        }
    }

    public void checkEmailAddressFormat(String emailAddress) throws GridHomeException {
        Trace.out("Checking email address: " + emailAddress + " is in valid format");
        this.sureNotNull(emailAddress, "emailAddress");
        if (emailAddress.trim().length() == 0) {
            throw new GridHomeClientException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "emailAddress");
        }
        Boolean b = emailAddress.matches(EMAIL_PATTERN);
        if (!b.booleanValue()) {
            throw new GridHomeException((MessageKey)PrCgMsgID.INVALID_EMAIL_ADDRESS_FORMAT, emailAddress);
        }
    }
}

