/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gns;

import oracle.gridnamingservice.QueryTypes;

public enum GNSQueryTypes {
    BRIDGE_PORT(QueryTypes.BRIDGE_PORT),
    MULTICAST_PORT(QueryTypes.MULTICAST_PORT),
    STATUS(QueryTypes.STATUS),
    SUBDOMAIN(QueryTypes.SUBDOMAIN),
    VERSION(QueryTypes.VERSION),
    CLUSTER_GUID(QueryTypes.CLUSTER_GUID),
    CLUSTER_NAME(QueryTypes.CLUSTER_NAME),
    CLUSTER_TYPE(QueryTypes.CLUSTER_TYPE),
    LOG_LEVEL(QueryTypes.LOG_LEVEL),
    LISTENING_ADDRESSES(QueryTypes.LISTENING_ADDRESSES),
    NETWORK("network"),
    ALL_EXCEPT_CONFIG(QueryTypes.ALL_EXCEPT_CONFIG);

    private QueryTypes queryType;
    private String name;
    private boolean isGNSQuery;

    private GNSQueryTypes(QueryTypes queryType) {
        this.queryType = queryType;
        this.name = null;
        this.isGNSQuery = true;
    }

    private GNSQueryTypes(String name) {
        this.queryType = null;
        this.name = name;
        this.isGNSQuery = false;
    }

    public QueryTypes getGNSQueryType() {
        return this.queryType;
    }

    public String getName() {
        return this.name != null ? this.name : this.queryType.toString();
    }

    public boolean isGNS() {
        return this.isGNSQuery;
    }

    public boolean equals(GNSQueryTypes queryType) {
        return this.getName().equals(queryType.getName());
    }

    public static GNSQueryTypes[] getValues() {
        int numValues = GNSQueryTypes.values().length - 1;
        GNSQueryTypes[] usableValues = new GNSQueryTypes[numValues];
        System.arraycopy(GNSQueryTypes.values(), 0, usableValues, 0, numValues);
        return usableValues;
    }
}

