/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gns;

import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.credentials.GNSProperties;
import oracle.cluster.gns.GNS;
import oracle.cluster.gns.GNSDomainAlreadyExistsException;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSQueryTypes;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.gns.GNSVIPException;
import oracle.cluster.impl.gns.GNSFactoryImpl;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.GNSInfo;
import oracle.gridnamingservice.GNSRecordList;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.VIPAddress;
import oracle.ops.mgmt.trace.Trace;

public class GNSFactory {
    private static GNSFactory s_instance;
    private static GNSFactoryImpl s_factoryImpl;

    private GNSFactory() throws VIPNotFoundException, SoftwareModuleException {
        s_factoryImpl = GNSFactoryImpl.getInstance();
    }

    public static synchronized GNSFactory getInstance() throws VIPNotFoundException, SoftwareModuleException {
        if (null == s_instance) {
            s_instance = new GNSFactory();
        }
        return s_instance;
    }

    public GNSVIP getVIP() throws VIPNotFoundException, GNSVIPException {
        return s_factoryImpl.getVIP();
    }

    public void create(GNSVIP gnsVIP, Version version) throws VIPNotFoundException, NotExistsException, AlreadyExistsException, GNSException {
        s_factoryImpl.create(gnsVIP, version);
    }

    public void create(GNSVIP gnsVIP, String domain) throws GNSDomainAlreadyExistsException, AlreadyExistsException, GNSException {
        s_factoryImpl.create(gnsVIP, domain);
    }

    public void create(String clientData, GNSVIP gnsVIP) throws GNSException, AlreadyExistsException {
        s_factoryImpl.create(clientData, gnsVIP);
    }

    public GNSVIP createVIP(VIPAddress vipAddress, Network network, Version version) throws GNSVIPException, AlreadyExistsException {
        return s_factoryImpl.createVIP(vipAddress, network, version);
    }

    public GNSVIP createVIP(VIPAddress vipAddress, Network network, Version version, boolean skipVIPReachabilityCheck) throws GNSVIPException, AlreadyExistsException {
        Trace.out("Create VIP....");
        return s_factoryImpl.createVIP(vipAddress, network, version, skipVIPReachabilityCheck);
    }

    public void modify(String domain, String[] allowedNetworks, String[] deniedNetworks) throws GNSException {
        s_factoryImpl.modify(domain, allowedNetworks, deniedNetworks);
    }

    public GNSVIP modifyVIP(VIPAddress ipAddress) throws GNSException {
        return s_factoryImpl.modifyVIP(ipAddress);
    }

    public GNSVIP modifyVIP(VIPAddress ipAddress, boolean skipVIPReachabilityCheck) throws GNSException {
        return s_factoryImpl.modifyVIP(ipAddress, skipVIPReachabilityCheck);
    }

    public void removeGNS() throws GNSException {
        s_factoryImpl.remove();
    }

    public GNSVIP getGNSVIP() throws VIPNotFoundException, GNSVIPException {
        return s_factoryImpl.getVIP();
    }

    public GNS getGNS() throws VIPNotFoundException, NotExistsException, GNSException {
        return s_factoryImpl.getGNS();
    }

    public GNSInfo query(MessageBundle messageBundle, GNSQueryTypes[] queryTypes) throws GNSException {
        return s_factoryImpl.query(messageBundle, queryTypes);
    }

    public String query(GNSQueryTypes queryType) throws GNSException {
        return s_factoryImpl.query(queryType);
    }

    public GNSRecordList queryRecords() throws GNSException {
        return s_factoryImpl.queryRecords();
    }

    public GNSRecordList queryRecords(String name) throws GNSException {
        return s_factoryImpl.queryRecords(name, null);
    }

    public GNSRecordList queryRecords(String name, String recordType) throws GNSException {
        return s_factoryImpl.queryRecords(name, recordType);
    }

    public void validateSubdomainName(String subdomainName) throws GNSException {
        s_factoryImpl.validateSubdomainName(subdomainName);
    }

    public static String getGNSSubSubDomain(String clusterName, GNSProperties gnsProps) throws GNSException {
        return GNSFactoryImpl.getGNSSubSubDomain(clusterName, gnsProps);
    }

    public boolean isGNSClient() {
        return s_factoryImpl.isGNSClient();
    }

    public boolean isGNSConfigured() throws GNSException {
        return this.isGNSConfigured(true);
    }

    public boolean isGNSConfigured(boolean serverOnly) throws GNSException {
        return s_factoryImpl.isGNSConfigured(serverOnly);
    }

    public String[] executeDNSQueryForHostPort(String vipAddr, String subDomain, String serviceName, String clusterName) throws GNSException {
        Trace.out("executeDNSQueryForHostPort....");
        return s_factoryImpl.executeDNSQueryForHostPort(vipAddr, subDomain, serviceName, clusterName);
    }

    public String executeDNSQueryForHost(String vipAddr, String subDomain, String serviceName, String clusterName, String hostName) throws GNSException {
        Trace.out("executeDNSQueryForHostPort....");
        return s_factoryImpl.executeDNSQueryForHost(vipAddr, subDomain, serviceName, clusterName, hostName);
    }

    public GNSRecordList getInstanceList() throws GNSException {
        Trace.out("getInstanceList...");
        return s_factoryImpl.getInstanceList();
    }
}

