/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.gns;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.Relocatable;
import oracle.cluster.gns.GNSDomainAlreadyExistsException;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSParameter;
import oracle.cluster.gns.GNSRole;
import oracle.cluster.gns.GNSVIP;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.NotExistsException;
import oracle.gridnamingservice.AdvertiseRecord;
import oracle.gridnamingservice.GNSClusterTypes;
import oracle.gridnamingservice.GNSInfo;
import oracle.gridnamingservice.QueryTypes;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.has.VIPNotFoundException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.nodeapps.VIPAddress;

public interface GNS
extends SoftwareModule,
Relocatable {
    public static final int GNS_LOG_LEVEL_MIN = 1;
    public static final int GNS_LOG_LEVEL_MAX = 6;

    public Network network() throws GNSException;

    public InetAddress address() throws GNSException;

    public Map<IPAddressUtil.IPAddrType, InetAddress> addresses() throws GNSException;

    public String getGNSName() throws GNSException;

    @Override
    public boolean isRunning() throws GNSException;

    @Override
    public boolean isRunning(Node var1) throws GNSException;

    @Override
    public void start() throws AlreadyRunningException, SoftwareModuleException;

    public void start(int var1) throws AlreadyRunningException, SoftwareModuleException;

    public void start(Node var1) throws AlreadyRunningException, SoftwareModuleException;

    public void start(Node var1, int var2) throws AlreadyRunningException, SoftwareModuleException;

    @Override
    public void stop(boolean var1) throws SoftwareModuleException;

    public void stop(Node var1, boolean var2) throws SoftwareModuleException;

    public void stopResourcesWarnIfExists(Node var1, boolean var2) throws GNSException, AlreadyStoppedException;

    public void addDomain(String var1, String var2, String var3) throws GNSDomainAlreadyExistsException, GNSException;

    public void add(String var1, String var2) throws GNSDomainAlreadyExistsException, GNSException;

    public void add(String var1, String var2, Network var3) throws GNSDomainAlreadyExistsException, GNSException;

    public void addSecondary(String var1, String var2) throws GNSException;

    public void removeDomain(String var1) throws AlreadyRunningException, GNSException;

    @Override
    public void enable() throws AlreadyEnabledException, GNSException;

    public void enable(boolean var1) throws AlreadyEnabledException, GNSException;

    public void enable(Node var1, boolean var2) throws AlreadyEnabledException, GNSException;

    @Override
    public void disable() throws AlreadyDisabledException, GNSException;

    public void disable(boolean var1) throws AlreadyDisabledException, GNSException;

    public void disable(Node var1, boolean var2) throws AlreadyDisabledException, GNSException;

    public void remove() throws GNSException;

    public void remove(boolean var1) throws GNSException;

    public void advertiseRecord(AdvertiseRecord var1) throws GNSException;

    public void deleteRecord(AdvertiseRecord var1) throws GNSException;

    public void deleteName(String var1) throws GNSException;

    public String resolve(String var1) throws GNSException;

    public void validate(String var1) throws GNSException;

    public String query(QueryTypes var1) throws GNSException;

    public GNSInfo query(QueryTypes[] var1, int var2) throws GNSException;

    public String getQueryResult(GNSInfo var1, QueryTypes var2) throws GNSException;

    public void setTraceLevel(int var1) throws GNSException;

    public void setParameterList(ArrayList<GNSParameter> var1) throws GNSException;

    public GNSVIP modifyVIP(VIPAddress var1) throws SoftwareModuleException, VIPNotFoundException, GNSException;

    public GNSVIP modifyVIP(VIPAddress var1, boolean var2) throws SoftwareModuleException, VIPNotFoundException, GNSException;

    public void modifyClientData(String var1) throws GNSException;

    public void modifyRole(GNSRole var1) throws GNSException;

    public void modifyRole(GNSRole var1, boolean var2) throws GNSException;

    public void modify(String var1, String[] var2, String[] var3) throws SoftwareModuleException, VIPNotFoundException, GNSException;

    public CRSResource crsResource() throws NotExistsException, GNSException;

    public void exportCredentials(String var1) throws GNSException;

    public void exportCredentials(String var1, GNSRole var2) throws GNSException;

    public void exportCredentials(String var1, GNSRole var2, Version var3) throws GNSException;

    public void importCredentials(String var1) throws GNSException;

    public void importInstance(String var1) throws GNSException;

    public void exportInstance(String var1) throws GNSException;

    public boolean isGNSConfigured() throws GNSException;

    public boolean isGNSConfigured(boolean var1) throws GNSException;

    public String getSubdomain() throws GNSException;

    public void ntGrantAclsForTransparentHA() throws GNSException;

    public void upgrade112To121() throws GNSException;

    public void upgrade121To122() throws GNSException;

    public boolean isGNSResourceExist() throws GNSException;

    public GNSClusterTypes getClusterType();

    public GNSRole getGNSInstanceRole() throws GNSException;
}

