/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.ops.mgmt.nativesystem.NativeResult;

public class TransferResult
extends NativeResult {
    private final int m_sourceNodeID;
    private final int m_targetNodeID;
    private TransferStatus m_transferStatus;
    private final List<String> m_generalErrors;
    private final SortedMap<String, String> m_dirErrors;
    private final SortedMap<String, String> m_fileErrors;
    private final SortedMap<String, String> m_symlinkErrors;

    protected TransferResult(int sourceNodeID, int targetNodeID, TransferStatus transferStatus) {
        this.m_sourceNodeID = sourceNodeID;
        this.m_targetNodeID = targetNodeID;
        this.m_transferStatus = transferStatus;
        this.m_generalErrors = new LinkedList<String>();
        this.m_dirErrors = new TreeMap<String, String>();
        this.m_fileErrors = new TreeMap<String, String>();
        this.m_symlinkErrors = new TreeMap<String, String>();
        this.m_status = this.m_transferStatus == TransferStatus.SUCCESS;
        this.m_OSString = new String[0];
    }

    public String toString() {
        int counter;
        StringBuilder strRepresentation = new StringBuilder();
        strRepresentation.append("Source node ID : " + this.m_sourceNodeID + MultiTierTransferConstants.NEW_LINE);
        strRepresentation.append("Target node ID : " + this.m_targetNodeID + MultiTierTransferConstants.NEW_LINE);
        strRepresentation.append("Transfer status: " + this.m_transferStatus.toString() + MultiTierTransferConstants.NEW_LINE);
        if (this.m_generalErrors != null && !this.m_generalErrors.isEmpty()) {
            strRepresentation.append("General Errors: " + MultiTierTransferConstants.NEW_LINE);
            counter = 1;
            for (String error : this.m_generalErrors) {
                strRepresentation.append(counter + ") " + error + MultiTierTransferConstants.NEW_LINE);
                ++counter;
            }
        }
        if (this.m_dirErrors != null && !this.m_dirErrors.isEmpty()) {
            strRepresentation.append("Directory Errors: " + MultiTierTransferConstants.NEW_LINE);
            counter = 1;
            Set<String> dirPathnames = this.m_dirErrors.keySet();
            for (String dirPathname : dirPathnames) {
                strRepresentation.append(counter + ") " + dirPathname + ':' + (String)this.m_dirErrors.get(dirPathname) + MultiTierTransferConstants.NEW_LINE);
                ++counter;
            }
        }
        if (this.m_fileErrors != null && !this.m_fileErrors.isEmpty()) {
            strRepresentation.append("File Errors: " + MultiTierTransferConstants.NEW_LINE);
            counter = 1;
            Set<String> filePathnames = this.m_fileErrors.keySet();
            for (String filePathname : filePathnames) {
                strRepresentation.append(counter + ") " + filePathname + ':' + (String)this.m_fileErrors.get(filePathname) + MultiTierTransferConstants.NEW_LINE);
                ++counter;
            }
        }
        if (this.m_symlinkErrors != null && !this.m_symlinkErrors.isEmpty()) {
            strRepresentation.append("Symlink Errors: " + MultiTierTransferConstants.NEW_LINE);
            counter = 1;
            Set<String> symlinkPathnames = this.m_symlinkErrors.keySet();
            for (String symlinkPath : symlinkPathnames) {
                strRepresentation.append(counter + ") " + symlinkPath + ':' + (String)this.m_symlinkErrors.get(symlinkPath) + MultiTierTransferConstants.NEW_LINE);
            }
        }
        return strRepresentation.toString();
    }

    protected void addGeneralError(String errorMsg) {
        this.m_generalErrors.add(errorMsg);
        this.updateOSString();
    }

    protected void addDirError(String dirPathname, String errorMsg) {
        this.m_dirErrors.put(dirPathname, errorMsg);
        this.updateOSString();
    }

    protected void addFileError(String filePathname, String errorMsg) {
        this.m_fileErrors.put(filePathname, errorMsg);
        this.updateOSString();
    }

    protected void addSymlinkError(String symlinkPathname, String errorMsg) {
        this.m_symlinkErrors.put(symlinkPathname, errorMsg);
        this.updateOSString();
    }

    protected void setTransferStatus(TransferStatus transferStatus) {
        this.m_transferStatus = transferStatus;
    }

    protected int getSourceNodeID() {
        return this.m_sourceNodeID;
    }

    protected int getTargetNodeID() {
        return this.m_targetNodeID;
    }

    protected TransferStatus getTransferStatus() {
        return this.m_transferStatus;
    }

    protected List<String> getGeneralErrors() {
        return this.m_generalErrors;
    }

    protected SortedMap<String, String> getDirErrors() {
        return this.m_dirErrors;
    }

    protected SortedMap<String, String> getFileErrors() {
        return this.m_fileErrors;
    }

    protected SortedMap<String, String> getSymlinkErrors() {
        return this.m_symlinkErrors;
    }

    private void updateOSString() {
        String[] stringArray;
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.m_generalErrors.isEmpty()) {
            errors.add("General Errors: ");
            errors.addAll(this.m_generalErrors);
        }
        if (!this.m_dirErrors.isEmpty()) {
            errors.add("Directory Errors: ");
            Set<String> dirPathnames = this.m_dirErrors.keySet();
            for (String dirPathname : dirPathnames) {
                errors.add(dirPathname + ':' + (String)this.m_dirErrors.get(dirPathname));
            }
        }
        if (!this.m_fileErrors.isEmpty()) {
            errors.add("File Errors: ");
            Set<String> filePathnames = this.m_fileErrors.keySet();
            for (String filePathname : filePathnames) {
                errors.add(filePathname + ':' + (String)this.m_fileErrors.get(filePathname));
            }
        }
        if (!this.m_symlinkErrors.isEmpty()) {
            errors.add("Symlink Errors: ");
            Set<String> symlinkPathnames = this.m_symlinkErrors.keySet();
            for (String symlinkPath : symlinkPathnames) {
                errors.add(symlinkPath + ':' + (String)this.m_symlinkErrors.get(symlinkPath));
            }
        }
        if (this.m_transferStatus == TransferStatus.TIMEOUT) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = TransferStatus.TIMEOUT.toString();
        } else {
            stringArray = errors.toArray(new String[0]);
        }
        this.m_OSString = stringArray;
    }

    public static enum TransferStatus {
        SUCCESS(0, "SUCCESS"),
        CRITICAL_FAILURE(1, "CRITICAL FAILURE"),
        FAILURE(2, "FAILURE"),
        WARNING(3, "WARNING"),
        TIMEOUT(4, "TIMEOUT");

        private static final Map<Integer, TransferStatus> lookup;
        private final int m_code;
        private final String m_strRepresentation;

        private TransferStatus(int code, String strRepresentation) {
            this.m_code = code;
            this.m_strRepresentation = strRepresentation;
        }

        public int getCode() {
            return this.m_code;
        }

        public String toString() {
            return this.m_strRepresentation;
        }

        protected static TransferStatus getTransferStatus(int code) {
            return lookup.get(code);
        }

        static {
            lookup = new HashMap<Integer, TransferStatus>();
            for (TransferStatus transferStatus : TransferStatus.values()) {
                lookup.put(transferStatus.m_code, transferStatus);
            }
        }
    }
}

