/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.FileHandler;
import oracle.cluster.deployment.ractrans.IllegalArgException;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.TransferNode;
import oracle.cluster.deployment.ractrans.TransferOptimizer;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.command.file.CopyCommand;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class TransferPlanner {
    private final String m_mttransID;
    private final String m_mttransTimestamp;
    private int m_numOfTransferThreadsPerNode;
    private List<TransferNode>[] m_hierarchyTree;

    protected TransferPlanner(String mttransID) {
        this.m_mttransID = mttransID;
        this.m_mttransTimestamp = this.generateTimestamp();
    }

    protected void createPlan(String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String javaNodeName, String[] nodeNames, String[] nodeDestDirPathnames, String transferBinaryPathname, int portNumber, SortedMap<Integer, String> nodeNameLookupMap) throws IllegalArgException, RACTransErrorException {
        this.createDataPlan(topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex);
        this.createNodePlan(topLevelDir, javaNodeName, nodeNames, nodeDestDirPathnames, portNumber, nodeNameLookupMap);
        this.copyTransferBinary(transferBinaryPathname);
    }

    protected void cleanup() {
        String planDirPathname = this.getPlanDirPathname();
        if (MultiTierTransferConstants.DEBUG_MODE) {
            Trace.out("The plan directory is not deleted for debugging.Plan directory location:" + planDirPathname);
            return;
        }
        if (planDirPathname != null) {
            if (this.removeDir(new File(planDirPathname))) {
                Trace.out("Successfully removed temporary directory \"" + planDirPathname + "\" and all its contents");
            } else {
                Trace.out("Temporary directory \"" + planDirPathname + "\" is not completely removed");
            }
        }
    }

    protected List<TransferNode>[] constructNodeHierarchy(String topLevelDir, String javaNodeName, String[] nodeNames, String[] nodeDestDirPathnames, int branchingFactor, SortedMap<Integer, String> nodeNameLookupMap) throws IllegalArgException {
        int numOfNodes = nodeNames.length;
        HashMap<Integer, String> nodeDestDirLookupMap = new HashMap<Integer, String>();
        this.initNodeLookupMaps(javaNodeName, nodeNames, nodeDestDirPathnames, nodeNameLookupMap, nodeDestDirLookupMap);
        ArrayList hierarchyTree = new ArrayList();
        int currIndex = nodeNameLookupMap.firstKey();
        int lastIndex = nodeNameLookupMap.lastKey();
        boolean isLeafNode = false;
        LinkedList<Integer> currLevelNodeIDs = new LinkedList<Integer>();
        currLevelNodeIDs.add(0);
        LinkedList<Integer> allChildNodeIDs = new LinkedList<Integer>();
        while (!isLeafNode) {
            allChildNodeIDs = new LinkedList();
            LinkedList<TransferNode> nodesInCurrLevel = new LinkedList<TransferNode>();
            for (Integer nodeID : currLevelNodeIDs) {
                LinkedList<Integer> childNodeIDs = null;
                if (!isLeafNode) {
                    childNodeIDs = new LinkedList<Integer>();
                    for (int i = 0; i < branchingFactor; ++i) {
                        if (currIndex > lastIndex) {
                            isLeafNode = true;
                            break;
                        }
                        if (currIndex != 0) {
                            childNodeIDs.add(currIndex);
                            allChildNodeIDs.add(currIndex);
                        }
                        ++currIndex;
                    }
                    if (branchingFactor == 1 && nodeNameLookupMap.containsKey(0) && nodeID == 0 && numOfNodes > 1) {
                        childNodeIDs.add(currIndex);
                        allChildNodeIDs.add(currIndex);
                        ++currIndex;
                    }
                }
                String nodeName = (String)nodeNameLookupMap.get(nodeID);
                String nodeDestDir = (String)nodeDestDirLookupMap.get(nodeID);
                if (nodeID == 0 && nodeName == null) {
                    nodeName = javaNodeName;
                    nodeDestDir = "";
                }
                TransferNode transferNode = new TransferNode(nodeID, nodeName, topLevelDir, nodeDestDir, childNodeIDs);
                nodesInCurrLevel.add(transferNode);
            }
            int numOfTransferNodes = nodesInCurrLevel.size();
            if (isLeafNode && numOfTransferNodes > 1 && allChildNodeIDs.size() > 0) {
                int numOfLeafNodes = allChildNodeIDs.size();
                int leafNodesPerTransferNode = numOfLeafNodes / numOfTransferNodes;
                int tansferNodesWithOneMoreLeafNode = numOfLeafNodes % numOfTransferNodes;
                Iterator allChildNodeIDsItr = allChildNodeIDs.iterator();
                LinkedList<TransferNode> nodesInLevelBeforeBottomLevel = new LinkedList<TransferNode>();
                for (TransferNode currTranferNode : nodesInCurrLevel) {
                    int mumOfLeafNodes = leafNodesPerTransferNode;
                    if (tansferNodesWithOneMoreLeafNode > 0) {
                        ++mumOfLeafNodes;
                        --tansferNodesWithOneMoreLeafNode;
                    }
                    LinkedList<Integer> leafNodeIDs = new LinkedList<Integer>();
                    for (int i = 0; i < mumOfLeafNodes; ++i) {
                        leafNodeIDs.add((Integer)allChildNodeIDsItr.next());
                    }
                    TransferNode nodeInLevelBeforeBottomLevel = new TransferNode(currTranferNode.getID(), currTranferNode.getName(), topLevelDir, currTranferNode.getDestDir(), leafNodeIDs);
                    nodesInLevelBeforeBottomLevel.add(nodeInLevelBeforeBottomLevel);
                }
                hierarchyTree.add(nodesInLevelBeforeBottomLevel);
            } else {
                hierarchyTree.add(nodesInCurrLevel);
            }
            if (!(currLevelNodeIDs = allChildNodeIDs).isEmpty()) continue;
            break;
        }
        LinkedList<TransferNode> nodesInLastLevel = new LinkedList<TransferNode>();
        for (Integer nodeID : allChildNodeIDs) {
            nodesInLastLevel.add(new TransferNode(nodeID, (String)nodeNameLookupMap.get(nodeID), topLevelDir, (String)nodeDestDirLookupMap.get(nodeID), null));
        }
        if (!nodesInLastLevel.isEmpty()) {
            hierarchyTree.add(nodesInLastLevel);
        }
        return hierarchyTree.toArray(new List[0]);
    }

    protected String getPlanDirPathname() {
        return MultiTierTransferConstants.getTempDir() + File.separator + "mttrans" + '_' + this.m_mttransID + '_' + 0;
    }

    protected Map<String, String> getLogFilePathnames(Set<Integer> nodeIDs) {
        HashMap<String, String> logFilePathnames = new HashMap<String, String>();
        if (nodeIDs == null || nodeIDs.isEmpty()) {
            return logFilePathnames;
        }
        for (List<TransferNode> nodesInCurrLevel : this.m_hierarchyTree) {
            for (TransferNode nodeInCurrLevel : nodesInCurrLevel) {
                boolean isParentNodeOfInterest;
                String nodeName = nodeInCurrLevel.getName();
                int nodeID = nodeInCurrLevel.getID();
                if (nodeIDs.contains(nodeID)) {
                    logFilePathnames.put(nodeName, this.getLogFilePathname(nodeName, nodeID));
                    Trace.out("Node that failed: " + nodeName);
                    continue;
                }
                List<Integer> currChildNodeIDs = nodeInCurrLevel.getChildNodeIDs();
                if (currChildNodeIDs == null) {
                    isParentNodeOfInterest = false;
                } else {
                    boolean bl = isParentNodeOfInterest = !Collections.disjoint(currChildNodeIDs, nodeIDs);
                }
                if (!isParentNodeOfInterest) continue;
                logFilePathnames.put(nodeName, this.getLogFilePathname(nodeName, nodeID));
                Trace.out("Parent of node that failed: " + nodeName);
            }
        }
        return logFilePathnames;
    }

    protected Integer getParentNodeID(int receiverNodeID) {
        if (receiverNodeID < 0) {
            return null;
        }
        if (receiverNodeID == 0) {
            return 0;
        }
        for (List<TransferNode> nodesInCurrLevel : this.m_hierarchyTree) {
            for (TransferNode nodeInCurrLevel : nodesInCurrLevel) {
                List<Integer> currChildNodeIDs = nodeInCurrLevel.getChildNodeIDs();
                if (currChildNodeIDs == null || !currChildNodeIDs.contains(receiverNodeID)) continue;
                return nodeInCurrLevel.getID();
            }
        }
        return null;
    }

    private void initNodeLookupMaps(String javaNodeName, String[] nodeNames, String[] nodeDestDirPathnames, SortedMap<Integer, String> nodeNameLookupMap, Map<Integer, String> nodeDestDirLookupMap) {
        int i;
        int numOfNodes = nodeNames.length;
        int javaNodeIndex = -1;
        if (!MultiTierTransferConstants.JAVA_NODE_NOT_DEST_NODE) {
            for (i = 0; i < numOfNodes; ++i) {
                if (!nodeNames[i].equalsIgnoreCase(javaNodeName)) continue;
                javaNodeIndex = i;
                break;
            }
        }
        if (javaNodeIndex == -1) {
            for (i = 0; i < numOfNodes; ++i) {
                nodeNameLookupMap.put(i + 1, nodeNames[i]);
                nodeDestDirLookupMap.put(i + 1, nodeDestDirPathnames[i]);
            }
        } else {
            nodeNameLookupMap.put(0, nodeNames[javaNodeIndex]);
            nodeDestDirLookupMap.put(0, nodeDestDirPathnames[javaNodeIndex]);
            for (i = 1; i < numOfNodes; ++i) {
                if (i == javaNodeIndex) {
                    nodeNameLookupMap.put(javaNodeIndex, nodeNames[0]);
                    nodeDestDirLookupMap.put(javaNodeIndex, nodeDestDirPathnames[0]);
                    continue;
                }
                nodeNameLookupMap.put(i, nodeNames[i]);
                nodeDestDirLookupMap.put(i, nodeDestDirPathnames[i]);
            }
        }
    }

    private void createDataPlan(String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex) throws RACTransErrorException {
        boolean planDirCreatedSuccessfully;
        String planDirPathname = this.getPlanDirPathname();
        File planDir = new File(planDirPathname);
        try {
            planDirCreatedSuccessfully = planDir.mkdir();
        }
        catch (SecurityException se) {
            planDirCreatedSuccessfully = false;
            Trace.out("SecurityException while creating the plan directory. Details:" + MultiTierTransferConstants.NEW_LINE + se.getMessage());
        }
        if (!planDirCreatedSuccessfully) {
            this.reportDirPermissionsAndOwner(planDirPathname, true);
            throw new RACTransErrorException((MessageKey)PrCfMsgID.DIR_CREATE_ERROR, true, planDirPathname);
        }
        TransferOptimizer transferOptimizer = new TransferOptimizer(topLevelDir, excludeListFile, excludePathnamesCanBeRegex, includeListFile, includePathnamesCanBeRegex, false);
        this.m_numOfTransferThreadsPerNode = transferOptimizer.createDataPlanFiles(planDirPathname, true);
    }

    private void reportDirPermissionsAndOwner(String dirPathname, boolean isRecursive) {
        if (dirPathname == null) {
            return;
        }
        try {
            FileDescriptor dir = new FileDescriptor(dirPathname);
            Trace.out("Directory \"" + dirPathname + "\" has owner ID=" + dir.getOwnerID() + " and permissions=" + dir.getPermissions());
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("Directory \"" + dirPathname + "\" does not exist");
        }
        catch (RACTransErrorException ree) {
            Trace.out("Error calling the FileDescriptor constructor for \"" + dirPathname + "\". Details:" + MultiTierTransferConstants.NEW_LINE + ree.getMessage());
        }
        if (isRecursive) {
            String parentDirPathname = new File(dirPathname).getParent();
            this.reportDirPermissionsAndOwner(parentDirPathname, true);
        }
    }

    private void createNodePlan(String topLevelDir, String javaNodeName, String[] nodeNames, String[] nodeDestDirPathnames, int portNumber, SortedMap<Integer, String> nodeNameLookupMap) throws IllegalArgException, RACTransErrorException {
        ArrayList<String> nodePlanFileContents = new ArrayList<String>();
        nodePlanFileContents.add(MultiTierTransferConstants.NODE_PLAN_FILE_KEYNOTE);
        nodePlanFileContents.add(MultiTierTransferConstants.NEW_LINE);
        nodePlanFileContents.add("RESULT_LISTENER_HOST=" + javaNodeName + MultiTierTransferConstants.NEW_LINE);
        nodePlanFileContents.add("RESULT_LISTENER_PORT=" + portNumber + MultiTierTransferConstants.NEW_LINE);
        nodePlanFileContents.add("THREADS_PER_TRANSFER=" + this.getNumOfTransferThreadsPerNode() + MultiTierTransferConstants.NEW_LINE);
        nodePlanFileContents.add("MTTRANS_ID=" + this.m_mttransID + MultiTierTransferConstants.NEW_LINE);
        int debugLevel = this.getLogLevel();
        nodePlanFileContents.add("LOG_LEVEL=" + debugLevel + MultiTierTransferConstants.NEW_LINE);
        nodePlanFileContents.add("LOG_FILE_NAME=" + this.getLogFileName() + MultiTierTransferConstants.NEW_LINE);
        nodePlanFileContents.add("LOG_FILE_PATH=" + this.getLogFilePath() + MultiTierTransferConstants.NEW_LINE);
        if (MultiTierTransferConstants.DEBUG_MODE) {
            nodePlanFileContents.add("SRVM_MTTRANS_DEBUG=1" + MultiTierTransferConstants.NEW_LINE);
        } else {
            nodePlanFileContents.add("SRVM_MTTRANS_DEBUG=0" + MultiTierTransferConstants.NEW_LINE);
        }
        int branchingFactor = this.getBranchingFactor();
        this.m_hierarchyTree = this.constructNodeHierarchy(topLevelDir, javaNodeName, nodeNames, nodeDestDirPathnames, branchingFactor, nodeNameLookupMap);
        for (int level = 0; level < this.m_hierarchyTree.length; ++level) {
            List<TransferNode> nodes = this.m_hierarchyTree[level];
            for (TransferNode node : nodes) {
                nodePlanFileContents.add("NODE_ID=" + node.getID() + MultiTierTransferConstants.NEW_LINE);
                nodePlanFileContents.add("NODE_NAME=" + node.getName().toLowerCase() + MultiTierTransferConstants.NEW_LINE);
                String sourceDir = node.getSourceDir();
                if (sourceDir != null) {
                    nodePlanFileContents.add("NODE_SOURCE=" + sourceDir + MultiTierTransferConstants.NEW_LINE);
                } else {
                    nodePlanFileContents.add("NODE_SOURCE=" + MultiTierTransferConstants.NEW_LINE);
                }
                String destDir = node.getDestDir();
                if (destDir != null) {
                    nodePlanFileContents.add("NODE_DESTINATION=" + destDir + MultiTierTransferConstants.NEW_LINE);
                } else {
                    nodePlanFileContents.add("NODE_DESTINATION=" + MultiTierTransferConstants.NEW_LINE);
                }
                List<Integer> childNodeIDs = node.getChildNodeIDs();
                if (childNodeIDs != null) {
                    StringBuilder childNodes = new StringBuilder();
                    Iterator<Integer> childNodeNamesItr = childNodeIDs.iterator();
                    while (childNodeNamesItr.hasNext()) {
                        childNodes.append(childNodeNamesItr.next());
                        if (!childNodeNamesItr.hasNext()) continue;
                        childNodes.append(",");
                    }
                    nodePlanFileContents.add("CHILD_NODES=" + childNodes + MultiTierTransferConstants.NEW_LINE);
                    continue;
                }
                nodePlanFileContents.add("CHILD_NODES=" + MultiTierTransferConstants.NEW_LINE);
            }
        }
        String nodePlanPathname = this.getNodePlanPathName();
        Trace.out("Creating file " + nodePlanPathname);
        StringBuilder nodePlanContent = new StringBuilder();
        for (String nodePlanLine : nodePlanFileContents) {
            nodePlanContent.append(nodePlanLine);
        }
        Trace.out("Node-plan:" + MultiTierTransferConstants.NEW_LINE + nodePlanContent.toString());
        FileHandler.writeFile(nodePlanPathname, nodePlanFileContents, false);
    }

    private boolean removeDir(File dir) {
        File[] dirContents;
        try {
            if (!dir.exists()) {
                return true;
            }
            if (!dir.isDirectory()) {
                return true;
            }
        }
        catch (SecurityException se) {
            Trace.out("The security manager denied read access to directory \"" + dir.getPath() + "\" Details: " + se.getMessage());
            return false;
        }
        boolean allContentsRemoved = true;
        for (File dirContent : dirContents = dir.listFiles()) {
            try {
                if (dirContent.isDirectory()) {
                    this.removeDir(dirContent);
                    continue;
                }
                if (dirContent.delete()) continue;
                Trace.out("Failed to remove \"" + dirContent.getPath() + "\"");
                allContentsRemoved = false;
            }
            catch (SecurityException se) {
                Trace.out("The security manager denied access to \"" + dirContent.getPath() + "\" Details: " + se.getMessage());
                allContentsRemoved = false;
            }
        }
        try {
            if (dir.listFiles().length == 0 && !dir.delete()) {
                allContentsRemoved = false;
            }
        }
        catch (SecurityException se) {
            Trace.out("The security manager denied access to directory \"" + dir.getPath() + "\" Details: " + se.getMessage());
            allContentsRemoved = false;
        }
        return allContentsRemoved;
    }

    private void copyTransferBinary(String transferBinaryPathname) throws RACTransErrorException {
        String planDirPathname = this.getPlanDirPathname();
        File transferBinary = new File(transferBinaryPathname);
        String destDirPathname = planDirPathname + File.separator + "bin";
        try {
            new File(destDirPathname).mkdir();
        }
        catch (SecurityException se) {
            Trace.out("No permission to create directory \"" + destDirPathname + "\"");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.DIR_CREATE_ERROR, true, destDirPathname);
        }
        String destPathname = destDirPathname + File.separator + transferBinary.getName();
        CopyCommand copyCmd = new CopyCommand(transferBinary.getParent(), destDirPathname, transferBinary.getName(), false);
        if (!copyCmd.execute()) {
            Trace.out("Failed to copy mttrans binary (" + transferBinaryPathname + ") to plan directory (" + destPathname + ")");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_COPY_ERROR, true, transferBinaryPathname, destPathname);
        }
        Trace.out("Successfully copied mttrans binary (" + transferBinaryPathname + ") to plan directory (" + destPathname + ")");
    }

    private String getLogFilePathname(String nodeName, int nodeID) {
        String logFilePathname = this.getLogFilePath() + this.getLogFileName();
        return logFilePathname.replace("<NODENAME>", nodeName + '_' + nodeID);
    }

    private String getNodePlanPathName() {
        return this.getPlanDirPathname() + File.separator + "mttnode" + ".plan";
    }

    private String getLogFilePath() {
        return MultiTierTransferConstants.getTempDir() + File.separator + this.m_mttransID + "_trace" + File.separator;
    }

    private String getLogFileName() {
        return "mttrans_<NODENAME>_" + this.m_mttransTimestamp + ".log";
    }

    private String generateTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd_MM_yyyy_hh_mm_ss");
        Date currDate = new Date();
        String timestamp = dateFormat.format(currDate);
        return timestamp;
    }

    private int getNumOfTransferThreadsPerNode() {
        return this.m_numOfTransferThreadsPerNode;
    }

    private int getBranchingFactor() {
        int numOfTransferThreadsPerNode = this.getNumOfTransferThreadsPerNode();
        int branchingFactor = 32 / numOfTransferThreadsPerNode;
        return branchingFactor;
    }

    private int getLogLevel() {
        int logLevel = MultiTierTransferConstants.DEFAULT_LOG_LEVEL.getValue();
        if (System.getenv("SRVM_LOG_LEVEL") != null) {
            String envVarLogLevelStr = System.getenv("SRVM_LOG_LEVEL");
            try {
                int envVarLogLevel = Integer.valueOf(envVarLogLevelStr);
                if (!MultiTierTransferConstants.LogLevel.isValid(envVarLogLevel)) {
                    Trace.out("Environment variable SRVM_LOG_LEVEL=" + envVarLogLevelStr + " is out of range. " + "Using the default debug level instead (" + logLevel + ")");
                } else {
                    logLevel = envVarLogLevel;
                }
            }
            catch (NumberFormatException nfe) {
                Trace.out("Environment variable SRVM_LOG_LEVEL=" + envVarLogLevelStr + " which is not an " + "integer value. Using the default debug level (" + logLevel + ")");
            }
        }
        return logLevel;
    }
}

