/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import oracle.cluster.deployment.ractrans.MultiTierTransfer;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.cluster.deployment.ractrans.NodeStatusUpdate;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.ReportParseException;
import oracle.cluster.deployment.ractrans.ReportReader;
import oracle.cluster.deployment.ractrans.TransferResult;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ReportCollector {
    private final ServerSocket m_serverSocket;
    private final Thread m_listenerThread;
    private boolean m_socketIsClosedIntentionally;

    protected ReportCollector(MultiTierTransfer multiTierTransfer) throws RACTransErrorException {
        this(multiTierTransfer, multiTierTransfer.getReportReader());
        this.m_socketIsClosedIntentionally = false;
    }

    protected ReportCollector(final MultiTierTransfer multiTierTransfer, final ReportReader reportReader) throws RACTransErrorException {
        try {
            this.m_serverSocket = new ServerSocket(0);
        }
        catch (IOException ioe) {
            Trace.out("I/O error while opening the server socket on the Jave-node to allow the sender-nodes send their reports. Details:" + MultiTierTransferConstants.NEW_LINE + ioe.getMessage());
            throw new RACTransErrorException((MessageKey)PrCfMsgID.CANNOT_OPEN_SOCKET, ioe.getMessage());
        }
        this.m_listenerThread = new Thread(){

            @Override
            public void run() {
                ExecutorService threadPool = Executors.newCachedThreadPool();
                while (!this.isInterrupted()) {
                    try {
                        Socket socket = ReportCollector.this.m_serverSocket.accept();
                        threadPool.execute(new ConnectionRunnable(socket, multiTierTransfer, reportReader));
                    }
                    catch (IOException ioe) {
                        if (ReportCollector.this.m_socketIsClosedIntentionally) continue;
                        Trace.out("I/O error while waiting for a connection. Details: " + MultiTierTransferConstants.NEW_LINE + ioe.getMessage());
                        throw new RuntimeException(ioe);
                    }
                }
                threadPool.shutdownNow();
            }
        };
    }

    protected void startConnectionListener() {
        this.m_listenerThread.start();
    }

    protected void stopConnectionListener() {
        this.closeSocket();
        this.m_listenerThread.interrupt();
    }

    protected void closeSocket() {
        this.m_socketIsClosedIntentionally = true;
        try {
            this.m_serverSocket.close();
            if (this.m_serverSocket.isClosed()) {
                Trace.out("The server socket is successfully closed");
            }
        }
        catch (IOException ioe) {
            Trace.out("Error closing the socket. Details:" + MultiTierTransferConstants.NEW_LINE + ioe.getMessage());
        }
    }

    protected int getListenerPort() {
        return this.m_serverSocket.getLocalPort();
    }

    private static class ConnectionRunnable
    implements Runnable {
        private final Socket m_socket;
        private final MultiTierTransfer m_multiTierTransfer;
        private final ReportReader m_reportReader;

        private ConnectionRunnable(Socket socket, MultiTierTransfer multiTierTransfer, ReportReader reportReader) {
            this.m_socket = socket;
            this.m_multiTierTransfer = multiTierTransfer;
            this.m_reportReader = reportReader;
        }

        @Override
        public void run() {
            Object report;
            InputStream inStream;
            try {
                inStream = this.m_socket.getInputStream();
            }
            catch (IOException ioe) {
                String errorMsg = "I/O error when creating the input stream: " + ioe.getMessage();
                this.m_multiTierTransfer.reportAbrnormalError(errorMsg);
                return;
            }
            try {
                report = this.m_reportReader.readStream(inStream);
            }
            catch (ReportParseException rpe) {
                String errorMessage = rpe.getMessage();
                Trace.out("Error parsing the input stream. Details:" + MultiTierTransferConstants.NEW_LINE + errorMessage);
                this.m_multiTierTransfer.reportAbrnormalError(rpe.getMessage());
                report = null;
            }
            if (report != null) {
                if (report instanceof TransferResult) {
                    TransferResult transferResult = (TransferResult)report;
                    Trace.out("Received transfer result. Details:" + MultiTierTransferConstants.NEW_LINE + "------------------------------------------------" + MultiTierTransferConstants.NEW_LINE + transferResult.toString() + MultiTierTransferConstants.NEW_LINE + "------------------------------------------------");
                    this.m_multiTierTransfer.addTransferResult(transferResult);
                } else if (report instanceof NodeStatusUpdate) {
                    NodeStatusUpdate nodeStateUpdate = (NodeStatusUpdate)report;
                    Integer targetNodeID = nodeStateUpdate.getTargetNodeID();
                    NodeStatusUpdate.NodeState nodeState = nodeStateUpdate.getNodeState();
                    NodeStatusUpdate.UpdateType updateType = nodeStateUpdate.getUpdateType();
                    switch (updateType) {
                        case STATE: {
                            Trace.out("Received node state update. Details:" + MultiTierTransferConstants.NEW_LINE + nodeStateUpdate.toString());
                            this.m_multiTierTransfer.updateNodeState(targetNodeID, nodeState);
                            break;
                        }
                        case ERROR: {
                            Trace.out("Receieved transfer error update");
                            Trace.out("Received transfer error update. Details:" + MultiTierTransferConstants.NEW_LINE + "------------------------------------------------" + MultiTierTransferConstants.NEW_LINE + nodeStateUpdate.toString() + MultiTierTransferConstants.NEW_LINE + "------------------------------------------------");
                            Integer srcNodeID = nodeStateUpdate.getSourceNodeID();
                            String errorMsg = nodeStateUpdate.getErrors().get(0);
                            NodeStatusUpdate.ErrorType errorType = nodeStateUpdate.getErrorType();
                            String pathname = nodeStateUpdate.getErrorRelatedPathname();
                            TransferResult.TransferStatus criticality = nodeStateUpdate.getErrorCriticalities().get(0);
                            if (criticality != TransferResult.TransferStatus.FAILURE && criticality != TransferResult.TransferStatus.CRITICAL_FAILURE) break;
                            this.m_multiTierTransfer.updateTransferErrors(srcNodeID, targetNodeID, errorMsg, errorType, pathname, criticality);
                            break;
                        }
                    }
                }
            }
        }
    }
}

