/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.concurrency.ParallelCommandFactory;
import oracle.cluster.deployment.ractrans.DirListing;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.FileHandler;
import oracle.cluster.deployment.ractrans.IllegalArgException;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.RACTransfer;
import oracle.cluster.deployment.ractrans.RapidTransferConstants;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.deployment.ractrans.TransferOptimizer;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.transfer.RapidTransferCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class RapidTransfer {
    protected static Semaphore s_runRapidTransfer = new Semaphore(1);
    private static MessageBundle s_msgBundlePrCf = MessageBundle.getMessageBundle(PrCfMsgID.facility);
    private long m_effectiveTotalFileSize;
    private long m_progressStepInBytes;
    private long m_effectiveTotalFileSizeTransferredSoFar;
    private int m_progressStepsSoFar;
    private List m_progressListeners;

    public RapidTransfer() {
        try {
            s_runRapidTransfer.acquire();
        }
        catch (InterruptedException ie) {
            Trace.out("Unexpected exception." + RapidTransferConstants.NEW_LINE + "Details: " + ie.getMessage());
        }
        this.m_effectiveTotalFileSizeTransferredSoFar = 0L;
        this.m_progressStepsSoFar = 0;
        this.m_progressListeners = new ArrayList();
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs) throws RemoteFileOpException, ClusterException {
        ArrayList<ProgressListener> emptyListOfProgressListeners = new ArrayList<ProgressListener>();
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, emptyListOfProgressListeners);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, List<ProgressListener> progressListeners) throws RemoteFileOpException, ClusterException {
        this.transferDirStructureToNodesInternal(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, null, null, progressListeners);
    }

    public void transferDirStructureToNode(String oracleHome, String remoteNodeName, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String remoteNodeDestDir, RemoteUserInfo remoteUserInfo, String asUser, NodeProgressListener nodeProgressListener) throws RemoteFileOpException, ClusterException {
        this.transferDirStructureToNodes(oracleHome, new String[]{remoteNodeName}, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, new String[]{remoteNodeDestDir}, remoteUserInfo, asUser, nodeProgressListener);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, RemoteUserInfo remoteUserInfo, String asUser, NodeProgressListener nodeProgressListener) throws RemoteFileOpException, ClusterException {
        if (remoteNodeNames == null || remoteUserInfo == null || asUser == null) {
            if (remoteNodeNames == null) {
                Trace.out("Internal error: remoteNodeNames is null");
            }
            if (remoteUserInfo == null) {
                Trace.out("Internal error: remoteUserInfo is null");
            }
            if (asUser == null) {
                Trace.out("Internal error: asUser is null");
            }
            s_runRapidTransfer.release();
            String internalErrorMessage = MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "rorre1111");
            throw new ClusterException(internalErrorMessage);
        }
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            if (remoteNodeNames[i] != null) continue;
            Trace.out("Internal error: remoteNodeName[" + i + "] is null");
            s_runRapidTransfer.release();
            String internalErrorMessage = MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "rorre1112");
            throw new ClusterException(internalErrorMessage);
        }
        ArrayList<NodeProgressListener> nodeProgressListeners = new ArrayList<NodeProgressListener>(1);
        if (nodeProgressListener != null) {
            nodeProgressListeners.add(nodeProgressListener);
        }
        this.transferDirStructureToNodesInternal(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, remoteUserInfo, asUser, nodeProgressListeners);
    }

    public static long getTotalSizeInBytes(String topDirPathname, String excludeListFilePathname, boolean excludePathnamesCanBeRegex, String includeListFilePathname, boolean includePathnamesCanBeRegex) throws RACTransErrorException {
        FileDescriptor topDir;
        try {
            topDir = new FileDescriptor(topDirPathname);
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("The top-level directory \"" + topDirPathname + "\" does not exist.");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.TOP_DIR_NOT_FOUND, topDirPathname);
        }
        File excludeListFile = excludeListFilePathname == null ? null : new File(excludeListFilePathname);
        File includeListFile = includeListFilePathname == null ? null : new File(includeListFilePathname);
        boolean linkDestAreRelativePaths = false;
        DirListing dirListing = new DirListing(topDir, excludeListFile, excludePathnamesCanBeRegex, includeListFile, includePathnamesCanBeRegex, linkDestAreRelativePaths);
        List<FileDescriptor> nonReadableDirs = dirListing.getNonReadableDirs();
        List<FileDescriptor> nonReadableFiles = dirListing.getNonReadableFiles();
        if (!nonReadableDirs.isEmpty() || !nonReadableFiles.isEmpty()) {
            StringBuilder commaSeparatedListOfDirs = new StringBuilder();
            int numOfNonReadableDirs = nonReadableDirs.size();
            if (numOfNonReadableDirs > 0) {
                commaSeparatedListOfDirs.append(nonReadableDirs.get(0).getPath());
                for (int i = 1; i < numOfNonReadableDirs; ++i) {
                    commaSeparatedListOfDirs.append(", ");
                    commaSeparatedListOfDirs.append(nonReadableDirs.get(i).getPath());
                }
            }
            StringBuilder commaSeparatedListOfFiles = new StringBuilder();
            int numOfNonReadableFiles = nonReadableFiles.size();
            if (numOfNonReadableFiles > 0) {
                commaSeparatedListOfFiles.append(nonReadableFiles.get(0).getPath());
                for (int i = 1; i < numOfNonReadableFiles; ++i) {
                    commaSeparatedListOfFiles.append(", ");
                    commaSeparatedListOfFiles.append(nonReadableFiles.get(i).getPath());
                }
            }
            throw new RACTransErrorException((MessageKey)PrCfMsgID.NON_READABLE_CONTENTS, commaSeparatedListOfDirs.toString(), commaSeparatedListOfFiles.toString());
        }
        return dirListing.getTotalFilesize();
    }

    public synchronized void incrementTransferredEffectiveFileSize(long delta) {
        this.m_effectiveTotalFileSizeTransferredSoFar += delta;
        long differenceInBytes = this.m_effectiveTotalFileSizeTransferredSoFar - this.m_progressStepInBytes * (long)this.m_progressStepsSoFar;
        if (differenceInBytes >= this.m_progressStepInBytes) {
            while (differenceInBytes >= this.m_progressStepInBytes) {
                ++this.m_progressStepsSoFar;
                differenceInBytes -= this.m_progressStepInBytes;
            }
            double percent = 100.0 * (double)this.m_progressStepsSoFar / 10.0;
            String transferStatus = MessageBundle.getMessage(PrCfMsgID.PERCENT_COMPLETE, false, percent);
            this.notifyProgressListeners(transferStatus);
        }
    }

    private void transferDirStructureToNodesInternal(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, RemoteUserInfo remoteUserInfo, String asUser, List progressListeners) throws RemoteFileOpException, ClusterException {
        int numOfFiles;
        TransferOptimizer transferOptimizer;
        boolean progressStatusIsEnabled;
        RapidTransfer pointerToReportTransferredFiles;
        Trace.out("=============> RAPIDTRANS_INVOKED! <=============");
        try {
            RACTransfer.assertDir(topLevelDir);
            RACTransfer.assertRemoteNodeNames(remoteNodeNames, remoteNodeDestDirs);
            RACTransfer.assertIncludeListFile(includeListFile);
            RACTransfer.assertExcludeListFile(excludeListFile);
            RACTransfer.assertRemoteNodeDestDirs(remoteNodeDestDirs);
            if (progressListeners == null) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre013");
            }
            if (excludeListFile != null && !excludeListFile.trim().equals("") && RACTransfer.topLevelDirIsExcluded(topLevelDir, excludeListFile)) {
                s_runRapidTransfer.release();
                return;
            }
        }
        catch (IllegalArgException iae) {
            s_runRapidTransfer.release();
            throw new ClusterException(iae.getMessage(), iae);
        }
        if (!progressListeners.isEmpty()) {
            this.m_progressListeners.addAll(progressListeners);
            pointerToReportTransferredFiles = this;
            progressStatusIsEnabled = true;
        } else {
            pointerToReportTransferredFiles = null;
            progressStatusIsEnabled = false;
        }
        Trace.out("Creating tansfer plan");
        String planDirPathname = this.getPlanDirPathname();
        File planDir = new File(planDirPathname);
        planDir.mkdir();
        try {
            transferOptimizer = new TransferOptimizer(topLevelDir, excludeListFile, excludePathnamesCanBeRegex, includeListFile, includePathnamesCanBeRegex, false);
            numOfFiles = transferOptimizer.createDataPlanFiles(planDirPathname, false);
        }
        catch (RACTransErrorException error) {
            if (this.removeDir(planDir)) {
                Trace.out("Successfully removed temporary directory \"" + planDirPathname + "\" and all its contents");
            } else {
                Trace.out("Temporary directory \"" + planDirPathname + "\" is not completely removed");
            }
            s_runRapidTransfer.release();
            Trace.out("Error while creating the optimized plan for the transfer. Details:\n" + error.getMessage());
            String errorMsg = s_msgBundlePrCf.getMessage(PrCfMsgID.CREATE_PLAN_FAILED, true);
            throw new ClusterException(errorMsg, error);
        }
        int numOfRemoteNodes = remoteNodeNames.length;
        if (progressStatusIsEnabled) {
            String transferStatus = MessageBundle.getMessage(PrCfMsgID.TRANSFERRING_DATA_TO_NODES, false, numOfRemoteNodes);
            this.notifyProgressListeners(transferStatus);
        }
        this.m_effectiveTotalFileSize = transferOptimizer.getEffectiveTotalFileSize();
        this.m_progressStepInBytes = Math.round((double)numOfRemoteNodes * (double)this.m_effectiveTotalFileSize / 10.0);
        Command[] rapidTransferCommands = new RapidTransferCommand[numOfFiles];
        String rapidtransIncludeFile = planDirPathname + File.separator + "rapidtrans-include";
        try {
            RuntimeExec.updateNodeSemaphoreLookupMap(remoteNodeNames);
        }
        catch (InvalidNodeListException impossible) {
            Trace.out("Should not reach this point b/c we have already validated that the remoteNodeNames are not null");
        }
        for (int i = 0; i < rapidTransferCommands.length; ++i) {
            rapidTransferCommands[i] = new RapidTransferCommand(pointerToReportTransferredFiles, oracleHome, remoteNodeNames, topLevelDir, rapidtransIncludeFile + i, false, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, remoteUserInfo, asUser, "don't care-" + i);
        }
        System.setProperty("SRVM_PARALLEL_TRANSFER", "");
        Version version = new Version();
        try {
            Trace.out("Creating ParallelCommand instance");
            ParallelCommand parallelCommand = ParallelCommandFactory.getParallelCommand(rapidTransferCommands, version);
            Trace.out("Submitting the parallel command");
            parallelCommand.submit();
            if (progressStatusIsEnabled && this.m_progressStepsSoFar != 10) {
                String percent = "100";
                String transferStatus = MessageBundle.getMessage(PrCfMsgID.PERCENT_COMPLETE, false, percent);
                this.notifyProgressListeners(transferStatus);
            }
            this.checkForErrors((RapidTransferCommand[])rapidTransferCommands, remoteNodeNames);
            Trace.out("Transfer operation completed successfully");
        }
        catch (CompositeOperationException coe) {
            Trace.out("Transfer operation completed with errors. Details:\n" + coe.getMessage());
            int numOfNodeNames = remoteNodeNames.length;
            int rsltIndx = 0;
            NativeResult[] results = new NativeResult[numOfNodeNames];
            for (int i = 0; i < numOfNodeNames; ++i) {
                String nodeName = remoteNodeNames[i];
                try {
                    results[rsltIndx] = coe.getNativeResult(nodeName);
                    ++rsltIndx;
                    continue;
                }
                catch (NoSuchIdentifierException nsie) {
                    Trace.out("Encountered NoSuchIdentifierException exceptionwhile getting NativeResult for Node" + nodeName);
                }
            }
            String msg = MessageBundle.getMessageBundle(PrCfMsgID.facility).getMessage(PrCfMsgID.PARALLEL_TRANSFER_PARTIAL_FAILURE, true);
            throw new RemoteFileOpException(msg, results);
        }
        catch (ConcurrencyException ce) {
            Trace.out("Encountered ConcurrencyException. Details:\n" + ce.getMessage());
            throw new ClusterException(ce.getMessage(), ce);
        }
        finally {
            if (this.removeDir(planDir)) {
                Trace.out("Successfully removed temporary directory \"" + planDirPathname + "\" and all its contents");
            } else {
                Trace.out("Temporary directory \"" + planDirPathname + "\" is not completely removed");
            }
            s_runRapidTransfer.release();
            RuntimeExec.resetNodeSemaphoreLookupMap();
            System.clearProperty("SRVM_PARALLEL_TRANSFER");
        }
    }

    private void notifyProgressListeners(String transferStatus) {
        for (Object progressListener : this.m_progressListeners) {
            if (progressListener instanceof ProgressListener) {
                ((ProgressListener)progressListener).write(transferStatus);
                continue;
            }
            if (!(progressListener instanceof NodeProgressListener)) continue;
            ((NodeProgressListener)progressListener).write(transferStatus);
        }
    }

    private String getPlanDirPathname() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd--HH-mm-ss-SSS");
        Date currDate = new Date();
        String tempDir = System.getProperty("java.io.tmpdir");
        StringBuilder tempDir_strBuilder = new StringBuilder(tempDir);
        tempDir_strBuilder.append(File.separator);
        tempDir_strBuilder.append("tempOraXfer_");
        tempDir_strBuilder.append(dateFormat.format(currDate));
        return tempDir_strBuilder.toString();
    }

    protected void checkForErrors(RapidTransferCommand[] rapidTransferCommands, String[] remoteNodeNames) throws RemoteFileOpException, ClusterException {
        int numOfNodes = remoteNodeNames.length;
        HashMap nativeResultMap = new HashMap(numOfNodes);
        boolean throwClusterException = true;
        ClusterException clusterException = null;
        for (int i = 0; i < rapidTransferCommands.length; ++i) {
            if (!rapidTransferCommands[i].getStatus()) {
                String notTransferredContents;
                RemoteFileOpException remoteFileOpException = rapidTransferCommands[i].getRemoteFileOpException();
                if (remoteFileOpException != null) {
                    throwClusterException = false;
                    NativeResult[] nativeResults = remoteFileOpException.getNativeResults();
                    for (int index = 0; index < nativeResults.length; ++index) {
                        if (nativeResults[index].getStatus()) continue;
                        String nodeName = nativeResults[index].getNodeName();
                        List nativeResultList = nativeResultMap.containsKey(nodeName) ? (List)nativeResultMap.get(nodeName) : new ArrayList();
                        nativeResultList.add(nativeResults[index]);
                        nativeResultMap.put(nodeName, nativeResultList);
                    }
                    continue;
                }
                clusterException = rapidTransferCommands[i].getClusterException();
                if (clusterException == null) continue;
                String fileWithNotTransferredContents = rapidTransferCommands[i].getIncludeListFile();
                try {
                    notTransferredContents = FileHandler.readFile(fileWithNotTransferredContents);
                }
                catch (RACTransErrorException fileReadError) {
                    notTransferredContents = fileReadError.getMessage();
                }
                NativeResult result = new NativeResult();
                result.setStatus(false);
                result.setOSString(notTransferredContents);
                for (int index = 0; index < numOfNodes; ++index) {
                    String nodeName = remoteNodeNames[index];
                    result.setNodeName(nodeName);
                    List nativeResultList = nativeResultMap.containsKey(nodeName) ? (List)nativeResultMap.get(nodeName) : new ArrayList();
                    nativeResultList.add(result);
                    nativeResultMap.put(nodeName, nativeResultList);
                }
                continue;
            }
            throwClusterException = false;
        }
        if (throwClusterException) {
            throw clusterException;
        }
        if (!nativeResultMap.isEmpty()) {
            StringBuilder aggregatedErrorMsg = new StringBuilder();
            NativeResult[] results = new NativeResult[numOfNodes];
            for (int i = 0; i < numOfNodes; ++i) {
                String nodeName = remoteNodeNames[i];
                if (!nativeResultMap.containsKey(nodeName)) continue;
                List nativeResultList = (List)nativeResultMap.get(nodeName);
                NativeResult totalResult = new NativeResult();
                totalResult.setStatus(false);
                totalResult.setNodeName(nodeName);
                StringBuilder error = new StringBuilder();
                for (NativeResult result : nativeResultList) {
                    String partialError = result.getOSString();
                    if (partialError == null || partialError.length() <= 0) continue;
                    error.append(partialError);
                    error.append(RapidTransferConstants.NEW_LINE);
                }
                totalResult.setOSString(error.toString());
                results[i] = totalResult;
                aggregatedErrorMsg.append(nodeName + ':' + RapidTransferConstants.NEW_LINE + error.toString());
            }
            Trace.out("Transfer operation completed with errors");
            String msg = MessageBundle.getMessageBundle(PrCfMsgID.facility).getMessage(PrCfMsgID.COMMAND_ERROR_NOTIFICATION, true);
            msg = msg + aggregatedErrorMsg.toString();
            throw new RemoteFileOpException(msg, results);
        }
    }

    private boolean removeDir(File dir) {
        File[] dirContents;
        try {
            if (!dir.exists()) {
                return true;
            }
            if (!dir.isDirectory()) {
                return true;
            }
        }
        catch (SecurityException se) {
            Trace.out("The security manager denied read access to directory \"" + dir.getPath() + "\" Details: " + se.getMessage());
            return false;
        }
        boolean allContentsRemoved = true;
        for (File dirContent : dirContents = dir.listFiles()) {
            try {
                if (dirContent.isDirectory()) {
                    this.removeDir(dirContent);
                    continue;
                }
                if (dirContent.delete()) continue;
                Trace.out("Failed to remove \"" + dirContent.getPath() + "\"");
                allContentsRemoved = false;
            }
            catch (SecurityException se) {
                Trace.out("The security manager denied access to \"" + dirContent.getPath() + "\" Details: " + se.getMessage());
                allContentsRemoved = false;
            }
        }
        try {
            if (dir.listFiles().length == 0 && !dir.delete()) {
                allContentsRemoved = false;
            }
        }
        catch (SecurityException se) {
            Trace.out("The security manager denied access to directory \"" + dir.getPath() + "\" Details: " + se.getMessage());
            allContentsRemoved = false;
        }
        return allContentsRemoved;
    }
}

