/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.File;
import oracle.ops.mgmt.trace.Trace;

public class RACTransferConstants {
    static final String RACTRANS_BINPATH = "SRVM_RACTRANS_BINPATH";
    static final boolean VERBOSE_TRACING = Trace.isLevelEnabled(1) || System.getenv("ORA_RACTRANS_DEBUG") != null || System.getProperty("ORA_RACTRANS_DEBUG") != null;
    private static final int SIZE_IN_KB = 64;
    static final int BUFFER_SIZE = 65536;
    static final String NEW_LINE = System.getProperty("line.separator");
    static final String END_OF_FILE = null;
    static final byte NULL_BYTE = 0;
    static final int MAX_NUM_OF_SYMLINKS_TO_FOLLOW = 20;
    static final String QUALIFIED_CLASSNAME_IN_SRVM_JAR = "oracle.cluster.deployment.ractrans.RACTransfer";
    static final String RACTRANS_BIN_FILENAME = "ractrans";
    static final String BINARY_DIR_RELATIVE_TO_HOME = "srvm" + File.separator + "admin";
    static final String DATE_FORMAT_NOW = "yyyy_MM_dd--HH-mm-ss-SSS";
    static final String TEMP_DIR_NAME_WITHOUT_DATE = "tempRACTrans_";
    static final String COMMAND_IDENTIFIER_LEFT = "<";
    static final String COMMAND_IDENTIFIER_RIGHT = ">";
    static final String NAME_LENGTH_IDENTIFIER_LEFT = "<";
    static final String NAME_LENGTH_IDENTIFIER_RIGHT = ">";
    static final String LINKDEST_NAME_LENGTH_IDENTIFIER_LEFT = "<";
    static final String LINKDEST_NAME_LENGTH_IDENTIFIER_RIGHT = ">";
    static final String PERMISSION_IDENTIFIER_LEFT = "[m";
    static final String PERMISSION_IDENTIFIER_RIGHT = "]";
    static final String WRFILE_LENGTH_IDENTIFIER_LEFT = "[l";
    static final String WRFILE_LENGTH_IDENTIFIER_RIGHT = "]";
    static final String MKDIR_COMMAND = "mkdir";
    static final String MKDIR_IDENTIFIER = "<" + "mkdir".length() + ">" + "mkdir";
    static final String MKLINK_COMMAND = "mklink";
    static final String MKLINK_IDENTIFIER = "<" + "mklink".length() + ">" + "mklink";
    static final String END_OF_COMMAND_IDENTIFIER = "<0>";
    static final String END_OF_ALL_COMMANDS_IDENTIFIER = "<0><4>quit";
    static final String WRFILE_COMMAND = "wrfile";
    static final String WRFILE_IDENTIFIER = "<" + "wrfile".length() + ">" + "wrfile";
    static final String OK_MESSAGE = "OK";
    static final String REPLY_LENGTH_IDENTIFIER_LEFT = "<";
    static final String REPLY_LENGTH_IDENTIFIER_RIGHT = ">";
    static final String OK_IDENTIFIER = "<" + "OK".length() + ">" + "OK";
    static final String ERROR_MSG_FORMAT = "\"{0}\" cannot be created. --> Reason: {1}";
    static final String DEFAULT_ERROR_MSG = "unknown";
    static final char IPADDR_PORT_SEPARATOR_CHAR = ':';
    static final String SERVER_PORT_LABEL = "Server Port       : ";
    static final String SERVER_IPADDR_LABEL = "Server IP Address : ";
    static final String SERVER_HOSTNAME_LABEL = "Server Host Name  : ";
    static final String CLIENT_PORT_LABEL = "Client Port       : ";
    static final String CONNECTION_STATUS_LABEL = "Connection Status : ";
    static final String NODE_ID_LABEL = "Node ID           : ";

    static enum Connection {
        NOT_CONNECTED("Not Connected"),
        CONNECTION_ALIVE("Connected"),
        CONNECTION_LOST("Disconnected"),
        COMMAND_ERROR("Command Error"),
        SENDING_DATA("Sending Data"),
        SUCCESSFUL_TRANSFER("Successful Transfer"),
        UNSUCCESSFUL_TRANSFER("Unsuccessful Transfer");

        private String m_value;

        private Connection(String value) {
            this.m_value = value;
        }

        public String toString() {
            return this.m_value;
        }
    }

    static enum Status {
        SUCCESSFUL,
        PARTIALLY_SUCCESSFUL,
        UNSUCCESSFUL;

    }
}

