/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Semaphore;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.GETCRSHOMEUtil;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.deployment.ractrans.DirListingConstants;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.IllegalArgException;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.RACTransWarningException;
import oracle.cluster.deployment.ractrans.RACTransferConstants;
import oracle.cluster.deployment.ractrans.RACTransferCore;
import oracle.cluster.deployment.ractrans.RapidTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.ExecCommandNoUserEq;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCfMsgID;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class RACTransfer {
    protected static Semaphore s_runRACTransfer = new Semaphore(1);
    private final boolean m_singleInstanceOnly;
    private final RACTransferCore m_racTransferCore;
    private String[] m_filteredNodeNames;
    private String[] m_filteredNodeDestDir;

    public RACTransfer() {
        this(true, null);
    }

    public RACTransfer(boolean singleInstanceOnly) {
        this(singleInstanceOnly, null);
    }

    public RACTransfer(boolean singleInstanceOnly, RapidTransfer transferProgressMonitor) {
        this.m_singleInstanceOnly = singleInstanceOnly;
        if (this.m_singleInstanceOnly) {
            try {
                s_runRACTransfer.acquire();
            }
            catch (InterruptedException ie) {
                Trace.out("Unexpected exception." + RACTransferConstants.NEW_LINE + "Details: " + ie.getMessage());
            }
        }
        this.m_racTransferCore = this.m_singleInstanceOnly ? new RACTransferCore(null) : new RACTransferCore(transferProgressMonitor);
    }

    private int assertPortNumber(String portStr) throws RACTransWarningException {
        int port;
        try {
            port = Integer.valueOf(portStr);
        }
        catch (NumberFormatException nfe) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.PORT_NOT_INTEGER_NUMBER, true, portStr);
        }
        if (port < 1 || port > 65535) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.PORT_NUMBER_OUT_OF_EXPECTED_RANGE, true, port);
        }
        return port;
    }

    public void transferDirToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir) throws RemoteFileOpException, ClusterException {
        String[] remoteNodeDestDirs = new String[remoteNodeNames.length];
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            remoteNodeDestDirs[i] = topLevelDir;
        }
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, null, false, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs);
    }

    public void transferDirToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs) throws RemoteFileOpException, ClusterException {
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, null, false, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs);
    }

    public void transferListedDirsToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir) throws RemoteFileOpException, ClusterException {
        String[] remoteNodeDestDirs = new String[remoteNodeNames.length];
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            remoteNodeDestDirs[i] = topLevelDir;
        }
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs) throws RemoteFileOpException, ClusterException {
        this.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, null, null);
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, RemoteUserInfo remoteUserInfo, String asUser) throws RemoteFileOpException, ClusterException {
        Trace.out("=============> RACTRANS_INVOKED! <=============");
        try {
            RACTransfer.assertDir(topLevelDir);
            RACTransfer.assertRemoteNodeNames(remoteNodeNames, remoteNodeDestDirs);
            RACTransfer.assertIncludeListFile(includeListFile);
            RACTransfer.assertExcludeListFile(excludeListFile);
            RACTransfer.assertRemoteNodeDestDirs(remoteNodeDestDirs);
            topLevelDir = RACTransfer.getDestinationPathname(topLevelDir);
            if (excludeListFile != null && !excludeListFile.trim().equals("") && RACTransfer.topLevelDirIsExcluded(topLevelDir, excludeListFile)) {
                if (this.m_singleInstanceOnly) {
                    s_runRACTransfer.release();
                }
                return;
            }
            try {
                this.createDirListing(topLevelDir, excludeListFile, excludePathnamesCanBeRegex, includeListFile, includePathnamesCanBeRegex);
            }
            catch (RACTransWarningException warning) {
                Trace.out("The RAC Transfer encountered RACTransWarningException while creating the directory listing. Details:" + RACTransferConstants.NEW_LINE + warning.getMessage());
            }
            catch (RACTransErrorException error) {
                Trace.out("The RAC Transfer failed while creating the directory listing. Details:" + RACTransferConstants.NEW_LINE + error.getMessage());
                throw new ClusterException(error.getMessage(), error);
            }
            String binaryPathname = RACTransfer.getBinaryPathname(oracleHome, topLevelDir, "ractrans");
            this.filterNodeNames(remoteNodeNames, topLevelDir, remoteNodeDestDirs);
            remoteNodeNames = this.m_filteredNodeNames;
            remoteNodeDestDirs = this.m_filteredNodeDestDir;
            if (remoteNodeNames.length == 0) {
                Trace.out("After filtering out the local node(s) for which the source and destination file transfer location is identical there is no other node left. Therefore, no action is required (i.e., the files already exist in the destination)");
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd--HH-mm-ss-SSS");
            Date currDate = new Date();
            StringBuilder remoteNodeTempDir_strBuilder = new StringBuilder(remoteNodeTempDir);
            remoteNodeTempDir_strBuilder.append(File.separator);
            remoteNodeTempDir_strBuilder.append("tempRACTrans_");
            remoteNodeTempDir_strBuilder.append(dateFormat.format(currDate));
            int randomSequence = (int)(Math.random() * 1.0E8) % 100000;
            remoteNodeTempDir_strBuilder.append('_' + String.valueOf(randomSequence));
            remoteNodeTempDir = remoteNodeTempDir_strBuilder.toString();
            Trace.out("The ractrans binary will be copied to directory \"" + remoteNodeTempDir + "\" on all remote nodes.");
            this.copyFileToRemoteNodes(binaryPathname, remoteNodeTempDir, "ractrans", remoteNodeNames, remoteUserInfo, asUser);
            int[] remoteNodePorts = this.executeBinaryFile(remoteNodeNames, "ractrans", remoteNodeTempDir, remoteNodeDestDirs, remoteUserInfo, asUser);
            try {
                try {
                    this.m_racTransferCore.connectToRemoteNodes(remoteNodeNames, remoteNodePorts);
                }
                catch (RACTransErrorException error) {
                    Trace.out("The RAC Transfer failed while connecting to the remote nodes.");
                    throw new ClusterException(error.getMessage());
                }
                try {
                    this.m_racTransferCore.sendDummyStructureToNodes(remoteNodeDestDirs);
                }
                catch (RACTransErrorException error) {
                    Trace.out("The RAC Transfer failed while sending the directory listing structure to the renmote nodes, b/c the directory map was empty.");
                    throw new ClusterException(error.getMessage());
                }
                this.m_racTransferCore.broadcastFiles();
                Trace.out("Data sent to remote nodes");
                this.m_racTransferCore.checkForTransferErrors();
                Trace.out("Checked for errors");
            }
            catch (ClusterException ce) {
                throw ce;
            }
            catch (RemoteFileOpException rfoe) {
                throw rfoe;
            }
            finally {
                try {
                    this.cleanup(remoteNodeNames, remoteNodeTempDir, remoteUserInfo, asUser);
                    Trace.out("Done with clean-up");
                }
                catch (ClusterException ce) {
                    Trace.out("Cleanup error. Details: " + RACTransferConstants.NEW_LINE + ce.getMessage());
                }
            }
        }
        catch (IllegalArgException iae) {
            throw new ClusterException(iae.getMessage());
        }
        finally {
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
        }
        Trace.out("RACTRANS_EXIT_POINT");
    }

    protected static String getDestinationPathname(String pathname) throws IllegalArgException {
        FileDescriptor destination;
        try {
            destination = new FileDescriptor(pathname, false, false);
        }
        catch (FileNotFoundException fnfe) {
            throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre011");
        }
        catch (RACTransErrorException error) {
            throw new IllegalArgException((MessageKey)PrCfMsgID.NON_EXISTING_PATHNAME, pathname);
        }
        if (!destination.isLink()) {
            return pathname;
        }
        for (int numOfSymlinksToFollow = 20; destination.isLink() && numOfSymlinksToFollow > 0; --numOfSymlinksToFollow) {
            try {
                destination = new FileDescriptor(destination.getLinkDestination(), false, false);
                continue;
            }
            catch (FileNotFoundException fnfe) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre012");
            }
            catch (RACTransErrorException error) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.TOP_DIR_DEAD_SYMLINK, destination, destination.getLinkDestination());
            }
        }
        return destination.getPath();
    }

    protected static void assertDir(String dirPathname) throws IllegalArgException {
        if (dirPathname == null) {
            throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre003");
        }
        String destinationPathname = RACTransfer.getDestinationPathname(dirPathname);
        File dir = new File(destinationPathname);
        if (!dir.isDirectory()) {
            if (!destinationPathname.equals(dirPathname)) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.TOP_DIR_NOT_A_DIR_SYMLINK, dirPathname, destinationPathname);
            }
            throw new IllegalArgException((MessageKey)PrCfMsgID.TOP_DIR_NOT_A_DIR, destinationPathname);
        }
        if (!dir.canRead()) {
            throw new IllegalArgException((MessageKey)PrCfMsgID.NON_READABLE_DIR, destinationPathname);
        }
    }

    protected static void assertRemoteNodeNames(String[] remoteNodeNames, String[] remoteNodeDestDirs) throws IllegalArgException {
        if (remoteNodeNames == null || remoteNodeNames.length == 0 || remoteNodeDestDirs == null || remoteNodeDestDirs.length == 0) {
            throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre002");
        }
        int numOfNodes = remoteNodeNames.length;
        if (numOfNodes != remoteNodeDestDirs.length) {
            Trace.out("There are " + remoteNodeNames.length + " remote nodes, but the number " + "of the destination directories is " + remoteNodeDestDirs.length);
            throw new IllegalArgException((MessageKey)PrCfMsgID.NODE_NAME_DEST_DIR_MISMATCH, remoteNodeNames.length, remoteNodeDestDirs.length);
        }
        HashMap destDirPathnameLookup = new HashMap(numOfNodes);
        for (int i = 0; i < numOfNodes; ++i) {
            Set<String> destDirPathnames;
            if (remoteNodeNames[i] == null) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre019");
            }
            if (remoteNodeDestDirs[i] == null) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre023");
            }
            int dotIndex = remoteNodeNames[i].indexOf(46);
            String nodeName = remoteNodeNames[i].toLowerCase();
            if (dotIndex != -1) {
                nodeName = nodeName.substring(0, dotIndex);
            }
            if (destDirPathnameLookup.containsKey(nodeName)) {
                if (!MultiTierTransferConstants.DUPLICATE_NODE_NAMES_IN_TEST_MODE) {
                    throw new IllegalArgException((MessageKey)PrCfMsgID.DUPLICATE_NODENAME, remoteNodeNames[i]);
                }
                destDirPathnames = (Set)destDirPathnameLookup.get(nodeName);
                if (destDirPathnames.contains(remoteNodeDestDirs[i])) {
                    Trace.out("Detected the same destination path name (" + remoteNodeDestDirs[i] + "for more than one " + "nodes with the same node name (" + nodeName + ")");
                    throw new IllegalArgException((MessageKey)PrCfMsgID.INVALID_PATHNAME, remoteNodeDestDirs[i]);
                }
            } else {
                destDirPathnames = new HashSet(numOfNodes);
                destDirPathnameLookup.put(nodeName, destDirPathnames);
            }
            destDirPathnames.add(remoteNodeDestDirs[i]);
        }
    }

    protected static void assertIncludeListFile(String includeListFilePathname) throws IllegalArgException {
        if (includeListFilePathname != null) {
            File includeListFile = new File(includeListFilePathname);
            if (!includeListFile.exists()) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, includeListFilePathname);
            }
            if (includeListFile.isDirectory()) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.NOT_A_FILE, includeListFilePathname);
            }
        }
    }

    protected static void assertExcludeListFile(String excludeListFilePathname) throws IllegalArgException {
        if (excludeListFilePathname != null) {
            File excludeListFile = new File(excludeListFilePathname);
            if (!excludeListFile.exists()) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, excludeListFilePathname);
            }
            if (excludeListFile.isDirectory()) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.NOT_A_FILE, excludeListFilePathname);
            }
        }
    }

    protected static void assertRemoteNodeDestDirs(String[] remoteNodeDestDirs) throws IllegalArgException {
        if (remoteNodeDestDirs == null || remoteNodeDestDirs.length == 0) {
            throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre004");
        }
        for (int i = 0; i < remoteNodeDestDirs.length; ++i) {
            if (remoteNodeDestDirs[i] == null) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.INVALID_PATHNAME, remoteNodeDestDirs[i]);
            }
            if (remoteNodeDestDirs[i].trim().startsWith(DirListingConstants.ROOT_DIRECTORY.toString())) continue;
            throw new IllegalArgException((MessageKey)PrCfMsgID.INVALID_PATHNAME, remoteNodeDestDirs[i]);
        }
    }

    protected static String getBinaryPathname(String oracleHome, String topLevelDir, String binaryName) throws ClusterException {
        File binaryFile;
        String binaryDirPath = "";
        if (oracleHome != null) {
            String crsHome;
            binaryDirPath = oracleHome + File.separator + RACTransferConstants.BINARY_DIR_RELATIVE_TO_HOME;
            binaryFile = new File(binaryDirPath + File.separator + binaryName);
            if (binaryFile.exists()) {
                Trace.out("1st attempt to locate " + binaryName + " binary (" + binaryDirPath + "): successful");
                return binaryDirPath + File.separator + binaryName;
            }
            Trace.out("1st attempt to locate " + binaryName + " binary (" + binaryDirPath + "): unsuccessful");
            try {
                crsHome = new GETCRSHOMEUtil(oracleHome).getCRS_HOME();
            }
            catch (CmdToolUtilException ctue1) {
                try {
                    crsHome = new GETCRSHOMEUtil(topLevelDir).getCRS_HOME();
                }
                catch (CmdToolUtilException ctue2) {
                    crsHome = null;
                }
            }
            if (crsHome == null) {
                Trace.out("2nd attempt to locate " + binaryName + " binary : unsuccessful (unable to find CRS Home via " + "getcrshome binary)");
            } else {
                binaryDirPath = crsHome + File.separator + RACTransferConstants.BINARY_DIR_RELATIVE_TO_HOME;
                binaryFile = new File(binaryDirPath + File.separator + binaryName);
                if (binaryFile.exists()) {
                    Trace.out("2nd attempt to locate " + binaryName + " binary (" + binaryDirPath + "): successful");
                    return binaryDirPath + File.separator + binaryName;
                }
                Trace.out("2nd attempt to locate " + binaryName + " binary (" + binaryDirPath + "): unsuccessful");
            }
        } else {
            Trace.out("1st and 2nd attempts to locate " + binaryName + " binary: skipped (because oracleHome == null)");
        }
        String srvmJarPath = RACTransfer.getClassLocation("oracle.cluster.deployment.ractrans.RACTransfer");
        if (srvmJarPath == null) {
            Trace.out("3rd attempt to locate " + binaryName + " binary via " + "srvm.jar: unsuccessful (unable to locate srvm.jar)");
        } else {
            File srvmJar = new File(srvmJarPath);
            int endIndex = srvmJar.getParent().lastIndexOf(File.separator);
            if (endIndex != -1) {
                String oneLevelUp = srvmJarPath.substring(0, endIndex);
                binaryDirPath = oneLevelUp + File.separator + RACTransferConstants.BINARY_DIR_RELATIVE_TO_HOME;
                binaryFile = new File(binaryDirPath + File.separator + binaryName);
                if (binaryFile.exists()) {
                    Trace.out("3rd attempt to locate " + binaryName + " binary via srvm.jar (" + binaryDirPath + "): successful");
                    return binaryDirPath + File.separator + binaryName;
                }
                Trace.out("The transfer binary was not located under \"" + binaryDirPath + "\"");
                endIndex = oneLevelUp.lastIndexOf(File.separator);
                if (endIndex != -1) {
                    String twoLevelsUp = oneLevelUp.substring(0, endIndex);
                    binaryDirPath = twoLevelsUp + File.separator + RACTransferConstants.BINARY_DIR_RELATIVE_TO_HOME;
                    binaryFile = new File(binaryDirPath + File.separator + binaryName);
                    if (binaryFile.exists()) {
                        Trace.out("3rd attempt to locate " + binaryName + " binary via srvm.jar (" + binaryDirPath + "): successful");
                        return binaryDirPath + File.separator + binaryName;
                    }
                    Trace.out("The transfer binary was not located under \"" + binaryDirPath + "\"");
                }
            }
            Trace.out("3rd attempt to locate " + binaryName + " binary via srvm.jar (found under \"" + srvmJarPath + "\"): unsuccessful");
        }
        binaryDirPath = topLevelDir + File.separator + RACTransferConstants.BINARY_DIR_RELATIVE_TO_HOME;
        binaryFile = new File(binaryDirPath + File.separator + binaryName);
        if (binaryFile.exists()) {
            Trace.out("4th attempt to locate " + binaryName + " binary (" + binaryDirPath + "): successful");
            return binaryDirPath + File.separator + binaryName;
        }
        Trace.out("4th attempt to locate " + binaryName + " binary (" + binaryDirPath + "): unsuccessful");
        String errorMsg = MessageBundle.getMessage(PrCfMsgID.BINARY_NOT_FOUND, true, "ractrans");
        throw new ClusterException(errorMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean topLevelDirIsExcluded(String topLevelDir, String excludeListFilePathname) {
        FileReader fileReader;
        File excludeListFile = new File(excludeListFilePathname);
        try {
            fileReader = new FileReader(excludeListFile);
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("The file \"" + excludeListFile.getName() + "\" does not exist.");
            return false;
        }
        BufferedReader bufReader = new BufferedReader(fileReader);
        try {
            String curr_pathname;
            while ((curr_pathname = bufReader.readLine()) != DirListingConstants.END_OF_FILE) {
                if ((curr_pathname = curr_pathname.trim()).equals("") || !topLevelDir.startsWith(curr_pathname) && !new File(topLevelDir).getCanonicalPath().startsWith(new File(curr_pathname).getCanonicalPath())) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ioe) {
            Trace.out("An unexpected error condition was detected during reading the exclude-list or include-list file. Details: " + ioe.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufReader != null) {
                try {
                    bufReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private void filterNodeNames(String[] nodeNames, String srcDir, String[] destDir) throws ClusterException {
        String localNodeName;
        try {
            localNodeName = Utils.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out(uhe.getMessage());
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
            throw new ClusterException(uhe.getMessage());
        }
        ArrayList<String> nodeNameList = new ArrayList<String>(nodeNames.length);
        ArrayList<String> nodeDestDirList = new ArrayList<String>(destDir.length);
        for (int i = 0; i < nodeNames.length; ++i) {
            try {
                if (!this.identicalNodes(nodeNames[i], localNodeName)) {
                    nodeNameList.add(nodeNames[i]);
                    nodeDestDirList.add(destDir[i]);
                    continue;
                }
                if (destDir[i].equals(srcDir)) continue;
                nodeNameList.add(nodeNames[i]);
                nodeDestDirList.add(destDir[i]);
                continue;
            }
            catch (RACTransWarningException we) {
                Trace.out(we.getMessage());
                if (this.m_singleInstanceOnly) {
                    s_runRACTransfer.release();
                }
                throw new ClusterException(we.getMessage());
            }
        }
        if (nodeNames.length != nodeNameList.size()) {
            this.m_filteredNodeNames = nodeNameList.toArray(new String[0]);
            this.m_filteredNodeDestDir = nodeDestDirList.toArray(new String[0]);
        } else {
            this.m_filteredNodeNames = nodeNames;
            this.m_filteredNodeDestDir = destDir;
        }
    }

    private boolean identicalNodes(String nodeName1, String nodeName2) throws RACTransWarningException {
        if (nodeName1.trim().equalsIgnoreCase(nodeName2.trim())) {
            return true;
        }
        InetAddress[] inetAddressNode1 = null;
        try {
            inetAddressNode1 = InetAddress.getAllByName(nodeName1);
        }
        catch (UnknownHostException e) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.UNKNOWN_HOST, nodeName1.trim());
        }
        InetAddress[] inetAddressNode2 = null;
        try {
            inetAddressNode2 = InetAddress.getAllByName(nodeName2);
        }
        catch (UnknownHostException uhe) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.UNKNOWN_HOST, nodeName2.trim());
        }
        for (int i = 0; i < inetAddressNode1.length; ++i) {
            for (int j = 0; j < inetAddressNode2.length; ++j) {
                if (!inetAddressNode1[i].equals(inetAddressNode2[j])) continue;
                return true;
            }
        }
        return false;
    }

    private static String getClassLocation(String qualifiedClassName) {
        Class<?> qualifiedClassObject = null;
        try {
            qualifiedClassObject = Class.forName(qualifiedClassName);
        }
        catch (ClassNotFoundException cnfe) {
            Trace.out("Class \"" + qualifiedClassName + "\" was not found.");
            return null;
        }
        ProtectionDomain protectionDomain = null;
        try {
            protectionDomain = qualifiedClassObject.getProtectionDomain();
        }
        catch (SecurityException se) {
            Trace.out("The security manager of class \"" + qualifiedClassName + "\" doesn't allow getting the ProtectionDomain.");
            return null;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            Trace.out("Unknown code source for class \"" + qualifiedClassName);
            return null;
        }
        return codeSource.getLocation().getPath();
    }

    private void copyFileToRemoteNodes(String sourcePathname, String remoteNodeDestDir, String filename, String[] remoteNodeNames, RemoteUserInfo remoteUserInfo, String asUser) throws ClusterException {
        String destPathname = remoteNodeDestDir + File.separator + filename;
        if (remoteUserInfo == null) {
            try {
                ClusterCmd clusterCmd = new ClusterCmd();
                clusterCmd.createDirInNodes(remoteNodeNames, remoteNodeDestDir);
                clusterCmd.copyFileToNodes(sourcePathname, remoteNodeNames, destPathname);
            }
            catch (ClusterException ce) {
                Trace.out("Copying the ractrans to the remote nodes failed!Details: " + RACTransferConstants.NEW_LINE + ce.getStackTrace());
                if (this.m_singleInstanceOnly) {
                    s_runRACTransfer.release();
                }
                throw ce;
            }
        }
        Class[] parameterTypes = new Class[]{String[].class, String.class, String.class, RemoteUserInfo.class, Integer.class};
        Object[] argumentValues = new Object[]{remoteNodeNames, remoteNodeDestDir, asUser, remoteUserInfo, 777};
        int numOfNodes = remoteNodeNames.length;
        try {
            Map resultMap = (Map)this.invokeRemoteFactoryMethod("createDirOnNodes", parameterTypes, argumentValues);
            StringJoiner errors = new StringJoiner(RACTransferConstants.NEW_LINE);
            CommandResult[] commandResult = new CommandResult[numOfNodes];
            for (int i = 0; i < numOfNodes; ++i) {
                commandResult[i] = (CommandResult)resultMap.get(remoteNodeNames[i]);
                if (commandResult[i].getStatus()) continue;
                String errorMsg = MessageBundle.getMessage(PrCfMsgID.REMOTE_EXECUTION_ERROR, true, remoteNodeNames[i], commandResult[i].getOSString());
                Trace.out(errorMsg);
                errors.add(errorMsg);
            }
            if (errors.length() > 0) {
                throw new ClusterException(errors.toString());
            }
            Trace.out("Created successfully directory \"" + remoteNodeDestDir + "\" as user \"" + asUser + "\"");
            parameterTypes = new Class[]{String.class, String[].class, String.class, Boolean.TYPE, UserInfo.class, Integer.TYPE};
            argumentValues = new Object[]{sourcePathname, remoteNodeNames, destPathname, false, remoteUserInfo, 120};
            this.invokeRemoteFactoryMethod("copyFileToNodes", parameterTypes, argumentValues);
            Trace.out("Copied successfully \"" + sourcePathname + "\" to the remote nodes");
        }
        catch (RACTransErrorException ree) {
            Trace.out(ree.getMessage());
            String errorMsg = MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "rorre030:" + ree.getMessage());
            throw new ClusterException(errorMsg);
        }
        catch (InvocationTargetException ite) {
            String errorMessage;
            Trace.out("Error copying the ractrans binary. Details:" + RACTransferConstants.NEW_LINE + ite.getMessage());
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
            if (ite.getCause() instanceof CompositeOperationException) {
                CompositeOperationException coe = (CompositeOperationException)ite.getCause();
                Trace.out("CompositeOperationException: " + ite.getMessage());
                StringBuilder errors = new StringBuilder();
                NativeResult[] nativeResults = new NativeResult[numOfNodes];
                for (int i = 0; i < numOfNodes; ++i) {
                    String nodeName = remoteNodeNames[i];
                    try {
                        nativeResults[i] = coe.getNativeResult(nodeName);
                        if (nativeResults[i].getStatus()) continue;
                        String errorMsg = nativeResults[i].getOSString();
                        if (errors.length() > 0) {
                            errors.append(RACTransferConstants.NEW_LINE);
                        }
                        errors.append(nodeName).append(':').append(errorMsg);
                        continue;
                    }
                    catch (NoSuchIdentifierException nsie) {
                        Trace.out("Encountered NoSuchIdentifierException while getting NativeResult for node " + nodeName);
                        throw new ClusterException(nsie.getLocalizedMessage());
                    }
                }
                if (errors.length() > 0) {
                    throw new ClusterException(errors.toString());
                }
            }
            Throwable cause = ite.getCause();
            if (cause != null && cause.getMessage() != null) {
                Trace.out("%s: %s", cause.getClass().getSimpleName(), cause.getMessage());
                errorMessage = MessageBundle.getMessage(PrCfMsgID.FAILED_INVOKE_COPY, true, cause.getMessage());
            } else if (ite.getMessage() != null) {
                Trace.out("InvocationTargetException: " + ite.getMessage());
                errorMessage = MessageBundle.getMessage(PrCfMsgID.FAILED_INVOKE_COPY, true, ite.getMessage());
            } else {
                StringBuilder sb = null;
                for (String node : remoteNodeNames) {
                    if (sb == null) {
                        sb = new StringBuilder(node);
                        continue;
                    }
                    sb.append(", " + node);
                }
                errorMessage = MessageBundle.getMessage(PrCfMsgID.FAILED_COPY_SRC_NODES, true, sourcePathname, sb.toString());
            }
            Trace.out("Cluster Exception: " + errorMessage);
            throw new ClusterException(errorMessage);
        }
    }

    protected int[] executeBinaryFile(String[] remoteNodeNames, String exeFilename, String remoteNodeTempDir, String[] remoteNodeDestDirs, RemoteUserInfo remoteUserInfo, String asUser) throws ClusterException {
        String binaryPathname = remoteNodeTempDir + File.separator + exeFilename;
        if (remoteUserInfo == null) {
            return this.executeBinaryFilePasswordless(remoteNodeNames, binaryPathname, remoteNodeTempDir, remoteNodeDestDirs);
        }
        int[] portNumbers = new int[remoteNodeNames.length];
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            portNumbers[i] = this.executeBinaryFileNonPasswordless(remoteNodeNames[i], binaryPathname, remoteNodeTempDir, remoteNodeDestDirs[i], remoteUserInfo, asUser)[0];
        }
        return portNumbers;
    }

    private int[] executeBinaryFileNonPasswordless(String remoteNodeName, String binaryPathname, String remoteNodeTempDir, String remoteNodeDestDir, RemoteUserInfo remoteUserInfo, String asUser) throws ClusterException {
        ExecCommandNoUserEq execCommandNoUserEq;
        int[] portNumbers = new int[1];
        Class[] parameterTypes = new Class[]{RemoteUserInfo.class, String.class};
        Object[] argumentValues = new Object[]{remoteUserInfo, asUser};
        try {
            execCommandNoUserEq = (ExecCommandNoUserEq)this.invokeRemoteFactoryMethod("getExecCommandNoUserEq", parameterTypes, argumentValues);
        }
        catch (RACTransErrorException ree) {
            Trace.out(ree.getMessage());
            String errorMsg = MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "rorre031:" + ree.getMessage());
            throw new ClusterException(errorMsg);
        }
        catch (InvocationTargetException ite) {
            Trace.out("Error executing the ractrans binary. Details:" + RACTransferConstants.NEW_LINE + ite.getMessage());
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
            throw new ClusterException(ite.getMessage());
        }
        try {
            Map<String, CommandResult> resultMap = execCommandNoUserEq.runCmd(binaryPathname, new String[]{remoteNodeDestDir}, new String[]{remoteNodeName}, 120);
            CommandResult commandResult = resultMap.get(remoteNodeName);
            if (commandResult.getStatus()) {
                boolean validPort;
                String portNumberStr = commandResult.getResultString()[0];
                boolean bl = validPort = portNumberStr != null && portNumberStr.trim().length() > 0;
                if (validPort) {
                    try {
                        portNumbers[0] = Integer.valueOf(portNumberStr.trim());
                    }
                    catch (NumberFormatException nfe) {
                        validPort = false;
                    }
                }
                if (!validPort) {
                    Trace.out("Invalid port: " + portNumberStr + " for node \"" + remoteNodeName + "\"");
                    throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.PORT_NOT_INTEGER_NUMBER, true, portNumberStr));
                }
            } else {
                String errorMsg = MessageBundle.getMessage(PrCfMsgID.REMOTE_EXECUTION_ERROR, true, remoteNodeName, commandResult.getOSString());
                Trace.out(errorMsg);
                throw new ClusterException(errorMsg);
            }
            Trace.out("Executed successfully binary \"" + binaryPathname + "\" as user \"" + asUser + "\"");
            return portNumbers;
        }
        catch (InvalidArgsException iae) {
            Trace.out("Error executing the ractrans binary. Details:" + RACTransferConstants.NEW_LINE + iae.getMessage());
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
            throw new ClusterException(iae.getMessage());
        }
        catch (ExecException ee) {
            Trace.out("Error executing the ractrans binary. Details:" + RACTransferConstants.NEW_LINE + ee.getMessage());
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
            throw new ClusterException(ee.getMessage());
        }
        catch (CompositeOperationException coe) {
            Trace.out("Error executing the ractrans binary. Details:" + RACTransferConstants.NEW_LINE + coe.getMessage());
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
            throw new ClusterException(coe.getMessage());
        }
    }

    private int[] executeBinaryFilePasswordless(String[] remoteNodeNames, String binaryPathname, String remoteNodeTempDir, String[] remoteNodeDestDirs) throws ClusterException {
        boolean successfulExecution;
        int[] portNumbers = new int[remoteNodeNames.length];
        Command[] cmdArray = new RemoteExecCommand[remoteNodeNames.length];
        CommandResult[] result = new CommandResult[remoteNodeNames.length];
        String[] curr_remoteNodeDestDir = new String[1];
        for (int i = 0; i < remoteNodeNames.length; ++i) {
            curr_remoteNodeDestDir[0] = remoteNodeDestDirs[i];
            result[i] = new CommandResult();
            result[i].setNodeName(remoteNodeNames[i]);
            cmdArray[i] = new RemoteExecCommand(binaryPathname, curr_remoteNodeDestDir, null, remoteNodeNames[i], null, (String)null, null, (NativeResult)result[i]);
        }
        try {
            successfulExecution = new ClusterCmd().submit(cmdArray);
        }
        catch (ClusterException ce) {
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
            throw ce;
        }
        boolean throwClusterException = false;
        StringBuilder strBuilder = new StringBuilder();
        if (successfulExecution) {
            for (int i = 0; i < remoteNodeNames.length; ++i) {
                result[i] = cmdArray[i].getCommandResult();
                if (result[i].getBooleanResult()) {
                    String portNumberStr = result[i].getResultString()[0].trim();
                    try {
                        this.assertPortNumber(portNumberStr);
                        portNumbers[i] = Integer.valueOf(portNumberStr);
                        Trace.out("Node \"" + remoteNodeNames[i] + "\" executed " + "the binary successfully and replied that it " + "accepts clients at port: " + portNumbers[i]);
                    }
                    catch (RACTransWarningException warning) {
                        portNumbers[i] = -1;
                        strBuilder.append(MessageBundle.getMessage(PrCfMsgID.UNSUCCESSFUL_BINARY_EXECUTION_PORT_ERROR, true, remoteNodeNames[i]));
                        strBuilder.append(RACTransferConstants.NEW_LINE);
                        throwClusterException = true;
                    }
                    continue;
                }
                portNumbers[i] = -1;
                result[i].setStatus(false);
                strBuilder.append(MessageBundle.getMessage(PrCfMsgID.UNSUCCESSFUL_BINARY_EXECUTION, true, remoteNodeNames[i]));
                strBuilder.append(RACTransferConstants.NEW_LINE);
                throwClusterException = true;
            }
        }
        if (throwClusterException) {
            if (this.m_singleInstanceOnly) {
                s_runRACTransfer.release();
            }
            throw new ClusterException(strBuilder.toString());
        }
        return portNumbers;
    }

    private void cleanup(String[] remoteNodeNames, String remoteNodeTempDir, RemoteUserInfo remoteUserInfo, String asUser) throws ClusterException {
        String pathnameToRemove = remoteNodeTempDir + File.separator + "ractrans";
        if (remoteUserInfo == null) {
            ClusterCmd clusterCmd = new ClusterCmd();
            try {
                clusterCmd.removeFileFromNodes(remoteNodeNames, pathnameToRemove);
            }
            catch (ClusterException ce) {
                Trace.out("The ractrans binary was not deleted on all remote nodes.");
                throw ce;
            }
            try {
                clusterCmd.removeDirectory(remoteNodeNames, remoteNodeTempDir);
            }
            catch (ClusterException ce) {
                Trace.out("The directory \"" + remoteNodeTempDir + "\" is not empty on one or more of the remote nodes");
            }
        } else {
            Map resultMap;
            Class[] parameterTypes = new Class[]{String[].class, String.class, RemoteUserInfo.class, String.class, Boolean.TYPE};
            Object[] argumentValues = new Object[]{remoteNodeNames, remoteNodeTempDir, remoteUserInfo, asUser, true};
            try {
                resultMap = (Map)this.invokeRemoteFactoryMethod("removeDirOnNodes", parameterTypes, argumentValues);
            }
            catch (RACTransErrorException ree) {
                Trace.out(ree.getMessage());
                String errorMsg = MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "rorre032:" + ree.getMessage());
                throw new ClusterException(errorMsg);
            }
            catch (InvocationTargetException ite) {
                Trace.out("Error removing the temporary directory with the ractrans binary. Details:" + RACTransferConstants.NEW_LINE + ite.getMessage());
                throw new ClusterException(ite.getMessage());
            }
            CommandResult commandResult = (CommandResult)resultMap.get(remoteNodeNames[0]);
            if (!commandResult.getStatus()) {
                String errorMsg = MessageBundle.getMessage(PrCfMsgID.REMOTE_EXECUTION_ERROR, true, remoteNodeNames[0], commandResult.getOSString());
                Trace.out(errorMsg);
                throw new ClusterException(errorMsg);
            }
            Trace.out("Removed successfully directory \"" + remoteNodeTempDir + "\" as user \"" + asUser + "\"");
        }
        this.m_racTransferCore.threadCleanup();
    }

    private void createDirListing(String topDirPathname, String excludeListFile, boolean excludePathnamesCanBeRegex, String includeListFile, boolean includePathnamesCanBeRegex) throws RACTransWarningException, RACTransErrorException {
        if (excludeListFile != null && !excludeListFile.equals("")) {
            File excludeFile = new File(excludeListFile);
            RACTransferConstants.Status excludeFileStatus = this.m_racTransferCore.setExcludeList(excludeFile, excludePathnamesCanBeRegex, topDirPathname);
            Trace.out("Exclude-file status: " + (Object)((Object)excludeFileStatus) + "\n  Excplanatory Key: " + "\n    SUCCESSFUL -> everything in the exclude-file exists in the system " + "under the top-directory and therefore can be excluded." + "\n    PARTIALLY_SUCCESSFUL -> at least one content in the exclude-file " + "exists in the system under the top-directory and therefore " + "cannot be excluded." + "\n    UNSUCCESSFUL -> either no exclude-file was provided or the " + "exclude-file does not exist in the system.");
        }
        if (includeListFile != null && !includeListFile.equals("")) {
            File includeFile = new File(includeListFile);
            RACTransferConstants.Status includeFileStatus = this.m_racTransferCore.setIncludeList(includeFile, includePathnamesCanBeRegex, topDirPathname);
            Trace.out("Include-file status: " + (Object)((Object)includeFileStatus) + "\n  Excplanatory Key: " + "\n    SUCCESSFUL -> everything in the include-file exists in the system " + "under the top-directory and therefore can be included as long as it does " + "not conflict with the exclude-list." + "\n    PARTIALLY_SUCCESSFUL -> at least one content in the include-file " + "exists in the system under the top-directory and therefore " + "cannot be included." + "\n    UNSUCCESSFUL -> either no include-file was provided or the " + "include-file does not exist in the system.");
        }
        FileDescriptor topDir = null;
        try {
            topDir = new FileDescriptor(topDirPathname);
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("The top-level directory \"" + topDirPathname + "\" does not exist.");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.TOP_DIR_NOT_FOUND, topDirPathname);
        }
        this.m_racTransferCore.createDirListing(topDir);
    }

    public Object invokeRemoteFactoryMethod(String methodName, Class<?>[] parameterTypes, Object[] argumentValues) throws RACTransErrorException, InvocationTargetException {
        Object remoteFactory;
        Class<?> RemoteFactory2;
        try {
            RemoteFactory2 = Class.forName("oracle.cluster.remote.RemoteFactory");
        }
        catch (ClassNotFoundException cnfe) {
            throw new RACTransErrorException("Class oracle.cluster.remote.RemoteFactory not found. Details:" + RACTransferConstants.NEW_LINE + cnfe.getMessage());
        }
        catch (LinkageError le) {
            throw new RACTransErrorException("Linkage error. Details:" + RACTransferConstants.NEW_LINE + le.getMessage());
        }
        try {
            remoteFactory = RemoteFactory2.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new RACTransErrorException("Method RemoteFactory.getInstance() not found. Details:" + RACTransferConstants.NEW_LINE + nsme.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new RACTransErrorException("Error invoking method RemoteFactory.getInstance(). Details:" + RACTransferConstants.NEW_LINE + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new RACTransErrorException("Error invoking method RemoteFactory.getInstance(). Details:" + RACTransferConstants.NEW_LINE + iae.getMessage());
        }
        try {
            if (parameterTypes == null) {
                return RemoteFactory2.getMethod(methodName, new Class[0]).invoke(remoteFactory, new Object[0]);
            }
            return RemoteFactory2.getMethod(methodName, parameterTypes).invoke(remoteFactory, argumentValues);
        }
        catch (NoSuchMethodException nsme) {
            throw new RACTransErrorException("Method RemoteFactory." + methodName + "() not found. Details:" + RACTransferConstants.NEW_LINE + nsme.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new RACTransErrorException("Error invoking method RemoteFactory." + methodName + "(). Details:" + RACTransferConstants.NEW_LINE + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new RACTransErrorException("Illegal arguments while invoking method RemoteFactory." + methodName + "(). Details:" + RACTransferConstants.NEW_LINE + iae.getMessage());
        }
    }
}

