/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.cluster.deployment.ractrans.TransferResult;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;

public class MultiTierTransferConstants {
    protected static final String NEW_LINE = System.getProperty("line.separator");
    protected static final String TRACE_SEPARATOR = "------------------------------------------------";
    protected static final String SRVM_MTTRANS_DEBUG = "SRVM_MTTRANS_DEBUG";
    protected static final boolean DEBUG_MODE = System.getProperty("SRVM_MTTRANS_DEBUG") != null || System.getenv("SRVM_MTTRANS_DEBUG") != null;
    protected static final boolean DUPLICATE_NODE_NAMES_IN_TEST_MODE = System.getenv("SRVM_TEST_MTTRANS") != null || System.getProperty("SRVM_TEST_MTTRANS") != null;
    protected static final boolean JAVA_NODE_NOT_DEST_NODE = DUPLICATE_NODE_NAMES_IN_TEST_MODE && System.getenv("SRVM_TESTLOCALCOPY_MTTRANS") == null && System.getProperty("SRVM_TESTLOCALCOPY_MTTRANS") == null;
    protected static final MessageBundle MSG_BUNDLE = MessageBundle.getMessageBundle(PrCfMsgID.facility);
    protected static final Map<String, MessageKey> MSG_LOOKUP = new HashMap<String, MessageKey>();
    public static int MIN_NUM_OF_NODES_FOR_MTTRANS;
    protected static final int JAVA_NODE_ID = 0;
    protected static final String SRVM_LOG_LEVEL_ENV_VAR = "SRVM_LOG_LEVEL";
    protected static final String LOG_DIR_NAME = "mttrans";
    protected static final String PLAN_DIR_PREFIX = "mttrans";
    protected static final String DATA_PLAN_FILE_PREFIX = "mttdata";
    protected static final String DATA_PLAN_FILE_EXTENSION = ".plan";
    protected static final String NODE_PLAN_FILE_PREFIX = "mttnode";
    protected static final String NODE_PLAN_FILE_EXTENSION = ".plan";
    protected static final String MTTRANS_BINARY_NAME = "mttrans";
    protected static final String MTTRANS_BINARY_PLAN_SUBDIR = "bin";
    protected static final String QUALIFIED_CLASSNAME_IN_SRVM_JAR = "oracle.cluster.deployment.ractrans.MultiTierTransfer";
    protected static final String[] MTTRANS_CMD_ARGS;
    protected static final String GENERAL_ERRORS = "General Errors: ";
    protected static final String DIR_RELATED_ERRORS = "Directory Errors: ";
    protected static final String FILE_RELATED_ERRORS = "File Errors: ";
    protected static final String SYMLINK_RELATED_ERRORS = "Symlink Errors: ";
    private static final int SIZE_BOUNDARY_BETWEEN_1_AND_2_THREADS_IN_MB = 100;
    private static final int SIZE_BOUNDARY_BETWEEN_2_AND_3_THREADS_IN_MB = 400;
    private static final int LINEAR_THREAD_COUNT_INCREMENT_BOUNDARY_IN_MB = 1024;
    private static final int LINEAR_THREAD_COUNT_INCREMENT_STEP_IN_MB = 1024;
    private static final double FILE_OVERHEAD_LOAD_FACTOR_IN_MB = 0.6;
    private static final int NUM_OF_BYTES_PER_MB = 0x100000;
    protected static final long SIZE_BOUNDARY_BETWEEN_1_AND_2_THREADS_IN_BYTES = 0x6400000L;
    protected static final long SIZE_BOUNDARY_BETWEEN_2_AND_3_THREADS_IN_BYTES = 0x19000000L;
    protected static final long LINEAR_THREAD_COUNT_INCREMENT_BOUNDARY_IN_BYTES = 0x40000000L;
    protected static final long LINEAR_THREAD_COUNT_INCREMENT_STEP_IN_BYTES = 0x40000000L;
    protected static final int FILE_OVERHEAD_LOAD_FACTOR_IN_BYTES = 629145;
    protected static final int MAX_TRANSFER_THREADS_PER_CHILD_NODE = 6;
    protected static final int MAX_TOTAL_TRANSFER_THREADS = 32;
    protected static final String MKDIR_CMD_FORMAT = "<5>mkdir<%d>%s[m%s][u%d][g%d]";
    protected static final String WRFILE_CMD_FORMAT = "<6>wrfile<%d>%s[m%s][u%d][g%d][%d]";
    protected static final String MKLINK_CMD_FORMAT = "<6>mklink<%d>%s<%d>%s[m%s][u%d][g%d][s%d]";
    protected static final String CLOSE_IDENTIFIER = "]";
    protected static final String DATA_PLAN_FILE_KEYNOTE;
    protected static final String BARRIER_BETWEEN_DIR_AND_FILE_LISTING = "BARRIER_1";
    protected static final String BARRIER_BETWEEN_FILE_AND_SYMLINK_LISTING = "BARRIER_2";
    protected static final LogLevel DEFAULT_LOG_LEVEL;
    protected static final String RESULT_LISTENER_HOST_LABEL = "RESULT_LISTENER_HOST";
    protected static final String RESULT_LISTENER_PORT_LABEL = "RESULT_LISTENER_PORT";
    protected static final String THREADS_PER_TRANSFER_LABEL = "THREADS_PER_TRANSFER";
    protected static final String LOG_LEVEL_LABEL = "LOG_LEVEL";
    protected static final String LOG_FILE_PATH_LABEL = "LOG_FILE_PATH";
    protected static final String DEBUGGING_DISABLED = "0";
    protected static final String DEBUGGING_ENABLED = "1";
    protected static final String LOG_FILE_PATH_SUFFIX = "_trace";
    protected static final String LOG_FILE_NAME_LABEL = "LOG_FILE_NAME";
    protected static final String LOG_FILE_NAME = "mttrans_<NODENAME>_";
    protected static final String LOG_FILE_TIMESTAMP_FORMAT = "dd_MM_yyyy_hh_mm_ss";
    protected static final String LOG_FILE_NAME_EXTENSION = ".log";
    protected static final String NODE_NAME_LABEL = "NODE_NAME";
    protected static final String NODE_ID_LABEL = "NODE_ID";
    protected static final String NODE_SOURCE_LABEL = "NODE_SOURCE";
    protected static final String NODE_DESTINATION_LABEL = "NODE_DESTINATION";
    protected static final String CHILD_NODES_LABEL = "CHILD_NODES";
    protected static final String MTTRANS_ID_LABEL = "MTTRANS_ID";
    protected static final String NODE_PLAN_FILE_KEYNOTE;
    protected static final int TIMEOUT_CHECK_INTERVAL = 5000;

    protected static String getTempDir() {
        return "/tmp";
    }

    static {
        for (PrCfMsgID msgKey : PrCfMsgID.values()) {
            String msgName = msgKey.getName();
            MSG_LOOKUP.put(msgName, msgKey);
        }
        MIN_NUM_OF_NODES_FOR_MTTRANS = 2;
        MTTRANS_CMD_ARGS = new String[]{"<mttrans path>", "-plandir", "<plan directory path on java-node>", "-node", String.valueOf(0), "-javanode"};
        DATA_PLAN_FILE_KEYNOTE = "# Filetype: Transfer Data Plan File (mttdata<#>.plan file)" + NEW_LINE + "# Note    : Comment lines in this file (i.e., lines that start with '#') should be ignored" + NEW_LINE + "#" + NEW_LINE + "# Purpose : This file indicates the contents to be transferred by a given thread." + NEW_LINE + "# Format  : Each content is described in a separate line by the corresponding command." + NEW_LINE + "#           - Command for directories: " + NEW_LINE + "#               <5><mkdir>{relative dir path length}{relative dir path}[m{mode}][u{uid}][g{gid}]" + NEW_LINE + "#           - Command for files: " + NEW_LINE + "#               <6><wrfile>{relative file path lngth}{relative file path}[m{mode}][u{uid}][g{gid}][{file size in bytes}]" + NEW_LINE + "#           - Command for symbolic links: " + NEW_LINE + "#               <6><mklink>{symlink target path length}{symlink target path}{relative symlink path length}{relative symlink path}[m{mode}][u{uid}][g{gid}][s{0|1}]" + NEW_LINE + "# ------------------------------------------------------------------------------------------------- #";
        DEFAULT_LOG_LEVEL = LogLevel.DEBUG;
        NODE_PLAN_FILE_KEYNOTE = "# Filetype: Transfer Node Plan / Configuration File (mttnode.plan)" + NEW_LINE + "# Note    : Comment lines in this file (i.e., lines that start with '#') should be ignored" + NEW_LINE + "#" + NEW_LINE + "# Purpose : This files contains the transfer configuration" + NEW_LINE + "# Format  : In general each line is following the <attribute label>=<attribute value> pattern" + NEW_LINE + "#          " + RESULT_LISTENER_HOST_LABEL + "=<name or IP address of the local host>" + NEW_LINE + "#          " + RESULT_LISTENER_PORT_LABEL + "=<port that the local host listens on>" + NEW_LINE + "#          " + THREADS_PER_TRANSFER_LABEL + "=<number of threads per node that sends data>" + NEW_LINE + "#          " + MTTRANS_ID_LABEL + "=<unique transfer ID>" + NEW_LINE + "#          " + LOG_LEVEL_LABEL + "=<log level numeric value>" + NEW_LINE + "#          " + LOG_FILE_NAME_LABEL + "=<the name of the log file>" + NEW_LINE + "#          " + LOG_FILE_PATH_LABEL + "=<the absolute path name where the log file is created>" + NEW_LINE + "#          " + SRVM_MTTRANS_DEBUG + "=<0 for normal mode or 1 for debug mode>" + NEW_LINE + "#          " + NODE_ID_LABEL + "=<ID of sender or receiver node>" + NEW_LINE + "#          " + NODE_NAME_LABEL + "=<name of sender or receiver node>" + NEW_LINE + "#          " + NODE_SOURCE_LABEL + "=<source top-level directory absolute path name>" + NEW_LINE + "#          " + NODE_DESTINATION_LABEL + "=<destination top-level directory absolute path name>" + NEW_LINE + "#          " + CHILD_NODES_LABEL + "=<comma separated list with names of nodes to send data to>" + NEW_LINE + "#           (this section repeats for every node that participates in the transfer)" + NEW_LINE + "#" + NEW_LINE + "#          " + MTTRANS_ID_LABEL + "=<unique identifier for the temporary plan directory>";
    }

    protected static enum TransferResultTag {
        RESULT("RESULT", NodeValueType.NONE),
        SOURCE_NODE("SOURCE_NODE", NodeValueType.NON_NEGATIVE_INTEGER),
        TARGET_NODE("TARGET_NODE", NodeValueType.NON_NEGATIVE_INTEGER),
        STATUS("STATUS", NodeValueType.NON_NEGATIVE_INTEGER),
        FAILURE_DETAILS("FAILURE_DETAILS", NodeValueType.NONE),
        ERROR("ERROR", NodeValueType.NONE),
        ERROR_CODE("ERROR_CODE", NodeValueType.STRING),
        ERROR_ARG("ERROR_ARG", NodeValueType.STRING);

        private static final Map<String, TransferResultTag> lookup;
        private final String m_tagName;
        private final NodeValueType m_childNodeValueType;

        private TransferResultTag(String tagName, NodeValueType childNodeValueType) {
            this.m_tagName = tagName;
            this.m_childNodeValueType = childNodeValueType;
        }

        protected static TransferResultTag getTransferResultTag(String tagName) {
            if (tagName == null) {
                return null;
            }
            tagName = tagName.trim().toLowerCase();
            return lookup.get(tagName);
        }

        protected boolean hasValidValue(String value) {
            return this.m_childNodeValueType.isValidValue(value);
        }

        public String toString() {
            return this.m_tagName;
        }

        static {
            lookup = new HashMap<String, TransferResultTag>();
            for (TransferResultTag transferResultTag : TransferResultTag.values()) {
                lookup.put(transferResultTag.m_tagName.toLowerCase(), transferResultTag);
            }
        }
    }

    protected static enum NodeStatusUpdateTag {
        UPDATE("UPDATE", NodeValueType.NONE),
        SOURCE_NODE("SOURCE_NODE", NodeValueType.NON_NEGATIVE_INTEGER),
        TARGET_NODE("TARGET_NODE", NodeValueType.NON_NEGATIVE_INTEGER),
        STATUS("STATUS", NodeValueType.STRING),
        FAILURE_DETAILS("FAILURE_DETAILS", NodeValueType.NONE),
        ERROR("ERROR", NodeValueType.NONE),
        ERROR_CODE("ERROR_CODE", NodeValueType.POSITIVE_INTEGER),
        ERROR_ARG("ERROR_ARG", NodeValueType.STRING),
        DIR("DIR", NodeValueType.NONE),
        FILE("FILE", NodeValueType.NONE),
        SYMLINK("SYMLINK", NodeValueType.NONE),
        PATH("PATH", NodeValueType.STRING);

        private static final Map<String, NodeStatusUpdateTag> lookup;
        private final String m_tagName;
        private final NodeValueType m_childNodeValueType;

        private NodeStatusUpdateTag(String tagName, NodeValueType childNodeValueType) {
            this.m_tagName = tagName;
            this.m_childNodeValueType = childNodeValueType;
        }

        protected static NodeStatusUpdateTag getNodeStatusUpdateTag(String tagName) {
            if (tagName == null) {
                return null;
            }
            tagName = tagName.trim().toLowerCase();
            return lookup.get(tagName);
        }

        protected boolean hasValidValue(String value) {
            return this.m_childNodeValueType.isValidValue(value);
        }

        public String toString() {
            return this.m_tagName;
        }

        static {
            lookup = new HashMap<String, NodeStatusUpdateTag>();
            for (NodeStatusUpdateTag nodeStatusUpdateTag : NodeStatusUpdateTag.values()) {
                lookup.put(nodeStatusUpdateTag.m_tagName.toLowerCase(), nodeStatusUpdateTag);
            }
        }
    }

    protected static enum NodeStateTag {
        STATE_REPORT("STATE-REPORT", NodeValueType.NONE),
        NODE("NODE", NodeValueType.NON_NEGATIVE_INTEGER),
        STATE_CODE("STATE-CODE", NodeValueType.POSITIVE_INTEGER);

        private static final Map<String, NodeStateTag> lookup;
        private final String m_tagName;
        private final NodeValueType m_childNodeValueType;

        private NodeStateTag(String tagName, NodeValueType childNodeValueType) {
            this.m_tagName = tagName;
            this.m_childNodeValueType = childNodeValueType;
        }

        protected static NodeStateTag getNodeStateTag(String tagName) {
            if (tagName == null) {
                return null;
            }
            tagName = tagName.trim().toLowerCase();
            return lookup.get(tagName);
        }

        protected boolean hasValidValue(String value) {
            return this.m_childNodeValueType.isValidValue(value);
        }

        public String toString() {
            return this.m_tagName;
        }

        static {
            lookup = new HashMap<String, NodeStateTag>();
            for (NodeStateTag nodeStateTag : NodeStateTag.values()) {
                lookup.put(nodeStateTag.m_tagName.toLowerCase(), nodeStateTag);
            }
        }
    }

    protected static enum NodeValueType {
        BOOLEAN("TRUE", "FALSE"),
        INTEGER(new String[0]),
        NON_NEGATIVE_INTEGER(new String[0]),
        POSITIVE_INTEGER(new String[0]),
        DOUBLE(new String[0]),
        STRING(new String[0]),
        STATUS(String.valueOf(TransferResult.TransferStatus.SUCCESS.getCode()), String.valueOf(TransferResult.TransferStatus.CRITICAL_FAILURE.getCode()), String.valueOf(TransferResult.TransferStatus.FAILURE.getCode()), String.valueOf(TransferResult.TransferStatus.WARNING.getCode())),
        NONE(new String[0]);

        private final Set<String> m_values = new HashSet<String>();

        private NodeValueType(String ... values) {
            if (values != null) {
                for (String value : values) {
                    this.m_values.add(value.toLowerCase());
                }
            }
        }

        protected boolean isValidValue(String value) {
            if (value == null) {
                return false;
            }
            value = value.trim();
            switch (this) {
                case STRING: {
                    return value.length() > 0;
                }
                case BOOLEAN: 
                case STATUS: {
                    value = value.toLowerCase();
                    return this.m_values.contains(value);
                }
                case INTEGER: 
                case NON_NEGATIVE_INTEGER: 
                case POSITIVE_INTEGER: {
                    int intValue;
                    try {
                        intValue = Integer.valueOf(value);
                    }
                    catch (NumberFormatException notAnInteger) {
                        return false;
                    }
                    if (this == NON_NEGATIVE_INTEGER) {
                        return intValue >= 0;
                    }
                    if (this == POSITIVE_INTEGER) {
                        return intValue > 0;
                    }
                    return true;
                }
                case DOUBLE: {
                    try {
                        Double.valueOf(value);
                        return true;
                    }
                    catch (NumberFormatException notAnDouble) {
                        return false;
                    }
                }
                case NONE: {
                    return false;
                }
            }
            return false;
        }
    }

    protected static enum LogLevel {
        DISABLED(0),
        ADMIN(1),
        DEBUG(2);

        private final int m_value;

        private LogLevel(int value) {
            this.m_value = value;
        }

        protected int getValue() {
            return this.m_value;
        }

        protected static boolean isValid(int value) {
            return value >= DISABLED.getValue() && value <= DEBUG.getValue();
        }
    }
}

