/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.deployment.ractrans.DirListing;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.IllegalArgException;
import oracle.cluster.deployment.ractrans.MultiTierTransferConstants;
import oracle.cluster.deployment.ractrans.NodeStatusUpdate;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.RACTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.deployment.ractrans.ReportCollector;
import oracle.cluster.deployment.ractrans.ReportReader;
import oracle.cluster.deployment.ractrans.Timeout;
import oracle.cluster.deployment.ractrans.TransferPlanner;
import oracle.cluster.deployment.ractrans.TransferResult;
import oracle.cluster.install.InstallException;
import oracle.cluster.remote.NodeProgressListener;
import oracle.cluster.remote.timer.TimeoutChecker;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.RuntimeExec;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;

public class MultiTierTransfer {
    private final String m_mttransID = this.getMttransID();
    private final SortedMap<Integer, String> m_nodeNameLookupMap = new TreeMap<Integer, String>();
    private final Map<Integer, NodeStatusUpdate> m_statusUpdateMap = new HashMap<Integer, NodeStatusUpdate>();
    private final Map<Integer, Semaphore> m_statusUpdateLocks = new HashMap<Integer, Semaphore>();
    private final Map<Integer, TransferResult> m_resultMap = new HashMap<Integer, TransferResult>();
    private final CountDownLatch m_errorCheckingPermit;
    private final StringBuilder m_abnormalErrorBuffer = new StringBuilder();
    private final TimeoutChecker m_timeoutChecker = TimeoutChecker.getInstance(5000);
    private final Map<Integer, Timeout> m_timeoutLookup = new HashMap<Integer, Timeout>();
    private int m_totalNodes;
    private TransferPlanner m_transferPlanner;
    private ReportReader m_reportReader;
    private ReportCollector m_reportCollector;
    private int m_portNumber = -1;
    private List<NodeProgressListener> m_progressListeners = new ArrayList<NodeProgressListener>();

    public MultiTierTransfer() {
        this.m_errorCheckingPermit = new CountDownLatch(1);
    }

    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String tempDir, String[] nodeDestDirPathnames) throws RemoteFileOpException, ClusterException {
        ArrayList<NodeProgressListener> emptyListOfProgressListeners = new ArrayList<NodeProgressListener>();
        this.transferDirStructureToNodes(oracleHome, javaNodeName, nodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, tempDir, nodeDestDirPathnames, emptyListOfProgressListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferDirStructureToNodes(String oracleHome, String javaNodeName, String[] nodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String tempDir, String[] nodeDestDirPathnames, List<NodeProgressListener> progressListeners) throws RemoteFileOpException, ClusterException {
        String errorMsg;
        Trace.out("=============> MTTRANS_INVOKED! <=============");
        try {
            int dotIndex;
            if (javaNodeName == null || javaNodeName.trim().length() == 0) {
                throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre018");
            }
            RACTransfer.assertDir(topLevelDir);
            RACTransfer.assertDir(tempDir);
            RACTransfer.assertRemoteNodeNames(nodeNames, nodeDestDirPathnames);
            RACTransfer.assertRemoteNodeDestDirs(nodeDestDirPathnames);
            RACTransfer.assertIncludeListFile(includeListFile);
            RACTransfer.assertExcludeListFile(excludeListFile);
            if (progressListeners == null) {
                Trace.out("Internal error: The list with the progress listeners is null");
                throw new IllegalArgException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre020");
            }
            if (excludeListFile != null && !excludeListFile.trim().equals("") && RACTransfer.topLevelDirIsExcluded(topLevelDir, excludeListFile)) {
                Trace.out("The top-level directory is excluded. Therefore, the transfer is a NOP");
                return;
            }
            if (!IPAddressUtil.isIPv4AddressString(javaNodeName) && (dotIndex = javaNodeName.indexOf(46)) != -1) {
                javaNodeName = javaNodeName.substring(0, dotIndex);
            }
            for (int i = 0; i < nodeNames.length; ++i) {
                int dotIndex2;
                if (!IPAddressUtil.isIPv4AddressString(nodeNames[i]) && (dotIndex2 = nodeNames[i].indexOf(46)) != -1) {
                    nodeNames[i] = nodeNames[i].substring(0, dotIndex2);
                }
                if (!nodeNames[i].equalsIgnoreCase(javaNodeName)) continue;
                if (nodeDestDirPathnames[i].equals(topLevelDir)) {
                    Object[] args = new String[]{topLevelDir, javaNodeName};
                    errorMsg = MessageBundle.getMessage(PrCfMsgID.WORKLOAD_DISTRIBUTION_PROCESS_ERROR, true, args);
                    Trace.out(errorMsg);
                    TransferResult transferError = new TransferResult(0, 0, TransferResult.TransferStatus.CRITICAL_FAILURE);
                    transferError.addGeneralError(errorMsg);
                    this.m_resultMap.put(0, transferError);
                }
                break;
            }
        }
        catch (IllegalArgException iae) {
            Trace.out(iae.getMessage());
            throw new ClusterException(iae.getMessage());
        }
        if (!progressListeners.isEmpty()) {
            this.m_progressListeners.addAll(progressListeners);
        }
        this.m_totalNodes = nodeNames.length;
        this.m_reportReader = new ReportReader();
        try {
            this.m_reportCollector = new ReportCollector(this);
        }
        catch (RACTransErrorException ree) {
            throw new ClusterException(ree.getMessage());
        }
        this.m_portNumber = this.m_reportCollector.getListenerPort();
        String mttransBinaryPathname = RACTransfer.getBinaryPathname(oracleHome, topLevelDir, "mttrans");
        Trace.out("The path name of the mttrans binary is : " + mttransBinaryPathname);
        Trace.out("Creating transfer plan");
        this.m_transferPlanner = new TransferPlanner(this.m_mttransID);
        try {
            this.m_transferPlanner.createPlan(topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, javaNodeName, nodeNames, nodeDestDirPathnames, mttransBinaryPathname, this.m_portNumber, this.m_nodeNameLookupMap);
        }
        catch (IllegalArgException impossible) {
            throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "rorre017"));
        }
        catch (RACTransErrorException ree) {
            this.m_transferPlanner.cleanup();
            Trace.out("Error while creating the optimized plan for the transfer. Details:" + MultiTierTransferConstants.NEW_LINE + ree.getMessage());
            errorMsg = MultiTierTransferConstants.MSG_BUNDLE.getMessage(PrCfMsgID.CREATE_PLAN_FAILED, true);
            throw new ClusterException(errorMsg, ree);
        }
        StringBuilder nodeMapping = new StringBuilder();
        Set<Integer> nodeIDs = this.m_nodeNameLookupMap.keySet();
        for (Integer nodeID : nodeIDs) {
            nodeMapping.append("Node ID: " + nodeID + " - Node name: " + (String)this.m_nodeNameLookupMap.get(nodeID) + MultiTierTransferConstants.NEW_LINE);
        }
        Trace.out("Node ID-to-Node Name Mapping:" + MultiTierTransferConstants.NEW_LINE + "------------------------------------------------" + MultiTierTransferConstants.NEW_LINE + nodeMapping.toString() + "------------------------------------------------");
        this.initNodeStates();
        this.initTimeouts();
        this.m_timeoutChecker.start();
        this.m_reportCollector.startConnectionListener();
        try {
            this.runJavaNodeMttransBinary(mttransBinaryPathname, this.m_transferPlanner.getPlanDirPathname());
            String progressMsg = MessageBundle.getMessage(PrCfMsgID.TRANSFERRING_DATA_TO_NODES, false, this.m_totalNodes);
            this.notifyProgressListeners(progressMsg, null);
            try {
                this.m_errorCheckingPermit.await();
            }
            catch (InterruptedException impossible) {
                throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "rorre021"));
            }
            this.m_timeoutChecker.stop();
            String logDirPathname = null;
            if (oracleHome != null) {
                try {
                    String oracleBasePathname = new ClusterwareInfo().getOracleBaseLoc(oracleHome, new Version());
                    Trace.out("Oracle base location: " + oracleBasePathname);
                    File oracleBaseDir = new File(oracleBasePathname);
                    try {
                        if (!oracleBaseDir.exists()) {
                            logDirPathname = oracleHome;
                            Trace.out("Oracle base \"" + oracleBasePathname + "\" does not exist. Using oracle home " + "(\"" + oracleHome + "\") instead.");
                        } else if (!oracleBaseDir.isDirectory()) {
                            logDirPathname = oracleHome;
                            Trace.out("Oracle base \"" + oracleBasePathname + "\" is not a directory. Using oracle " + "home (\"" + oracleHome + "\") instead.");
                        } else if (!oracleBaseDir.canWrite()) {
                            logDirPathname = oracleHome;
                            Trace.out("Oracle base \"" + oracleBasePathname + "\" does not have write access. Using " + "oracle home (\"" + oracleHome + "\") instead.");
                        } else {
                            logDirPathname = oracleBasePathname;
                        }
                    }
                    catch (SecurityException se) {
                        logDirPathname = oracleHome;
                        Trace.out("Cannot verify that the oracle base directory \"" + oracleBasePathname + "\" exists and is a directory with write " + "access. Using oracle home (\"" + oracleHome + "\") instead.");
                    }
                }
                catch (InstallException ie) {
                    logDirPathname = oracleHome;
                    Trace.out("Cannot detect the oracle base location. Details:" + MultiTierTransferConstants.NEW_LINE + ie.getMessage() + MultiTierTransferConstants.NEW_LINE + "Using oracle home (\"" + oracleHome + "\") instead.");
                }
            } else {
                logDirPathname = topLevelDir;
                Trace.out("Oracle home is null. Hence using the top-level directory (\"" + topLevelDir + "\") to fetch the logs on the java-node");
            }
            logDirPathname = logDirPathname.endsWith(File.separator) ? logDirPathname + "mttrans" : logDirPathname + File.separator + "mttrans";
            this.checkForErrorsAndFetchLogs(nodeNames, logDirPathname);
            Trace.out("Transfer operation completed successfully");
        }
        finally {
            this.m_transferPlanner.cleanup();
        }
    }

    public static long getTotalSizeInBytes(String topDirPathname, String excludeListFilePathname, boolean excludePathnamesCanBeRegex, String includeListFilePathname, boolean includePathnamesCanBeRegex) throws RACTransErrorException {
        FileDescriptor topDir;
        try {
            topDir = new FileDescriptor(topDirPathname);
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("The top-level directory \"" + topDirPathname + "\" does not exist.");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.TOP_DIR_NOT_FOUND, topDirPathname);
        }
        File excludeListFile = excludeListFilePathname == null ? null : new File(excludeListFilePathname);
        File includeListFile = includeListFilePathname == null ? null : new File(includeListFilePathname);
        boolean linkDestAreRelativePaths = false;
        DirListing dirListing = new DirListing(topDir, excludeListFile, excludePathnamesCanBeRegex, includeListFile, includePathnamesCanBeRegex, linkDestAreRelativePaths);
        List<FileDescriptor> nonReadableDirs = dirListing.getNonReadableDirs();
        List<FileDescriptor> nonReadableFiles = dirListing.getNonReadableFiles();
        if (!nonReadableDirs.isEmpty() || !nonReadableFiles.isEmpty()) {
            StringBuilder commaSeparatedListOfDirs = new StringBuilder();
            int numOfNonReadableDirs = nonReadableDirs.size();
            if (numOfNonReadableDirs > 0) {
                commaSeparatedListOfDirs.append(nonReadableDirs.get(0).getPath());
                for (int i = 1; i < numOfNonReadableDirs; ++i) {
                    commaSeparatedListOfDirs.append(", ");
                    commaSeparatedListOfDirs.append(nonReadableDirs.get(i).getPath());
                }
            }
            StringBuilder commaSeparatedListOfFiles = new StringBuilder();
            int numOfNonReadableFiles = nonReadableFiles.size();
            if (numOfNonReadableFiles > 0) {
                commaSeparatedListOfFiles.append(nonReadableFiles.get(0).getPath());
                for (int i = 1; i < numOfNonReadableFiles; ++i) {
                    commaSeparatedListOfFiles.append(", ");
                    commaSeparatedListOfFiles.append(nonReadableFiles.get(i).getPath());
                }
            }
            throw new RACTransErrorException((MessageKey)PrCfMsgID.NON_READABLE_CONTENTS, commaSeparatedListOfDirs.toString(), commaSeparatedListOfFiles.toString());
        }
        return dirListing.getTotalFilesize();
    }

    protected int getListenerPort() {
        return this.m_portNumber;
    }

    protected synchronized void addTransferResult(TransferResult transferResult) {
        Integer nodeID = transferResult.getTargetNodeID();
        TransferResult.TransferStatus transferStatus = transferResult.getTransferStatus();
        Trace.out("Received transfer result for node with ID=" + nodeID + ". Transfer status: " + transferStatus.toString());
        TransferResult tempTransferResult = this.m_resultMap.get(nodeID);
        if (tempTransferResult == null) {
            this.m_resultMap.put(nodeID, transferResult);
        } else {
            tempTransferResult.setTransferStatus(transferStatus);
        }
        int completedNodes = this.m_resultMap.size();
        String progressMsg = MessageBundle.getMessage(PrCfMsgID.TRANSFER_STATUS_UPDATE, false, this.m_nodeNameLookupMap.get(nodeID), transferStatus.toString(), completedNodes, this.m_totalNodes);
        Trace.out("Transfer result update:" + progressMsg);
        this.notifyProgressListeners(progressMsg, (String)this.m_nodeNameLookupMap.get(nodeID));
        Trace.out("Done with " + completedNodes + " out of " + this.m_totalNodes + " nodes");
        if (completedNodes == this.m_totalNodes && this.m_reportCollector != null) {
            this.m_reportCollector.stopConnectionListener();
            this.m_errorCheckingPermit.countDown();
        }
    }

    protected void updateNodeState(Integer nodeID, NodeStatusUpdate.NodeState nodeState) {
        Semaphore lock = this.m_statusUpdateLocks.get(nodeID);
        lock.acquireUninterruptibly();
        NodeStatusUpdate nodeStatusUpdate = this.m_statusUpdateMap.get(nodeID);
        NodeStatusUpdate.NodeState currNodeState = nodeStatusUpdate.getNodeState();
        if (currNodeState != null && !currNodeState.precedes(nodeState)) {
            lock.release();
            return;
        }
        nodeStatusUpdate.setNodeState(nodeState);
        Timeout timeout = this.m_timeoutLookup.get(nodeID);
        this.m_timeoutChecker.cancelTimer(timeout.getTimerID());
        if (nodeState != NodeStatusUpdate.NodeState.DONE) {
            timeout = new Timeout(nodeID, nodeState, this);
            String timerID = this.m_timeoutChecker.createTimer(timeout, nodeState.getTimeoutLimit());
            timeout.setTimerID(timerID);
            this.m_timeoutLookup.put(nodeID, timeout);
        }
        String nodeName = (String)this.m_nodeNameLookupMap.get(nodeID);
        String progressMsg = MessageBundle.getMessage(PrCfMsgID.NODE_STATE_UPDATE, true, nodeName, nodeState.toString());
        Trace.out("Node state update:" + progressMsg);
        this.notifyProgressListeners(progressMsg, nodeName);
        lock.release();
    }

    protected void updateTransferErrors(Integer sourceNodeID, Integer targetNodeID, String errorMsg, NodeStatusUpdate.ErrorType errorType, String pathname, TransferResult.TransferStatus errorCriticality) {
        Semaphore lock = this.m_statusUpdateLocks.get(targetNodeID);
        lock.acquireUninterruptibly();
        NodeStatusUpdate nodeStatusUpdate = this.m_statusUpdateMap.get(targetNodeID);
        nodeStatusUpdate.addError(errorMsg, errorCriticality);
        TransferResult transferResultSoFar = this.m_resultMap.get(targetNodeID);
        if (transferResultSoFar == null) {
            transferResultSoFar = new TransferResult(sourceNodeID, targetNodeID, TransferResult.TransferStatus.FAILURE);
            this.m_resultMap.put(targetNodeID, transferResultSoFar);
        }
        switch (errorType) {
            case GENERAL_ERROR: {
                Trace.out("General error: " + errorMsg);
                transferResultSoFar.addGeneralError(errorMsg);
                break;
            }
            case DIR_ERROR: {
                Trace.out("Dir-related error (" + pathname + "): " + errorMsg);
                transferResultSoFar.addDirError(pathname, errorMsg);
                break;
            }
            case FILE_ERROR: {
                Trace.out("File-related error (" + pathname + "): " + errorMsg);
                transferResultSoFar.addFileError(pathname, errorMsg);
                break;
            }
            case SYMLINK_ERROR: {
                Trace.out("Symlink-related error (" + pathname + "): " + errorMsg);
                transferResultSoFar.addSymlinkError(pathname, errorMsg);
            }
        }
        String nodeName = (String)this.m_nodeNameLookupMap.get(targetNodeID);
        if (nodeName != null) {
            String progressMsg = MessageBundle.getMessage(PrCfMsgID.TRANSFER_ERROR_UPDATE, true, nodeName, errorMsg);
            Trace.out("Transfer error update:" + progressMsg);
            this.notifyProgressListeners(progressMsg, nodeName);
        } else {
            Trace.out("Error encountered with node name not present in list of nodes to be copied to. (Java node)");
        }
        lock.release();
    }

    protected void addTimeout(Timeout timeout) {
        Integer targetNodeID = timeout.getNodeID();
        String targetNodeName = (String)this.m_nodeNameLookupMap.get(targetNodeID);
        Trace.out("Node \"" + targetNodeName + "\" (node ID=" + targetNodeID + ") timed out");
        Integer sourceNodeID = this.m_transferPlanner.getParentNodeID(targetNodeID);
        TransferResult transferResult = new TransferResult(sourceNodeID, targetNodeID, TransferResult.TransferStatus.TIMEOUT);
        this.m_resultMap.put(targetNodeID, transferResult);
        int completedNodes = this.m_resultMap.size();
        String progressMsg = MessageBundle.getMessage(PrCfMsgID.TRANSFER_STATUS_UPDATE, false, targetNodeID, TransferResult.TransferStatus.TIMEOUT.toString(), completedNodes, this.m_totalNodes);
        this.notifyProgressListeners(progressMsg, (String)this.m_nodeNameLookupMap.get(targetNodeID));
        if (completedNodes == this.m_totalNodes && this.m_reportCollector != null) {
            this.m_reportCollector.stopConnectionListener();
            this.m_errorCheckingPermit.countDown();
        }
    }

    protected void reportAbrnormalError(String error) {
        this.m_abnormalErrorBuffer.append(error);
        this.m_abnormalErrorBuffer.append(MultiTierTransferConstants.NEW_LINE);
    }

    protected ReportReader getReportReader() {
        return this.m_reportReader;
    }

    protected Map<Integer, String> getNodeNameLookupMap() {
        return this.m_nodeNameLookupMap;
    }

    protected Map<Integer, TransferResult> getResultMap() {
        return this.m_resultMap;
    }

    protected void checkForErrorsAndFetchLogs(String[] nodeNames, String logDirPathname) throws RemoteFileOpException, ClusterException {
        Trace.out("Checking for transfer errors");
        if (this.m_abnormalErrorBuffer.length() > 0) {
            Trace.out("Abnormal errors: " + MultiTierTransferConstants.NEW_LINE + this.m_abnormalErrorBuffer.toString());
        }
        int numOfNodes = nodeNames.length;
        boolean noSuccesses = true;
        boolean noErrors = true;
        StringBuilder clusterExceptionMsg = new StringBuilder();
        NativeResult[] results = new NativeResult[numOfNodes];
        Set<Integer> nodeIDs = this.m_nodeNameLookupMap.keySet();
        if (!nodeIDs.contains(0)) {
            NodeStatusUpdate generalUpdates = this.m_statusUpdateMap.get(0);
            List<TransferResult.TransferStatus> errorCriticalities = generalUpdates.getErrorCriticalities();
            List<String> errors = generalUpdates.getErrors();
            for (int i = 0; i < errorCriticalities.size(); ++i) {
                TransferResult.TransferStatus errorCriticality = errorCriticalities.get(i);
                if (errorCriticality == TransferResult.TransferStatus.WARNING) {
                    Trace.out("WARNING: " + errors.get(i));
                    continue;
                }
                if (errorCriticality != TransferResult.TransferStatus.FAILURE && errorCriticality != TransferResult.TransferStatus.CRITICAL_FAILURE) continue;
                clusterExceptionMsg.append(errors.get(i) + MultiTierTransferConstants.NEW_LINE);
            }
        }
        HashSet<Integer> failedNodeIDs = new HashSet<Integer>();
        HashSet<Integer> preocessedIndices = new HashSet<Integer>();
        block1: for (Integer nodeID : nodeIDs) {
            String nodeName = (String)this.m_nodeNameLookupMap.get(nodeID);
            TransferResult transferResult = this.m_resultMap.get(nodeID);
            if (transferResult == null) {
                Trace.out("No result for node \"" + (String)this.m_nodeNameLookupMap.get(nodeID) + "\" with node ID=" + nodeID);
                throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, true, "rorre022"));
            }
            if (transferResult.getStatus()) {
                noSuccesses = false;
            } else {
                failedNodeIDs.add(nodeID);
                noErrors = false;
            }
            if (noSuccesses) {
                clusterExceptionMsg.append(nodeName + ':' + transferResult.getOSString() + MultiTierTransferConstants.NEW_LINE);
            }
            for (int i = 0; i < numOfNodes; ++i) {
                if (!nodeNames[i].equalsIgnoreCase(nodeName) || preocessedIndices.contains(i)) continue;
                results[i] = transferResult;
                preocessedIndices.add(i);
                continue block1;
            }
        }
        if (noSuccesses) {
            this.fetchLogFiles(failedNodeIDs, logDirPathname);
            throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.CLUSTER_EXCEPTION_MESSAGE, true, clusterExceptionMsg.toString()));
        }
        if (!noErrors) {
            Trace.out("The transfer operation completed with errors");
            this.fetchLogFiles(failedNodeIDs, logDirPathname);
            StringBuilder errors = new StringBuilder();
            for (int i = 0; i < numOfNodes; ++i) {
                if (results[i].getStatus()) continue;
                Object[] args = new Object[]{nodeNames[i], results[i].getOSString()};
                String errorMsg = MessageBundle.getMessage(PrCfMsgID.ERRORS_PER_NODE, true, args);
                errors.append(errorMsg + MultiTierTransferConstants.NEW_LINE);
            }
            Trace.out(errors.toString());
            throw new RemoteFileOpException(errors.toString(), results);
        }
    }

    private void fetchLogFiles(Set<Integer> failedNodeIDs, String logDirPathname) {
        File logDir = new File(logDirPathname);
        try {
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            if (!logDir.canWrite()) {
                Trace.out("Directory \"" + logDirPathname + "\" does not have write access");
                return;
            }
        }
        catch (SecurityException se) {
            Trace.out("Cannot create directory \"" + logDirPathname + "\". Details: " + MultiTierTransferConstants.NEW_LINE + se.getMessage());
            return;
        }
        Map<String, String> logFilePathnames = this.m_transferPlanner.getLogFilePathnames(failedNodeIDs);
        Set<String> nodeNames = logFilePathnames.keySet();
        ClusterCmd clusterCmd = new ClusterCmd();
        for (String nodeName : nodeNames) {
            String logFilePathname = logFilePathnames.get(nodeName);
            String destFilePathname = logDirPathname + File.separator + new File(logFilePathname).getName();
            try {
                Trace.out("About to copy file \"" + logFilePathname + "\" from node " + nodeName + " to \"" + destFilePathname + "\" on the java-node");
                clusterCmd.copyFileFromNode(nodeName, logFilePathname, destFilePathname);
            }
            catch (ClusterException ce) {
                Trace.out("Error fetching log file \"" + logFilePathname + "\" from node \"" + nodeName + "\". Details:" + MultiTierTransferConstants.NEW_LINE + ce.getMessage());
            }
        }
    }

    protected void runJavaNodeMttransBinary(String binaryPathname, String planDirPathname) throws ClusterException {
        MultiTierTransferConstants.MTTRANS_CMD_ARGS[0] = binaryPathname;
        MultiTierTransferConstants.MTTRANS_CMD_ARGS[2] = planDirPathname;
        StringBuilder mttransCmd = new StringBuilder();
        for (int i = 0; i < MultiTierTransferConstants.MTTRANS_CMD_ARGS.length - 1; ++i) {
            mttransCmd.append(MultiTierTransferConstants.MTTRANS_CMD_ARGS[i] + " ");
        }
        mttransCmd.append(MultiTierTransferConstants.MTTRANS_CMD_ARGS[MultiTierTransferConstants.MTTRANS_CMD_ARGS.length - 1]);
        Trace.out("Mttrans command: " + mttransCmd.toString());
        RuntimeExec runtime = new RuntimeExec(MultiTierTransferConstants.MTTRANS_CMD_ARGS, null, null);
        runtime.runCommand();
        String[] cmdOutput = runtime.getOutput();
        String[] cmdError = runtime.getError();
        if (cmdError != null && cmdError.length != 0) {
            StringBuilder error = new StringBuilder();
            for (int i = 0; i < cmdError.length; ++i) {
                error.append(cmdError[i] + MultiTierTransferConstants.NEW_LINE);
            }
            Trace.out("Mttrans command error:" + error.toString());
            String errorMsg = MessageBundle.getMessage(PrCfMsgID.TRANSFER_BINARY_EXECUTION_ERROR, true, error.toString());
            throw new ClusterException(errorMsg);
        }
        if (cmdOutput != null && cmdOutput.length != 0) {
            StringBuilder output = new StringBuilder();
            for (int i = 0; i < cmdOutput.length; ++i) {
                output.append(cmdOutput[i] + MultiTierTransferConstants.NEW_LINE);
            }
            Trace.out("Mttrans command output:" + output.toString());
        }
    }

    protected String getMttransID() {
        StringBuilder mttransID = new StringBuilder();
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int a = 97;
        int z = 122;
        char randomChar = (char)(a + random.nextInt(z - a + 1));
        mttransID.append(randomChar);
        for (int i = 0; i < 7; ++i) {
            mttransID.append(random.nextInt(10));
        }
        return mttransID.toString();
    }

    private void notifyProgressListeners(String transferStatus, String nodeName) {
        for (NodeProgressListener progressListener : this.m_progressListeners) {
            if (nodeName != null) {
                progressListener.write(nodeName, transferStatus);
                continue;
            }
            progressListener.write(transferStatus);
        }
    }

    private void initNodeStates() {
        Set<Integer> nodeIDs = this.m_nodeNameLookupMap.keySet();
        if (!nodeIDs.contains(0)) {
            this.m_statusUpdateLocks.put(0, new Semaphore(1));
            this.m_statusUpdateMap.put(0, new NodeStatusUpdate(0, NodeStatusUpdate.NodeState.INIT));
        }
        for (Integer nodeID : nodeIDs) {
            this.m_statusUpdateMap.put(nodeID, new NodeStatusUpdate(nodeID, NodeStatusUpdate.NodeState.INIT));
            this.m_statusUpdateLocks.put(nodeID, new Semaphore(1));
        }
    }

    private void initTimeouts() {
        Set<Integer> nodeIDs = this.m_nodeNameLookupMap.keySet();
        NodeStatusUpdate.NodeState initState = NodeStatusUpdate.NodeState.INIT;
        for (Integer nodeID : nodeIDs) {
            Timeout timeout = new Timeout(nodeID, initState, this);
            String timerID = this.m_timeoutChecker.createTimer(timeout, initState.getTimeoutLimit());
            timeout.setTimerID(timerID);
            this.m_timeoutLookup.put(nodeID, timeout);
        }
    }
}

