/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public class FileHandler {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String END_OF_STREAM = null;
    private static final int BUFFER_SIZE = 1024;
    public static final String COMMENT_IDENTIFIER = "#";

    public static String readFile(String filePathname) throws RACTransErrorException {
        List<String> fileLines = FileHandler.readFile(filePathname, false, false);
        String fileContentsAsSingleString = "";
        for (String currLine : fileLines) {
            fileContentsAsSingleString = fileContentsAsSingleString + currLine + NEW_LINE;
        }
        return fileContentsAsSingleString;
    }

    public static List<String> readFile(String filePathname, boolean skipEmptyLines, boolean skipCommentLines) throws RACTransErrorException {
        BufferedInputStream bufInStream;
        try {
            bufInStream = new BufferedInputStream(new FileInputStream(filePathname), 1024);
        }
        catch (IOException ioe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_CANNOT_BE_OPENED_FOR_READING, (Throwable)ioe, filePathname, ioe.getMessage());
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufInStream));
        ArrayList<String> processedLines = new ArrayList<String>();
        try {
            String currLine;
            while ((currLine = bufferedReader.readLine()) != END_OF_STREAM) {
                currLine = currLine.trim();
                boolean skipCurrLine = skipEmptyLines && currLine.equals("") || skipCommentLines && currLine.startsWith(COMMENT_IDENTIFIER);
                if (skipCurrLine) continue;
                processedLines.add(currLine);
            }
            bufInStream.close();
            bufferedReader.close();
            return processedLines;
        }
        catch (IOException ioe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_READ_ERROR, (Throwable)ioe, filePathname, ioe.getMessage());
        }
    }

    public static boolean writeFile(String filePathname, List<String> contents, boolean append) throws RACTransErrorException {
        BufferedWriter bufferedWriter;
        FileWriter fileWriter;
        try {
            fileWriter = new FileWriter(filePathname, append);
            bufferedWriter = new BufferedWriter(fileWriter);
        }
        catch (IOException ioe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.CANNOT_CREATE_FILE_FOR_WRITING, (Throwable)ioe, filePathname, ioe.getMessage());
        }
        try {
            for (String currString : contents) {
                bufferedWriter.write(currString);
            }
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException ioe) {
            throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_WRITE_ERROR, (Throwable)ioe, filePathname, ioe.getMessage());
        }
        return true;
    }
}

