/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment.ractrans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.concurrent.Semaphore;
import oracle.cluster.deployment.ractrans.ClientHandlerSupervisor;
import oracle.cluster.deployment.ractrans.ConnectionInfo;
import oracle.cluster.deployment.ractrans.FileDescriptor;
import oracle.cluster.deployment.ractrans.RACTransErrorException;
import oracle.cluster.deployment.ractrans.RACTransWarningException;
import oracle.cluster.deployment.ractrans.RACTransferConstants;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ClientHandler {
    private final String m_msgFormat = "------------> {0} encountered InterruptedException while {1}. <------------";
    private Socket m_socketToServer;
    private OutputStream m_outputStream;
    private ClientHandlerSupervisor m_clientHandlerSupervisor;
    private int m_nodeID;
    private String m_nodeName;
    private Object m_inputStream_lock;
    private Semaphore m_canSend;
    private Semaphore m_canReceive;
    private boolean m_sendingMkdirCommands;
    private boolean m_sendingMklinkCommands;
    private boolean m_sendingWrfileCommands;
    private boolean m_connectionLost;
    private String m_expectedReply;
    private String m_replyStr;
    private Semaphore m_remoteNodeReply;
    private InputHandler m_inputHandlerThread;

    protected ClientHandler(ClientHandlerSupervisor clientHandlerSupervisor, InetAddress hostNameOrIP, int port, int nodeID, String nodeName) throws RACTransWarningException {
        this.m_clientHandlerSupervisor = clientHandlerSupervisor;
        this.m_nodeID = nodeID;
        this.m_nodeName = nodeName;
        this.m_connectionLost = false;
        this.m_inputStream_lock = new Object();
        this.m_canSend = new Semaphore(1);
        this.m_canReceive = new Semaphore(0);
        this.m_remoteNodeReply = new Semaphore(0);
        try {
            this.m_socketToServer = new Socket(hostNameOrIP, port);
            this.m_outputStream = this.m_socketToServer.getOutputStream();
            this.m_inputHandlerThread = new InputHandler(this.m_socketToServer);
            this.m_inputHandlerThread.start();
        }
        catch (IOException ioe) {
            throw new RACTransWarningException((MessageKey)PrCfMsgID.CONNECTION_REFUSED, hostNameOrIP.getHostAddress(), port);
        }
    }

    protected Socket getSocketToServer() {
        return this.m_socketToServer;
    }

    private void receive_acquirePermit(InputStream inputStream) throws InterruptedException, RACTransErrorException {
        try {
            this.m_canReceive.acquire();
        }
        catch (InterruptedException ie) {
            String exceptionMessage = MessageFormat.format("------------> {0} encountered InterruptedException while {1}. <------------", "The thread waiting for reply from node \"\"" + this.m_nodeName + "\" got interrupted." + "This is expected only at the end of the " + "transfer operation to clean up the " + "thread resources");
            throw new InterruptedException(exceptionMessage);
        }
        if (this.m_connectionLost) {
            return;
        }
        byte[] dataIn = this.receive(inputStream);
        this.m_replyStr = this.m_replyStr + new String(dataIn);
        if (this.completeReplyReceived(this.m_replyStr)) {
            boolean successfulExecution = this.m_replyStr.equals(this.m_expectedReply);
            if (!successfulExecution) {
                Trace.out("Reply mismatch: Expected \"" + this.m_expectedReply + "\" but received \"" + this.m_replyStr + "\" from remote node \"" + this.m_nodeName + "\"");
                this.appendErrorLog(this.m_clientHandlerSupervisor.getConnectionInfo(this.m_nodeID));
            }
            this.m_replyStr = "";
            this.m_canSend.release();
        } else {
            this.m_canReceive.release();
        }
    }

    private byte[] receive(InputStream inputStream) throws RACTransErrorException {
        byte[] buffer = new byte[65536];
        int numOfUsefulBytes = 0;
        try {
            numOfUsefulBytes = inputStream.read(buffer);
        }
        catch (IOException ioe) {
            Trace.out("Encountered IOException while receving the input data");
            this.signalConnectionLost();
            Trace.out("Connection to node \"" + this.m_nodeName + "\" was lost while receiving data.");
            String errorDescription = MessageBundle.getMessage(PrCfMsgID.CONNECTION_LOST_DATA_IN, true, this.m_nodeName);
            throw new RACTransErrorException(errorDescription);
        }
        if (numOfUsefulBytes < 0) {
            Trace.out("Warning! Dropping the connection to node \"" + this.m_nodeName + "\" as the end of the stream has been reached!");
            this.signalConnectionLost();
            Trace.out("Connection to node \"" + this.m_nodeName + "\" was lost while receiving data.");
            String errorDescription = MessageBundle.getMessage(PrCfMsgID.CONNECTION_LOST_DATA_IN, true, this.m_nodeName);
            throw new RACTransErrorException(errorDescription);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(numOfUsefulBytes);
        byteBuffer.put(buffer, 0, numOfUsefulBytes);
        return byteBuffer.array();
    }

    protected void send_singlePacket(byte[] dataOut) throws RACTransErrorException {
        if (this.m_connectionLost) {
            return;
        }
        try {
            this.m_canSend.acquire();
        }
        catch (InterruptedException ie) {
            Trace.out(MessageFormat.format("------------> {0} encountered InterruptedException while {1}. <------------", "Node \"" + this.m_nodeName + "\"", "acquiring the permit to send data (in this case single-packet)"));
            throw new RACTransErrorException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre006");
        }
        this.send(dataOut);
        this.setExpectedReply(dataOut);
        if (this.m_expectedReply.equals("")) {
            this.m_canSend.release();
        } else {
            this.m_canReceive.release();
            try {
                this.m_remoteNodeReply.acquire();
            }
            catch (InterruptedException ie) {
                Trace.out(MessageFormat.format("------------> {0} encountered InterruptedException while {1}. <------------", "Node \"" + this.m_nodeName + "\"", "acquiring the permit to receive data (in this case single-packet)"));
                throw new RACTransErrorException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre007");
            }
        }
    }

    protected void send_multiPacket(byte[] dataOut) throws RACTransErrorException {
        if (this.m_connectionLost) {
            return;
        }
        try {
            this.m_canSend.acquire();
        }
        catch (InterruptedException ie) {
            Trace.out(MessageFormat.format("------------> {0} encountered InterruptedException while {1}. <------------", "Node \"" + this.m_nodeName + "\"", "acquiring the permit to send data (in this case multi-packet byte-array)"));
            throw new RACTransErrorException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre008");
        }
        this.send(dataOut);
        this.setExpectedReply(dataOut);
        this.m_canSend.release();
    }

    protected void send_multiPacket(FileDescriptor file) throws RACTransErrorException {
        FileInputStream fileInputStream;
        if (this.m_connectionLost) {
            return;
        }
        try {
            this.m_canSend.acquire();
        }
        catch (InterruptedException ie) {
            Trace.out(MessageFormat.format("------------> {0} encountered InterruptedException while {1}. <------------", "Node \"" + this.m_nodeName + "\"", "acquiring the permit to send data (in this case multi-packet file)"));
            throw new RACTransErrorException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre009");
        }
        long filesize = file.length();
        long numOfBytesSentSoFar = 0L;
        long numOfBytesToSend = filesize;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fnfe) {
            Trace.out("Error in ClientHandlrer.send_multiPacket() because file \"" + file.getPath() + "\" was not found");
            throw new RACTransErrorException((MessageKey)PrCfMsgID.FILE_NOT_FOUND, file.getPath());
        }
        FileChannel fileChannel = fileInputStream.getChannel();
        byte[] bytes2send = null;
        while (numOfBytesToSend > 0L) {
            bytes2send = this.getBytesFromFile(fileChannel, numOfBytesSentSoFar);
            if (bytes2send != null) {
                if ((long)bytes2send.length <= numOfBytesToSend) {
                    this.send(bytes2send);
                    numOfBytesToSend -= (long)bytes2send.length;
                    numOfBytesSentSoFar += (long)bytes2send.length;
                    continue;
                }
                Trace.out("File \"" + file.getPath() + "\" is changing with time (growing in size). " + "Initially it had " + filesize + " bytes, while now it has " + new File(file.getPath()).length() + " bytes.");
                ByteBuffer byteBuffer = ByteBuffer.allocate((int)numOfBytesToSend);
                byteBuffer.put(bytes2send, 0, (int)numOfBytesToSend);
                this.send(byteBuffer.array());
                numOfBytesToSend = 0L;
                continue;
            }
            Trace.out("File \"" + file.getPath() + "\" is changing with time (shrinking in size). " + "Initially it had " + filesize + " bytes, while now it has " + numOfBytesSentSoFar + " bytes.");
            String errorDescription = MessageBundle.getMessage(PrCfMsgID.FILE_SHRINKING_WITH_TIME, true, file.getPath());
            this.appendErrorLog(errorDescription);
            byte[] nullByteFullBuffer = this.getNullByteArray(65536);
            while (numOfBytesToSend > 65536L) {
                this.send(nullByteFullBuffer);
                numOfBytesToSend -= 65536L;
            }
            if (numOfBytesToSend <= 0L) continue;
            bytes2send = this.getNullByteArray((int)numOfBytesToSend);
            this.send(bytes2send);
            numOfBytesToSend = 0L;
        }
        try {
            fileInputStream.close();
            if (fileChannel != null) {
                fileChannel.close();
            }
        }
        catch (IOException errorDescription) {
            // empty catch block
        }
        this.m_canReceive.release();
        try {
            this.m_remoteNodeReply.acquire();
        }
        catch (InterruptedException ie) {
            Trace.out(MessageFormat.format("------------> {0} encountered InterruptedException while {1}. <------------", "Node \"" + this.m_nodeName + "\"", "acquiring the remote node reply permit to check if an error occured for the file that the local node just sent to remote node \"" + this.m_nodeName + "\""));
            throw new RACTransErrorException((MessageKey)PrCfMsgID.UNEXPECTED_INTERNAL_ERROR, "rorre010");
        }
    }

    protected synchronized void send(byte[] dataOut) throws RACTransErrorException {
        if (this.m_connectionLost) {
            return;
        }
        try {
            if (this.m_outputStream != null) {
                this.m_outputStream.write(dataOut);
                this.m_outputStream.flush();
            }
        }
        catch (SocketException se) {
            Trace.out("Warning! SocketException encountered.");
            this.m_outputStream = null;
            this.signalConnectionLost();
            String errorDescription = MessageBundle.getMessage(PrCfMsgID.CONNECTION_LOST_DATA_OUT, true, this.m_nodeName);
            Trace.out("Connection to node \"" + this.m_nodeName + "\" lost while sending data.");
            throw new RACTransErrorException(errorDescription);
        }
        catch (IOException ioe) {
            Trace.out("Dropping the output stream for node \"" + this.m_nodeName + "\"");
            this.m_outputStream = null;
            this.signalConnectionLost();
            String errorDescription = MessageBundle.getMessage(PrCfMsgID.CONNECTION_LOST_DATA_OUT, true, this.m_nodeName);
            Trace.out("Connection to node \"" + this.m_nodeName + "\" lost while sending data.");
            throw new RACTransErrorException(errorDescription);
        }
    }

    protected void closeSocket() {
        this.m_inputHandlerThread.interrupt();
        try {
            if (this.m_socketToServer != null) {
                this.m_socketToServer.close();
            }
        }
        catch (IOException ioe) {
            Trace.out("Problem encountered while closing the socket for node \"" + this.m_nodeName + "\"");
        }
    }

    private byte[] getBytesFromFile(FileChannel fileChannel, long position) {
        long numOfBytesRead;
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        try {
            numOfBytesRead = fileChannel.read(byteBuffer, position);
        }
        catch (IOException ioe) {
            Trace.out("I/O error occured.");
            return null;
        }
        if (numOfBytesRead < 0L) {
            Trace.out("ERROR! EOF is reached while reading bytes from the file channel.");
            return null;
        }
        if (numOfBytesRead == 65536L) {
            return byteBuffer.array();
        }
        ByteBuffer byteSubBuffer = ByteBuffer.allocate((int)numOfBytesRead);
        byteSubBuffer.put(byteBuffer.array(), 0, byteSubBuffer.capacity());
        return byteSubBuffer.array();
    }

    private void setExpectedReply(byte[] dataOut) {
        this.m_expectedReply = "";
        String dataOutStr = new String(dataOut);
        if (dataOutStr.equals("<0><4>quit")) {
            return;
        }
        if (dataOut != null) {
            if (dataOutStr.startsWith(RACTransferConstants.MKDIR_IDENTIFIER)) {
                dataOutStr = dataOutStr.substring(RACTransferConstants.MKDIR_IDENTIFIER.length(), dataOutStr.length());
                this.m_sendingMkdirCommands = true;
            } else if (dataOutStr.startsWith(RACTransferConstants.MKLINK_IDENTIFIER)) {
                dataOutStr = dataOutStr.substring(RACTransferConstants.MKLINK_IDENTIFIER.length(), dataOutStr.length());
                this.m_sendingMklinkCommands = true;
            } else if (dataOutStr.startsWith(RACTransferConstants.WRFILE_IDENTIFIER)) {
                this.m_sendingWrfileCommands = true;
            }
            if (this.m_sendingMkdirCommands) {
                int permissionStartIndex = dataOutStr.indexOf("[m");
                if (permissionStartIndex != -1) {
                    this.m_expectedReply = dataOutStr.substring(0, permissionStartIndex) + RACTransferConstants.OK_IDENTIFIER;
                }
            } else if (this.m_sendingMklinkCommands) {
                String dataOutWithoutEndOfCommand = "";
                dataOutWithoutEndOfCommand = !dataOutStr.endsWith("<0>") ? dataOutStr : dataOutStr.substring(0, dataOutStr.indexOf("<0>"));
                int startIndex = dataOutWithoutEndOfCommand.indexOf(">");
                if ((startIndex = dataOutWithoutEndOfCommand.indexOf("<", startIndex)) != -1) {
                    this.m_expectedReply = dataOutStr.substring(startIndex, dataOutWithoutEndOfCommand.length()) + RACTransferConstants.OK_IDENTIFIER;
                }
            } else if (this.m_sendingWrfileCommands) {
                int offsetStartIndex;
                if (dataOutStr.startsWith(RACTransferConstants.WRFILE_IDENTIFIER)) {
                    dataOutStr = dataOutStr.substring(RACTransferConstants.WRFILE_IDENTIFIER.length(), dataOutStr.length());
                }
                if ((offsetStartIndex = dataOutStr.indexOf("[m")) != -1) {
                    this.m_expectedReply = dataOutStr.substring(0, offsetStartIndex) + RACTransferConstants.OK_IDENTIFIER;
                }
            }
            if (dataOutStr.endsWith("<0>")) {
                int endOfCommandIndex = this.m_expectedReply.indexOf("<0>");
                if (endOfCommandIndex != -1) {
                    this.m_expectedReply = this.m_expectedReply.substring(0, endOfCommandIndex);
                }
                this.m_sendingMkdirCommands = false;
                this.m_sendingMklinkCommands = false;
            }
        }
    }

    private boolean completeReplyReceived(String reply) {
        int fromIndex = reply.indexOf(">");
        int endOfReplyMessage = reply.indexOf(">", fromIndex + 1);
        return endOfReplyMessage != -1;
    }

    private void signalConnectionLost() throws RACTransErrorException {
        String errorDescription = MessageBundle.getMessage(PrCfMsgID.CONNECTION_LOST, true, this.m_nodeName);
        this.appendErrorLog(errorDescription);
        Trace.out("Lost connection to node \"" + this.m_nodeName + "\"");
        ConnectionInfo connectionInfo = this.m_clientHandlerSupervisor.getConnectionInfo(this.m_nodeID);
        this.m_clientHandlerSupervisor.setConnectionLost(connectionInfo);
        this.m_connectionLost = true;
        this.m_canReceive.release();
        this.m_canSend.release();
        this.m_remoteNodeReply.release();
        throw new RACTransErrorException((MessageKey)PrCfMsgID.CONNECTION_LOST, true, this.m_nodeName);
    }

    private void appendErrorLog(ConnectionInfo connectionInfo) {
        connectionInfo.setStatus(RACTransferConstants.Connection.COMMAND_ERROR);
        String commandThatFailed = "";
        if (this.m_sendingMkdirCommands) {
            commandThatFailed = "mkdir";
        } else if (this.m_sendingMklinkCommands) {
            commandThatFailed = "mklink";
        } else if (this.m_sendingWrfileCommands) {
            commandThatFailed = "wrfile";
        }
        int beginIndex = this.m_replyStr.indexOf(">") + 1;
        int endIndex = this.m_replyStr.lastIndexOf("<");
        String contentThatFailed = this.m_replyStr.substring(beginIndex, endIndex);
        beginIndex = this.m_replyStr.lastIndexOf(">") + 1;
        String errorMsg = this.m_replyStr.substring(beginIndex, this.m_replyStr.length());
        String errorDescription = MessageBundle.getMessage(PrCfMsgID.COMMAND_EXECUTION_ERROR, true, commandThatFailed, contentThatFailed, connectionInfo.getNodeName(), errorMsg);
        connectionInfo.appendErrorLog(errorDescription);
        this.m_clientHandlerSupervisor.updateConnectionInfo(connectionInfo.getNodeID(), connectionInfo);
    }

    private void appendErrorLog(String errorDescription) {
        ConnectionInfo connectionInfo = this.m_clientHandlerSupervisor.getConnectionInfo(this.m_nodeID);
        connectionInfo.appendErrorLog(errorDescription);
        this.m_clientHandlerSupervisor.updateConnectionInfo(this.m_nodeID, connectionInfo);
    }

    private byte[] getNullByteArray(int length) {
        if (length < 0 || length > 65536) {
            Trace.out("The number of bytes of the byte array that will be generated cannot be less than zero or more than the BUFFER_SIZE (65536 bytes).");
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        return byteBuffer.array();
    }

    private class InputHandler
    extends Thread {
        private Socket socketToServer;

        private InputHandler(Socket socketToServer) {
            this.socketToServer = socketToServer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ConnectionInfo connectionInfo = null;
            try {
                InputStream inputStream = this.socketToServer.getInputStream();
                connectionInfo = new ConnectionInfo(ClientHandler.this.m_clientHandlerSupervisor, ClientHandler.this.m_nodeID, ClientHandler.this.m_nodeName, this.socketToServer);
                ClientHandler.this.m_clientHandlerSupervisor.setConnectionEstablished(connectionInfo);
                ClientHandler.this.m_replyStr = "";
                while (true) {
                    Object object = ClientHandler.this.m_inputStream_lock;
                    synchronized (object) {
                        try {
                            ClientHandler.this.receive_acquirePermit(inputStream);
                        }
                        catch (InterruptedException ie) {
                            Trace.out(ie.getMessage());
                            return;
                        }
                        ClientHandler.this.m_remoteNodeReply.release();
                    }
                }
            }
            catch (RACTransErrorException ree) {
                Trace.out("RACTransErrorException in InputHandler.run() thrown by receive_acquirePermit(). Details:" + RACTransferConstants.NEW_LINE + ree.getMessage());
                ClientHandler.this.m_clientHandlerSupervisor.reportConnectionError(ClientHandler.this.m_nodeID, ree.getMessage());
                return;
            }
            catch (IOException ioe) {
                Trace.out("Error obtaining input stream from socket. Details:" + RACTransferConstants.NEW_LINE + ioe.getMessage());
                ClientHandler.this.m_clientHandlerSupervisor.reportConnectionError(ClientHandler.this.m_nodeID, ioe.getMessage());
            }
        }
    }
}

