/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.cluster.deployment.LWServerPoolException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class LWServerPool {
    private List<String> m_ActiveServerList = new ArrayList<String>();
    private List<String> m_CandServerList = new ArrayList<String>();
    private String m_Category;
    private String m_Name;
    private int m_MinSize;
    private int m_MaxSize = -1;
    private int m_Importance;

    private LWServerPool() {
    }

    public LWServerPool(String serverpoolName, String category, int importance, int minSize, int maxSize, List<String> activeServerList, List<String> candidateServerList) throws LWServerPoolException {
        if (serverpoolName == null || serverpoolName.trim().length() == 0) {
            throw new LWServerPoolException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverpoolName");
        }
        if (minSize < 0) {
            throw new LWServerPoolException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "minSize");
        }
        this.m_Name = serverpoolName;
        Trace.out("LWServerPool object: name " + serverpoolName);
        this.m_MinSize = minSize;
        this.m_Importance = importance;
        this.m_MaxSize = maxSize;
        if (category != null && category.trim().length() != 0) {
            this.m_Category = category;
            Trace.out("Category : " + category);
        }
        if (activeServerList != null && !activeServerList.isEmpty()) {
            this.m_ActiveServerList = activeServerList;
            Trace.out("activeServerList " + Arrays.toString(activeServerList.toArray()));
        }
        if (candidateServerList != null && !candidateServerList.isEmpty()) {
            this.m_CandServerList = candidateServerList;
            Trace.out("candidateServerList " + Arrays.toString(candidateServerList.toArray()));
        }
    }

    public LWServerPool(String serverpoolName, String category) throws LWServerPoolException {
        if (serverpoolName == null || serverpoolName.trim().length() == 0) {
            throw new LWServerPoolException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverpoolName");
        }
        this.m_Name = serverpoolName;
        Trace.out("LWServerPool object: name " + serverpoolName);
        if (category == null || category.trim().length() == 0) {
            throw new LWServerPoolException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "category");
        }
        this.m_Category = category;
        Trace.out("Category : " + category);
    }

    public LWServerPool(String serverpoolName, String category, int importance, int minSize, int maxSize) throws LWServerPoolException {
        if (serverpoolName == null || serverpoolName.trim().length() == 0) {
            throw new LWServerPoolException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "serverpoolName");
        }
        if (minSize < 0) {
            throw new LWServerPoolException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "minSize");
        }
        this.m_Name = serverpoolName;
        Trace.out("LWServerPool object: name " + serverpoolName);
        this.m_MinSize = minSize;
        if (category != null && category.trim().length() != 0) {
            this.m_Category = category;
            Trace.out("Category : " + category);
        }
        this.m_Importance = importance;
        this.m_MaxSize = maxSize;
    }

    public String getServerPoolName() {
        return this.m_Name;
    }

    public String getCategory() {
        return this.m_Category;
    }

    public int getMinSize() {
        return this.m_MinSize;
    }

    public int getMaxSize() {
        return this.m_MaxSize;
    }

    public List<String> getActiveServers() {
        return this.m_ActiveServerList;
    }

    public List<String> getCandidateServers() {
        return this.m_CandServerList;
    }

    public int getImportance() {
        return this.m_Importance;
    }
}

