/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.deployment;

import java.io.File;
import java.util.List;
import oracle.cluster.common.ProgressListener;
import oracle.cluster.deployment.ractrans.RapidTransfer;
import oracle.cluster.deployment.ractrans.RemoteFileOpException;
import oracle.cluster.resources.PrCfMsgID;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;

public class FileTransfer {
    private static final boolean IS_UNIX_SYSTEM = new SystemFactory().CreateSystem().isUnixSystem();
    private static MessageBundle s_msgBundlePrCf = MessageBundle.getMessageBundle(PrCfMsgID.facility);

    private void assertDir(String dirName) throws ClusterException {
        if (dirName == null || dirName.trim().length() == 0 || !new File(dirName).isDirectory()) {
            Object[] args = new Object[]{dirName};
            throw new ClusterException(MessageBundle.getMessage(PrCfMsgID.NOT_A_DIR, true, args));
        }
    }

    public void rapidTransferDirToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs) throws RemoteFileOpException, ClusterException {
        this.rapidTransferDirToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, null);
    }

    public void rapidTransferDirToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String[] remoteNodeDestDirs, List<ProgressListener> progressListeners) throws RemoteFileOpException, ClusterException {
        if (IS_UNIX_SYSTEM) {
            this.assertDir(topLevelDir);
            this.assertDir(oracleHome);
            RapidTransfer rapidTransfer = new RapidTransfer();
            rapidTransfer.transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestDirs, progressListeners);
        }
    }
}

