/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.resources.PrCdMsgID;
import oracle.ops.mgmt.nls.MessageKey;

public enum StartOptions {
    MOUNT("mount"),
    NOMOUNT("nomount"),
    OPEN("open", true),
    EXCLUSIVE("exclusive"),
    FORCE("force", true),
    RESTRICT("restrict"),
    READONLY("read only", true),
    READWRITE("read write", true);

    private String m_startOpt;
    private boolean m_allowedWService;

    private StartOptions(String startOpt) {
        this(startOpt, false);
    }

    private StartOptions(String startOpt, boolean allowedWService) {
        this.m_startOpt = startOpt;
        this.m_allowedWService = allowedWService;
    }

    public String toString() {
        return this.m_startOpt;
    }

    public static StartOptions getEnumMember(String startOpt) throws DatabaseException {
        for (StartOptions opt : StartOptions.values()) {
            if (!opt.toString().equalsIgnoreCase(startOpt)) continue;
            return opt;
        }
        throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_START_OPTION, startOpt);
    }

    public static List<StartOptions> getEnumMemberList(String startOpts) throws DatabaseException {
        String[] optionsArr = startOpts.split(Pattern.quote(String.valueOf(" ")));
        ArrayList<StartOptions> optList = new ArrayList<StartOptions>(optionsArr.length);
        for (String option : optionsArr) {
            for (StartOptions mbr : StartOptions.values()) {
                if (!mbr.toString().equalsIgnoreCase(option)) continue;
                optList.add(mbr);
            }
        }
        if (optionsArr.length > 1) {
            for (int i = 1; i < optionsArr.length; ++i) {
                String option = optionsArr[i - 1] + String.valueOf(" ") + optionsArr[i];
                for (StartOptions mbr : StartOptions.values()) {
                    if (!mbr.toString().equalsIgnoreCase(option)) continue;
                    optList.add(mbr);
                }
            }
        }
        if (optList.size() > 0) {
            return optList;
        }
        throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_START_OPTION, startOpts);
    }

    public boolean isValidForService() {
        return this.m_allowedWService;
    }
}

