/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import java.util.List;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.database.Database;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.ServiceException;
import oracle.cluster.database.ServiceTAF;
import oracle.cluster.database.ServiceType;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;

public interface Service
extends SoftwareModule {
    public boolean isCardinal() throws ServiceException;

    public CRSResource crsResource() throws NotExistsException, ServiceException;

    public Database database() throws ServiceException;

    public List<DatabaseInstance> getProviderInstances() throws ServiceException;

    public void start(boolean var1) throws AlreadyRunningException, SoftwareModuleException;

    public void start(StartOptions[] var1) throws AlreadyRunningException, CompositeOperationException, ServiceException;

    public void start(StartOptions[] var1, boolean var2) throws AlreadyRunningException, CompositeOperationException, ServiceException;

    public void start(List<DatabaseInstance> var1, StartOptions[] var2, boolean var3) throws AlreadyRunningException, CompositeOperationException, ServiceException;

    public void start(List<DatabaseInstance> var1, StartOptions[] var2) throws AlreadyRunningException, CompositeOperationException, ServiceException;

    public void start(ServiceArgs var1) throws AlreadyRunningException, CompositeOperationException, ServiceException;

    public void start(List<DatabaseInstance> var1, ServiceArgs var2) throws AlreadyRunningException, CompositeOperationException, ServiceException;

    public void stop(List<DatabaseInstance> var1, StopOptions[] var2, boolean var3, boolean var4) throws AlreadyStoppedException, CompositeOperationException, ServiceException;

    public void stop(List<DatabaseInstance> var1, StopOptions[] var2, boolean var3, boolean var4, boolean var5) throws AlreadyStoppedException, CompositeOperationException, ServiceException;

    public void stop(List<DatabaseInstance> var1, StopOptions[] var2, boolean var3) throws AlreadyStoppedException, CompositeOperationException, ServiceException;

    public void stop(StopOptions[] var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, ServiceException;

    public void stop(StopOptions[] var1, boolean var2, boolean var3) throws AlreadyStoppedException, CompositeOperationException, ServiceException;

    public void stop(StopOptions[] var1, boolean var2, boolean var3, boolean var4) throws AlreadyStoppedException, CompositeOperationException, ServiceException;

    public String getEdition() throws ServiceException;

    public String getTranslationProfile() throws ServiceException;

    public String getPDB() throws ServiceException;

    public boolean isGlobal() throws ServiceException;

    public boolean isRFService() throws ServiceException;

    public String getMaxLagTime() throws ServiceException;

    public ServiceTAF getTAF() throws ServiceException;

    public void setTAF(ServiceTAF var1) throws ServiceException;

    public String getDrainTimeout() throws ServiceException;

    public void remove(boolean var1, boolean var2) throws AlreadyRunningException, ServiceException;

    public void remove(boolean var1) throws AlreadyRunningException, ServiceException;

    public void enable(boolean var1) throws AlreadyEnabledException, SoftwareModuleException;

    public void enable(List<Node> var1) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException;

    public void enable(List<Node> var1, boolean var2) throws AlreadyEnabledException, CompositeOperationException, SoftwareModuleException;

    public void disable(boolean var1) throws AlreadyDisabledException, SoftwareModuleException;

    public void disable(List<Node> var1) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException;

    public void disable(List<Node> var1, boolean var2) throws AlreadyDisabledException, CompositeOperationException, SoftwareModuleException;

    public String getMainService() throws ServiceException;

    public String getPQService() throws ServiceException;

    public void setPQService(String var1) throws ServiceException;

    public ServiceType getServiceType() throws ServiceException;

    public ServerGroup getServerGroup() throws ServiceException;

    public void setServiceType(ServiceType var1) throws ServiceException;

    public ServiceArgs getArgs() throws ServiceException;

    public void updateCSSCritical(CRSResource.CSSCritical var1) throws InvalidArgsException, ServiceException;

    public boolean isCSSCritical() throws ServiceException;

    public boolean isJavaService() throws ServiceException, NotRunningException;
}

