/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.OmotionListener;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCdMsgID;
import oracle.cluster.server.Node;
import oracle.ops.mgmt.nls.MessageKey;

public class OmotionArgs {
    private Node m_targetNode = null;
    private Integer m_timeout = null;
    private OmotionListener m_listener = null;
    private boolean m_removeTarget = false;
    private String m_stopOption = null;
    private Integer m_drainTimeout = null;

    public void setTargetNode(Node targetNode) throws DatabaseException {
        this.sureNotNull(targetNode, "targetNode");
        this.m_targetNode = targetNode;
    }

    public Node getTargetNode() {
        return this.m_targetNode;
    }

    public void setOnlineRelocationTimeout(int timeout) throws DatabaseException {
        if (timeout < 1 || timeout > 720) {
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_OMOTION_TIMEOUT, timeout, 1, 720);
        }
        this.m_timeout = timeout;
    }

    public Integer getOnlineRelocationTimeout() {
        return this.m_timeout;
    }

    public void setOmotionListener(OmotionListener listener) throws DatabaseException {
        this.sureNotNull(listener, "listener");
        this.m_listener = listener;
    }

    public OmotionListener getOmotionListener() {
        return this.m_listener;
    }

    public void setRemoveTargetNode(boolean removeTarget) {
        this.m_removeTarget = removeTarget;
    }

    public boolean isRemoveTargetNode() {
        return this.m_removeTarget;
    }

    public void setStopOption(String option) {
        this.m_stopOption = option;
    }

    public String getStopOption() {
        return this.m_stopOption;
    }

    public void setDrainTimeout(Integer timeout) throws DatabaseException {
        this.sureNotNull(timeout, "OmotionArgs-drain_timeout");
        if (timeout < -1) {
            throw new DatabaseException((MessageKey)PrCdMsgID.INVALID_INTEGER, timeout.toString());
        }
        this.m_drainTimeout = timeout;
    }

    public Integer getDrainTimeout() {
        return this.m_drainTimeout;
    }

    private void sureNotNull(Object o, String name) throws DatabaseException {
        if (o == null) {
            throw new DatabaseException((MessageKey)PrCcMsgID.PARAM_CANNOT_BE_NULL, name);
        }
    }
}

