/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.database;

import java.util.List;
import java.util.Map;
import oracle.cluster.asm.AsmClusterFileSystem;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.crs.CRSNeedForceException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.VersionMismatchException;
import oracle.cluster.database.AlreadyInOptionException;
import oracle.cluster.database.DBRole;
import oracle.cluster.database.DatabaseException;
import oracle.cluster.database.DatabaseInstance;
import oracle.cluster.database.DatabaseOptionalArgs;
import oracle.cluster.database.DatabaseType;
import oracle.cluster.database.IncompatibleOptionException;
import oracle.cluster.database.InstanceException;
import oracle.cluster.database.ManagementPolicy;
import oracle.cluster.database.MoveDatabaseException;
import oracle.cluster.database.SIDBType;
import oracle.cluster.database.Service;
import oracle.cluster.database.ServiceArgs;
import oracle.cluster.database.StartOptions;
import oracle.cluster.database.StopOptions;
import oracle.cluster.home.HomeException;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerGroupException;
import oracle.cluster.util.AlreadyDowngradedException;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.AlreadyUpgradedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.cluster.Version;

public interface Database
extends SoftwareModule {
    public boolean isCardinal() throws DatabaseException;

    public boolean isClusterDatabase() throws DatabaseException;

    public String getPWFile() throws NotExistsException, DatabaseException;

    public void setPWFile(String var1) throws DatabaseException;

    public String getDBName() throws DatabaseException;

    public void setDBName(String var1) throws DatabaseException;

    public String getDomain() throws DatabaseException;

    public void setDomain(String var1) throws DatabaseException;

    public String getDefaultServiceName() throws DatabaseException;

    public CRSResource crsResource() throws NotExistsException, DatabaseException;

    public String getSPFile() throws NotExistsException, DatabaseException;

    public void setSPFile(String var1) throws DatabaseException;

    public List<DatabaseInstance> instances() throws DatabaseException;

    public List<Node> nodes() throws DatabaseException;

    public void addInstance(DatabaseInstance var1) throws AlreadyExistsException, InstanceException;

    public void addInstance(DatabaseInstance var1, boolean var2) throws AlreadyExistsException, CRSNeedForceException, InstanceException;

    public void removeInstance(DatabaseInstance var1) throws InstanceException;

    public void modifyInstance(DatabaseInstance var1) throws InstanceException;

    public List<Service> services() throws DatabaseException;

    public List<Service> services(boolean var1) throws DatabaseException;

    public void removeServices(boolean var1) throws DatabaseException;

    public void start(StartOptions[] var1) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void start(StartOptions[] var1, int var2) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, boolean var2) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, DatabaseInstance var2) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, DatabaseInstance var2, boolean var3) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, StartOptions[] var2) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, StartOptions[] var2, boolean var3) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, StartOptions[] var2, DatabaseInstance var3) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, StartOptions[] var2, DatabaseInstance var3, boolean var4) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, ServiceArgs var2) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(List<Service> var1, DatabaseInstance var2, ServiceArgs var3) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(DatabaseInstance var1, ServiceArgs var2) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void startServices(ServiceArgs var1) throws AlreadyRunningException, CompositeOperationException, DatabaseException;

    public void stop(StopOptions[] var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public void stop(StopOptions[] var1, int var2, boolean var3) throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public void stop(DatabaseOptionalArgs var1) throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public void stopServices() throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public void stopServices(ServiceArgs var1) throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public void stopServices(String var1, ServiceArgs var2) throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public void stopServices(List<Service> var1) throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public void stopServices(List<Service> var1, ServiceArgs var2) throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public void stopServices(List<Service> var1, String var2, ServiceArgs var3) throws AlreadyStoppedException, CompositeOperationException, DatabaseException;

    public List<Service> getServices(String var1) throws DatabaseException;

    public void remove(boolean var1) throws AlreadyRunningException, DatabaseException;

    public String getOracleHome() throws DatabaseException;

    public String getOracleHome(Node var1) throws NotExistsException, DatabaseException;

    public Map<String, String> getDBHomeNodesMap() throws DatabaseException;

    public void setOracleHome(String var1) throws DatabaseException;

    public void setOracleHome(Node var1, String var2) throws DatabaseException;

    public List<ServerGroup> serverGroups() throws ServerGroupException;

    public void setServerGroups(List<ServerGroup> var1) throws ServerGroupException;

    public void setServerGroups(List<ServerGroup> var1, boolean var2) throws ServerGroupException;

    public void setServerGroups(List<ServerGroup> var1, boolean var2, boolean var3) throws ServerGroupException;

    public List<ServerGroup> getPQPools() throws ServerGroupException;

    public void setPQPools(List<ServerGroup> var1) throws ServerGroupException;

    public void setPQPools(List<ServerGroup> var1, boolean var2) throws ServerGroupException;

    public List<ServerGroup> getRFPools() throws ServerGroupException;

    public void setRFPools(List<ServerGroup> var1) throws ServerGroupException;

    public void setRFPools(List<ServerGroup> var1, boolean var2) throws ServerGroupException;

    public List<StartOptions> getStartOptions() throws DatabaseException;

    public void setStartOptions(List<StartOptions> var1) throws DatabaseException;

    public List<StopOptions> getStopOptions() throws DatabaseException;

    public void setStopOptions(List<StopOptions> var1) throws DatabaseException;

    public int getStartConcurrency() throws DatabaseException;

    public int getStopConcurrency() throws DatabaseException;

    public DBRole getDBRole() throws DatabaseException;

    public void setDBRole(DBRole var1) throws DatabaseException;

    public ManagementPolicy getMgmtPolicy() throws DatabaseException;

    public void setMgmtPolicy(ManagementPolicy var1) throws DatabaseException;

    public List<DatabaseInstance> configuredInstances() throws DatabaseException;

    public DatabaseType databaseType() throws DatabaseException;

    public Database upgrade(String var1) throws DatabaseException, AlreadyUpgradedException, CompositeOperationException;

    public Database downgrade(String var1, Version var2) throws AlreadyDowngradedException, CompositeOperationException, DatabaseException;

    public List<AsmClusterFileSystem> asmClusterFileSystems() throws DatabaseException;

    public void checkOracleUser() throws DatabaseException;

    public ResourceAttribute createACLAttr() throws DatabaseException;

    public boolean isAdminManaged() throws DatabaseException;

    public List<String> getAdminDBConfiguredNodes() throws DatabaseException;

    public Map<String, String> getGroups() throws DatabaseException;

    public SIDBType getSIDBType();

    public void updateStartMode(StartOptions[] var1) throws IncompatibleOptionException, AlreadyInOptionException, DatabaseException;

    public void updateStartMode(String var1, StartOptions[] var2) throws IncompatibleOptionException, AlreadyInOptionException, NotRunningException, DatabaseException;

    public void updateInstanceStartMode(String var1, StartOptions[] var2) throws IncompatibleOptionException, AlreadyInOptionException, DatabaseException;

    public void move(String var1) throws HomeException, VersionMismatchException, MoveDatabaseException;

    public void move(String var1, boolean var2) throws HomeException, VersionMismatchException, MoveDatabaseException;

    public void startMonitor() throws DatabaseException, CompositeActionException;

    public void stopMonitor() throws DatabaseException, CompositeActionException;

    public void updateCSSCritical(CRSResource.CSSCritical var1) throws InvalidArgsException, DatabaseException;

    public boolean isCSSCritical() throws DatabaseException;

    public void setCPUCount(int var1) throws DatabaseException;

    public int getCPUCount() throws DatabaseException;

    public void setDefaultNetwork(Network var1) throws DatabaseException;

    public Network getDefaultNetwork() throws DatabaseException, NotExistsException;

    public void setMemoryTarget(int var1) throws DatabaseException;

    public int getMemoryTarget() throws DatabaseException;

    public void setMaxMemory(int var1) throws DatabaseException;

    public int getMaxMemory() throws DatabaseException;

    public void setCPUCap(int var1) throws DatabaseException;

    public int getCPUCap() throws DatabaseException;
}

