/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.crs;

import java.util.List;
import java.util.Map;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.ActionListener;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.impl.crs.ResourceAttribute;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerCategory;
import oracle.cluster.server.ServerPool;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.NotRunningException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;

public interface CRSResource {
    public String getName() throws CRSException;

    public ResourceStatus getStatus() throws CRSException;

    public Map<String, List<String>> getDetailedState() throws CRSException;

    public Map<String, String> getStateDetails() throws CRSException;

    public ResourcePermissions getPermissions() throws CRSException;

    public ServerCategory.ServerCategoryType getServerCategory() throws CRSException;

    public List<Node> fetchRunningNodes() throws CRSException;

    public Map<Node, ResourceStatusOnNode> fetchStatusByNodes() throws CRSException;

    public List<Node> fetchEnabledNodes() throws CRSException;

    public List<Node> fetchDisabledNodes() throws CRSException;

    public void enable() throws AlreadyEnabledException, CRSException;

    public void disable() throws AlreadyDisabledException, CRSException;

    public void start() throws AlreadyRunningException, CRSException;

    public void stop(boolean var1) throws AlreadyStoppedException, CRSException;

    public void stop(boolean var1, boolean var2) throws AlreadyStoppedException, CRSException;

    public void remove(boolean var1) throws CRSException;

    public void enable(List<Node> var1) throws AlreadyEnabledException, CompositeOperationException, CRSException;

    public void disable(List<Node> var1) throws AlreadyDisabledException, CompositeOperationException, CRSException;

    public void enableCardinality(List<Integer> var1) throws AlreadyEnabledException, CompositeOperationException, CRSException;

    public void disableCardinality(List<Integer> var1) throws AlreadyDisabledException, CompositeOperationException, CRSException;

    public void enable(int var1) throws AlreadyEnabledException, CRSException;

    public void disable(int var1) throws AlreadyDisabledException, CRSException;

    public void start(List<Node> var1) throws AlreadyRunningException, CompositeOperationException, CRSException;

    public void start(List<ServerPool> var1, boolean var2, List<ResourceAttribute> var3) throws InvalidArgsException, AlreadyRunningException, CompositeOperationException, CRSException;

    public void stop(List<ServerPool> var1, List<ResourceAttribute> var2, boolean var3, boolean var4) throws InvalidArgsException, AlreadyStoppedException, NotRunningException, CompositeOperationException, CRSException;

    public void stop(List<Node> var1, boolean var2) throws AlreadyStoppedException, CompositeOperationException, CRSException;

    public void check() throws CRSException;

    public void remove(List<Node> var1, boolean var2) throws NotExistsException, CompositeOperationException, CRSException;

    public String getEnv(String var1) throws CRSException;

    public Map<String, String> getEnv() throws CRSException;

    public void setEnv(Map<String, String> var1) throws CRSException;

    public void setPermissions(ResourcePermissions var1) throws CRSException;

    public void setPermissions(ResourcePermissions var1, boolean var2) throws CRSException;

    public boolean isRegistered() throws CRSException;

    public List<CRSResource> dependentCRSResources() throws CRSException;

    public void requestAction(String var1, ActionAttribute[] var2, Node[] var3, boolean var4, boolean var5, ActionListener var6) throws CompositeActionException;

    public void requestAction(String var1, ActionAttribute[] var2) throws CompositeActionException;

    public void requestAction(String var1, ActionAttribute[] var2, Node[] var3) throws CompositeActionException;

    public void requestAction(String var1, ActionAttribute[] var2, ActionListener var3) throws CompositeActionException;

    public void requestAction(String var1, ActionAttribute[] var2, Node[] var3, ActionListener var4) throws CompositeActionException;

    public String[] resourceInstanceIds(String var1) throws NotRunningException, CRSException;

    public static enum CSSCritical {
        YES("yes"),
        NO("no");

        private String m_option;

        private CSSCritical(String option) {
            this.m_option = option;
        }

        public String toString() {
            return this.m_option;
        }

        public static CSSCritical getEnumMember(String option) throws EnumConstNotFoundException {
            for (CSSCritical val : CSSCritical.values()) {
                if (!val.toString().equalsIgnoreCase(option)) continue;
                return val;
            }
            throw new EnumConstNotFoundException((MessageKey)PrCrMsgID.INVALID_CSS_CRITICAL_OPT, option);
        }
    }

    public static enum ResourceStatusOnNode {
        RUNNING_ON_NODE,
        STARTING_ON_NODE,
        STOPPING_ON_NODE,
        NOT_RUNNING_ON_NODE,
        CLEANING_ON_NODE,
        UNKNOWN_ON_NODE;

    }

    public static enum ResourceStatus {
        ONLINE_ONLINE,
        INTERMEDIATE_ONLINE,
        UNKNOWN_ONLINE,
        OFFLINE_ONLINE,
        ONLINE_OFFLINE,
        INTERMEDIATE_OFFLINE,
        UNKNOWN_OFFLINE,
        OFFLINE_OFFLINE;

        public static final String ONLINE = "ONLINE";
        public static final String OFFLINE = "OFFLINE";
        public static final String UNKNOWN = "UNKNOWN";
        public static final String INTERMEDIATE = "INTERMEDIATE";

        public static ResourceStatus valueOf(String state, String target) throws IllegalArgumentException {
            if (target.equals(ONLINE)) {
                if (state.equals(ONLINE)) {
                    return ONLINE_ONLINE;
                }
                if (state.equals(OFFLINE)) {
                    return OFFLINE_ONLINE;
                }
                if (state.equals(UNKNOWN)) {
                    return UNKNOWN_ONLINE;
                }
                if (state.equals(INTERMEDIATE)) {
                    return INTERMEDIATE_ONLINE;
                }
            }
            if (target.equals(OFFLINE)) {
                if (state.equals(ONLINE)) {
                    return ONLINE_OFFLINE;
                }
                if (state.equals(OFFLINE)) {
                    return OFFLINE_OFFLINE;
                }
                if (state.equals(UNKNOWN)) {
                    return UNKNOWN_OFFLINE;
                }
                if (state.equals(INTERMEDIATE)) {
                    return INTERMEDIATE_OFFLINE;
                }
            }
            PrCcMsgID key = PrCcMsgID.ENUM_NO_MEMBER_FOUND;
            String stp = state + "/" + target;
            throw new IllegalArgumentException(MessageBundle.getMessage(key, true, ResourceStatus.class, stp));
        }
    }

    public static enum AutoStart {
        ALWAYS("always"),
        NEVER("never"),
        RESTORE("restore");

        private String m_autoStart;

        private AutoStart(String autoStart) {
            this.m_autoStart = autoStart;
        }

        public String toString() {
            return this.m_autoStart;
        }

        public static AutoStart getMember(String value) {
            for (AutoStart member : AutoStart.values()) {
                if (!member.toString().equalsIgnoreCase(value)) continue;
                return member;
            }
            throw new EnumConstantNotPresentException(AutoStart.class, value);
        }
    }
}

