/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.crs;

import oracle.cluster.crs.ActionAttribute;
import oracle.cluster.crs.ActionListener;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.CRSResource;
import oracle.cluster.crs.CompositeActionException;
import oracle.cluster.crs.CompositeActionStatus;
import oracle.cluster.crs.OracleCMCluster;
import oracle.cluster.crs.ResourcePermissions;
import oracle.cluster.crs.VendorCluster;
import oracle.cluster.impl.crs.CRSFactoryImpl;
import oracle.cluster.impl.crs.ResourceType;
import oracle.cluster.resources.PrCrMsgID;
import oracle.cluster.server.Node;
import oracle.cluster.util.NotExistsException;
import oracle.cluster.util.UpgradeException;
import oracle.ops.mgmt.nls.MessageKey;

public class CRSFactory {
    private static CRSFactory s_instance;
    private CRSFactoryImpl s_factoryImpl = CRSFactoryImpl.getInstance();
    public static final String CRS_MODE_PROPERTY = "SRVMCRSCACHE.DEFAULT";
    public static final CRSCacheMode defaultCRSCacheMode;

    private CRSFactory() throws CRSException {
    }

    public static synchronized CRSFactory getInstance() throws CRSException {
        if (null == s_instance) {
            s_instance = new CRSFactory();
        }
        return s_instance;
    }

    public CRSResource get(String resName) throws NotExistsException, CRSException {
        return this.s_factoryImpl.get(this.s_factoryImpl.create(ResourceType.LocalResource.NAME.name(), resName));
    }

    public ResourcePermissions getPermissions(String resName, String aclValue) throws CRSException {
        return this.s_factoryImpl.getPermissions(resName, aclValue);
    }

    public OracleCMCluster getOracleCMCluster() throws NotExistsException {
        return this.s_factoryImpl.getOracleCMCluster();
    }

    public OracleCMCluster getOracleCMCluster(String nodeName) throws NotExistsException {
        return this.s_factoryImpl.getOracleCMCluster(nodeName);
    }

    public VendorCluster getVendorCluster() throws NotExistsException {
        return this.s_factoryImpl.getVendorCluster();
    }

    public VendorCluster getVendorCluster(String nodeName) throws NotExistsException {
        return this.s_factoryImpl.getVendorCluster(nodeName);
    }

    public long getSeqNumber() throws CRSException {
        return this.s_factoryImpl.getSeqNumber();
    }

    public CompositeActionStatus requestTargetStatus(CRSResource crsRes, String targetType, String targetName) throws CRSException {
        return this.s_factoryImpl.requestTargetStatus(crsRes, targetType, targetName);
    }

    public void upgradeResourceTypes() throws CRSException, UpgradeException {
        this.s_factoryImpl.upgradeResourceTypes();
    }

    public void createResourceTypes() throws CRSException {
        this.s_factoryImpl.createResourceTypes();
    }

    public void createUpgradeResourceTypes() throws CRSException, UpgradeException {
        this.s_factoryImpl.createUpgradeResourceTypes();
    }

    public void upgradeType(Class<? extends Enum> clazz) throws UpgradeException {
        this.s_factoryImpl.upgradeType(clazz);
    }

    public CRSCacheMode crsCacheMode() {
        return this.s_factoryImpl.crsCacheMode();
    }

    public void setCrsCacheMode(CRSCacheMode mode) throws CRSException {
        this.s_factoryImpl.setCrsCacheMode(mode);
    }

    public void invalidateCrsCache() throws CRSException {
        this.s_factoryImpl.invalidateCrsCache();
    }

    public void requestAction(String actionName, ActionAttribute[] attrs, Node[] nodes, boolean async, boolean queue, ActionListener lsnr) throws CompositeActionException {
        throw new CompositeActionException((MessageKey)PrCrMsgID.CRS_JNI_RESOURCE_REQUEST_ACTION_FAILED_ON_MULTIPLE_RESOURCES, (Throwable)new UnsupportedOperationException("NOT IMPLEMENTED YET"), new Object[0]);
    }

    static {
        defaultCRSCacheMode = CRSCacheMode.None;
    }

    public static enum CRSCacheMode {
        None,
        Local;


        public CRSCacheMode getEnumMember(String mode) throws EnumConstantNotPresentException {
            for (CRSCacheMode eMode : CRSCacheMode.values()) {
                if (!eMode.name().equalsIgnoreCase(mode)) continue;
                return eMode;
            }
            throw new EnumConstantNotPresentException(CRSCacheMode.class, mode);
        }
    }
}

