/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.credentials;

import java.net.InetAddress;
import java.util.Map;
import oracle.cluster.credentials.CredentialsException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;

public interface GNSProperties {
    public static final String GNS_ATTRIBUTES = "GNS_ATTRIBUTES";

    public String getGNSSubDomain() throws CredentialsException;

    public String getGNSSubDomain(String var1) throws CredentialsException;

    public String getGNSDiscoveryAddresses() throws CredentialsException;

    public Map<IPAddressUtil.IPAddrType, InetAddress> getGNSDiscoveryAddressMap() throws CredentialsException;

    public static enum GNSPropName {
        SUBDOMAIN("SUBDOMAIN"),
        DISCOVERY_ADDRESSES("DISCOVERY_ADDRESSES");

        private String m_propname;

        private GNSPropName(String propname) {
            this.m_propname = propname;
        }

        private GNSPropName() {
            this.m_propname = null;
        }

        public String toString() {
            return this.m_propname;
        }

        public static GNSPropName getEnumMember(String value) throws EnumConstantNotPresentException {
            for (GNSPropName v : GNSPropName.values()) {
                if (!v.toString().equals(value)) continue;
                return v;
            }
            Trace.out("Invalid GNS Property name [" + value + "]");
            throw new EnumConstantNotPresentException(GNSPropName.class, value);
        }
    }
}

