/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.concurrency;

import oracle.cluster.concurrency.ParallelCommand;
import oracle.cluster.impl.concurrency.ParallelCommandFactoryImpl;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.util.ConcurrencyException;
import oracle.cluster.util.ConcurrencyTimeoutException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ParallelCommandFactory {
    private static ParallelCommandFactory s_instance;
    private static ParallelCommandFactoryImpl s_parallelFactoryImpl;

    private ParallelCommandFactory() throws ConcurrencyException {
        s_parallelFactoryImpl = ParallelCommandFactoryImpl.getInstance();
    }

    public static ParallelCommand getParallelCommand(Command[] cmd, Version version) throws ConcurrencyException {
        try {
            return ParallelCommandFactory.getParallelCommand(cmd, 0, version);
        }
        catch (ConcurrencyTimeoutException e) {
            Trace.out("timeout exception in an untimed command");
            throw new ConcurrencyException(e);
        }
    }

    public static ParallelCommand getParallelCommand(Command[] cmd, int timeout, Version version) throws ConcurrencyException, ConcurrencyTimeoutException {
        if (s_instance == null) {
            s_instance = new ParallelCommandFactory();
        }
        if (cmd == null) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cmd");
        }
        if (version == null) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "version");
        }
        if (timeout < 0) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "timeout");
        }
        return s_parallelFactoryImpl.getParallelCommandInstance(cmd, timeout, version);
    }

    public static ParallelCommand getParallelCommand(Command[] cmd, int timeout, String[] identifier, Version version) throws ConcurrencyException, ConcurrencyTimeoutException {
        if (s_instance == null) {
            s_instance = new ParallelCommandFactory();
        }
        if (cmd == null) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "cmd");
        }
        if (version == null) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "version");
        }
        if (timeout < 0) {
            throw new ConcurrencyException((MessageKey)PrCcMsgID.INVALID_NULL_PARAM, "timeout");
        }
        return s_parallelFactoryImpl.getParallelCommandInstance(cmd, timeout, identifier, version);
    }
}

