/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.common;

import java.util.List;
import java.util.Map;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.common.SoftwareModuleException;
import oracle.cluster.crs.NoVersionAvailableException;
import oracle.cluster.install.InstallGroup;
import oracle.cluster.server.Node;
import oracle.cluster.util.AlreadyDisabledException;
import oracle.cluster.util.AlreadyEnabledException;
import oracle.cluster.util.AlreadyRunningException;
import oracle.cluster.util.AlreadyStoppedException;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;

public interface SoftwareModule
extends ManageableEntity {
    public void start() throws AlreadyRunningException, SoftwareModuleException;

    public void stop(boolean var1) throws AlreadyStoppedException, SoftwareModuleException;

    public void check() throws SoftwareModuleException;

    public void enable() throws AlreadyEnabledException, SoftwareModuleException;

    public void disable() throws AlreadyDisabledException, SoftwareModuleException;

    public boolean isEnabled() throws SoftwareModuleException;

    public boolean isEnabled(Node var1) throws SoftwareModuleException;

    public List<Node> getDisabledNodes() throws ClusterException, SoftwareModuleException;

    public boolean isRunning() throws SoftwareModuleException;

    public boolean isRunning(Node var1) throws SoftwareModuleException;

    public String getEnv(String var1) throws SoftwareModuleException;

    public Map<String, String> getEnv() throws SoftwareModuleException;

    public void setEnv(Map<String, String> var1) throws SoftwareModuleException;

    public InstallGroup installGroup() throws SoftwareModuleException;

    public void setInstallGroup(InstallGroup var1) throws SoftwareModuleException;

    public boolean isConfigured() throws SoftwareModuleException;

    public boolean isInstalled() throws SoftwareModuleException;

    public Version version() throws NoVersionAvailableException, SoftwareModuleException;
}

