/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.common;

import oracle.ops.mgmt.trace.Trace;

public enum NodeRole {
    NONE(0),
    HUB(1),
    RIM(2),
    AUTO(3);

    private int m_role;
    private String m_roleStr;

    private NodeRole(int role) {
        this.m_role = role;
        switch (this.m_role) {
            case 0: {
                this.m_roleStr = "none";
                break;
            }
            case 1: {
                this.m_roleStr = "hub";
                break;
            }
            case 2: {
                this.m_roleStr = "leaf";
                break;
            }
            case 3: {
                this.m_roleStr = "auto";
            }
        }
    }

    private NodeRole() {
        this.m_role = 0;
        this.m_roleStr = "none";
    }

    public int getRole() {
        return this.m_role;
    }

    public String getRoleStr() {
        return this.m_roleStr;
    }

    public static NodeRole getEnumMember(int value) throws EnumConstantNotPresentException {
        for (NodeRole v : NodeRole.values()) {
            if (v.getRole() != value) continue;
            return v;
        }
        Trace.out("Invalid role value [" + value + "]");
        throw new EnumConstantNotPresentException(NodeRole.class, Integer.toString(value));
    }

    public static NodeRole getEnumMember(String roleStr) throws EnumConstantNotPresentException {
        for (NodeRole v : NodeRole.values()) {
            if (!roleStr.equalsIgnoreCase(v.getRoleStr())) continue;
            return v;
        }
        Trace.out("Invalid role value [" + roleStr + "]");
        throw new EnumConstantNotPresentException(NodeRole.class, roleStr);
    }
}

