/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.common;

import oracle.cluster.common.CommonBaseException;
import oracle.cluster.crs.CRSConnectionException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;

public class ManageableEntityException
extends CommonBaseException {
    protected boolean m_isNoMsg = false;

    protected ManageableEntityException() {
        this.m_isNoMsg = true;
    }

    public ManageableEntityException(Throwable cause) {
        super(cause);
        this.m_isNoMsg = true;
    }

    public ManageableEntityException(MessageKey key, Object ... args) {
        this(key, null, args);
    }

    public ManageableEntityException(MessageKey key, Throwable cause, Object ... args) {
        super(MessageBundle.getMessage(key, true, args), cause);
    }

    public ManageableEntityException(String msg) {
        super(msg);
    }

    public ManageableEntityException(Throwable cause, String msg) {
        super(msg, cause);
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        Throwable causedBy = super.getCause();
        if (causedBy == null) {
            return super.getMessage();
        }
        String supermsg = super.getMessage();
        String causedmsg = causedBy.getMessage();
        if (this.m_isNoMsg) {
            return causedmsg;
        }
        return supermsg + "\n" + causedmsg;
    }

    public boolean hasCRSConnectionIssue() {
        for (Throwable cause = this.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof CRSConnectionException)) continue;
            return true;
        }
        return false;
    }
}

