/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;

class InnerInterruptHandler
extends Thread {
    private static MessageBundle m_msgBndl_PrCt;
    private static HashMap<Method, List<Object>> m_intHndlrTable;

    public InnerInterruptHandler() {
        m_intHndlrTable = new HashMap();
        m_msgBndl_PrCt = MessageBundle.getMessageBundle(PrCtMsgID.facility);
        m_msgBndl_PrCt.setPackage("oracle.cluster.resources");
    }

    public void addInterruptHandler(Method method, List<Object> args) {
        m_intHndlrTable.put(method, args);
    }

    @Override
    public void run() {
        try {
            Trace.out("Running the shutdown hook");
            Set<Method> mthdSet = m_intHndlrTable.keySet();
            for (Method mthd : mthdSet) {
                Trace.out("Calling Interrupt handler...." + mthd.getName());
                Class<?> cls = mthd.getDeclaringClass();
                List<Object> argList = m_intHndlrTable.get(mthd);
                mthd.invoke(cls.newInstance(), argList == null ? new Object[]{} : argList.toArray(new Object[0]));
            }
        }
        catch (IllegalAccessException e) {
            Trace.out("IllegalAccessException..." + e.getMessage());
            System.out.println(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, "interrupt-access"));
        }
        catch (InvocationTargetException e) {
            Trace.out("InvocationTargetException..." + e.getMessage());
            System.out.println(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, "interrupt-invocation"));
        }
        catch (InstantiationException e) {
            Trace.out("InstantiationException..." + e.getMessage());
            System.out.println(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, "interrupt-instatiation"));
        }
        catch (IllegalArgumentException e) {
            Trace.out("IllegalArgumentException..." + e.getMessage());
            System.out.println(MessageBundle.getMessage(PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, true, "interrupt-arg"));
        }
    }
}

