/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.common;

import oracle.cluster.logger.TraceLogger;
import oracle.cluster.logger.TraceLoggerFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;

public class CommonBaseException
extends Exception {
    public CommonBaseException() {
        this.logDiagMessages();
    }

    public CommonBaseException(String msg) {
        super(msg);
        this.logDiagMessages();
    }

    public CommonBaseException(Throwable cause) {
        super(cause);
        this.logDiagMessages();
    }

    public CommonBaseException(String msg, Throwable cause) {
        super(msg, cause);
        this.logDiagMessages();
    }

    public CommonBaseException(MessageKey key, Object ... args) {
        super(MessageBundle.getMessageBundle(key.getFacility()).getMessage(key.getName(), true, args));
        this.logDiagMessages();
    }

    public CommonBaseException(MessageKey key, Throwable cause, Object ... args) {
        super(MessageBundle.getMessageBundle(key.getFacility()).getMessage(key.getName(), true, args), cause);
        this.logDiagMessages();
    }

    private void logDiagMessages() {
        TraceLoggerFactory tf = TraceLoggerFactory.getInstance();
        TraceLogger s_tlogger = tf.getTraceLogger();
        s_tlogger.logDiagnosticMessages();
    }
}

