/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.common;

import java.util.HashMap;
import java.util.List;
import oracle.cluster.asm.ASM;
import oracle.cluster.asm.ASMInstance;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.ClusterException;
import oracle.cluster.common.ManageableEntity;
import oracle.cluster.common.ResultSet;
import oracle.cluster.common.SoftwareModule;
import oracle.cluster.common.SoftwareVersion;
import oracle.cluster.crs.CRSException;
import oracle.cluster.crs.OCR;
import oracle.cluster.crs.VendorCluster;
import oracle.cluster.database.Database;
import oracle.cluster.install.InstallGroup;
import oracle.cluster.network.NetworkAdapter;
import oracle.cluster.nodeapps.Listener;
import oracle.cluster.nodeapps.Network;
import oracle.cluster.nodeapps.ONS;
import oracle.cluster.nodeapps.VIP;
import oracle.cluster.server.Node;
import oracle.cluster.server.ServerGroup;
import oracle.cluster.server.ServerPool;
import oracle.cluster.storage.Storage;
import oracle.cluster.util.NotExistsException;

public interface Cluster
extends ManageableEntity {
    public List<SoftwareModule> softwareModules() throws ClusterException;

    public List<Node> nodes() throws ClusterException;

    public List<ServerGroup> fetchServerGroups() throws NotExistsException, ClusterException;

    public List<ServerPool> fetchServerPools() throws NotExistsException, ClusterException;

    public Database fetchDatabase(String var1, String var2) throws ClusterException;

    public List<Database> fetchDatabases() throws NotExistsException, ClusterException;

    public SoftwareVersion getVersion() throws ClusterException;

    public List<InstallGroup> fetchDatabaseInstallGroups() throws ClusterException;

    public List<Listener> fetchListeners() throws NotExistsException, ClusterException;

    public List<ONS> fetchONSs() throws NotExistsException, ClusterException;

    public List<VIP> fetchVIPs() throws NotExistsException, ClusterException;

    public List<VIP> fetchVIPs(int var1) throws NotExistsException, ClusterException;

    public Node fetchNode(String var1) throws NotExistsException, ClusterException;

    public String fetchNodeName(String var1) throws NotExistsException, ClusterException;

    public Node getLocalNode() throws ClusterException;

    public ASM fetchASM() throws ClusterException;

    public List<ASMInstance> fetchASMInstances() throws ClusterException;

    public List<Storage> fetchSharedStorage() throws ClusterException;

    public List<Network> fetchNetworks() throws NotExistsException, ClusterException;

    public List<NetworkAdapter> fetchNetworkAdapters() throws ClusterException;

    public List<NetworkAdapter> fetchNetworkAdaptersByNode(String var1) throws NotExistsException, ClusterException;

    public List<NetworkAdapter> fetchNetworkAdaptersByName(String var1) throws ClusterException;

    public List<String> getPrivateAddresses() throws ClusterException;

    public ResultSet verifyClusterIntegrity() throws ClusterException;

    public ResultSet verifyNodeAppsIntegrity() throws ClusterException;

    public boolean isVendorCluster() throws ClusterException;

    public VendorCluster fetchVendorCluster() throws ClusterException;

    public OCR ocr() throws ClusterException;

    public List<String> votingDiskPaths() throws ClusterException;

    public boolean hasCRSAdminRole() throws CRSException;

    public CSSMode getCSSMode() throws ClusterException;

    public String getPatchLevelForNode(String var1) throws ClusterException;

    public HashMap<String, String> getPatchLevel() throws ClusterException;

    public int getTargetHubSize() throws ClusterException;

    public String getCRSBaseLoc() throws ClusterException;
}

