/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCcMsgID;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class USMDriverUtil {
    private CmdToolUtil m_cmdtool;
    private static final String USM_DRIVER_STATE = "acfsdriverstate";
    private static final String USM_DRIVER_STATE_OH_OPTION = "-orahome";
    private static final String USMDRIVER = new SystemFactory().CreateSystem().getScriptFileName("acfsdriverstate");
    private String m_crsHome;
    private static final String EXE_LOC = "bin";
    private final String[] USMDRIVER_DEP = new String[]{USMDRIVER};
    private static final String USMDRIVER_ARG_VERSION = "version";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String ACFS_SUPPORTED = "ACFS-9200";
    private static final String ACFS_NOT_SUPPORTED = "ACFS-9201";
    private static final String ACFS_OS_NOT_SUPP = "ACFS-9125";
    private static final String ACFS_TRUE = "ACFS-9203";
    private static final String ACFS_FALSE = "ACFS-9204";
    public static final String TRUE_STRING = "1";
    public static final String FALSE_STRING = "0";
    private String m_ACFSSupportMsg = null;

    public USMDriverUtil(String crshome) throws CmdToolUtilException {
        this.m_crsHome = crshome;
        String toolLoc = crshome + File.separator + EXE_LOC;
        File usmfile = new File(toolLoc + File.separator + USMDRIVER);
        Trace.out("Checking file exists for: " + usmfile);
        if (!usmfile.exists()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ACFS_NOT_SUPPORTED, new Object[0]);
        }
        this.m_cmdtool = new CmdToolUtil(USMDRIVER, toolLoc, this.USMDRIVER_DEP);
    }

    public String[] checkACFSSupported() throws CmdToolUtilException {
        return this.checkACFSSupported(this.m_crsHome);
    }

    public String[] checkACFSSupported(String oracleHome) throws CmdToolUtilException {
        String[] acfsArr = new String[]{this.checkACFSState(ACFSDriverState.SUPPORTED, oracleHome) ? TRUE_STRING : FALSE_STRING, this.m_ACFSSupportMsg};
        return acfsArr;
    }

    public boolean checkACFSState(ACFSDriverState state, String oracleHome) throws CmdToolUtilException {
        return this.checkACFSState(state, oracleHome, "localnode");
    }

    public boolean checkACFSState(ACFSDriverState state, String oracleHome, String nodename) throws CmdToolUtilException {
        String[] resultArr;
        if (state == null) {
            throw new CmdToolUtilException((MessageKey)PrCcMsgID.INVALID_PARAM_VALUE, "state");
        }
        CmdToolUtil.assertDir(oracleHome, true);
        CmdToolUtil.assertNode(nodename);
        String[] args = new String[]{USM_DRIVER_STATE_OH_OPTION, oracleHome, state.toString()};
        CommandResult result = null;
        result = nodename.equals("localnode") ? this.m_cmdtool.executeLocally(args, null, false, true) : this.m_cmdtool.execute(nodename, args, null, false, true, true);
        if (!result.getBooleanResult()) {
            Trace.out("result is negative");
            String[] errorString = result.getResultString();
            String[] outputString = result.getOutputString();
            String[] useString = errorString != null && errorString.length > 0 ? errorString : (outputString != null && outputString.length > 0 ? outputString : null);
            if (useString != null) {
                Trace.out("useString = " + Utils.getString(useString, NEWLINE));
                Trace.out("useString size = " + useString.length);
                for (int i = 0; i < useString.length; ++i) {
                    Trace.out(useString[0]);
                }
                return this.processState(state, useString, nodename);
            }
        }
        if ((resultArr = result.getResultString()) != null && resultArr.length > 0) {
            Trace.out("Printing ACFS output");
            Trace.out(Utils.getString(resultArr, NEWLINE));
            return this.processState(state, resultArr, nodename);
        }
        if (nodename.equals("localnode")) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ACFS_DRIVER_NO_OUTPUT, state.toString());
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.ACFS_DRIVER_NO_OUTPUT_NODE, state.toString(), nodename);
    }

    private boolean processState(ACFSDriverState state, String[] output, String nodename) throws CmdToolUtilException {
        if (state == ACFSDriverState.SUPPORTED) {
            if (output[0].indexOf(ACFS_SUPPORTED) >= 0) {
                Trace.out("ACFS is supported, output[0] = " + output[0]);
                this.m_ACFSSupportMsg = output[0];
                return true;
            }
            for (String out : output) {
                if (!out.contains(ACFS_NOT_SUPPORTED) && !out.contains(ACFS_OS_NOT_SUPP)) continue;
                this.m_ACFSSupportMsg = out;
                return false;
            }
        } else {
            Trace.out("output[0] = " + output[0]);
            if (output[0].indexOf(ACFS_TRUE) >= 0) {
                return true;
            }
            if (output[0].indexOf(ACFS_FALSE) >= 0) {
                return false;
            }
        }
        if (nodename.equals("localnode")) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.USM_DRIVER_FAIL_WITH_MSG, Utils.getString(output, NEWLINE));
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.ACFS_DRIVER_FAIL_WITH_MSG_NODE, nodename, Utils.getString(output, NEWLINE));
    }

    public static enum ACFSDriverState {
        SUPPORTED("supported"),
        INSTALLED("installed"),
        LOADED("loaded");

        private String m_state;

        private ACFSDriverState(String state) {
            this.m_state = state;
        }

        public String toString() {
            return this.m_state;
        }
    }
}

