/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.NodeRole;
import oracle.cluster.deployment.LWServerPool;
import oracle.cluster.deployment.LWServerPoolException;
import oracle.cluster.gridhome.RHPContainerType;
import oracle.cluster.helper.HelperException;
import oracle.cluster.helper.HelperUtil;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.EnumConstNotFoundException;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class SRVMHELPERUtil {
    private static final String SRVMHELPER = new SystemFactory().CreateSystem().getScriptFileName("srvmhelper");
    private static final String EXE_LOC = "srvm" + File.separator + "admin";
    private static final String[] SRVMHELPER_DEP = new String[]{SRVMHELPER};
    private static final boolean s_isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
    private static String HUB = ResourceLiterals.HUB.toString();
    private static String LEAF = ResourceLiterals.RIM.toString();
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String SRVMHELPER_COPYDIR = "copydir";
    private static final String SRVMHELPER_ADDNFS = "addnfs";
    private static final String SRVMHELPER_GETSERVERPOOLS = "-getserverpools";
    private static final String SRVMHELPER_RUNMGMTCA = "runmgmtca";
    private static final String SRVMHELPER_FSOPT = "-fsoptions";
    private static final String SRVMHELPER_CREATEGHWALLET = "ghcreds";
    private static final String SRVMHELPER_IS_ADMIN_MANAGED = "-isDatabaseAdminManaged";
    private static final String SRVMHELPER_GET_ADMINDB_CONFIG_NODES = "-getAdminDBConfiguredNodes";
    private static final String SRVMHELPER_IS_LEAFNODE_ALLOWED = "-isLeafNodeAllowed";
    private static final String SRVMHELPER_GET_ACTIVE_SERVERS = "-getactiveservers";
    private static final String SRVMHELPER_ACFS_MTPOINT_NODES = "getACFSMountNodes";
    private static final String SRVMHELPER_IS_ACFS_NODE_LOCAL = "isACFSNodeLocal";
    private static final String SRVMHELPER_GET_RHP_CLUSTER_TYPE = "getRHPClusterType";
    private static final String SRVMHELPER_GET_SCAN_NAME = "getScanName";
    private CmdToolUtil m_cmdTool;

    public SRVMHELPERUtil(String oracleHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(oracleHome, true);
        String toolLoc = oracleHome;
        toolLoc = toolLoc + File.separator + EXE_LOC;
        this.m_cmdTool = new CmdToolUtil(SRVMHELPER, toolLoc, SRVMHELPER_DEP);
        Trace.out("Toolname: " + SRVMHELPER + "   ---    Tool location: " + toolLoc + "Tool dependencies: " + SRVMHELPER_DEP);
    }

    public void copyDirContent(String srcPath, String dstPath, String nodeName, String exclFile) throws CmdToolUtilException {
        String[] errorString;
        Trace.out("copy through srvmhelper");
        Trace.out("Excl file list is " + exclFile);
        CmdToolUtil.assertNode(nodeName);
        String[] args = new String[]{SRVMHELPER_COPYDIR, srcPath, dstPath, exclFile == null ? "null" : exclFile};
        String[] env = null;
        CommandResult result = null;
        Trace.out("source path is " + srcPath);
        Trace.out("dest path is " + dstPath);
        Trace.out("exectuion node is " + nodeName);
        Trace.out("excl file is " + args[3]);
        try {
            result = nodeName.equals("localnode") ? this.m_cmdTool.executeLocally(args, env) : this.m_cmdTool.execute(nodeName, args, env, false);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_COPYDIR_FAIL, srcPath, dstPath, nodeName, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("cmdTool.execute() failed.");
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                stringBuilder.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_COPYDIR_FAIL, srcPath, dstPath, nodeName, stringBuilder.toString());
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("srvmhelper copydir command executed, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, nodeName);
        }
    }

    public void addNFS(String expPath, String expServer, String mntPath, String mntOptions, String user) throws CmdToolUtilException {
        String[] errorString;
        Trace.out("adding nfs resource");
        String[] args = new String[]{SRVMHELPER_ADDNFS, mntPath, expServer, expPath, SRVMHELPER_FSOPT, mntOptions != null && mntOptions.length() > 0 ? mntOptions : "", user != null && user.length() > 0 ? user : ""};
        String[] env = null;
        CommandResult result = null;
        Trace.out("mount point path is " + mntPath);
        Trace.out("export server is " + expServer);
        Trace.out("export path is " + expPath);
        Trace.out("mount options are " + mntOptions);
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_ADDNFS_FAIL, mntPath, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("cmdTool.execute() failed.");
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                stringBuilder.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_ADDNFS_FAIL, mntPath, stringBuilder.toString());
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("srvmhelper addnfs command executed, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
    }

    public void runMgmtca(String user) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = null;
        String[] env = null;
        String[] args = new String[]{SRVMHELPER_RUNMGMTCA};
        String nodeName = null;
        String localHost = null;
        try {
            nodeName = new HelperUtil().getMgmtDBNodeName();
        }
        catch (HelperException he) {
            Trace.out("Failed to get node on which mgmtdb is running." + he.getMessage());
            nodeName = " ";
        }
        try {
            result = this.m_cmdTool.execute(args, env, user, true, false);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_RUNMGMTCA_FAIL, user, nodeName, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("cmdTool.execute() failed.");
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                stringBuilder.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_RUNMGMTCA_FAIL, user, nodeName, stringBuilder.toString());
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("srvmhelper runmgmtca command executed, but produced empty output, throwing CmdToolUtilException");
            try {
                localHost = Utils.getLocalHost();
                Trace.out("Local Node is " + localHost);
            }
            catch (UnknownHostException uhe) {
                Trace.out("Local host could not be retrieved setting it to LOCALNODE");
                localHost = "localnode";
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, localHost);
        }
    }

    public void createGHCreds(String user, String clName, String updFlag) throws CmdToolUtilException {
        this.createGHCreds(user, clName, updFlag, false);
    }

    public void createGHCreds(String user, String clName, String updFlag, boolean isUpg) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = null;
        String[] env = null;
        String[] args = null;
        if (clName == null) {
            args = new String[3];
        } else {
            args = new String[4];
            args[3] = clName;
        }
        args[0] = SRVMHELPER_CREATEGHWALLET;
        args[1] = updFlag;
        args[2] = isUpg ? "true" : "false";
        try {
            result = this.m_cmdTool.execute(args, env, user, true, false);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_CREATEGHWALLET_FAIL, user, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("cmdTool.execute() failed.");
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                stringBuilder.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_CREATEGHWALLET_FAIL, user, stringBuilder.toString());
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("srvmhelper ghcreds command executed, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
    }

    public void createGHCreds(String clName, String updFlag) throws CmdToolUtilException {
        this.createGHCreds(null, clName, updFlag);
    }

    public void makeDir(String userName, String nodeList, String dirPath) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = null;
        String[] env = null;
        String[] args = new String[]{"makedir", nodeList, dirPath};
        try {
            result = this.m_cmdTool.execute(args, env, userName, true, false);
        }
        catch (CmdToolUtilException e) {
            Trace.out("CmdToolUtilException: " + e.getMessage());
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_MAKE_DIR_FAIL, dirPath, nodeList, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("CmdToolUtilException: " + Utils.getString(errorString, NEWLINE));
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_MAKE_DIR_FAIL, dirPath, nodeList, Utils.getString(errorString, NEWLINE));
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("srvmhelper makedir command executed, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
    }

    public boolean isDatabaseAdminManaged(String dbUniqueName) throws CmdToolUtilException {
        Trace.out("Checking if database: " + dbUniqueName + " is admin-managed.");
        String[] args = new String[]{SRVMHELPER_IS_ADMIN_MANAGED, dbUniqueName};
        String[] env = null;
        CommandResult result = null;
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_IS_ADMIN_MANAGED_FAIL, dbUniqueName, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult()) {
            String errorString = this.getErrorMessage(result);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_IS_ADMIN_MANAGED_FAIL, dbUniqueName, errorString);
        }
        String cmdOutput = this.getOutput(result);
        if (cmdOutput == null) {
            Trace.out("srvmhelper isDatabaseAdminManaged command executed, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        return Boolean.valueOf(cmdOutput);
    }

    public List<String> getAdminDBConfiguredNodes(String dbUniqueName) throws CmdToolUtilException {
        Trace.out("Getting nodes on which database: " + dbUniqueName + " is configured.");
        String[] args = new String[]{SRVMHELPER_GET_ADMINDB_CONFIG_NODES, dbUniqueName};
        String[] env = null;
        CommandResult result = null;
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ADMINDB_CONFIG_NODES_FAIL, dbUniqueName, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult()) {
            String errorString = this.getErrorMessage(result);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ADMINDB_CONFIG_NODES_FAIL, dbUniqueName, errorString);
        }
        String cmdOutput = this.getOutput(result);
        if (cmdOutput == null) {
            Trace.out("srvmhelper getAdminDBConfiguredNodes command executed, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        List<String> nodes = new ArrayList<String>();
        if (!cmdOutput.trim().isEmpty()) {
            nodes = Arrays.asList(cmdOutput.split(","));
        }
        return nodes;
    }

    public String exportClientData(String sysID, String client, String vipAddr, String subdomain, String credFile, String version) throws CmdToolUtilException {
        CommandResult result = null;
        String[] env = null;
        String[] args = new String[]{"exportClientData", sysID, client, vipAddr, subdomain, credFile, version};
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        if (!result.getBooleanResult()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 4) {
            Trace.out("srvmhelper exportClientData command executed, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        StringBuilder res = new StringBuilder(cmdOutput[1]);
        for (int i = 2; i < cmdOutput.length - 3; ++i) {
            res.append(cmdOutput[i]);
        }
        return res.toString();
    }

    public boolean isLeafNodeAllowed() throws CmdToolUtilException {
        String[] errorString;
        Trace.out("Checking whether the cluster is configured to support leaf nodes");
        String[] args = new String[]{SRVMHELPER_IS_LEAFNODE_ALLOWED};
        String[] env = null;
        CommandResult result = null;
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_IS_LEAFNODE_ALLOWED_FAIL, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_IS_LEAFNODE_ALLOWED_FAIL, Utils.getString(errorString, NEWLINE));
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("srvmhelper isLeafNodeAllowed command executed, but produced empty output, throwing CmdToolUtilException");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        return Boolean.valueOf(cmdOutput[1]);
    }

    public List<LWServerPool> getServerPools(String activeCSSRole) throws CmdToolUtilException {
        CommandResult result = null;
        String[] env = null;
        String[] args = new String[]{SRVMHELPER_GETSERVERPOOLS, activeCSSRole};
        if (activeCSSRole == null) {
            Trace.out("srvmhelper getserverpools executed with null CSS role");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SHgetServerPools001");
        }
        if (!activeCSSRole.equalsIgnoreCase(HUB) && !activeCSSRole.equalsIgnoreCase(LEAF)) {
            Trace.out("srvmhelper getserverpools executed with invalid CSS role");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SHgetServerPools002");
        }
        String fullCmd = SRVMHELPER + " " + SRVMHELPER_GETSERVERPOOLS + " " + activeCSSRole;
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            Trace.out("srvmhelper execution failed " + e.getMessage());
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SERVERPOOL_ATTRIBUTE_LIST_FAIL, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult()) {
            String[] errorString = result.getResultString();
            if (errorString != null && errorString.length > 0) {
                String err = Utils.getString(errorString, NEWLINE);
                Trace.out("srvmhelper execution failed " + err);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SERVERPOOL_ATTRIBUTE_LIST_FAIL, err);
            }
            Trace.out("srvmhelper execution failed - error string empty");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, fullCmd, "localnode");
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("srvmhelper getserverpools executed with empty output");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, fullCmd, "localnode");
        }
        return this.listServerPoolAttributes(cmdOutput);
    }

    private List<LWServerPool> listServerPoolAttributes(String[] tagdOutput) throws CmdToolUtilException {
        int i;
        ArrayList<LWServerPool> lwspList = new ArrayList<LWServerPool>();
        Object lwsp = null;
        List<String> activeServerList = new ArrayList<String>();
        List<String> candServerList = new ArrayList<String>();
        String category = "";
        String name = "";
        int minSize = 0;
        int maxSize = -1;
        int importance = 0;
        for (i = 0; i < tagdOutput.length; ++i) {
            Trace.out("Line " + i + "  " + tagdOutput[i]);
        }
        block3: for (i = 0; i < tagdOutput.length; ++i) {
            if (tagdOutput[i].contains("<SERVERPOOLS>") || !tagdOutput[i].contains("<SERVERPOOL>")) continue;
            boolean isPoolValid = false;
            do {
                String sizeInStr;
                Object[] args;
                if (tagdOutput[++i].contains("</SERVERPOOL>")) {
                    if (isPoolValid) {
                        try {
                            lwspList.add(new LWServerPool(name, category, importance, minSize, maxSize, activeServerList, candServerList));
                        }
                        catch (LWServerPoolException le) {
                            Trace.out("Got LWServerPoolException" + le.getMessage());
                            isPoolValid = false;
                        }
                    }
                    activeServerList = new ArrayList();
                    candServerList = new ArrayList();
                    category = "";
                    name = "";
                    minSize = 0;
                    maxSize = -1;
                    importance = 0;
                    isPoolValid = false;
                    continue block3;
                }
                if (tagdOutput[i].contains("<SERVERPOOL_NAME>")) {
                    name = HelperUtil.fetchTextByTags(tagdOutput[i], "<SERVERPOOL_NAME>", "</SERVERPOOL_NAME>");
                    if (isPoolValid || name == null || name.length() == 0) {
                        Trace.out("Marlformed output found.. " + tagdOutput);
                        args = new Object[]{"SHListServerPools-01"};
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, args);
                    }
                    Trace.out("New serverpool information  found" + name);
                    isPoolValid = true;
                    continue;
                }
                if (tagdOutput[i].contains("<MIN_SIZE>") && isPoolValid) {
                    sizeInStr = HelperUtil.fetchTextByTags(tagdOutput[i], "<MIN_SIZE>", "</MIN_SIZE>");
                    int size = Integer.parseInt(sizeInStr.trim());
                    if (size < 0) {
                        Trace.out("Marlformed output found.. MinSize lt 0" + tagdOutput);
                        Object[] args2 = new Object[]{"SHListServerPools-02"};
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, args2);
                    }
                    minSize = size;
                    continue;
                }
                if (tagdOutput[i].contains("<MAX_SIZE>") && isPoolValid) {
                    sizeInStr = HelperUtil.fetchTextByTags(tagdOutput[i], "<MAX_SIZE>", "</MAX_SIZE>");
                    maxSize = Integer.parseInt(sizeInStr.trim());
                    if (maxSize >= -1) continue;
                    Trace.out("Marlformed output found.. maxSize lt -1" + tagdOutput);
                    Object[] args3 = new Object[]{"SHListServerPools-03"};
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, args3);
                }
                if (tagdOutput[i].contains("<IMPORTANCE>") && isPoolValid) {
                    sizeInStr = HelperUtil.fetchTextByTags(tagdOutput[i], "<IMPORTANCE>", "</IMPORTANCE>");
                    importance = Integer.parseInt(sizeInStr.trim());
                    if (importance >= 0) continue;
                    Trace.out("Marlformed output found.. Importance lt 0" + tagdOutput);
                    Object[] args4 = new Object[]{"SHListServerPools-04"};
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, args4);
                }
                if (tagdOutput[i].contains("<SERVERPOOL_CATEGORY>") && isPoolValid) {
                    category = HelperUtil.fetchTextByTags(tagdOutput[i], "<SERVERPOOL_CATEGORY>", "</SERVERPOOL_CATEGORY>");
                    if (category == null || category.length() == 0) {
                        Trace.out("Marlformed output found.. category null" + tagdOutput);
                        args = new Object[]{"SHListServerPools-05"};
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, args);
                    }
                    Trace.out("Category " + category);
                    continue;
                }
                if (tagdOutput[i].contains("<ACTIVE_SERVERS>") && isPoolValid) {
                    String activeServers = HelperUtil.fetchTextByTags(tagdOutput[i], "<ACTIVE_SERVERS>", "</ACTIVE_SERVERS>");
                    Trace.out("Active Servers :" + activeServers);
                    activeServerList = Arrays.asList(activeServers.split("\\s*,\\s*"));
                    continue;
                }
                if (!tagdOutput[i].contains("<CANDIDATE_SERVERS>") || !isPoolValid) continue;
                String candidateServers = HelperUtil.fetchTextByTags(tagdOutput[i], "<CANDIDATE_SERVERS>", "</CANDIDATE_SERVERS>");
                Trace.out("Candidate Servers :" + candidateServers);
                candServerList = Arrays.asList(candidateServers.split("\\s*,\\s*"));
            } while (i < tagdOutput.length);
        }
        return lwspList;
    }

    public void resetRepos(String user) throws CmdToolUtilException {
        String[] errorString;
        CommandResult result = null;
        String[] env = null;
        String[] args = new String[]{"resetRepos"};
        try {
            result = this.m_cmdTool.execute(args, env, user, true, false);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_RESETREPOS_FAIL, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdTool.execute() failed");
            StringBuilder stringBuilder = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                stringBuilder.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_RESETREPOS_FAIL, stringBuilder.toString());
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("No output from 'srvmhelper resetRepos'");
            String localHost = null;
            try {
                localHost = Utils.getLocalHost();
                Trace.out((Object)"localHost: %s", localHost);
            }
            catch (UnknownHostException e) {
                Trace.out("Could not get local host. Using LOCALNODE.");
                localHost = "localnode";
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, localHost);
        }
    }

    public List<String> getAdminDatabases(String node) throws InvalidArgsException, CmdToolUtilException {
        Trace.out((Object)"retrieving admin databases running on node %s", node);
        if (node == null || node.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SRVMHELPER-getAdminDBs-node");
        }
        String[] args = new String[]{"-getAdminDBRunOnNode", node};
        String[] env = null;
        CommandResult result = null;
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ADMIN_DBS_FAIL, (Throwable)e, node);
        }
        if (!result.getBooleanResult()) {
            String errMsg = this.getErrorMessage(result);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ADMIN_DBS_FAIL, (Throwable)new Exception(errMsg), node);
        }
        String cmdOutput = this.getOutput(result);
        if (cmdOutput == null) {
            Trace.out("srvmhelper cmd produced empty output, throwing CmdToolUtilException ...");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        return cmdOutput.trim().isEmpty() ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(cmdOutput.split(",")));
    }

    public Map<NodeRole, List<String>> getActiveServers(String serverPoolName) throws CmdToolUtilException {
        CommandResult result = null;
        String[] env = null;
        String[] args = new String[]{SRVMHELPER_GET_ACTIVE_SERVERS, serverPoolName};
        if (serverPoolName == null) {
            Trace.out("srvmhelper getActiveServers executed with null server pool name");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SHgetActiveServerss001");
        }
        String fullCmd = SRVMHELPER + " " + SRVMHELPER_GET_ACTIVE_SERVERS + " " + serverPoolName;
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            Trace.out("srvmhelper execution failed " + e.getMessage());
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ACTIVE_SERVERS_FAIL, serverPoolName, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult()) {
            String[] errorString = result.getResultString();
            if (errorString != null && errorString.length > 0) {
                String err = Utils.getString(errorString, NEWLINE);
                Trace.out("srvmhelper execution failed " + err);
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ACTIVE_SERVERS_FAIL, serverPoolName, err);
            }
            Trace.out("srvmhelper execution failed - error string empty");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, fullCmd, "localnode");
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 1) {
            Trace.out("srvmhelper getActiveServers executed with empty output");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, fullCmd, "localnode");
        }
        List<Object> activeHubServerList = new ArrayList();
        List<Object> activeLeafServerList = new ArrayList();
        String hubServers = null;
        String leafServers = null;
        String[] outArr = HelperUtil.fetchOutput(cmdOutput);
        if (outArr.length != 2) {
            Trace.out("Got no output or multiple output from srvmhelper. Should never happen:" + outArr.length);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, fullCmd, "localnode");
        }
        hubServers = HelperUtil.fetchTextByTags(outArr[0], "<ACTIVE_HUB_SERVERS>", "</ACTIVE_HUB_SERVERS>");
        leafServers = HelperUtil.fetchTextByTags(outArr[1], "<ACTIVE_LEAF_SERVERS>", "</ACTIVE_LEAF_SERVERS>");
        if (!hubServers.isEmpty()) {
            activeHubServerList = Arrays.asList(hubServers.split(","));
        }
        if (!leafServers.isEmpty()) {
            activeLeafServerList = Arrays.asList(leafServers.split(","));
        }
        Trace.out("Active hub servers " + activeHubServerList);
        Trace.out("Active leaf servers " + activeLeafServerList);
        HashMap<NodeRole, List<String>> serverMap = new HashMap<NodeRole, List<String>>();
        serverMap.put(NodeRole.HUB, activeHubServerList);
        serverMap.put(NodeRole.RIM, activeLeafServerList);
        return serverMap;
    }

    public List<String> getACFSMountNodes(String volDevice) throws InvalidArgsException, CmdToolUtilException {
        if (volDevice == null || volDevice.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SRVMHELPER-getACFSMountNodes-volDevice");
        }
        return this.doGetACFSMountNodes(volDevice, null, null);
    }

    public List<String> getACFSMountNodes(String dgName, String volName) throws InvalidArgsException, CmdToolUtilException {
        if (dgName == null || dgName.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SRVMHELPER-getACFSMountNodes-dgName");
        }
        if (volName == null || volName.trim().isEmpty()) {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SRVMHELPER-getACFSMountNodes-volName");
        }
        return this.doGetACFSMountNodes(null, dgName, volName);
    }

    private List<String> doGetACFSMountNodes(String volDevice, String dgName, String volName) throws InvalidArgsException, CmdToolUtilException {
        String[] args = new String[4];
        boolean isDeviceCase = false;
        args[0] = SRVMHELPER_ACFS_MTPOINT_NODES;
        if (volDevice != null) {
            isDeviceCase = true;
            args[1] = volDevice;
            args[2] = "";
            args[3] = "";
        } else if (dgName != null && volName != null) {
            args[1] = "";
            args[2] = dgName;
            args[3] = volName;
        } else {
            throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SRVMHELPER-getACFSMountNodes-ANInput");
        }
        String[] env = null;
        CommandResult result = null;
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            if (isDeviceCase) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ACFS_NODES_FAIL_DEV, (Throwable)e, volDevice);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ACFS_NODES_FAIL_DG, (Throwable)e, dgName, volName);
        }
        if (!result.getBooleanResult()) {
            String errMsg = this.getErrorMessage(result);
            if (isDeviceCase) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ACFS_NODES_FAIL_DEV, (Throwable)new Exception(errMsg), volDevice);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_ACFS_NODES_FAIL_DG, (Throwable)new Exception(errMsg), dgName, volName);
        }
        String cmdOutput = this.getOutput(result);
        if (cmdOutput == null) {
            Trace.out("srvmhelper cmd produced empty output, throwing CmdToolUtilException ...");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        return cmdOutput.trim().isEmpty() ? new ArrayList() : Arrays.asList(cmdOutput.split(","));
    }

    public boolean isACFSNodeLocal(String volDevice) throws InvalidArgsException, CmdToolUtilException {
        CommandResult result;
        block5: {
            String[] args = new String[2];
            boolean isDeviceCase = false;
            args[0] = SRVMHELPER_IS_ACFS_NODE_LOCAL;
            if (volDevice == null || volDevice.isEmpty()) {
                throw new InvalidArgsException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SRVMHELPER-isACFSNodeLocal-ANInput");
            }
            args[1] = volDevice;
            String[] env = null;
            result = null;
            try {
                result = this.m_cmdTool.executeLocally(args, env);
            }
            catch (CmdToolUtilException e) {
                if (!isDeviceCase) break block5;
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_IS_ACFS_NODELOCAL_FAIL, (Throwable)e, volDevice);
            }
        }
        if (!result.getBooleanResult()) {
            String errMsg = this.getErrorMessage(result);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_IS_ACFS_NODELOCAL_FAIL, (Throwable)new Exception(errMsg), volDevice);
        }
        String cmdOutput = this.getOutput(result);
        if (cmdOutput == null) {
            Trace.out("srvmhelper cmd produced empty output, throwing CmdToolUtilException ...");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        return cmdOutput.equalsIgnoreCase("1");
    }

    public String getScanName(int netnum) throws CmdToolUtilException {
        Trace.out("Getting scan name for netnum: " + netnum);
        String[] env = null;
        CommandResult result = null;
        String[] args = new String[]{SRVMHELPER_GET_SCAN_NAME, String.valueOf(netnum)};
        try {
            result = this.m_cmdTool.executeLocally(args, env);
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_SCAN_NAME_FAIL, netnum, HelperUtil.formatExceptionMessage(e.getMessage()));
        }
        if (!result.getBooleanResult()) {
            String errorString = this.getErrorMessage(result);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_GET_SCAN_NAME_FAIL, netnum, errorString);
        }
        String cmdOutput = this.getOutput(result);
        if (cmdOutput == null) {
            Trace.out("srvmhelper -getScanName command executed, but produced empty output");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        return cmdOutput;
    }

    private String getErrorMessage(CommandResult result) {
        StringBuilder sb = new StringBuilder();
        if (result == null) {
            return sb.toString();
        }
        String[] output = result.getResultString();
        if (output != null && output.length > 0) {
            for (int i = 0; i < output.length; ++i) {
                if (!"<HLP_EMSG>".equals(output[i])) continue;
                for (int j = i + 1; j < output.length && !"</HLP_EMSG>".equals(output[j]); ++j) {
                    sb.append((sb.length() == 0 ? "" : NEWLINE) + output[j]);
                }
            }
        }
        return sb.toString();
    }

    private String getOutput(CommandResult result) {
        if (result == null) {
            return null;
        }
        String[] output = result.getResultString();
        if (output == null || output.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < output.length; ++i) {
            if (!"<HLP_OUT>".equals(output[i])) continue;
            for (int j = i + 1; j < output.length && !"</HLP_OUT>".equals(output[j]); ++j) {
                Trace.out((Object)"appending %s ...", output[j]);
                sb.append((sb.length() == 0 ? "" : NEWLINE) + output[j]);
            }
        }
        return sb.toString();
    }

    public RHPContainerType getRHPClusterType() throws CmdToolUtilException {
        RHPContainerType rhpType;
        String[] args = new String[]{SRVMHELPER_GET_RHP_CLUSTER_TYPE};
        String[] env = null;
        CommandResult result = null;
        result = this.m_cmdTool.executeLocally(args, env);
        if (!result.getBooleanResult()) {
            String errMsg = this.getErrorMessage(result);
            Trace.out(errMsg);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVMHELPER_IS_RHP_CONFIGURED_FAIL, (Throwable)new Exception(errMsg), new Object[0]);
        }
        String[] cmdOutput = result.getResultString();
        if (cmdOutput == null || cmdOutput.length < 2) {
            Trace.out("srvmhelper cmd produced empty output, throwing CmdToolUtilException .");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, SRVMHELPER, "localnode");
        }
        try {
            rhpType = RHPContainerType.getEnumMember(cmdOutput[1]);
        }
        catch (EnumConstNotFoundException ne) {
            rhpType = RHPContainerType.NONE;
        }
        return rhpType;
    }
}

