/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.util.StringJoiner;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class SRVCTLUtil {
    private CmdToolUtil m_cmdtool;
    private String m_home = null;
    static final String SRVCTLUTL = new SystemFactory().CreateSystem().getScriptFileName("srvctl");
    private static final String EXE_LOC = "bin";
    static final String[] SRVCTLUTL_DEP = new String[]{SRVCTLUTL};
    private static final String STATUS_CMD = "status";
    private static final String CONFIG_CMD = "config";
    private static final String MGMTLSNR_NOUN = "mgmtlsnr";
    private static final String MGMTDB_NOUN = "mgmtdb";
    private static final String RHPSERVER_NOUN = "rhpserver";
    private static final String RHPCLIENT_NOUN = "rhpclient";
    private static final String VERSION_OPT = "-V";
    private static final String INNER_OPT = "-inner";
    private static final String INNER_VALUE = "1";
    private static final String COL_DELIMITER = ":";
    private static final String DOT_DELIMITER = "\\.";
    private static final String BRACE_DELIMITER = "\\{";
    private static final String COMMA_DELIMITER = ",";
    private static final String RHP_DG_STR = "Disk Groups: ";
    private static final String PRCR_1001_STR = "PRCR-1001";
    private static final int MAX_RETRIES = 3;
    private static final String EXCEPTION_CLASS_NOCLASSDEFFOUND = "java.lang.NoClassDefFoundError";

    public SRVCTLUtil(String oHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(oHome, false);
        String toolLoc = oHome + File.separator + EXE_LOC;
        String srvctlutl = toolLoc + File.separator + SRVCTLUTL;
        File srvctlfile = new File(srvctlutl);
        Trace.out("Check " + srvctlutl);
        if (!srvctlfile.exists()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_HOME_NO_SRVCTL, oHome, EXE_LOC + File.separator + SRVCTLUTL);
        }
        this.m_home = oHome;
        this.m_cmdtool = new CmdToolUtil(SRVCTLUTL, toolLoc, SRVCTLUTL_DEP);
    }

    public Version getSRVCTLVersion() throws CmdToolUtilException {
        return this.getVersion("localnode", false);
    }

    public Version getSRVCTLVersion(String nodeName) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        return this.getVersion(nodeName, false);
    }

    public Version getSRVCTLVersionNLS() throws CmdToolUtilException {
        return this.getVersion("localnode", true);
    }

    public Version getSRVCTLVersionNLS(String nodeName) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        return this.getVersion(nodeName, true);
    }

    public CommandResult runCommand(String nodeName, String[] arguments) throws CmdToolUtilException {
        String[] envs = null;
        envs = new String[]{"ORACLE_HOME=" + this.m_home};
        CommandResult result = null;
        result = nodeName.equalsIgnoreCase("localnode") ? this.m_cmdtool.executeLocally(arguments, envs) : this.m_cmdtool.execute(nodeName, arguments, envs, false, true);
        return result;
    }

    private Version getVersion(String nodeName, boolean nlsRes) throws CmdToolUtilException {
        String[] errorString;
        int argcount = nlsRes ? 3 : 1;
        String[] args = new String[argcount];
        if (nlsRes) {
            args[0] = VERSION_OPT;
            args[1] = INNER_OPT;
            args[2] = INNER_VALUE;
        } else {
            args[0] = VERSION_OPT;
        }
        CommandResult result = null;
        try {
            result = this.runCommandWithRetryForHP(nodeName, args);
        }
        catch (CmdToolUtilException e) {
            if (nodeName.equalsIgnoreCase("localnode")) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_VERSION_FAILED, this.m_cmdtool.getSourceLocation(), e.toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_VERSION_FAILED_NODE, nodeName, this.m_cmdtool.getSourceLocation(), e.toString());
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            if (nodeName.equalsIgnoreCase("localnode")) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_VERSION_FAILED, this.m_cmdtool.getSourceLocation(), sb.toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_VERSION_FAILED_NODE, nodeName, this.m_cmdtool.getSourceLocation(), sb.toString());
        }
        String[] cmdOutPut = result.getResultString();
        String cmdOutString = Utils.getString(cmdOutPut, Constants.LINE_SEPARATOR);
        Trace.out("Command output for  is " + cmdOutString);
        String versionstr = this.getVersionFromResult(cmdOutPut, nodeName, nlsRes);
        Version version = null;
        try {
            Version.VersionEnum verEnum = Version.VersionEnum.getEnumMember(versionstr);
            version = verEnum.toVersion();
        }
        catch (ConfigurationException e) {
            if (nodeName.equalsIgnoreCase("localnode")) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_VERSION_FAILED, this.m_cmdtool.getSourceLocation(), e.getMessage());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_VERSION_FAILED_NODE, nodeName, this.m_cmdtool.getSourceLocation(), e.getMessage());
        }
        return version;
    }

    private String getVersionFromResult(String[] cmdOutString, String nodeName, boolean nlsFlag) throws CmdToolUtilException {
        String retVal = null;
        if (cmdOutString == null) {
            if (nodeName.equalsIgnoreCase("localnode")) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_GET_VERSION_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_GET_VERSION_PARSE_OUTPUT_FAIL_NODE, nodeName, this.m_cmdtool.getSourceLocation());
        }
        Trace.out("Number of output lines:" + cmdOutString.length);
        for (int i = 0; i < cmdOutString.length; ++i) {
            Trace.out("Parsing Output line:" + cmdOutString[i]);
            String[] values = nlsFlag ? cmdOutString[i].split(BRACE_DELIMITER) : cmdOutString[i].split(COL_DELIMITER);
            NativeSystem ns = new SystemFactory().CreateSystem();
            boolean isUnixSystem = ns.isUnixSystem();
            if (values.length != 2 || values[1].trim().split(DOT_DELIMITER).length != 5) continue;
            try {
                Trace.out("First Token is " + values[0].trim() + ", checking if it contains version before the equality");
                if (isUnixSystem && !values[0].trim().contains("version")) continue;
                retVal = nlsFlag ? values[1].trim().substring(0, values[1].trim().length() - 1) : values[1].trim();
                return retVal;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (nodeName.equalsIgnoreCase("localnode")) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_GET_VERSION_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
                }
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_GET_VERSION_PARSE_OUTPUT_FAIL_NODE, nodeName, this.m_cmdtool.getSourceLocation());
            }
        }
        if (nodeName.equalsIgnoreCase("localnode")) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_GET_VERSION_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_GET_VERSION_PARSE_OUTPUT_FAIL_NODE, nodeName, this.m_cmdtool.getSourceLocation());
    }

    public String getMgmtLsnrNode() throws CmdToolUtilException {
        String[] args = new String[]{STATUS_CMD, MGMTLSNR_NOUN, INNER_OPT, INNER_VALUE};
        String out = this.runCmd(args)[0];
        return this.getValFromOut(out, "up");
    }

    public String[] getMgmtLsnrPorts() throws CmdToolUtilException {
        String[] args = new String[]{CONFIG_CMD, MGMTLSNR_NOUN, INNER_OPT, INNER_VALUE};
        String out = this.runCmd(args)[0];
        return this.getValFromOut(out, "ports").split(COMMA_DELIMITER);
    }

    public String getMgmtDBPDB() throws CmdToolUtilException {
        String[] args = new String[]{CONFIG_CMD, MGMTDB_NOUN, INNER_OPT, INNER_VALUE};
        String out = this.runCmd(args)[0];
        return this.getValFromOut(out, "pdb_name");
    }

    public boolean isRHPConfigured(boolean isRHPServer) throws CmdToolUtilException {
        boolean isRHP = false;
        Version srvctlVersion = this.getSRVCTLVersion();
        if (!Version.isPre12102(srvctlVersion)) {
            String[] args = new String[]{CONFIG_CMD, isRHPServer ? RHPSERVER_NOUN : RHPCLIENT_NOUN};
            try {
                CommandResult result = this.runCommandWithRetryForHP("localnode", args);
                isRHP = result.getBooleanResult();
            }
            catch (CmdToolUtilException cmde) {
                if (cmde.getMessage().contains(PRCR_1001_STR)) {
                    isRHP = false;
                }
                throw cmde;
            }
        }
        return isRHP;
    }

    public String[] getRHPDiskgroups() throws CmdToolUtilException {
        String[] args = new String[]{CONFIG_CMD, RHPSERVER_NOUN};
        String[] out = this.runCmd(args);
        if (out == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SRVCTLUtil-getRHPDiskgroups-nullOut");
        }
        String[] dgArr = null;
        for (String s : out) {
            if (!s.contains(RHP_DG_STR)) continue;
            String dgStr = s.substring(RHP_DG_STR.length(), s.length());
            Trace.out((Object)"RHP disk groups: %s", dgStr);
            dgArr = dgStr.split(COMMA_DELIMITER);
            break;
        }
        return dgArr;
    }

    private String[] runCmd(String[] args) throws CmdToolUtilException {
        return this.runCmd("localnode", args);
    }

    private String[] runCmd(String node, String[] args) throws CmdToolUtilException {
        String[] errorString;
        StringJoiner cmd = new StringJoiner(" ");
        cmd.add(SRVCTLUTL);
        for (String arg : args) {
            cmd.add(arg);
        }
        Trace.out((Object)"Command to run: %s", cmd.toString());
        CommandResult result = null;
        try {
            result = this.runCommandWithRetryForHP(node, args);
        }
        catch (CmdToolUtilException e) {
            Trace.out((Object)"CmdToolUtilException: %s", e.getMessage());
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_CMD_FAILED, cmd.toString(), this.m_cmdtool.getSourceLocation(), e.getMessage());
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed");
            StringBuilder sb = new StringBuilder();
            for (String err : errorString) {
                sb.append(err);
            }
            Trace.out((Object)"Error: %s", sb.toString());
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SRVCTL_CMD_FAILED, cmd.toString(), this.m_cmdtool.getSourceLocation(), sb.toString());
        }
        String[] out = result.getResultString();
        Trace.out((Object)"Output: %s", Utils.getString(out, Constants.LINE_SEPARATOR));
        return out;
    }

    private String getValFromOut(String out, String key) throws CmdToolUtilException {
        if (out == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, "SRVCTLUtil-getValFromOut-null");
        }
        int start = out.indexOf(" " + key + "={") + key.length() + 3;
        int end = out.indexOf(125, start);
        String val = out.substring(start, end);
        Trace.out("The value for key %s is %s", key, val);
        return val;
    }

    private CommandResult runCommandWithRetryForHP(String node, String[] args) throws CmdToolUtilException {
        CommandResult result = null;
        String osName = DeterminePlatform.getOSName();
        Trace.out("OS Name is..." + osName);
        if (!osName.equals("HP-UX")) {
            result = this.runCommand(node, args);
        } else {
            Trace.out("HP Specific");
            boolean executecmd = true;
            int count = 0;
            while (executecmd) {
                Trace.out("Enter loop " + ++count);
                Trace.out("executecmd " + executecmd);
                try {
                    result = this.runCommand(node, args);
                    executecmd = false;
                    Trace.out("Command execution Success");
                }
                catch (CmdToolUtilException e) {
                    Trace.out("CmdToolUtilException");
                    Trace.out(e);
                    if (e.getMessage().contains(EXCEPTION_CLASS_NOCLASSDEFFOUND) && count != 3) continue;
                    throw e;
                }
            }
        }
        return result;
    }
}

