/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.RemoteListener;
import oracle.cluster.database.StopOptions;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.Constants;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class SQLPLUSUtil {
    private CmdToolUtil m_cmdtool;
    private String m_home = null;
    private RemoteUserInfo m_uInfo = null;
    static final String SQLPLUSUTL = new SystemFactory().CreateSystem().getExeName("sqlplus");
    private static final String EXE_LOC = "bin";
    static final String[] SQLPLUSUTL_DEP = new String[]{SQLPLUSUTL};
    private static final String SQLPLUS_VERSION = "-V";
    private static final String SHUTDOWN = "shutdown";
    private static final String STARTUP = "startup;";
    private static final String SET_CONTAINER = "alter session set container=";
    private static final String GRANT = "grant ";
    private static final String TO = " to ";
    private static final String ID_BY = " identified by ";
    private static final String CREATE_DIR = "create directory ";
    private static final String DROP_DIR = "drop directory ";
    private static final String AS = " as ";
    private static final String EXIT = "exit";
    private static final String CONNECT_SYSDBA = " / as sysdba";
    private static final String SPACE_DELIMITER = "\\ ";
    private static final String DOT = "\\.";
    private static final String DIGITS = "[\\d]+";
    private static final String LD_LIBRARY_PATH_ENV = "LD_LIBRARY_PATH";
    private static final String LD_LIBRARY_PATH64_ENV = "LD_LIBRARY_PATH_64";
    private static final String ORACLE_HOME_ENV = "ORACLE_HOME";

    public SQLPLUSUtil(String oHome) throws CmdToolUtilException {
        this(oHome, true);
    }

    public SQLPLUSUtil(String oHome, boolean isLocal) throws CmdToolUtilException {
        CmdToolUtil.assertDir(oHome, false);
        String toolLoc = oHome + File.separator + EXE_LOC;
        if (isLocal) {
            String sqlplusutl = toolLoc + File.separator + SQLPLUSUTL;
            Trace.out((Object)"Checking existence of %s", sqlplusutl);
            if (!new File(sqlplusutl).exists()) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_HOME_NO_SQLPLUS, oHome, EXE_LOC + File.separator + SQLPLUSUTL);
            }
        }
        this.m_home = oHome;
        this.m_cmdtool = new CmdToolUtil(SQLPLUSUTL, toolLoc, SQLPLUSUTL_DEP);
    }

    public SQLPLUSUtil(String oHome, RemoteUserInfo uInfo) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(oHome, "SQLPLUSUtil-constr2-oHome");
        oracle.cluster.impl.util.Utils.assertInputNotNull(uInfo, "SQLPLUSUtil-constr2-uInfo");
        String toolLoc = oHome + File.separator + EXE_LOC;
        this.m_home = oHome;
        this.m_uInfo = uInfo;
        this.m_cmdtool = new CmdToolUtil(uInfo, SQLPLUSUTL, toolLoc);
    }

    public SQLPLUSUtil(String oHome, RemoteUserInfo uInfo, RemoteListener lsnr) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(oHome, "SQLPLUSUtil-constr3-oHome");
        oracle.cluster.impl.util.Utils.assertInputNotNull(uInfo, "SQLPLUSUtil-constr3-uInfo");
        oracle.cluster.impl.util.Utils.assertInputNotNull(lsnr, "SQLPLUSUtil-constr3-lsnr");
        String toolLoc = oHome + File.separator + EXE_LOC;
        this.m_home = oHome;
        this.m_uInfo = uInfo;
        this.m_cmdtool = new CmdToolUtil(uInfo, SQLPLUSUTL, toolLoc, lsnr);
    }

    public Version getSQLPLUSVersion() throws CmdToolUtilException {
        return this.getVersion("localnode");
    }

    public Version getSQLPLUSVersion(String nodeName) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        return this.getVersion(nodeName);
    }

    public String getSQLPLUSVersionStr() throws CmdToolUtilException {
        return this.getVersionStr("localnode");
    }

    public String getSQLPLUSVersionStr(String nodeName) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodeName);
        return this.getVersionStr(nodeName);
    }

    public void stopDatabase(String sid, StopOptions stopOpt, String node, String asUser) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(sid, "SQLPLUSUtil-stopDB-sid");
        oracle.cluster.impl.util.Utils.assertInput(node, "SQLPLUSUtil-stopDB-node");
        oracle.cluster.impl.util.Utils.assertInputNotNull((Object)stopOpt, "SQLPLUSUtil-stopDB-stopOpt");
        oracle.cluster.impl.util.Utils.assertInput(asUser, "SQLPLUSUtil-stopDB-asUser");
        String sidEnv = "ORACLE_SID=" + sid;
        List<String> envList = this.getEnvs();
        envList.add(sidEnv);
        String[] env = envList.toArray(new String[envList.size()]);
        String[] args = new String[]{CONNECT_SYSDBA};
        String[] stdIn = new String[]{"shutdown " + stopOpt.toString() + ";", EXIT};
        Trace.out((Object)"stopping database %s using sqlplus ...", sid);
        this.m_cmdtool.execute(node, args, env, stdIn, asUser, false);
        Trace.out((Object)"stopped database %s", sid);
    }

    public void startDatabase(String sid, String node, String asUser) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(sid, "SQLPLUSUtil-startDB-sid");
        oracle.cluster.impl.util.Utils.assertInput(node, "SQLPLUSUtil-startDB-node");
        oracle.cluster.impl.util.Utils.assertInput(asUser, "SQLPLUSUtil-startDB-asUser");
        String sidEnv = "ORACLE_SID=" + sid;
        List<String> envList = this.getEnvs();
        envList.add(sidEnv);
        String[] env = envList.toArray(new String[envList.size()]);
        String[] args = new String[]{CONNECT_SYSDBA};
        String[] stdIn = new String[]{STARTUP, EXIT};
        Trace.out((Object)"starting database %s using sqlplus ...", sid);
        this.m_cmdtool.execute(node, args, env, stdIn, asUser, false);
        Trace.out((Object)"started database %s", sid);
    }

    public void grantPermission(String node, String sid, String pdb, String schema, String perm) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(node, "SQLPLUSUtil-grantPermission-node");
        oracle.cluster.impl.util.Utils.assertInput(sid, "SQLPLUSUtil-grantPermission-sid");
        oracle.cluster.impl.util.Utils.assertInput(pdb, "SQLPLUSUtil-grantPermission-pdb");
        oracle.cluster.impl.util.Utils.assertInput(schema, "SQLPLUSUtil-grantPermission-schema");
        oracle.cluster.impl.util.Utils.assertInput(perm, "SQLPLUSUtil-grantPermission-perm");
        this.doGrantPermission(node, sid, pdb, schema, perm, null);
    }

    public void grantPermission(String node, String sid, String pdb, String schema, String perm, String pwd) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(node, "SQLPLUSUtil-grantPermission-node");
        oracle.cluster.impl.util.Utils.assertInput(sid, "SQLPLUSUtil-grantPermission-sid");
        oracle.cluster.impl.util.Utils.assertInput(pdb, "SQLPLUSUtil-grantPermission-pdb");
        oracle.cluster.impl.util.Utils.assertInput(schema, "SQLPLUSUtil-grantPermission-schema");
        oracle.cluster.impl.util.Utils.assertInput(perm, "SQLPLUSUtil-grantPermission-perm");
        oracle.cluster.impl.util.Utils.assertInput(pwd, "SQLPLUSUtil-grantPermission-pwd");
        this.doGrantPermission(node, sid, pdb, schema, perm, pwd);
    }

    private void doGrantPermission(String node, String sid, String pdb, String schema, String perm, String pwd) throws InvalidArgsException, CmdToolUtilException {
        String sidEnv = "ORACLE_SID=" + sid;
        List<String> envList = this.getEnvs();
        envList.add(sidEnv);
        String[] env = envList.toArray(new String[envList.size()]);
        String[] args = new String[]{CONNECT_SYSDBA};
        String createStr = pwd == null ? "" : ID_BY + pwd;
        String[] stdIn = new String[]{SET_CONTAINER + pdb + ";", GRANT + perm + TO + schema + createStr + ";", EXIT};
        Trace.out("Granting %s to schema %s on db %s & pdb %s on node %s", perm, schema, sid, pdb, node);
        this.m_cmdtool.execute(node, args, env, stdIn);
        Trace.out("Permission granted");
    }

    public void createDir(String node, String sid, String pdb, String dirName, String dir) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(node, "SQLPLUSUtil-createDir-node");
        oracle.cluster.impl.util.Utils.assertInput(sid, "SQLPLUSUtil-createDir-sid");
        oracle.cluster.impl.util.Utils.assertInput(pdb, "SQLPLUSUtil-createDir-pdb");
        oracle.cluster.impl.util.Utils.assertInput(dirName, "SQLPLUSUtil-createDir-dirName");
        oracle.cluster.impl.util.Utils.assertInput(dir, "SQLPLUSUtil-createDir-dir");
        String sidEnv = "ORACLE_SID=" + sid;
        List<String> envList = this.getEnvs();
        envList.add(sidEnv);
        String[] env = envList.toArray(new String[envList.size()]);
        String[] args = new String[]{CONNECT_SYSDBA};
        String[] stdIn = new String[]{SET_CONTAINER + pdb + ";", CREATE_DIR + dirName + AS + "'" + dir + "';", EXIT};
        Trace.out("Creating dir %s with path %s on db %s & pdb %s on node %s", dirName, dir, sid, pdb, node);
        this.m_cmdtool.execute(node, args, env, stdIn);
        Trace.out((Object)"Directory %s created", dirName);
    }

    public void dropDir(String node, String sid, String pdb, String dirName) throws InvalidArgsException, CmdToolUtilException {
        oracle.cluster.impl.util.Utils.assertInput(node, "SQLPLUSUtil-dropDir-node");
        oracle.cluster.impl.util.Utils.assertInput(sid, "SQLPLUSUtil-dropDir-sid");
        oracle.cluster.impl.util.Utils.assertInput(pdb, "SQLPLUSUtil-dropDir-pdb");
        oracle.cluster.impl.util.Utils.assertInput(dirName, "SQLPLUSUtil-dropDir-dirName");
        String sidEnv = "ORACLE_SID=" + sid;
        List<String> envList = this.getEnvs();
        envList.add(sidEnv);
        String[] env = envList.toArray(new String[envList.size()]);
        String[] args = new String[]{CONNECT_SYSDBA};
        String[] stdIn = new String[]{SET_CONTAINER + pdb + ";", DROP_DIR + dirName + ";", EXIT};
        Trace.out("Dropping directory %s on db %s & pdb %s on node %s", dirName, sid, pdb, node);
        this.m_cmdtool.execute(node, args, env, stdIn);
        Trace.out((Object)"Directory %s dropped", dirName);
    }

    private Version getVersion(String nodeName) throws CmdToolUtilException {
        String verStr = null;
        Version version = null;
        verStr = this.getVersionStr(nodeName);
        try {
            Version.VersionEnum verEnum = Version.VersionEnum.getEnumMember(verStr);
            version = verEnum.toVersion();
        }
        catch (ConfigurationException e) {
            if (nodeName.equalsIgnoreCase("localnode")) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SQLPLUS_VERSION_FAILED, this.m_cmdtool.getSourceLocation(), e.getMessage());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SQLPLUS_VERSION_FAILED_NODE, nodeName, this.m_cmdtool.getSourceLocation(), e.getMessage());
        }
        return version;
    }

    private String getVersionStr(String nodeName) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{SQLPLUS_VERSION};
        List<String> envList = this.getEnvs();
        String[] envs = envList.toArray(new String[envList.size()]);
        CommandResult result = null;
        result = nodeName.equalsIgnoreCase("localnode") ? this.m_cmdtool.executeLocally(args, envs) : this.m_cmdtool.execute(nodeName, args, envs, false, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            if (nodeName.equalsIgnoreCase("localnode")) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SQLPLUS_VERSION_FAILED, this.m_cmdtool.getSourceLocation(), sb.toString());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SQLPLUS_VERSION_FAILED_NODE, nodeName, this.m_cmdtool.getSourceLocation(), sb.toString());
        }
        String[] cmdOutPut = result.getResultString();
        String cmdOutString = Utils.getString(cmdOutPut, Constants.LINE_SEPARATOR);
        Trace.out("Command output for  is " + cmdOutString);
        String versionstr = this.getVersionFromResult(cmdOutPut, nodeName);
        return versionstr;
    }

    private String getVersionFromResult(String[] cmdOutString, String nodeName) throws CmdToolUtilException {
        Object retVal = null;
        if (cmdOutString == null) {
            if (nodeName.equalsIgnoreCase("localnode")) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.SQLPLUS_GET_VERSION_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SQLPLUS_GET_VERSION_PARSE_OUTPUT_FAIL_NODE, nodeName, this.m_cmdtool.getSourceLocation());
        }
        for (int i = 0; i < cmdOutString.length; ++i) {
            Trace.out((Object)"Parsing Output line: %s", cmdOutString[i]);
            String[] values = cmdOutString[i].trim().split(SPACE_DELIMITER);
            String versionRegex = "[\\d]+\\.[\\d]+\\.[\\d]+\\.[\\d]+\\.[\\d]+";
            for (String str : values) {
                if (!str.trim().matches(versionRegex)) continue;
                Trace.out("Version String retrieved is :" + str.trim());
                return str.trim();
            }
        }
        Trace.out("Could not find version in cmd output");
        String cmdOutStr = Utils.getString(cmdOutString, Constants.LINE_SEPARATOR);
        if (nodeName.equalsIgnoreCase("localnode")) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.SQLPLUS_GET_VERSION_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation(), cmdOutStr);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.SQLPLUS_GET_VERSION_PARSE_OUTPUT_FAIL_NODE, nodeName, this.m_cmdtool.getSourceLocation(), cmdOutStr);
    }

    private List<String> getEnvs() {
        ArrayList<String> envList = new ArrayList<String>();
        envList.add("ORACLE_HOME=" + this.getSafeVal(this.m_home));
        Trace.out("OS Name: " + DeterminePlatform.getOSName());
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            HashMap<String, String> envMap = new HashMap<String, String>(System.getenv());
            String libPath = this.m_home + "/lib";
            String ldLibPath = envMap.get(LD_LIBRARY_PATH_ENV);
            ldLibPath = ldLibPath == null ? libPath : libPath + ":" + ldLibPath;
            String libPathEnvVar = "LD_LIBRARY_PATH=" + this.getSafeVal(ldLibPath);
            Trace.out(libPathEnvVar);
            envList.add(libPathEnvVar);
            if (this.m_uInfo == null) {
                envMap.remove(ORACLE_HOME_ENV);
                envMap.remove(LD_LIBRARY_PATH_ENV);
                String libPath64 = envMap.get(LD_LIBRARY_PATH64_ENV);
                libPath64 = libPath64 == null ? libPath : libPath + ":" + libPath64;
                envMap.put(LD_LIBRARY_PATH64_ENV, libPath64);
                Trace.out("LD_LIBRARY_PATH_64=" + libPath64);
                for (String envvar : envMap.keySet()) {
                    if (SQLPLUSUtil.isValidName(envvar)) {
                        envList.add(envvar + "=" + this.getSafeVal(envMap.get(envvar)));
                        continue;
                    }
                    Trace.out((Object)"Skipping invalidly named variable %s", envvar);
                }
            }
        }
        return envList;
    }

    private static boolean isValidName(String var) {
        Pattern pattern = Pattern.compile("\\A[a-zA-Z_][a-zA-Z0-9_]*\\z");
        return pattern.matcher(var).find();
    }

    private String getSafeVal(String val) {
        return val.contains(" ") || val.contains(";") ? "\"" + val + "\"" : val;
    }
}

