/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.common.RemoteListener;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;

public class SQLPATCHUtil {
    private CmdToolUtil m_cmdtool;
    private String m_home = null;
    private Version m_homeVer = null;
    static final String SQLPATCHUTL = new SystemFactory().CreateSystem().getExeName("sqlpatch");
    private static final String EXE_LOC = "sqlpatch";
    private static final String DBNAME_OPTION = "-db";
    private static final String PREREQ_OPTION = "-prereq";
    private static final String HOME_OPTION = "-oh";

    public SQLPATCHUtil(String oHome, RemoteUserInfo uInfo) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oHome, "SQLPATCHUtil-constr-oHome");
        Utils.assertInputNotNull(uInfo, "SQLPATCHUtil-constr-uInfo");
        String toolLoc = oHome + File.separator + EXE_LOC;
        this.m_home = oHome;
        this.m_cmdtool = new CmdToolUtil(uInfo, SQLPATCHUTL, toolLoc);
    }

    public SQLPATCHUtil(String oHome, RemoteUserInfo uInfo, RemoteListener lsnr) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(oHome, "SQLPATCHUtil-constr2-oHome");
        Utils.assertInputNotNull(uInfo, "SQLPATCHUtil-constr2-uInfo");
        Utils.assertInputNotNull(uInfo, "SQLPATCHUtil-constr2-lsnr");
        String toolLoc = oHome + File.separator + EXE_LOC;
        this.m_home = oHome;
        this.m_cmdtool = new CmdToolUtil(uInfo, SQLPATCHUTL, toolLoc, lsnr);
    }

    public void executePatch(String sid, String node, String asUser) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(sid, "SQLPATCHUtil-executePatch-sid");
        Utils.assertInput(node, "SQLPATCHUtil-executePatch-node");
        Utils.assertInput(asUser, "SQLPATCHUtil-executePatch-asUser");
        String sidEnv = "ORACLE_SID=" + sid;
        String homeEnv = "ORACLE_HOME=" + this.m_home;
        String[] env = new String[]{sidEnv, homeEnv};
        String[] args = new String[]{DBNAME_OPTION, sid, HOME_OPTION, this.m_home};
        Trace.out("running sqlpatch ...");
        this.m_cmdtool.execute(node, args, env, null, asUser, false);
        Trace.out("completed sqlpatch");
    }

    public void executePrereqCheck(String sid, String node, String asUser) throws InvalidArgsException, CmdToolUtilException {
        Utils.assertInput(sid, "SQLPATCHUtil-execPreReq-sid");
        Utils.assertInput(node, "SQLPATCHUtil-execPreReq-node");
        Utils.assertInput(asUser, "SQLPATCHUtil-execPreReq-asUser");
        String sidEnv = "ORACLE_SID=" + sid;
        String homeEnv = "ORACLE_HOME=" + this.m_home;
        String[] env = new String[]{sidEnv, homeEnv};
        String[] args = new String[]{DBNAME_OPTION, sid, HOME_OPTION, this.m_home, PREREQ_OPTION};
        Trace.out("running sqlpatch ...");
        this.m_cmdtool.execute(node, args, env, null, asUser, false);
        Trace.out("completed sqlpatch");
    }
}

