/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterWindows;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class ORABASEUtil {
    private static final String ORABASE = new SystemFactory().CreateSystem().getExeName("orabase");
    private static final String EXE_LOC = "bin";
    private static final String[] ORABASE_DEP = new String[]{ORABASE};
    private static final boolean s_isUnixSystem = new SystemFactory().CreateSystem().isUnixSystem();
    private static String oraHome;
    private CmdToolUtil m_cmdTool;

    public ORABASEUtil(String oracleHome) throws CmdToolUtilException {
        CmdToolUtil.assertDir(oracleHome, true);
        oraHome = oracleHome;
        String toolLoc = oracleHome;
        toolLoc = toolLoc + File.separator + EXE_LOC;
        this.m_cmdTool = new CmdToolUtil(ORABASE, toolLoc, ORABASE_DEP);
        Trace.out("Toolname: " + ORABASE + "   ---   Tool location: " + toolLoc + "Tool dependencies: " + ORABASE_DEP);
    }

    public String getORABASE_LOC() throws CmdToolUtilException {
        return this.getORABASE_LOC("localnode");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getORABASE_LOC(String nodeName) throws CmdToolUtilException {
        String oracleBaseName;
        String oracleConfigLoc;
        String oracleBaseLoc;
        block15: {
            if (s_isUnixSystem) {
                String[] errorString;
                CmdToolUtil.assertNode(nodeName);
                String[] args = new String[]{};
                String[] env = new String[]{"ORACLE_HOME=" + oraHome};
                CommandResult result = null;
                result = nodeName.equals("localnode") ? this.m_cmdTool.executeLocally(args, env) : this.m_cmdTool.execute(nodeName, args, env, false);
                if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
                    Trace.out("cmdTool.execute() failed.");
                    StringBuilder stringBuilder = new StringBuilder("");
                    int i = 0;
                    while (true) {
                        if (i >= errorString.length) {
                            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORABASE_FAIL, stringBuilder.toString());
                        }
                        stringBuilder.append(errorString[i]);
                        ++i;
                    }
                }
                String[] cmdOutput = result.getResultString();
                if (cmdOutput != null) {
                    if (cmdOutput.length >= 1) return cmdOutput[0];
                }
                Trace.out("orabase command succeeded, but produced empty output, throwing CmdToolUtilException");
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.COMMAND_TOOL_FAIL, ORABASE, nodeName);
            }
            oracleBaseLoc = null;
            String oracleKeyLoc = oraHome + File.separator + EXE_LOC + File.separator + "oracle.key";
            BufferedReader br = null;
            oracleConfigLoc = null;
            oracleBaseName = "ORACLE_BASE";
            try {
                br = new BufferedReader(new FileReader(oracleKeyLoc));
                oracleConfigLoc = br.readLine();
                if (br == null) break block15;
            }
            catch (IOException e) {
                try {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORACLE_KEY_READ_FAIL, e.getMessage());
                }
                catch (Throwable throwable) {
                    if (br == null) throw throwable;
                    try {
                        br.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORACLE_KEY_READ_FAIL, e2.getMessage());
                    }
                }
            }
            try {
                br.close();
            }
            catch (IOException e) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORACLE_KEY_READ_FAIL, e.getMessage());
            }
        }
        oracleConfigLoc = "HKEY_LOCAL_MACHINE" + File.separator + oracleConfigLoc;
        Trace.out("Key Location: " + oracleConfigLoc);
        try {
            oracleBaseLoc = new ClusterWindows().getRegStringDataOnNode(oracleConfigLoc, oracleBaseName, nodeName);
            Trace.out("Oracle Base Location: " + oracleBaseLoc);
            if (oracleBaseLoc != null) return oracleBaseLoc;
            Object[] args = new Object[]{oracleConfigLoc + File.separator + oracleBaseName, nodeName};
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ORACLE_BASE_KEY_NULL, args);
        }
        catch (ClusterException ce) {
            throw new CmdToolUtilException(ce);
        }
    }
}

