/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.net.InetAddress;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;

public class OIFCFGResult {
    private String m_interfaceName;
    private InetAddress m_subnet;
    private String m_interfaceType;
    private InetAddress m_subnetMask;
    private int m_PrefixLength = 0;
    private String m_nodeScope;
    private IPAddressUtil.IPAddrType m_type;

    OIFCFGResult(String interfaceName, InetAddress subnetIPv4, String interfaceType, InetAddress subnetMaskIPv4) {
        this(interfaceName, subnetIPv4, interfaceType, subnetMaskIPv4, null);
    }

    OIFCFGResult(String interfaceName, InetAddress subnetIPv6, String interfaceType, int ipv6PrefixLength) throws IPAddressException {
        this(interfaceName, subnetIPv6, interfaceType, ipv6PrefixLength, null);
    }

    OIFCFGResult(String interfaceName, InetAddress subnetIPv4, String interfaceType, InetAddress subnetMaskIPv4, String nodeScope) {
        this.m_interfaceName = interfaceName.trim();
        this.m_interfaceType = interfaceType.trim();
        this.m_subnet = subnetIPv4;
        this.m_subnetMask = subnetMaskIPv4;
        this.m_nodeScope = nodeScope;
        this.m_type = IPAddressUtil.IPAddrType.IPv4;
        if (this.m_subnetMask != null) {
            this.m_PrefixLength = IPAddressUtil.getIPv4MaskPrefix(this.m_subnetMask.getHostAddress());
        }
    }

    OIFCFGResult(String interfaceName, InetAddress subnetIPv6, String interfaceType, int ipv6PrefixLength, String nodeScope) throws IPAddressException {
        this.m_interfaceName = interfaceName.trim();
        this.m_interfaceType = interfaceType.trim();
        this.m_subnet = subnetIPv6;
        this.m_PrefixLength = ipv6PrefixLength;
        this.m_subnetMask = IPAddressUtil.getIPv6Mask(ipv6PrefixLength);
        this.m_nodeScope = nodeScope;
        this.m_type = IPAddressUtil.IPAddrType.IPv6;
    }

    public String getInterfaceName() {
        return this.m_interfaceName;
    }

    public InetAddress getSubnet() {
        return this.m_subnet;
    }

    public String getInterfaceType() {
        return this.m_interfaceType;
    }

    public void setSubnetMask(InetAddress subnetMask, int netmaskPrefix) {
        this.m_subnetMask = subnetMask;
        this.m_PrefixLength = netmaskPrefix;
    }

    public InetAddress getSubnetMask() {
        return this.m_subnetMask;
    }

    public int getSubnetMaskPrefix() {
        return this.m_PrefixLength;
    }

    public String getSubnetMaskAsString() {
        if (this.m_type == IPAddressUtil.IPAddrType.IPv4) {
            return this.m_subnetMask.getHostAddress();
        }
        return String.valueOf(this.m_PrefixLength);
    }

    public String getNodeScope() {
        return this.m_nodeScope;
    }

    public IPAddressUtil.IPAddrType getType() {
        return this.m_type;
    }
}

