/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.cmdtools.ADVMUtil;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.deployment.ACFSInfo;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.resources.PrCtMsgID;
import oracle.cluster.util.AlreadyExistsException;
import oracle.cluster.util.NotExistsException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;

public class OFSUtil {
    public static final String ACFSUTIL_EXE_LOC = "bin";
    private static final String OFS_ERROR_1 = "ofs-error-1";
    private CmdToolUtil m_cmdtool;
    public static final String ACFSUTL = oracle.cluster.impl.util.Utils.getACFSUTILExeName();
    private final String[] ACFSUTL_DEP = new String[]{ACFSUTL};
    private static final String ACFSUTIL_OPT_OPER;
    private static final String MKFS_LOCATION;
    private static final String MKFS_TYPE_OPT;
    private static final String ACFSUTL_ARG_INFO = "info";
    private static final String ACFSUTL_ARG_FS = "fs";
    private static final String ACFSUTL_ARG_REGISTRY = "registry";
    private static final String ACFSUTL_ARG_SIZE = "size";
    private static final String ACFSUTL_FREESPACE = "freespace";
    private static final String ACFSUTL_TOTALSPACE = "totalspace";
    private static final String ACFSUTL_DISKGROUP = "diskgroup";
    private static final String ACFSUTL_ISMOUNTP = "ismountpoint";
    private static final String ACFSUTL_MOUNTPTS = "mountpoints";
    private static final String ACFSUTL_VERSION = "version";
    private static final String ACFSUTL_VERSION_VERBOSE_WIN = "\"/v\"";
    private static final String ACFSUTL_VERSION_VERBOSE_UNIX = "-v";
    private static final String ACFSUTL_AUXVOLUME = "auxvolume";
    private static final String ACFSUTL_ISAUXVOLUME = "isauxvolume";
    private static final String ACFSUTL_PRIMARY_VOL = "primaryvolume";
    private static final String ACFSUTL_VOLDEV_MTPT = "primaryvolume,mountpoint";
    private static final String ACFSUTL_OUT_OPT;
    private static final String ACFSUTL_M_DEVICE_OPT;
    private static final String ACFSUTL_L_DEVICE_OPT;
    private static final String ACFSUTL_ARG_SNAP = "snap";
    private static final String ACFSUTL_SNAP_CREATE = "create";
    private static final String ACFSUTL_SNAP_CONVERT = "convert";
    private static final String ACFSUTL_SNAP_DELETE = "delete";
    private static final String ACFSUTL_SNAP_READOPT = "-r";
    private static final String ACFSUTL_SNAP_WRITEOPT = "-w";
    private static final String ACFSUTL_SNAP_PSNAPOPT = "-p";
    private static final String ACFSUTL_SNAP_CLONEOPT = "-c";
    private static final String DELIMITER = "\\s+";
    private static final String COL_DELIMITER = ":";
    private static final String NEWLINE;
    private static final String TRUE_STRING = "1";
    private static final String FALSE_STRING = "0";
    static final String ACFSUTIL_NO_MOUNTED_FILESYSTEM = "ACFS-03036";
    static final String ACFSUTIL_NOT_ACFS_FILESYSTEM = "ACFS-03037";
    public static final String ACFSUTIL_UNP_SNAP_OPS = "ACFS-03046";
    public static final String ACFSUTIL_WAIT_SNAP_OPS = "ACFS-03047";
    public static final String ACFSUTIL_SNAP_INCOMP = "ACFS-03048";
    public static final String ACFSUTIL_TOO_MANY_SNAP = "ACFS-03212";
    public static final String ACFSUTIL_SNAP_EXST = "ACFS-03050";
    public static final String ACFSUTIL_SNAP_NOT_EXIST = "ACFS-03051";
    public static final String ACFSUTIL_NOT_SNAP_DEL = "ACFS-03052";
    public static final String ACFSUTIL_DEL_SNAP_FAIL = "ACFS-03053";
    public static final String ACFSUTIL_INV_SNAP_NAME = "ACFS-03054";
    public static final String ACFSUTIL_INSUFFICIENT_SPACE = "ACFS-03171";
    public static final String ACFSUTIL_SNAP_CLONE_TARGET = "CLONE TARGET";
    private static final String MKFS_NAME;
    public static final String MKFS;
    private final String[] MKFS_DEP = new String[]{MKFS};
    private static final String MKFS_TYPE_NAME = "acfs";
    private static final String RMFS_NAME = "rmfs";

    public OFSUtil() throws CmdToolUtilException {
        try {
            String binLoc = oracle.cluster.impl.util.Utils.getACFSUTILPath();
            this.m_cmdtool = new CmdToolUtil(ACFSUTL, binLoc, this.ACFSUTL_DEP);
        }
        catch (InstallException e) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_NO_DEFAULT_LOCATION, oracle.cluster.impl.util.Utils.getACFSUTILExeName());
        }
    }

    public OFSUtil(String location) throws CmdToolUtilException {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem() || new File(location + File.separator + ACFSUTL).exists()) {
            Trace.out("Using provided binary location:" + location);
            this.m_cmdtool = new CmdToolUtil(ACFSUTL, location, this.ACFSUTL_DEP);
        } else {
            this.m_cmdtool = new CmdToolUtil(ACFSUTL, nativeSystem.getOFSUtilLocation(), this.ACFSUTL_DEP);
        }
    }

    public OFSUtil(boolean iscreateFS) throws CmdToolUtilException {
        if (!iscreateFS && MKFS_LOCATION != null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_NO_DEFAULT_LOCATION, MKFS);
        }
        this.m_cmdtool = new CmdToolUtil(MKFS, MKFS_LOCATION, this.MKFS_DEP);
    }

    public String getOFSUtilDirectory() {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            return nativeSystem.getOFSUtilLocation();
        }
        return this.m_cmdtool.getSourceLocation();
    }

    public String getOFSUtilExeName() {
        return ACFSUTL;
    }

    public String getOFSActiveVersion() throws CmdToolUtilException {
        return this.getOFSActiveVersion("localnode");
    }

    public String getOFSActiveVersion(String nodename) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodename);
        return this.doGetACFSActiveVersion(nodename);
    }

    private String doGetACFSActiveVersion(String nodename) throws CmdToolUtilException {
        String[] split;
        String[] errorString;
        String[] args = new String[]{ACFSUTL_VERSION};
        CommandResult result = this.m_cmdtool.execute(nodename, args, null, false, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for nodename, " + nodename);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_ACTIVE_VERSION_NODE_FAIL, nodename, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        this.print_outputTrace(result.getResultString());
        String version = null;
        ArrayList<String> linesOfInterest = new ArrayList<String>();
        for (String line : result.getResultString()) {
            if (!line.contains(COL_DELIMITER)) continue;
            linesOfInterest.add(line);
        }
        if (!linesOfInterest.isEmpty() && (split = ((String)linesOfInterest.get(0)).split(COL_DELIMITER)).length > 1) {
            version = split[1].trim();
        }
        Trace.out("ACFS version for the node " + nodename + " = " + version);
        return version;
    }

    public String getOFSCommandsVersion() throws CmdToolUtilException {
        return this.doGetACFSVerboseVersion("localnode", false);
    }

    public String getOFSCommandsVersion(String nodename) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodename);
        return this.doGetACFSVerboseVersion(nodename, false);
    }

    public String getOFSKernelVersion() throws CmdToolUtilException {
        return this.doGetACFSVerboseVersion("localnode", true);
    }

    public String getOFSKernelVersion(String nodename) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodename);
        return this.doGetACFSVerboseVersion(nodename, true);
    }

    private String doGetACFSVerboseVersion(String nodename, boolean kernelVersion) throws CmdToolUtilException {
        String[] split;
        String[] errorString;
        String[] args = new String[2];
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        args[0] = ACFSUTL_VERSION;
        args[1] = nativeSystem.isUnixSystem() ? ACFSUTL_VERSION_VERBOSE_UNIX : ACFSUTL_VERSION_VERBOSE_WIN;
        CommandResult result = this.m_cmdtool.execute(nodename, args, null, false, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for nodename, " + nodename);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_ACTIVE_VERSION_NODE_FAIL, nodename, this.m_cmdtool.getSourceLocation(), Utils.getString(errorString, NEWLINE));
        }
        this.print_outputTrace(result.getResultString());
        String version = null;
        ArrayList<String> linesOfInterest = new ArrayList<String>();
        for (String line : result.getResultString()) {
            if (!line.contains(COL_DELIMITER)) continue;
            linesOfInterest.add(line);
        }
        if (kernelVersion) {
            if (linesOfInterest.size() > 1 && (split = ((String)linesOfInterest.get(1)).split(COL_DELIMITER)).length > 1) {
                version = split[1].trim();
            }
        } else if (linesOfInterest.size() > 5 && (split = ((String)linesOfInterest.get(5)).split(COL_DELIMITER)).length > 1) {
            version = split[1].trim();
        }
        Trace.out("ACFS " + (kernelVersion ? "Kernel" : "Commands") + " version for the node " + nodename + " = " + version);
        return version;
    }

    public boolean isOFSPartition(String location) throws CmdToolUtilException {
        return this.isOFSPartition(location, "localnode");
    }

    public boolean isOFSPartition(String location, String nodename) throws CmdToolUtilException {
        if (location == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NULL_LOCATION_NODE, nodename);
        }
        if (nodename == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.UNEXPECTED_INTERNAL_ERROR, OFS_ERROR_1);
        }
        return this.doIsACFSPartition(location, nodename);
    }

    private boolean doIsACFSPartition(String location, String nodename) throws CmdToolUtilException {
        CommandResult result = new CommandResult();
        try {
            result = this.m_cmdtool.execute(nodename, new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_ISMOUNTP, location}, null, false, false, true);
        }
        catch (CmdToolUtilException e) {
            Trace.out("CmdToolUtil execute failed. boolean result = " + result.getBooleanResult());
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_COMMAND_FAIL_WITH_PATH, (Throwable)e, nodename, location);
        }
        String errorString = result.getErrorString();
        Trace.out("result.getBooleanResult() = " + result.getBooleanResult());
        Trace.out("OS String: " + result.getOSString());
        Trace.out("Result string: " + Arrays.toString(result.getResultString()));
        Trace.out("Command status: " + result.getStatus());
        if (result.getStatus() && result.getBooleanResult()) {
            String[] resultString = result.getResultString();
            if (resultString[0].equals(TRUE_STRING)) {
                return true;
            }
            if (resultString[0].equals(FALSE_STRING)) {
                return false;
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_COMMAND_FAIL_WITH_PATH, nodename, location);
        }
        if (errorString.contains(ACFSUTIL_NOT_ACFS_FILESYSTEM)) {
            return false;
        }
        if (errorString.contains("CLSU-00101") && errorString.contains("No such file or directory")) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_INVALID_LOCATION_NODE, location, nodename);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_COMMAND_FAIL_WITH_PATH, nodename, location);
    }

    public List<String> getOFSMountPoints() throws CmdToolUtilException {
        return this.getOFSMountPoints("localnode");
    }

    public List<String> getOFSMountPoints(String nodename) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodename);
        return this.doGetACFSMountPoints(nodename);
    }

    private List<String> doGetACFSMountPoints(String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_MOUNTPTS};
        CommandResult result = this.m_cmdtool.execute(nodename, args, null, false, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NODE_FAIL_WITH_MSG, nodename, sb.toString());
        }
        this.print_outputTrace(result.getResultString());
        if (result.getResultString() != null && result.getResultString().length > 0) {
            Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
            List<String> mntptlist = null;
            if (new SystemFactory().CreateSystem().isUnixSystem()) {
                mntptlist = Arrays.asList(result.getResultString());
            } else {
                mntptlist = new ArrayList<String>(result.getResultString().length);
                for (String r : result.getResultString()) {
                    String mtpt = r.replaceAll("\\n", "");
                    mntptlist.add(mtpt);
                }
            }
            return mntptlist;
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_EMPTY_RESULT1, nodename);
    }

    public List<String> getAllOFSDiskGroupNames() throws CmdToolUtilException {
        return this.getAllOFSDiskGroupNames("localnode");
    }

    public List<String> getAllOFSDiskGroupNames(String nodename) throws CmdToolUtilException {
        CmdToolUtil.assertNode(nodename);
        return this.doGetAllOFSDiskGroupNames(nodename);
    }

    public List<String> doGetAllOFSDiskGroupNames(String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_DISKGROUP};
        CommandResult result = this.m_cmdtool.execute(nodename, args, null, false, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NODE_FAIL_WITH_MSG, nodename, sb.toString());
        }
        this.print_outputTrace(result.getResultString());
        if (result.getResultString() != null && result.getResultString().length > 0) {
            Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
            List<String> diskgroups = Arrays.asList(result.getResultString());
            return diskgroups;
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_PARSE_DISKGROUPNAMES_FAIL, nodename);
    }

    public String getOFSDiskGroupName(String location) throws CmdToolUtilException {
        return this.getOFSDiskGroupName(location, "localnode");
    }

    public String getOFSDiskGroupName(String location, String nodename) throws CmdToolUtilException {
        if (location == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NULL_LOCATION_NODE, nodename);
        }
        CmdToolUtil.assertNode(nodename);
        boolean isofs = this.isOFSPartition(location, nodename);
        if (isofs) {
            return this.doGetACFSDiskGroupName(location, nodename);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_INVALID_LOCATION_NODE, location, nodename);
    }

    private String doGetACFSDiskGroupName(String location, String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_DISKGROUP, location};
        CmdToolUtil.assertNode(nodename);
        CommandResult result = this.m_cmdtool.execute(nodename, args, null, false, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NODE_FAIL_WITH_MSG, nodename, sb.toString());
        }
        this.print_outputTrace(result.getResultString());
        if (result.getResultString() != null && result.getResultString().length > 0) {
            Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
            String diskgroup = this.parseOutput(nodename, result.getResultString(), 0, 0);
            Trace.out("diskgroup for path " + location + " = " + diskgroup);
            return diskgroup;
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_EMPTY_RESULT2, location, nodename);
    }

    public Long getOFSTotalSize(String location) throws CmdToolUtilException {
        return this.getOFSTotalSize(location, "localnode");
    }

    public Long getOFSTotalSize(String location, String nodename) throws CmdToolUtilException {
        boolean isofs = false;
        if (location == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NULL_LOCATION_NODE, nodename);
        }
        CmdToolUtil.assertNode(nodename);
        isofs = this.isOFSPartition(location, nodename);
        if (isofs) {
            return this.doGetACFSTotalSize(location, nodename);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_INVALID_LOCATION_NODE, location, nodename);
    }

    private Long doGetACFSTotalSize(String location, String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_TOTALSPACE, location};
        CommandResult result = this.m_cmdtool.execute(nodename, args, null, false, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NODE_FAIL_WITH_MSG, nodename, sb.toString());
        }
        this.print_outputTrace(result.getResultString());
        if (result.getResultString() != null && result.getResultString().length > 0) {
            Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
            String totalspace = this.parseOutput(nodename, result.getResultString(), 0, 0);
            Trace.out("totalspace for path " + location + " = " + totalspace);
            return Long.valueOf(totalspace);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_EMPTY_RESULT3, location, nodename);
    }

    public Long getOFSFreeSpace(String location) throws CmdToolUtilException {
        return this.getOFSFreeSpace(location, "localnode");
    }

    public Long getOFSFreeSpace(String location, String nodename) throws CmdToolUtilException {
        String mtPoint = "";
        if (location == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NULL_LOCATION_NODE, nodename);
        }
        CmdToolUtil.assertNode(nodename);
        mtPoint = this.getMountPoint(location, nodename);
        if (mtPoint != null && !mtPoint.isEmpty()) {
            return this.doGetACFSFreeSpace(mtPoint, nodename);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_INVALID_LOCATION_NODE, location, nodename);
    }

    private Long doGetACFSFreeSpace(String location, String nodename) throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_FREESPACE, location};
        CommandResult result = this.m_cmdtool.execute(nodename, args, null, false, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed ");
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < errorString.length; ++i) {
                sb.append(errorString[i]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NODE_FAIL_WITH_MSG, location, sb.toString());
        }
        this.print_outputTrace(result.getResultString());
        if (result.getResultString() != null && result.getResultString().length > 0) {
            Trace.out("result string = " + Utils.getString(result.getResultString(), NEWLINE));
            String freespace = this.parseOutput(nodename, result.getResultString(), 0, 0);
            Trace.out("freespace for path " + location + " = " + freespace);
            return Long.valueOf(freespace);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_EMPTY_RESULT4, location, nodename);
    }

    public boolean isOFSDriversInstalled() throws CmdToolUtilException {
        return this.isOFSDriversInstalled("localnode");
    }

    public boolean isOFSDriversInstalled(String nodename) throws CmdToolUtilException {
        return this.doIsOFSDriversInstalled(nodename);
    }

    public boolean doIsOFSDriversInstalled(String nodename) throws CmdToolUtilException {
        this.getOFSActiveVersion(nodename);
        return true;
    }

    public boolean isOFSDriversConfigured() throws CmdToolUtilException {
        return this.isOFSDriversConfigured("localnode");
    }

    public boolean isOFSDriversConfigured(String nodename) throws CmdToolUtilException {
        return this.doIsOFSDriversConfigured(nodename);
    }

    public boolean doIsOFSDriversConfigured(String nodename) throws CmdToolUtilException {
        this.getOFSActiveVersion(nodename);
        return true;
    }

    public String getMountpoint(String path) throws CmdToolUtilException {
        return this.getMountPoint(path, "localnode");
    }

    public String getMountPoint(String path, String node) throws CmdToolUtilException {
        String[] errorString;
        CmdToolUtil.assertFile(path);
        String[] args = new String[5];
        args[0] = ACFSUTL_ARG_INFO;
        args[1] = ACFSUTL_ARG_FS;
        args[2] = ACFSUTL_OUT_OPT;
        args[3] = ACFSUTL_MOUNTPTS;
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        args[4] = !nativeSystem.isUnixSystem() && path.trim().endsWith("\"") ? path.trim().substring(0, path.trim().length() - 1) : path.trim();
        CommandResult result = this.m_cmdtool.execute(node, args, null, false, true, true);
        Trace.out("getBooleanResult: " + result.getBooleanResult());
        Trace.out("getErrorString: " + result.getErrorString());
        Trace.out("getOSString: " + result.getOSString());
        Trace.out("getStatus: " + result.getStatus());
        Trace.out("getNativeResultString: " + result.getNativeResultString());
        String errorStr = result.getErrorString();
        if (errorStr != null && errorStr.indexOf(ACFSUTIL_NOT_ACFS_FILESYSTEM) != -1) {
            Trace.out(path + " is not on an ACFS filesystem");
            return null;
        }
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for given path, " + path);
            if (node.equals("localnode")) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NODE_FAIL_WITH_MSG, node, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            String mtpt = this.parseOutput(node, resultArr, 0, 0);
            Trace.out("mountpoint = " + mtpt);
            return mtpt;
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_EMPTY_RESULT_MTPOINT, path);
    }

    public String getVolumeDevice(String mtpoint) throws CmdToolUtilException {
        String[] errorString;
        if (mtpoint == null || mtpoint.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_INVALID_MTPOINT, new Object[0]);
        }
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_PRIMARY_VOL, mtpoint};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for given mountpoint, " + mtpoint);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            String volDevice = this.parseOutput(null, resultArr, 0, 0);
            Trace.out("volDevice = " + volDevice);
            return volDevice;
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_EMPTY_RESULT_VOLDEVICE, mtpoint);
    }

    public List<String> getVolumeDevices() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_PRIMARY_VOL};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for finding all volume devices");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            return Arrays.asList(resultArr);
        }
        return new ArrayList<String>(0);
    }

    public String getMtPtFromVolDev(String volDevice, String crsHome) throws CmdToolUtilException {
        if (volDevice == null || volDevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        Map<String, String> acfsInfos = this.getACFSInfos();
        ADVMUtil advmutil = new ADVMUtil(crsHome);
        String newVolDevice = advmutil.getCanonicalVolume(volDevice);
        Trace.out("new volume device = " + newVolDevice);
        String mtPt = acfsInfos.get(newVolDevice);
        if (mtPt == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.ACFSUTIL_GET_MOUNTPOINT_FAILED, volDevice);
        }
        return mtPt;
    }

    private Map<String, String> getACFSInfos() throws CmdToolUtilException {
        String[] errorString;
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_VOLDEV_MTPT};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            if (errorString[0].indexOf(ACFSUTIL_NO_MOUNTED_FILESYSTEM) != -1) {
                return new LinkedHashMap<String, String>(0);
            }
            Trace.out("m_cmdtool.execute failed for finding all volume devices");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        LinkedHashMap<String, String> mountedACFS = new LinkedHashMap<String, String>();
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            Trace.out("length = " + resultArr.length);
            this.print_outputTrace(resultArr);
            String[] lines = resultArr;
            Trace.out("number of lines = " + lines.length);
            for (int i = 0; i < lines.length; i += 2) {
                String volDev = lines[i];
                String mtPt = lines[i + 1];
                Trace.out("volume device=%s, mount point=%s", volDev, mtPt);
                mountedACFS.put(volDev, mtPt);
            }
        }
        return mountedACFS;
    }

    public String getMountPointFromVolDevice(String voldevice) throws CmdToolUtilException {
        String[] errorString;
        if (voldevice == null || voldevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        String[] args = new String[]{ACFSUTL_ARG_REGISTRY, ACFSUTL_M_DEVICE_OPT, voldevice};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for given voldevice, " + voldevice);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            String mtpoint = this.parseOutput(null, resultArr, 0, 0);
            Trace.out("mtpoint = " + mtpoint);
            return mtpoint;
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.ACFSUTIL_DEV_EMPTY_RESULT_MTPOINT, voldevice);
    }

    public String getDiskGroupFromVolDevice(String voldevice) throws CmdToolUtilException {
        String[] errorString;
        if (voldevice == null || voldevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        String[] args = new String[]{ACFSUTL_ARG_REGISTRY, ACFSUTL_L_DEVICE_OPT, voldevice};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for given voldevice, " + voldevice);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        String dg = "";
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            dg = this.parseRegistryOutput(resultArr, 0, 4);
            Trace.out("dg = " + dg);
        }
        return dg;
    }

    public String getVolumeFromVolDevice(String voldevice) throws CmdToolUtilException {
        String[] errorString;
        if (voldevice == null || voldevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        String[] args = new String[]{ACFSUTL_ARG_REGISTRY, ACFSUTL_L_DEVICE_OPT, voldevice};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for given voldevice, " + voldevice);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        String volume = "";
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            volume = this.parseRegistryOutput(resultArr, 0, 5);
            Trace.out("volume = " + volume);
        }
        return volume;
    }

    public void createACFSfs(String voldevice) throws CmdToolUtilException {
        this.doCreateACFSfs(voldevice, null);
    }

    public void createACFSfs(String voldevice, String user) throws CmdToolUtilException {
        this.doCreateACFSfs(voldevice, user);
    }

    private void doCreateACFSfs(String voldevice, String user) throws CmdToolUtilException {
        String[] errorString;
        if (voldevice == null || voldevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        String[] args = new SystemFactory().CreateSystem().isUnixSystem() ? new String[]{MKFS_TYPE_OPT, MKFS_TYPE_NAME, voldevice} : new String[]{voldevice};
        CommandResult result = this.m_cmdtool.execute(args, null, user, true, false);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for given voldevice, " + voldevice);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
    }

    public void removeACFSfs(String voldevice) throws CmdToolUtilException {
        String[] errorString;
        if (voldevice == null || voldevice.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        String[] args = new String[]{RMFS_NAME, voldevice};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for given voldevice, " + voldevice);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
    }

    private void doCreateSNAP(String snapname, String mountpt, String stype, String pname) throws CmdToolUtilException, AlreadyExistsException {
        if (mountpt == null || mountpt.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_INVALID_MOUNTPT, new Object[0]);
        }
        int count = pname == null ? 5 : 7;
        String[] args = new String[count];
        args[0] = ACFSUTL_ARG_SNAP;
        args[1] = ACFSUTL_SNAP_CREATE;
        args[2] = ACFSUTIL_SNAP_CLONE_TARGET.equals(stype) ? ACFSUTL_SNAP_CLONEOPT : (stype.equalsIgnoreCase("READONLY") ? ACFSUTL_SNAP_READOPT : ACFSUTL_SNAP_WRITEOPT);
        args[3] = snapname;
        if (pname != null) {
            args[4] = ACFSUTL_SNAP_PSNAPOPT;
            args[5] = pname;
            args[6] = mountpt;
        } else {
            args[4] = mountpt;
        }
        CommandResult result = null;
        try {
            result = this.m_cmdtool.execute(args, null, true);
        }
        catch (CmdToolUtilException cmte) {
            String errorString = cmte.getMessage();
            if (errorString != null && errorString.contains(ACFSUTIL_SNAP_EXST)) {
                Trace.out("Snapshot already exists. Error: " + errorString);
                throw new AlreadyExistsException((MessageKey)PrCtMsgID.OFSUTIL_SNAP_EXIST, (Throwable)cmte, snapname, this.m_cmdtool.getSourceLocation(), errorString, NEWLINE);
            }
            Trace.out("m_cmdtool.execute failed for given snap , " + snapname);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, errorString);
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
    }

    public void createSNAPONSNAP(String snapname, String mountpt, String stype, String pname) throws CmdToolUtilException, AlreadyExistsException {
        this.doCreateSNAP(snapname, mountpt, stype, pname);
    }

    public void createSNAP(String snapname, String mountpt, String stype) throws CmdToolUtilException, AlreadyExistsException {
        this.doCreateSNAP(snapname, mountpt, stype, null);
    }

    public void convertSNAP(String snapname, String mountpt, boolean toWritable) throws CmdToolUtilException {
        String[] errorString;
        if (mountpt == null || mountpt.isEmpty()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_INVALID_MOUNTPT, new Object[0]);
        }
        String[] args = new String[]{ACFSUTL_ARG_SNAP, ACFSUTL_SNAP_CONVERT, toWritable ? ACFSUTL_SNAP_WRITEOPT : ACFSUTL_SNAP_READOPT, snapname, mountpt};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for snapshopt " + snapname);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
    }

    public void removeSNAP(String snapname, String mountpt) throws CmdToolUtilException, NotExistsException {
        String[] errorString;
        if (mountpt == null || mountpt.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_INVALID_MOUNTPT, new Object[0]);
        }
        String[] args = new String[]{ACFSUTL_ARG_SNAP, ACFSUTL_SNAP_DELETE, snapname, mountpt};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            Trace.out("m_cmdtool.execute failed for given snapshopt, " + snapname);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        this.print_outputTrace(resultArr);
        if (resultArr[0].startsWith(ACFSUTIL_SNAP_NOT_EXIST)) {
            Trace.out("Snapshot does not exist. Error: " + resultArr[0]);
            throw new NotExistsException((MessageKey)PrCtMsgID.OFSUTIL_SNAP_NOT_EXIST, snapname, this.m_cmdtool.getSourceLocation(), Utils.getString(resultArr, NEWLINE));
        }
    }

    public boolean isPathOnSnap(String path) throws CmdToolUtilException {
        String[] errorString;
        if (path == null || path.trim().length() == 0) {
            Trace.out("isPathOnSnap gets a empty path as input.");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.NULL_FILE_PATH, new Object[0]);
        }
        String mountpt = this.getMountPoint(path, "localnode");
        String[] args = new String[]{ACFSUTL_ARG_SNAP, ACFSUTL_ARG_INFO, mountpt};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            if (errorString[0].indexOf(ACFSUTIL_SNAP_NOT_EXIST) != -1) {
                Trace.out("Snapshot does not exist. " + errorString[0]);
                return false;
            }
            Trace.out("m_cmdtool.execute failed for given mount point , " + mountpt);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        String resultPath = null;
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            for (int i = 1; i < resultArr.length; i += 6) {
                resultPath = this.parseOutput(null, resultArr, i, 2);
                File resPath = new File(resultPath);
                Trace.out("A Snap shot path is compared: " + resultPath);
                File pathToFile = new File(path);
                try {
                    if (!pathToFile.getCanonicalPath().startsWith(resPath.getCanonicalPath())) continue;
                    return true;
                }
                catch (IOException error) {
                    throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_FILE_PATH, path);
                }
            }
        }
        return false;
    }

    public boolean isSNAP(String snapname, String mountpt) throws CmdToolUtilException {
        String[] errorString;
        boolean issnap = false;
        if (mountpt == null || mountpt.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_INVALID_MOUNTPT, new Object[0]);
        }
        String[] args = new String[]{ACFSUTL_ARG_SNAP, ACFSUTL_ARG_INFO, snapname, mountpt};
        CommandResult result = this.m_cmdtool.execute(args, null, true, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            if (errorString[0].indexOf(ACFSUTIL_SNAP_NOT_EXIST) != -1) {
                Trace.out("Snapshot does not exist. " + errorString[0]);
                return issnap;
            }
            Trace.out("m_cmdtool.execute failed for given snap , " + snapname);
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            this.print_outputTrace(resultArr);
            String sname = this.parseOutput(null, resultArr, 0, 2);
            Trace.out("snapshot exists  for name " + sname);
            if (sname.trim().equalsIgnoreCase(snapname)) {
                issnap = true;
            }
        }
        return issnap;
    }

    public void increaseSize(int increSize, String mountPt) throws CmdToolUtilException {
        String[] errorString;
        if (mountPt == null || mountPt.trim().length() == 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_INVALID_MOUNTPT, new Object[0]);
        }
        String sz = Integer.toString(increSize);
        String[] args = new String[]{ACFSUTL_ARG_SIZE, "+" + sz + "G", mountPt};
        CommandResult result = this.m_cmdtool.execute(args, null, true);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
    }

    public boolean isAuxiliaryVolume(String volDevice) throws CmdToolUtilException {
        if (volDevice == null || volDevice.isEmpty()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        File vol = new File(volDevice);
        if (!vol.exists()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_VOLUME_DEVICE_NOT_FOUND, volDevice);
        }
        CommandResult result = new CommandResult();
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_ISAUXVOLUME, volDevice};
        try {
            result = this.m_cmdtool.execute(args, null, true);
        }
        catch (CmdToolUtilException e) {
            Trace.out("CmdToolUtil execute failed. boolean result = " + result.getBooleanResult());
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_COMMAND_FAIL_WITH_PATH, volDevice, "localnode", e);
        }
        Trace.out("result.getBooleanResult() = " + result.getBooleanResult());
        Trace.out("OS String: " + result.getOSString());
        Trace.out("Result string: " + Arrays.toString(result.getResultString()));
        Trace.out("Command status: " + result.getStatus());
        Trace.out("Error string: " + result.getEnvironment());
        if (result.getStatus() && result.getBooleanResult()) {
            String[] resultString = result.getResultString();
            if (resultString != null && resultString.length > 0) {
                if (resultString[0].equals(TRUE_STRING)) {
                    return true;
                }
                if (resultString[0].equals(FALSE_STRING)) {
                    return false;
                }
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, new Object[0]);
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_AUXILIARY_VOLUME_NOT_ACFS, volDevice);
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, new Object[0]);
    }

    public List<String> getAuxiliaryVolumes(String volDevice) throws CmdToolUtilException {
        if (volDevice == null || volDevice.isEmpty()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.INVALID_VOLDEVICE, new Object[0]);
        }
        CommandResult result = new CommandResult();
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, ACFSUTL_OUT_OPT, ACFSUTL_AUXVOLUME, volDevice};
        try {
            result = this.m_cmdtool.execute(args, null, true);
        }
        catch (CmdToolUtilException e) {
            Trace.out("CmdToolUtil execute failed. boolean result = " + result.getBooleanResult());
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_COMMAND_FAIL_WITH_PATH, volDevice, "localnode", e);
        }
        String errorString = result.getErrorString();
        Trace.out("result.getBooleanResult() = " + result.getBooleanResult());
        Trace.out("OS String: " + result.getOSString());
        Trace.out("Result string: " + Arrays.toString(result.getResultString()));
        Trace.out("Command status: " + result.getStatus());
        Trace.out("Error string: " + result.getEnvironment());
        if (result.getStatus() && result.getBooleanResult()) {
            ArrayList<String> auxVolumes = new ArrayList<String>();
            String[] resultString = result.getResultString();
            if (resultString != null && resultString.length > 0) {
                auxVolumes.add(resultString[0]);
            } else {
                Trace.out("Empty result, no auxiliary volumes configured for this device");
            }
            return auxVolumes;
        }
        if (errorString.contains("CLSU-00101") && errorString.contains("No such file or directory")) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_INVALID_LOCATION_NODE, volDevice, "localnode");
        }
        throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_COMMAND_FAIL_WITH_PATH, volDevice, "localnode");
    }

    public ACFSInfo getACFSInformation(String mountpoint) throws CmdToolUtilException {
        return this.do_getACFSInformation(mountpoint, null);
    }

    public ACFSInfo getACFSInformation(String mountpoint, String node) throws CmdToolUtilException {
        CmdToolUtil.assertNode(node);
        return this.do_getACFSInformation(mountpoint, node);
    }

    private ACFSInfo do_getACFSInformation(String mountpoint, String node) throws CmdToolUtilException {
        String[] errorString;
        Trace.out("Retrieving ACFS info from mount point " + mountpoint);
        if (mountpoint == null || mountpoint.trim().isEmpty()) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_INVALID_MTPOINT, new Object[0]);
        }
        Map<String, List<String>> resultMap = null;
        String[] args = new String[]{ACFSUTL_ARG_INFO, ACFSUTL_ARG_FS, mountpoint};
        CommandResult result = node != null ? this.m_cmdtool.execute(node, args, null, false, true, true) : this.m_cmdtool.execute(args, null, false);
        if (!result.getBooleanResult() && (errorString = result.getResultString()) != null && errorString.length > 0) {
            if (errorString[0].indexOf(ACFSUTIL_NO_MOUNTED_FILESYSTEM) != -1) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_NO_ACFS_MOUNTED, new Object[0]);
            }
            Trace.out("m_cmdtool.execute failed for finding all volume devices");
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFSUTIL_FAIL_WITH_MSG, Utils.getString(errorString, NEWLINE));
        }
        String[] resultArr = result.getResultString();
        if (resultArr != null && resultArr.length > 0) {
            Trace.out("length = " + resultArr.length);
            this.print_outputTrace(resultArr);
            boolean isNodeLocal = node != null;
            resultMap = this.parseInfoFS(resultArr, isNodeLocal);
        }
        try {
            return new ACFSInfo(resultMap);
        }
        catch (InstallException ie) {
            throw new CmdToolUtilException(ie);
        }
    }

    private String parseOutput(String nodename, String[] strArr, int row, int col) throws CmdToolUtilException {
        this.print_outputTrace(strArr);
        if (strArr == null || strArr.length <= row) {
            if (nodename == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_PARSE_OUTPUT_NODE_FAIL, nodename, this.m_cmdtool.getSourceLocation());
        }
        String[] values = strArr[row].split(DELIMITER);
        if (values.length <= col) {
            if (nodename == null) {
                throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_PARSE_VALUE_FAIL, strArr[row], this.m_cmdtool.getSourceLocation());
            }
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_PARSE_VALUE_NODE_FAIL, strArr[row], nodename, this.m_cmdtool.getSourceLocation());
        }
        Trace.out("Returned value from parseOutput = >" + values[col] + "<");
        return values[col];
    }

    private Map<String, List<String>> parseInfoFS(String[] strArr, boolean isNodeLocal) throws CmdToolUtilException {
        if (strArr == null) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
        }
        LinkedHashMap<String, List<String>> infoMap = new LinkedHashMap<String, List<String>>();
        String value = "";
        ArrayList<String> values = new ArrayList<String>();
        if (isNodeLocal) {
            values.add(TRUE_STRING);
        } else {
            values.add(FALSE_STRING);
        }
        infoMap.put(ACFSInfo.ACFSInfoLabel.IS_NODELOCAL.getValue(), values);
        for (String line : strArr) {
            String[] colArr = line.split(":( )+");
            if (colArr.length <= 1) continue;
            String label = colArr[0].trim();
            value = colArr[1].trim();
            if (infoMap.containsKey(label)) {
                infoMap.get(label).add(value);
                continue;
            }
            values = new ArrayList();
            values.add(value);
            infoMap.put(label, values);
        }
        return infoMap;
    }

    private String parseRegistryOutput(String[] strArr, int row, int col) throws CmdToolUtilException {
        int column;
        this.print_outputTrace(strArr);
        if (strArr == null || strArr.length <= row) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_PARSE_OUTPUT_FAIL, this.m_cmdtool.getSourceLocation());
        }
        String[] values = strArr[row].split(COL_DELIMITER);
        if (values.length <= (column = col * 2 + 1)) {
            throw new CmdToolUtilException((MessageKey)PrCtMsgID.OFS_PARSE_VALUE_FAIL, strArr[row], this.m_cmdtool.getSourceLocation());
        }
        Trace.out("Returned value from parseOutput = >" + values[column] + "<");
        return values[column];
    }

    private void print_outputTrace(String[] result) {
        if (Trace.isTraceEnabled() && result != null && result.length > 0) {
            for (int i = 0; i < result.length; ++i) {
                Trace.out("result[" + i + "] = " + result[i]);
            }
        }
    }

    static {
        if (new SystemFactory().CreateSystem().isUnixSystem()) {
            ACFSUTIL_OPT_OPER = "-";
            if (DeterminePlatform.getOSName().equals("AIX")) {
                MKFS_LOCATION = "/usr/sbin";
                MKFS_TYPE_OPT = "-V";
            } else if (DeterminePlatform.getOSName().equals("Solaris") || DeterminePlatform.getOSName().equals("SunOS")) {
                MKFS_LOCATION = "/usr/sbin";
                MKFS_TYPE_OPT = "-F";
            } else {
                MKFS_LOCATION = "/sbin";
                MKFS_TYPE_OPT = "-t";
            }
        } else {
            ACFSUTIL_OPT_OPER = "/";
            String crsHome = null;
            try {
                crsHome = new ClusterwareInfo().getCRSHome(new Version());
            }
            catch (InstallException ie) {
                Trace.out("failed to retrieve CRS home, logging error: " + ie.getMessage());
            }
            MKFS_LOCATION = crsHome != null ? crsHome + "\\bin" : null;
            MKFS_TYPE_OPT = null;
        }
        ACFSUTL_OUT_OPT = ACFSUTIL_OPT_OPER + "o";
        ACFSUTL_M_DEVICE_OPT = ACFSUTIL_OPT_OPER + "m";
        ACFSUTL_L_DEVICE_OPT = ACFSUTIL_OPT_OPER + "l";
        NEWLINE = System.getProperty("line.separator");
        MKFS_NAME = new SystemFactory().CreateSystem().isUnixSystem() ? "mkfs" : "acfsformat";
        MKFS = new SystemFactory().CreateSystem().getExeName(MKFS_NAME);
    }
}

