/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.cmdtools;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.cluster.cmdtools.CmdToolUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.resources.PrCiMsgID;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.trace.Trace;

public class OCRDUMPUtil {
    private CmdToolUtil m_cmdtool;
    private static MessageBundle s_msgBundle = MessageBundle.getMessageBundle(PrCiMsgID.facility);
    NativeSystem nativeSystem = new SystemFactory().CreateSystem();
    private final String OCRDUMP_CMD = this.nativeSystem.getExeName("ocrdump");
    private static final String OCRDUMP_EXE_LOC = "bin";
    private final String[] OCRDUMP_DEP = new String[]{this.OCRDUMP_CMD};
    private static final String OCRDUMP_ARG_NOHDR = "-noheader";
    private static final String OCRDUMP_ARG_STDOUT = "-stdout";
    private static final String OCRDUMP_ARG_KEYNAME = "-keyname";
    private static final String OCRDUMP_VAL_KEYNAME = "SYSTEM.version.hostnames";
    private static final String OCRDUMP_KEY_PREFIX = "[SYSTEM.version.hostnames.";
    private static final String OCRDUMP_KEY_SURFIX = "]";
    private static final String OCRDUMP_KEY_PATCHLEVEL = ".patchlevel]";
    private static final String OCRDUMP_KEY_SITE = ".site]";
    private static final String OCRDUMP_KEY_TIMESTAMP = ".last_active_timestamp";

    public OCRDUMPUtil(String crsHome) throws CmdToolUtilException {
        String location = crsHome + File.separator + OCRDUMP_EXE_LOC;
        CmdToolUtil.assertDir(location, true);
        this.m_cmdtool = new CmdToolUtil(this.OCRDUMP_CMD, location, this.OCRDUMP_DEP);
    }

    public List<String> getHistoricalClusterNodes() throws CmdToolUtilException {
        String[] args = new String[]{OCRDUMP_ARG_NOHDR, OCRDUMP_ARG_STDOUT, OCRDUMP_ARG_KEYNAME, OCRDUMP_VAL_KEYNAME};
        CommandResult result = null;
        ArrayList<String> hostnames = new ArrayList<String>();
        try {
            result = this.m_cmdtool.executeLocally(args, null);
            if (!result.getBooleanResult()) {
                String[] errorString = result.getResultString();
                if (errorString != null && errorString.length > 0) {
                    Trace.out("m_cmdtool.execute failed ");
                    StringBuilder sb = new StringBuilder("");
                    for (int i = 0; i < errorString.length; ++i) {
                        sb.append(errorString[i]);
                    }
                }
                throw new CmdToolUtilException((MessageKey)PrCiMsgID.GET_ALL_NODES_FAILED, this.m_cmdtool.getSourceLocation());
            }
        }
        catch (CmdToolUtilException e) {
            throw new CmdToolUtilException((MessageKey)PrCiMsgID.GET_ALL_NODES_FAILED, (Throwable)e, this.m_cmdtool.getSourceLocation());
        }
        String[] outputs = result.getResultString();
        int prefixlen = OCRDUMP_KEY_PREFIX.length();
        for (String output : outputs) {
            Trace.out("Parse output: " + output);
            int prefixindx = output.indexOf(OCRDUMP_KEY_PREFIX);
            if (prefixindx < 0 || output.indexOf(OCRDUMP_KEY_PATCHLEVEL) >= 0 || output.indexOf(OCRDUMP_KEY_SITE) >= 0 || output.indexOf(OCRDUMP_KEY_TIMESTAMP) >= 0) continue;
            int surfixindx = output.trim().indexOf(OCRDUMP_KEY_SURFIX);
            String hostname = output.substring(prefixindx + prefixlen, surfixindx);
            hostnames.add(hostname);
        }
        return hostnames;
    }
}

